/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.multitenancy;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.BusinessRuleTaskBuilder;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.DecisionEvaluationIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.DecisionEvaluationRecordValue;
import io.camunda.zeebe.protocol.record.value.DeploymentRecordValue;
import io.camunda.zeebe.protocol.record.value.ErrorType;
import io.camunda.zeebe.protocol.record.value.EvaluatedDecisionValue;
import io.camunda.zeebe.protocol.record.value.IncidentRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.protocol.record.value.deployment.DecisionRecordValue;
import io.camunda.zeebe.test.util.BrokerClassRuleHelper;
import io.camunda.zeebe.test.util.record.ProcessInstanceRecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.groups.Tuple;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class TenantAwareBusinessRuleTaskTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    private static final String DMN_DECISION_TABLE = "/dmn/decision-table.dmn";
    private static final String DMN_DECISION_TABLE_WITH_ASSERTION = "/dmn/decision-table-with-assertions.dmn";
    private static final String PROCESS_ID = "process";
    private static final String TASK_ID = "task";
    private static final String RESULT_VARIABLE = "result";
    private static final String DECISION_ID = "jedi_or_sith";
    @Rule
    public final BrokerClassRuleHelper helper = new BrokerClassRuleHelper();
    private final String tenantOne = "foo";
    private final String tenantTwo = "bar";
    private Map<String, DecisionRecordValue> deployedDecisionsById;

    private static BpmnModelInstance processWithBusinessRuleTask() {
        return Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().businessRuleTask(TASK_ID, t -> ((BusinessRuleTaskBuilder)t.zeebeCalledDecisionId(DECISION_ID)).zeebeResultVariable(RESULT_VARIABLE)).done();
    }

    @Test
    public void shouldActivateBusinessRuleTask() {
        BpmnModelInstance process = TenantAwareBusinessRuleTaskTest.processWithBusinessRuleTask();
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource("process.bpmn", process).withXmlClasspathResource(DMN_DECISION_TABLE).withTenantId("foo").deploy();
        this.deployedDecisionsById = ((DeploymentRecordValue)deployment.getValue()).getDecisionsMetadata().stream().collect(Collectors.toMap(DecisionRecordValue::getDecisionId, Function.identity()));
        ENGINE.deployment().withXmlResource("process.bpmn", process).withTenantId("bar").deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withTenantId("foo").withVariable("lightsaberColor", "blue").create();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.BUSINESS_RULE_TASK).withTenantId("foo").limit(3L)).extracting(new Function[]{Record::getRecordType, Record::getIntent}).containsSequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{RecordType.COMMAND, ProcessInstanceIntent.ACTIVATE_ELEMENT}), Assertions.tuple((Object[])new Object[]{RecordType.EVENT, ProcessInstanceIntent.ELEMENT_ACTIVATING}), Assertions.tuple((Object[])new Object[]{RecordType.EVENT, ProcessInstanceIntent.ELEMENT_ACTIVATED})});
        Record taskActivating = (Record)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).withIntent((Intent)ProcessInstanceIntent.ELEMENT_ACTIVATING)).withElementType(BpmnElementType.BUSINESS_RULE_TASK).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((ProcessInstanceRecordValue)((ProcessInstanceRecordValue)taskActivating.getValue())).hasElementId(TASK_ID).hasBpmnElementType(BpmnElementType.BUSINESS_RULE_TASK).hasFlowScopeKey(processInstanceKey).hasBpmnProcessId(PROCESS_ID).hasProcessInstanceKey(processInstanceKey).hasTenantId("foo");
    }

    @Test
    public void shouldWriteDecisionEvaluationEvent() {
        BpmnModelInstance process = TenantAwareBusinessRuleTaskTest.processWithBusinessRuleTask();
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource("process.bpmn", process).withXmlClasspathResource(DMN_DECISION_TABLE).withTenantId("foo").deploy();
        this.deployedDecisionsById = ((DeploymentRecordValue)deployment.getValue()).getDecisionsMetadata().stream().collect(Collectors.toMap(DecisionRecordValue::getDecisionId, Function.identity()));
        ENGINE.deployment().withXmlResource("process.bpmn", process).withTenantId("bar").deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withTenantId("foo").withVariable("lightsaberColor", "blue").create();
        DecisionRecordValue calledDecision = this.deployedDecisionsById.get(DECISION_ID);
        Record decisionEvaluationRecord = (Record)RecordingExporter.decisionEvaluationRecords().withProcessInstanceKey(processInstanceKey).withTenantId("foo").getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((Record)decisionEvaluationRecord).hasRecordType(RecordType.EVENT).hasValueType(ValueType.DECISION_EVALUATION).hasIntent((Intent)DecisionEvaluationIntent.EVALUATED);
        DecisionEvaluationRecordValue decisionEvaluationValue = (DecisionEvaluationRecordValue)decisionEvaluationRecord.getValue();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((DecisionEvaluationRecordValue)decisionEvaluationValue).hasDecisionKey(calledDecision.getDecisionKey()).hasDecisionId(calledDecision.getDecisionId()).hasDecisionName(calledDecision.getDecisionName()).hasDecisionVersion(calledDecision.getVersion()).hasDecisionRequirementsKey(calledDecision.getDecisionRequirementsKey()).hasDecisionRequirementsId(calledDecision.getDecisionRequirementsId()).hasTenantId("foo");
        EvaluatedDecisionValue evaluatedDecision = (EvaluatedDecisionValue)decisionEvaluationValue.getEvaluatedDecisions().get(0);
        io.camunda.zeebe.protocol.record.Assertions.assertThat((EvaluatedDecisionValue)evaluatedDecision).hasTenantId("foo");
    }

    @Test
    public void shouldWriteDecisionEvaluationEventIfEvaluationFailed() {
        BpmnModelInstance process = TenantAwareBusinessRuleTaskTest.processWithBusinessRuleTask();
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource("process.bpmn", process).withXmlClasspathResource(DMN_DECISION_TABLE_WITH_ASSERTION).withTenantId("foo").deploy();
        this.deployedDecisionsById = ((DeploymentRecordValue)deployment.getValue()).getDecisionsMetadata().stream().collect(Collectors.toMap(DecisionRecordValue::getDecisionId, Function.identity()));
        ENGINE.deployment().withXmlResource("process.bpmn", process).withTenantId("bar").deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withTenantId("foo").create();
        DecisionRecordValue calledDecision = this.deployedDecisionsById.get(DECISION_ID);
        Record decisionEvaluationRecord = (Record)RecordingExporter.decisionEvaluationRecords().withProcessInstanceKey(processInstanceKey).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((Record)decisionEvaluationRecord).hasRecordType(RecordType.EVENT).hasValueType(ValueType.DECISION_EVALUATION).hasIntent((Intent)DecisionEvaluationIntent.FAILED);
        DecisionEvaluationRecordValue decisionEvaluationValue = (DecisionEvaluationRecordValue)decisionEvaluationRecord.getValue();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((DecisionEvaluationRecordValue)decisionEvaluationValue).hasDecisionKey(calledDecision.getDecisionKey()).hasDecisionId(calledDecision.getDecisionId()).hasDecisionName(calledDecision.getDecisionName()).hasDecisionVersion(calledDecision.getVersion()).hasDecisionRequirementsKey(calledDecision.getDecisionRequirementsKey()).hasDecisionRequirementsId(calledDecision.getDecisionRequirementsId()).hasTenantId("foo").hasEvaluationFailureMessage("Expected to evaluate decision 'jedi_or_sith', but Assertion failure on evaluate the expression 'assert(lightsaberColor, lightsaberColor != null)': The condition is not fulfilled");
        EvaluatedDecisionValue evaluatedDecision = (EvaluatedDecisionValue)decisionEvaluationValue.getEvaluatedDecisions().get(0);
        io.camunda.zeebe.protocol.record.Assertions.assertThat((EvaluatedDecisionValue)evaluatedDecision).hasTenantId("foo");
    }

    @Test
    public void shouldNotActivateBusinessRuleTask() {
        BpmnModelInstance process = TenantAwareBusinessRuleTaskTest.processWithBusinessRuleTask();
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource("process.bpmn", process).withXmlClasspathResource(DMN_DECISION_TABLE).withTenantId("foo").deploy();
        this.deployedDecisionsById = ((DeploymentRecordValue)deployment.getValue()).getDecisionsMetadata().stream().collect(Collectors.toMap(DecisionRecordValue::getDecisionId, Function.identity()));
        ENGINE.deployment().withXmlResource("process.bpmn", process).withTenantId("bar").deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withTenantId("bar").withVariable("lightsaberColor", "blue").create();
        Assertions.assertThat((Stream)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().onlyEvents()).withProcessInstanceKey(processInstanceKey).withTenantId("bar").withElementType(BpmnElementType.BUSINESS_RULE_TASK).withIntent((Intent)ProcessInstanceIntent.ELEMENT_ACTIVATED)).isEmpty();
        Record incident = (Record)RecordingExporter.incidentRecords().withProcessInstanceKey(processInstanceKey).withElementId(TASK_ID).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((IncidentRecordValue)((IncidentRecordValue)incident.getValue())).hasErrorType(ErrorType.CALLED_DECISION_ERROR).hasErrorMessage("Expected to evaluate decision 'jedi_or_sith', but no decision found for id 'jedi_or_sith'");
    }
}

