/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.multitenancy;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.builder.BoundaryEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.EndEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.IntermediateCatchEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.IntermediateThrowEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.StartEventBuilder;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RecordAssert;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.intent.SignalIntent;
import io.camunda.zeebe.protocol.record.value.SignalRecordValue;
import io.camunda.zeebe.test.util.Strings;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import io.camunda.zeebe.test.util.record.SignalRecordStream;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestWatcher;

public class TenantAwareSignalEventTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    @Rule
    public final TestWatcher testWatcher = new RecordingExporterTestWatcher();
    private String processId;
    private String signalName;

    @Before
    public void setup() {
        this.processId = Strings.newRandomValidBpmnId();
        this.signalName = "signal-%s".formatted(this.processId);
    }

    @Test
    public void shouldBroadcastSignalForDefaultTenant() {
        ENGINE.deployment().withXmlResource(((StartEventBuilder)Bpmn.createExecutableProcess((String)this.processId).startEvent("signal-start").signal(this.signalName)).endEvent().done()).withTenantId("<default>").deploy();
        Record<SignalRecordValue> broadcasted = ENGINE.signal().withSignalName(this.signalName).broadcast();
        ((RecordAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat(broadcasted).describedAs("Expect that signal was broadcast successfully", new Object[0])).hasIntent((Intent)SignalIntent.BROADCASTED);
        ((RecordAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat((Record)((Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withBpmnProcessId(this.processId).withElementId("signal-start").getFirst())).describedAs("Expect that process instance was created", new Object[0])).isNotNull();
    }

    @Test
    public void shouldBroadcastSignalForSpecificTenant() {
        String tenantId = "custom-tenant";
        ENGINE.deployment().withXmlResource(((StartEventBuilder)Bpmn.createExecutableProcess((String)this.processId).startEvent("signal-start").signal(this.signalName)).endEvent().done()).withTenantId("custom-tenant").deploy();
        Record<SignalRecordValue> broadcasted = ENGINE.signal().withSignalName(this.signalName).withTenantId("custom-tenant").broadcast();
        ((RecordAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat(broadcasted).describedAs("Expect that signal was broadcast successfully", new Object[0])).hasIntent((Intent)SignalIntent.BROADCASTED);
        ((RecordAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat((Record)((Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withBpmnProcessId(this.processId).withElementId("signal-start").withTenantId("custom-tenant").getFirst())).describedAs("Expect that process instance was created", new Object[0])).isNotNull();
    }

    @Test
    public void shouldBroadcastToSignalCatchEventForSpecificTenant() {
        String tenantId = "custom-tenant";
        ENGINE.deployment().withXmlResource(((IntermediateCatchEventBuilder)Bpmn.createExecutableProcess((String)this.processId).startEvent().intermediateCatchEvent("signal-catch").signal(this.signalName)).endEvent().done()).withTenantId("custom-tenant").deploy();
        ENGINE.processInstance().ofBpmnProcessId(this.processId).withTenantId("custom-tenant").create();
        Record<SignalRecordValue> broadcasted = ENGINE.signal().withSignalName(this.signalName).withTenantId("custom-tenant").broadcast();
        ((RecordAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat(broadcasted).describedAs("Expect that signal was broadcast successfully", new Object[0])).hasIntent((Intent)SignalIntent.BROADCASTED);
        ((RecordAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat((Record)((Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withBpmnProcessId(this.processId).withElementId("signal-catch").withTenantId("custom-tenant").getFirst())).describedAs("Expect that a signal catch event was activated", new Object[0])).isNotNull();
    }

    @Test
    public void shouldBroadcastToSignalCatchEventAttachedToEventBasedGatewayForSpecificTenant() {
        String tenantId = "custom-tenant";
        ENGINE.deployment().withXmlResource(((IntermediateCatchEventBuilder)((IntermediateCatchEventBuilder)Bpmn.createExecutableProcess((String)this.processId).startEvent().eventBasedGateway().intermediateCatchEvent("signal-catch-attached").signal(this.signalName)).endEvent().moveToLastGateway().intermediateCatchEvent().message(m -> m.name("message").zeebeCorrelationKeyExpression("123"))).endEvent().done()).withTenantId("custom-tenant").deploy();
        ENGINE.processInstance().ofBpmnProcessId(this.processId).withTenantId("custom-tenant").create();
        Record<SignalRecordValue> broadcasted = ENGINE.signal().withSignalName(this.signalName).withTenantId("custom-tenant").broadcast();
        ((RecordAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat(broadcasted).describedAs("Expect that signal was broadcast successfully", new Object[0])).hasIntent((Intent)SignalIntent.BROADCASTED);
        ((RecordAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat((Record)((Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withBpmnProcessId(this.processId).withElementId("signal-catch-attached").withTenantId("custom-tenant").getFirst())).describedAs("Expect that a signal catch event was activated", new Object[0])).isNotNull();
    }

    @Test
    public void shouldBroadcastToSignalEventSubProcessEventForSpecificTenant() {
        String tenantId = "custom-tenant";
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)this.processId).eventSubProcess("signal-sub", sub -> ((StartEventBuilder)sub.startEvent("signal-start-event-sub").signal(this.signalName)).endEvent()).startEvent().userTask().endEvent().done()).withTenantId("custom-tenant").deploy();
        ENGINE.processInstance().ofBpmnProcessId(this.processId).withTenantId("custom-tenant").create();
        Record<SignalRecordValue> broadcasted = ENGINE.signal().withSignalName(this.signalName).withTenantId("custom-tenant").broadcast();
        ((RecordAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat(broadcasted).describedAs("Expect that signal was broadcast successfully", new Object[0])).hasIntent((Intent)SignalIntent.BROADCASTED);
        ((RecordAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat((Record)((Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withBpmnProcessId(this.processId).withElementId("signal-start-event-sub").withTenantId("custom-tenant").getFirst())).describedAs("Expect that an event sub-process was activated", new Object[0])).isNotNull();
    }

    @Test
    public void shouldBroadcastToSignalBoundaryEventForSpecificTenant() {
        String tenantId = "custom-tenant";
        ENGINE.deployment().withXmlResource(((BoundaryEventBuilder)Bpmn.createExecutableProcess((String)this.processId).startEvent().userTask().boundaryEvent("signal-boundary").signal(this.signalName)).endEvent().done()).withTenantId("custom-tenant").deploy();
        ENGINE.processInstance().ofBpmnProcessId(this.processId).withTenantId("custom-tenant").create();
        Record<SignalRecordValue> broadcasted = ENGINE.signal().withSignalName(this.signalName).withTenantId("custom-tenant").broadcast();
        ((RecordAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat(broadcasted).describedAs("Expect that signal was broadcast successfully", new Object[0])).hasIntent((Intent)SignalIntent.BROADCASTED);
        ((RecordAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat((Record)((Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withBpmnProcessId(this.processId).withElementId("signal-boundary").withTenantId("custom-tenant").getFirst())).describedAs("Expect that a signal boundary event was activated", new Object[0])).isNotNull();
    }

    @Test
    public void shouldThrowIntermediateSignalEventForSpecificTenant() {
        String tenantId = "custom-tenant";
        ENGINE.deployment().withXmlResource(((IntermediateThrowEventBuilder)Bpmn.createExecutableProcess((String)this.processId).startEvent().intermediateThrowEvent("signal-throw").signal(this.signalName)).endEvent().done()).withTenantId("custom-tenant").deploy();
        ENGINE.processInstance().ofBpmnProcessId(this.processId).withTenantId("custom-tenant").create();
        ((RecordAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat((Record)((Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withBpmnProcessId(this.processId).withElementId("signal-throw").withTenantId("custom-tenant").getFirst())).describedAs("Expect that a signal throw event was activated", new Object[0])).isNotNull();
        ((RecordAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat((Record)((Record)((SignalRecordStream)RecordingExporter.signalRecords().withSignalName(this.signalName).withIntent((Intent)SignalIntent.BROADCASTED)).withTenantId("custom-tenant").getFirst())).describedAs("Expect that signal is thrown", new Object[0])).isNotNull();
    }

    @Test
    public void shouldThrowSignalEndEventForSpecificTenant() {
        String tenantId = "custom-tenant";
        ENGINE.deployment().withXmlResource(((EndEventBuilder)Bpmn.createExecutableProcess((String)this.processId).startEvent().endEvent("signal-throw-end").signal(this.signalName)).done()).withTenantId("custom-tenant").deploy();
        ENGINE.processInstance().ofBpmnProcessId(this.processId).withTenantId("custom-tenant").create();
        ((RecordAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat((Record)((Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withBpmnProcessId(this.processId).withElementId("signal-throw-end").withTenantId("custom-tenant").getFirst())).describedAs("Expect that a signal end event was activated", new Object[0])).isNotNull();
        ((RecordAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat((Record)((Record)((SignalRecordStream)RecordingExporter.signalRecords().withSignalName(this.signalName).withIntent((Intent)SignalIntent.BROADCASTED)).withTenantId("custom-tenant").getFirst())).describedAs("Expect that signal is thrown", new Object[0])).isNotNull();
    }

    @Test
    public void shouldCatchThrownSignalEndEventForSpecificTenant() {
        String tenantId = "custom-tenant";
        ENGINE.deployment().withXmlResource(((EndEventBuilder)Bpmn.createExecutableProcess((String)this.processId).startEvent().endEvent("signal-throw-end").signal(this.signalName)).done()).withTenantId("custom-tenant").deploy();
        String signalCatchingProcess = this.processId + "catch";
        ENGINE.deployment().withXmlResource(((StartEventBuilder)Bpmn.createExecutableProcess((String)signalCatchingProcess).startEvent("signal-start").signal(this.signalName)).endEvent().done()).withTenantId("custom-tenant").deploy();
        ENGINE.processInstance().ofBpmnProcessId(this.processId).withTenantId("custom-tenant").create();
        ((RecordAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat((Record)((Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withBpmnProcessId(this.processId).withElementId("signal-throw-end").withTenantId("custom-tenant").getFirst())).describedAs("Expect that a signal throw event was created", new Object[0])).isNotNull();
        ((RecordAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat((Record)((Record)((SignalRecordStream)RecordingExporter.signalRecords().withSignalName(this.signalName).withIntent((Intent)SignalIntent.BROADCASTED)).withTenantId("custom-tenant").getFirst())).describedAs("Expect that signal is thrown", new Object[0])).isNotNull();
        ((RecordAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat((Record)((Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withBpmnProcessId(signalCatchingProcess).withElementId("signal-start").withTenantId("custom-tenant").getFirst())).describedAs("Expect that process instance was created", new Object[0])).isNotNull();
    }

    @Test
    public void shouldNotCatchThrownSignalEndEventForDifferentTenant() {
        String tenantIdA = "custom-tenant-a";
        String tenantIdB = "custom-tenant-b";
        ENGINE.deployment().withXmlResource(((EndEventBuilder)Bpmn.createExecutableProcess((String)this.processId).startEvent().endEvent("signal-throw-end").signal(this.signalName)).done()).withTenantId("custom-tenant-a").deploy();
        String signalCatchingProcess = this.processId + "catch";
        ENGINE.deployment().withXmlResource(((StartEventBuilder)Bpmn.createExecutableProcess((String)signalCatchingProcess).startEvent("signal-start").signal(this.signalName)).endEvent().done()).withTenantId("custom-tenant-b").deploy();
        ENGINE.processInstance().ofBpmnProcessId(this.processId).withTenantId("custom-tenant-a").create();
        ((RecordAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat((Record)((Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withBpmnProcessId(this.processId).withElementId("signal-throw-end").withTenantId("custom-tenant-a").getFirst())).describedAs("Expect that a signal throw event was created", new Object[0])).isNotNull();
        ((RecordAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat((Record)((Record)((SignalRecordStream)RecordingExporter.signalRecords().withSignalName(this.signalName).withIntent((Intent)SignalIntent.BROADCASTED)).withTenantId("custom-tenant-a").getFirst())).describedAs("Expect that signal is thrown", new Object[0])).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withBpmnProcessId(signalCatchingProcess).withElementId("signal-start").withTenantId("custom-tenant-b").exists()).describedAs("Expect that process instance was not created", new Object[0])).isFalse();
    }
}

