/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.multitenancy;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.AbstractBpmnModelElementBuilder;
import io.camunda.zeebe.model.bpmn.builder.StartEventBuilder;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.intent.TimerIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.BpmnEventType;
import io.camunda.zeebe.protocol.record.value.DeploymentRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.protocol.record.value.TimerRecordValue;
import io.camunda.zeebe.protocol.record.value.deployment.ProcessMetadataValue;
import io.camunda.zeebe.test.util.record.ProcessInstanceRecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.TimerRecordStream;
import java.time.Duration;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.groups.Tuple;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class TenantAwareTimerStartEventTest {
    private static final String PROCESS_ID = "process";
    private static final String TENANT = "tenant-a";
    @Rule
    public final EngineRule engine = EngineRule.singlePartition();
    private long processDefinitionKey;

    private static BpmnModelInstance processWithTimerStartEvent(Consumer<StartEventBuilder> consumer) {
        StartEventBuilder builder = Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent("startEvent");
        consumer.accept(builder);
        return builder.endEvent().done();
    }

    @Before
    public void init() {
        BpmnModelInstance process = TenantAwareTimerStartEventTest.processWithTimerStartEvent(c -> c.timerWithCycle("R2/PT1M"));
        Record<DeploymentRecordValue> deployment = this.engine.deployment().withXmlResource(process).withTenantId(TENANT).deploy();
        this.processDefinitionKey = ((ProcessMetadataValue)((DeploymentRecordValue)deployment.getValue()).getProcessesMetadata().get(0)).getProcessDefinitionKey();
    }

    @Test
    public void shouldCreateTimer() {
        Record timerRecord = (Record)RecordingExporter.timerRecords((TimerIntent)TimerIntent.CREATED).withProcessDefinitionKey(this.processDefinitionKey).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((TimerRecordValue)((TimerRecordValue)timerRecord.getValue())).hasTenantId(TENANT);
    }

    @Test
    public void shouldTriggerTimer() {
        this.engine.increaseTime(Duration.ofMinutes(1L));
        Assertions.assertThat((Stream)RecordingExporter.timerRecords((TimerIntent)TimerIntent.TRIGGERED).withProcessDefinitionKey(this.processDefinitionKey)).extracting(new Function[]{r -> ((TimerRecordValue)r.getValue()).getTenantId(), Record::getIntent}).containsSequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{TENANT, TimerIntent.TRIGGERED})});
    }

    @Test
    public void shouldRescheduleTimer() {
        Record timerCreated = (Record)RecordingExporter.timerRecords((TimerIntent)TimerIntent.CREATED).withProcessDefinitionKey(this.processDefinitionKey).getFirst();
        this.engine.increaseTime(Duration.ofMinutes(1L));
        Record timerRescheduled = (Record)((TimerRecordStream)RecordingExporter.timerRecords((TimerIntent)TimerIntent.CREATED).withProcessDefinitionKey(this.processDefinitionKey).limit(2L)).getLast();
        Assertions.assertThat((long)timerRescheduled.getKey()).isGreaterThan(timerCreated.getKey());
        io.camunda.zeebe.protocol.record.Assertions.assertThat((TimerRecordValue)((TimerRecordValue)timerRescheduled.getValue())).hasTenantId(TENANT);
    }

    @Test
    public void shouldCreateProcessInstance() {
        this.engine.increaseTime(Duration.ofMinutes(1L));
        Assertions.assertThat((Stream)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().onlyEvents()).withProcessDefinitionKey(this.processDefinitionKey).withElementType(BpmnElementType.START_EVENT).withEventType(BpmnEventType.TIMER).limit("startEvent", ProcessInstanceIntent.ELEMENT_COMPLETED)).extracting(new Function[]{r -> ((ProcessInstanceRecordValue)r.getValue()).getTenantId(), Record::getIntent}).containsSequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{TENANT, ProcessInstanceIntent.ELEMENT_ACTIVATING}), Assertions.tuple((Object[])new Object[]{TENANT, ProcessInstanceIntent.ELEMENT_ACTIVATED}), Assertions.tuple((Object[])new Object[]{TENANT, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{TENANT, ProcessInstanceIntent.ELEMENT_COMPLETED})});
    }

    @Test
    public void shouldCancelTimerWhenDeployingNewProcessDefinitionVersionWithoutTimer() {
        BpmnModelInstance process = TenantAwareTimerStartEventTest.processWithTimerStartEvent(AbstractBpmnModelElementBuilder::done);
        this.engine.deployment().withXmlResource(process).withTenantId(TENANT).deploy();
        Record canceledEvent = (Record)RecordingExporter.timerRecords((TimerIntent)TimerIntent.CANCELED).withProcessDefinitionKey(this.processDefinitionKey).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((TimerRecordValue)((TimerRecordValue)canceledEvent.getValue())).hasTenantId(TENANT);
    }

    @Test
    public void shouldCreateNewTimerWhenDeployingNewProcessDefinitionVersionWithTimer() {
        Assertions.assertThat((boolean)RecordingExporter.timerRecords((TimerIntent)TimerIntent.CREATED).withProcessDefinitionKey(this.processDefinitionKey).exists()).isTrue();
        BpmnModelInstance process = TenantAwareTimerStartEventTest.processWithTimerStartEvent(c -> c.timerWithCycle("R/PT1M"));
        Record<DeploymentRecordValue> deployment = this.engine.deployment().withXmlResource(process).withTenantId(TENANT).deploy();
        long latestProcessDefinitionKey = ((ProcessMetadataValue)((DeploymentRecordValue)deployment.getValue()).getProcessesMetadata().get(0)).getProcessDefinitionKey();
        Record canceledEvent = (Record)RecordingExporter.timerRecords((TimerIntent)TimerIntent.CANCELED).withProcessDefinitionKey(this.processDefinitionKey).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((TimerRecordValue)((TimerRecordValue)canceledEvent.getValue())).hasTenantId(TENANT);
        Record newCreatedTimer = (Record)RecordingExporter.timerRecords((TimerIntent)TimerIntent.CREATED).withProcessDefinitionKey(latestProcessDefinitionKey).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((TimerRecordValue)((TimerRecordValue)newCreatedTimer.getValue())).hasTenantId(TENANT);
    }

    @Test
    public void shouldCancelTimerWhenDeletingProcessDefinition() {
        Assertions.assertThat((boolean)RecordingExporter.timerRecords((TimerIntent)TimerIntent.CREATED).withProcessDefinitionKey(this.processDefinitionKey).exists()).isTrue();
        this.engine.resourceDeletion().withResourceKey(this.processDefinitionKey).withAuthorizedTenantIds(TENANT).delete();
        Record canceledEvent = (Record)RecordingExporter.timerRecords((TimerIntent)TimerIntent.CANCELED).withProcessDefinitionKey(this.processDefinitionKey).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((TimerRecordValue)((TimerRecordValue)canceledEvent.getValue())).hasTenantId(TENANT);
    }

    @Test
    public void shouldRecreateTimerWhenDeletingLatestProcessDefinition() {
        Assertions.assertThat((boolean)RecordingExporter.timerRecords((TimerIntent)TimerIntent.CREATED).withProcessDefinitionKey(this.processDefinitionKey).exists()).isTrue();
        BpmnModelInstance process = TenantAwareTimerStartEventTest.processWithTimerStartEvent(c -> c.timerWithCycle("R/PT1M"));
        Record<DeploymentRecordValue> deployment = this.engine.deployment().withXmlResource(process).withTenantId(TENANT).deploy();
        long latestProcessDefinitionKey = ((ProcessMetadataValue)((DeploymentRecordValue)deployment.getValue()).getProcessesMetadata().get(0)).getProcessDefinitionKey();
        this.engine.resourceDeletion().withResourceKey(latestProcessDefinitionKey).withAuthorizedTenantIds(TENANT).delete();
        Record canceledEvent = (Record)RecordingExporter.timerRecords((TimerIntent)TimerIntent.CANCELED).withProcessDefinitionKey(latestProcessDefinitionKey).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((TimerRecordValue)((TimerRecordValue)canceledEvent.getValue())).hasTenantId(TENANT);
        Record recreatedTimerRecord = (Record)((TimerRecordStream)RecordingExporter.timerRecords((TimerIntent)TimerIntent.CREATED).withProcessDefinitionKey(this.processDefinitionKey).limit(2L)).getLast();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((TimerRecordValue)((TimerRecordValue)recreatedTimerRecord.getValue())).hasTenantId(TENANT);
    }

    @Test
    public void shouldCreateTimerForAnotherTenantWhenHavingSameBPMNProcessId() {
        String tenantB = "tenant-b";
        BpmnModelInstance processWithSameBPMNProcessId = TenantAwareTimerStartEventTest.processWithTimerStartEvent(c -> c.timerWithCycle("R2/PT1M"));
        Assertions.assertThat((boolean)RecordingExporter.timerRecords((TimerIntent)TimerIntent.CREATED).withProcessDefinitionKey(this.processDefinitionKey).exists()).isTrue();
        Record<DeploymentRecordValue> tenantBDeployment = this.engine.deployment().withXmlResource(processWithSameBPMNProcessId).withTenantId("tenant-b").deploy();
        long tenantBProcessDefinitionKey = ((ProcessMetadataValue)((DeploymentRecordValue)tenantBDeployment.getValue()).getProcessesMetadata().get(0)).getProcessDefinitionKey();
        Assertions.assertThat((boolean)RecordingExporter.timerRecords((TimerIntent)TimerIntent.CANCELED).withProcessDefinitionKey(this.processDefinitionKey).exists()).isFalse();
        Assertions.assertThat((boolean)RecordingExporter.timerRecords((TimerIntent)TimerIntent.CREATED).withProcessDefinitionKey(tenantBProcessDefinitionKey).exists()).isTrue();
    }
}

