/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.processinstance;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.engine.util.RecordToWrite;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.MultiInstanceLoopCharacteristicsBuilder;
import io.camunda.zeebe.model.bpmn.builder.ServiceTaskBuilder;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.JobRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.test.util.record.ProcessInstanceRecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public final class CancelProcessInstanceConcurrentlyTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    private static final String PROCESS_ID = "process";
    private static final String ELEMENT_ID = "task";
    private static final String JOB_TYPE = "test";
    private static final String INPUT_COLLECTION_VARIABLE = "items";
    private static final BpmnModelInstance SEQUENTIAL_FLOW = Bpmn.createExecutableProcess((String)"process").startEvent().parallelGateway("fork").serviceTask("task", t -> t.zeebeJobType(JOB_TYPE)).serviceTask("task-after", t -> t.zeebeJobType("nope")).done();
    private static final BpmnModelInstance PARALLEL_FLOW = Bpmn.createExecutableProcess((String)"process").startEvent().parallelGateway("fork").serviceTask("task", t -> t.zeebeJobType(JOB_TYPE)).endEvent().moveToLastGateway().serviceTask("parallel-task", t -> t.zeebeJobType("nope")).endEvent().done();
    private static final BpmnModelInstance SUB_PROCESS = Bpmn.createExecutableProcess((String)"process").startEvent().subProcess("sub-process", s -> s.embeddedSubProcess().startEvent().parallelGateway("fork").serviceTask(ELEMENT_ID, t -> t.zeebeJobType(JOB_TYPE)).endEvent().moveToLastGateway().serviceTask("parallel-task", t -> t.zeebeJobType("nope")).endEvent()).done();
    private static final BpmnModelInstance MULTI_INSTANCE = Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask("task", t -> ((ServiceTaskBuilder)t.zeebeJobType(JOB_TYPE)).multiInstance(m -> ((MultiInstanceLoopCharacteristicsBuilder)m.parallel()).zeebeInputCollectionExpression(INPUT_COLLECTION_VARIABLE))).serviceTask("task-after", t -> t.zeebeJobType("nope")).done();
    @Rule
    public final RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();
    @Parameterized.Parameter(value=0)
    public String description;
    @Parameterized.Parameter(value=1)
    public BpmnModelInstance process;
    @Parameterized.Parameter(value=2)
    public int expectedActivatableJobs;
    @Parameterized.Parameter(value=3)
    public List<String> expectedTerminatedElementIds;
    private long processInstanceKey;
    private Record<JobRecordValue> createdJob;
    private Record<ProcessInstanceRecordValue> activityActivated;

    @Parameterized.Parameters(name="{0}")
    public static Object[][] parameters() {
        return new Object[][]{{"sequential flow", SEQUENTIAL_FLOW, 1, Arrays.asList(PROCESS_ID)}, {"parallel flow", PARALLEL_FLOW, 2, Arrays.asList("parallel-task", PROCESS_ID)}, {"sub-process", SUB_PROCESS, 2, Arrays.asList("parallel-task", "sub-process", PROCESS_ID)}, {"multi-instance", MULTI_INSTANCE, 2, Arrays.asList(ELEMENT_ID, ELEMENT_ID, PROCESS_ID)}};
    }

    @Before
    public void init() {
        ENGINE.deployment().withXmlResource(this.process).deploy();
        this.processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariable(INPUT_COLLECTION_VARIABLE, Arrays.asList("one", "two")).create();
        this.activityActivated = (Record)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(this.processInstanceKey).withElementId(ELEMENT_ID).withIntent((Intent)ProcessInstanceIntent.ELEMENT_ACTIVATED)).withElementType(BpmnElementType.SERVICE_TASK).getFirst();
        Assertions.assertThat((Stream)RecordingExporter.jobRecords((JobIntent)JobIntent.CREATED).withProcessInstanceKey(this.processInstanceKey).limit((long)this.expectedActivatableJobs)).hasSize(this.expectedActivatableJobs);
        this.createdJob = (Record)RecordingExporter.jobRecords((JobIntent)JobIntent.CREATED).withProcessInstanceKey(this.processInstanceKey).withType(JOB_TYPE).getFirst();
        ENGINE.stop();
    }

    @Test
    public void shouldCancelAfterJobComplete() {
        ENGINE.writeRecords(RecordToWrite.command().job(JobIntent.COMPLETE, (JobRecordValue)this.createdJob.getValue()).key(this.createdJob.getKey()), RecordToWrite.command().processInstance(ProcessInstanceIntent.CANCEL, (ProcessInstanceRecordValue)new ProcessInstanceRecord()).key(this.processInstanceKey));
        ENGINE.start();
        ((AbstractListAssert)Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(this.processInstanceKey).limitToProcessInstanceTerminated().filter(r -> r.getIntent() == ProcessInstanceIntent.ELEMENT_TERMINATED || r.getIntent() == ProcessInstanceIntent.ELEMENT_COMPLETED)).extracting(r -> ((ProcessInstanceRecordValue)r.getValue()).getElementId()).containsSubsequence(this.expectedTerminatedElementIds)).contains((Object[])new String[]{ELEMENT_ID});
    }

    @Test
    public void shouldCancelAfterJobCompleted() {
        ENGINE.writeRecords(RecordToWrite.command().job(JobIntent.COMPLETE, (JobRecordValue)this.createdJob.getValue()).key(this.createdJob.getKey()), RecordToWrite.event().job(JobIntent.COMPLETED, (JobRecordValue)this.createdJob.getValue()).key(this.createdJob.getKey()).causedBy(0), RecordToWrite.command().processInstance(ProcessInstanceIntent.CANCEL, (ProcessInstanceRecordValue)new ProcessInstanceRecord()).key(this.processInstanceKey));
        ENGINE.start();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(this.processInstanceKey).limitToProcessInstanceTerminated().filter(r -> r.getIntent() == ProcessInstanceIntent.ELEMENT_TERMINATED)).extracting(r -> ((ProcessInstanceRecordValue)r.getValue()).getElementId()).containsSubsequence(this.expectedTerminatedElementIds);
    }

    @Test
    public void shouldCancelAfterElementCompleting() {
        ENGINE.writeRecords(RecordToWrite.command().job(JobIntent.COMPLETE, (JobRecordValue)this.createdJob.getValue()).key(this.createdJob.getKey()), RecordToWrite.event().job(JobIntent.COMPLETED, (JobRecordValue)this.createdJob.getValue()).key(this.createdJob.getKey()).causedBy(0), RecordToWrite.event().processInstance(ProcessInstanceIntent.ELEMENT_COMPLETING, (ProcessInstanceRecordValue)this.activityActivated.getValue()).key(this.activityActivated.getKey()).causedBy(1), RecordToWrite.command().processInstance(ProcessInstanceIntent.CANCEL, (ProcessInstanceRecordValue)new ProcessInstanceRecord()).key(this.processInstanceKey));
        ENGINE.start();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(this.processInstanceKey).limitToProcessInstanceTerminated().filter(r -> r.getIntent() == ProcessInstanceIntent.ELEMENT_TERMINATED)).extracting(r -> ((ProcessInstanceRecordValue)r.getValue()).getElementId()).containsSubsequence(this.expectedTerminatedElementIds);
    }

    @Test
    public void shouldCancelAfterElementCompleted() {
        ENGINE.writeRecords(RecordToWrite.command().job(JobIntent.COMPLETE, (JobRecordValue)this.createdJob.getValue()).key(this.createdJob.getKey()), RecordToWrite.event().job(JobIntent.COMPLETED, (JobRecordValue)this.createdJob.getValue()).key(this.createdJob.getKey()).causedBy(0), RecordToWrite.event().processInstance(ProcessInstanceIntent.ELEMENT_COMPLETING, (ProcessInstanceRecordValue)this.activityActivated.getValue()).key(this.activityActivated.getKey()).causedBy(1), RecordToWrite.event().processInstance(ProcessInstanceIntent.ELEMENT_COMPLETED, (ProcessInstanceRecordValue)this.activityActivated.getValue()).key(this.activityActivated.getKey()).causedBy(2), RecordToWrite.command().processInstance(ProcessInstanceIntent.CANCEL, (ProcessInstanceRecordValue)new ProcessInstanceRecord()).key(this.processInstanceKey));
        ENGINE.start();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(this.processInstanceKey).limitToProcessInstanceTerminated().filter(r -> r.getIntent() == ProcessInstanceIntent.ELEMENT_TERMINATED)).extracting(r -> ((ProcessInstanceRecordValue)r.getValue()).getElementId()).containsSubsequence(this.expectedTerminatedElementIds);
    }
}

