/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.processinstance;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.ExclusiveGatewayBuilder;
import io.camunda.zeebe.model.bpmn.builder.IntermediateCatchEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.MultiInstanceLoopCharacteristicsBuilder;
import io.camunda.zeebe.model.bpmn.builder.ReceiveTaskBuilder;
import io.camunda.zeebe.model.bpmn.builder.ServiceTaskBuilder;
import io.camunda.zeebe.model.bpmn.builder.StartEventBuilder;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.test.util.record.ProcessInstanceRecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.groups.Tuple;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class CreateProcessInstanceSupportedElementTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    private static final String PROCESS_ID = "processId";
    private static final String CHILD_PROCESS_ID = "childProcessId";
    private static final String START_ELEMENT_ID = "startElement";
    private static final String MESSAGE = "message";
    private static final String JOBTYPE = "jobtype";
    @Rule
    public final RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();
    private final Scenario scenario;

    public CreateProcessInstanceSupportedElementTest(Scenario scenario) {
        this.scenario = scenario;
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object> scenarios() {
        return List.of(new Scenario(BpmnElementType.SUB_PROCESS, Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().subProcess(START_ELEMENT_ID).embeddedSubProcess().startEvent().subProcessDone().done(), Collections.emptyMap()), new Scenario(BpmnElementType.EVENT_SUB_PROCESS, Bpmn.createExecutableProcess((String)PROCESS_ID).eventSubProcess(START_ELEMENT_ID, e -> ((StartEventBuilder)e.startEvent().timerWithDuration("PT1H")).endEvent()).startEvent().endEvent().done(), Collections.emptyMap()), new Scenario(BpmnElementType.INTERMEDIATE_CATCH_EVENT, ((IntermediateCatchEventBuilder)Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().intermediateCatchEvent(START_ELEMENT_ID).message(b -> b.name(MESSAGE).zeebeCorrelationKeyExpression("correlationKey"))).done(), Map.of("correlationKey", "value")), new Scenario(BpmnElementType.INTERMEDIATE_THROW_EVENT, Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().intermediateThrowEvent(START_ELEMENT_ID).endEvent().done(), Collections.emptyMap()), new Scenario(BpmnElementType.END_EVENT, Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().endEvent(START_ELEMENT_ID).done(), Collections.emptyMap()), new Scenario(BpmnElementType.SERVICE_TASK, Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().serviceTask(START_ELEMENT_ID, b -> b.zeebeJobType(JOBTYPE)).done(), Collections.emptyMap()), new Scenario(BpmnElementType.RECEIVE_TASK, ((ReceiveTaskBuilder)Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().receiveTask(START_ELEMENT_ID).message(b -> b.name(MESSAGE).zeebeCorrelationKeyExpression("correlationKey"))).done(), Map.of("correlationKey", "value")), new Scenario(BpmnElementType.USER_TASK, Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().userTask(START_ELEMENT_ID).done(), Collections.emptyMap()), new Scenario(BpmnElementType.MANUAL_TASK, Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().manualTask(START_ELEMENT_ID).endEvent().done(), Collections.emptyMap()), new Scenario(BpmnElementType.EXCLUSIVE_GATEWAY, ((ExclusiveGatewayBuilder)Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().exclusiveGateway(START_ELEMENT_ID).defaultFlow()).endEvent().done(), Collections.emptyMap()), new Scenario(BpmnElementType.PARALLEL_GATEWAY, Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().parallelGateway(START_ELEMENT_ID).endEvent().done(), Collections.emptyMap()), new Scenario(BpmnElementType.EVENT_BASED_GATEWAY, ((IntermediateCatchEventBuilder)((IntermediateCatchEventBuilder)Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().eventBasedGateway(START_ELEMENT_ID).intermediateCatchEvent().message(b -> b.name(MESSAGE).zeebeCorrelationKeyExpression("correlationKey"))).moveToLastGateway().intermediateCatchEvent().timerWithDuration("PT1H")).done(), Map.of("correlationKey", "value")), new Scenario(BpmnElementType.MULTI_INSTANCE_BODY, Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().serviceTask(START_ELEMENT_ID, t -> ((ServiceTaskBuilder)t.zeebeJobType(JOBTYPE)).multiInstance(m -> ((MultiInstanceLoopCharacteristicsBuilder)m.parallel()).zeebeInputCollectionExpression("[1]"))).endEvent().done(), Collections.emptyMap()), new Scenario(BpmnElementType.CALL_ACTIVITY, Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().callActivity(START_ELEMENT_ID, c -> c.zeebeProcessId(CHILD_PROCESS_ID)).endEvent().done(), Collections.emptyMap()), new Scenario(BpmnElementType.BUSINESS_RULE_TASK, Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().businessRuleTask(START_ELEMENT_ID, b -> b.zeebeJobType(JOBTYPE)).done(), Collections.emptyMap()), new Scenario(BpmnElementType.SCRIPT_TASK, Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().scriptTask(START_ELEMENT_ID, b -> b.zeebeJobType(JOBTYPE)).done(), Collections.emptyMap()), new Scenario(BpmnElementType.SEND_TASK, Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().sendTask(START_ELEMENT_ID, b -> b.zeebeJobType(JOBTYPE)).done(), Collections.emptyMap()));
    }

    @Test
    public void testProcessInstanceCanStartAtElementType() {
        ENGINE.deployment().withXmlResource(this.scenario.modelInstance).deploy();
        if (this.scenario.type == BpmnElementType.CALL_ACTIVITY) {
            ENGINE.deployment().withXmlResource(this.getChildProcess()).deploy();
        }
        long instanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withStartInstruction(START_ELEMENT_ID).withVariables(this.scenario.variables).create();
        Assertions.assertThat((Stream)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(instanceKey).onlyEvents()).limit(r -> ((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType() == this.scenario.type && r.getIntent() == ProcessInstanceIntent.ELEMENT_ACTIVATED)).extracting(new Function[]{record -> ((ProcessInstanceRecordValue)record.getValue()).getBpmnElementType(), Record::getIntent}).containsSequence((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_ACTIVATING}), Tuple.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_ACTIVATED}), Tuple.tuple((Object[])new Object[]{this.scenario.type, ProcessInstanceIntent.ELEMENT_ACTIVATING}), Tuple.tuple((Object[])new Object[]{this.scenario.type, ProcessInstanceIntent.ELEMENT_ACTIVATED})});
    }

    private BpmnModelInstance getChildProcess() {
        return Bpmn.createExecutableProcess((String)CHILD_PROCESS_ID).startEvent().endEvent().done();
    }

    record Scenario(BpmnElementType type, BpmnModelInstance modelInstance, Map<String, Object> variables) {
    }
}

