/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.processinstance;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.builder.BoundaryEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.StartEventBuilder;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceCreationIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.test.util.record.ProcessInstanceCreationRecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import java.util.Arrays;
import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class CreateProcessInstanceUnsupportedElementTypeTest {
    private static final String PROCESS_ID = "process-id";
    @Rule
    public final EngineRule engine = EngineRule.singlePartition();
    @Rule
    public final RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();
    private final BpmnElementType elementType;
    private final String elementId;

    public CreateProcessInstanceUnsupportedElementTypeTest(BpmnElementType elementType, String elementId) {
        this.elementType = elementType;
        this.elementId = elementId;
    }

    @Test
    public void shouldRejectCommandIfElementTargetsUnsupportedElementType() {
        this.engine.deployment().withXmlResource(((StartEventBuilder)Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent("rootStartEvent").sequenceFlowId("sequenceFlow")).subProcess("subProcess", sp -> sp.embeddedSubProcess().startEvent("subStartEvent").manualTask("task").endEvent()).boundaryEvent("boundaryEvent", b -> ((BoundaryEventBuilder)b.error("ERROR")).endEvent()).endEvent().done()).deploy();
        this.engine.processInstance().ofBpmnProcessId(PROCESS_ID).withStartInstruction(this.elementId).expectRejection().create();
        Record rejectionRecord = (Record)((ProcessInstanceCreationRecordStream)RecordingExporter.processInstanceCreationRecords().onlyCommandRejections()).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((Record)rejectionRecord).hasIntent((Intent)ProcessInstanceCreationIntent.CREATE).hasRejectionType(RejectionType.INVALID_ARGUMENT);
        Assertions.assertThat((String)rejectionRecord.getRejectionReason()).contains(new CharSequence[]{"Expected to create instance of process with start instructions but the element with id '%s' targets unsupported element type '%s'. Supported element types are:".formatted(this.elementId, this.elementType)});
    }

    @Parameterized.Parameters(name="{index}: {0} - {1}")
    public static Collection<Object[]> parameters() {
        return Arrays.asList({BpmnElementType.START_EVENT, "rootStartEvent"}, {BpmnElementType.START_EVENT, "subStartEvent"}, {BpmnElementType.SEQUENCE_FLOW, "sequenceFlow"}, {BpmnElementType.BOUNDARY_EVENT, "boundaryEvent"});
    }
}

