/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.processinstance;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceResultRecord;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceResultIntent;
import io.camunda.zeebe.stream.api.CommandResponseWriter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import io.camunda.zeebe.util.buffer.BufferWriter;
import java.util.Map;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public final class CreateProcessInstanceWithResultTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    private static final BpmnModelInstance PROCESS = Bpmn.createExecutableProcess((String)"PROCESS").startEvent().endEvent().done();
    private static ProcessInstanceResultRecord response;
    private static CommandResponseWriter mockCommandResponseWriter;
    @Rule
    public final RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();

    @BeforeClass
    public static void init() {
        mockCommandResponseWriter = ENGINE.getCommandResponseWriter();
        CreateProcessInstanceWithResultTest.interceptResponseWriter(mockCommandResponseWriter);
        ENGINE.deployment().withXmlResource(PROCESS).deploy();
    }

    @Before
    public void reset() {
        Mockito.clearInvocations((Object[])new CommandResponseWriter[]{mockCommandResponseWriter});
    }

    @Test
    public void shouldSendResultAfterCompletion() {
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("PROCESS").withVariables(Map.of("x", "foo")).withResult().withRequestId(1L).withRequestStreamId(1).create();
        ((CommandResponseWriter)Mockito.verify((Object)mockCommandResponseWriter, (VerificationMode)Mockito.timeout((long)1000L).times(1))).intent((Intent)ProcessInstanceResultIntent.COMPLETED);
        ((CommandResponseWriter)Mockito.verify((Object)mockCommandResponseWriter, (VerificationMode)Mockito.timeout((long)1000L).times(1))).tryWriteResponse(1, 1L);
        Assertions.assertThat((Map)response.getVariables()).containsExactly(new Map.Entry[]{Map.entry("x", "foo")});
        Assertions.assertThat((long)response.getProcessInstanceKey()).isEqualTo(processInstanceKey);
        Assertions.assertThat((String)response.getBpmnProcessId()).isEqualTo("PROCESS");
    }

    @Test
    public void shouldSendResultWithNoVariablesAfterCompletion() {
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("PROCESS").withResult().withRequestId(1L).withRequestStreamId(1).create();
        ((CommandResponseWriter)Mockito.verify((Object)mockCommandResponseWriter, (VerificationMode)Mockito.timeout((long)1000L).times(1))).intent((Intent)ProcessInstanceResultIntent.COMPLETED);
        ((CommandResponseWriter)Mockito.verify((Object)mockCommandResponseWriter, (VerificationMode)Mockito.timeout((long)1000L).times(1))).tryWriteResponse(1, 1L);
        Assertions.assertThat((Map)response.getVariables()).isEmpty();
        Assertions.assertThat((long)response.getProcessInstanceKey()).isEqualTo(processInstanceKey);
        Assertions.assertThat((String)response.getBpmnProcessId()).isEqualTo("PROCESS");
    }

    @Test
    public void shouldSendRequestedVariablesAfterCompletion() {
        Set<String> fetchVariables = Set.of("x", "y");
        ENGINE.processInstance().ofBpmnProcessId("PROCESS").withVariables(Map.of("x", "foo", "y", "bar", "z", "foo-bar")).withResult().withFetchVariables(fetchVariables).withRequestId(1L).withRequestStreamId(1).create();
        ((CommandResponseWriter)Mockito.verify((Object)mockCommandResponseWriter, (VerificationMode)Mockito.timeout((long)1000L).times(1))).intent((Intent)ProcessInstanceResultIntent.COMPLETED);
        ((CommandResponseWriter)Mockito.verify((Object)mockCommandResponseWriter, (VerificationMode)Mockito.timeout((long)1000L).times(1))).tryWriteResponse(1, 1L);
        Assertions.assertThat((Map)response.getVariables()).containsExactlyInAnyOrderEntriesOf(Map.of("x", "foo", "y", "bar"));
    }

    @Test
    public void shouldSendRequestedVariablesWhenSomeAreNotAvailableAfterCompletion() {
        Set<String> fetchVariables = Set.of("x", "none-existing");
        ENGINE.processInstance().ofBpmnProcessId("PROCESS").withVariables(Map.of("x", "foo", "y", "bar", "z", "foo-bar")).withResult().withFetchVariables(fetchVariables).withRequestId(1L).withRequestStreamId(1).create();
        ((CommandResponseWriter)Mockito.verify((Object)ENGINE.getCommandResponseWriter(), (VerificationMode)Mockito.timeout((long)1000L).times(1))).tryWriteResponse(1, 1L);
        Assertions.assertThat((Map)response.getVariables()).containsExactlyInAnyOrderEntriesOf(Map.of("x", "foo"));
    }

    @Test
    public void shouldSendRejectionImmediately() {
        ENGINE.processInstance().ofBpmnProcessId("INVALID-PROCESS").withResult().withRequestId(3L).withRequestStreamId(3).asyncCreate();
        ((CommandResponseWriter)Mockito.verify((Object)ENGINE.getCommandResponseWriter(), (VerificationMode)Mockito.timeout((long)1000L).times(1))).rejectionType(RejectionType.NOT_FOUND);
        ((CommandResponseWriter)Mockito.verify((Object)ENGINE.getCommandResponseWriter(), (VerificationMode)Mockito.timeout((long)1000L).times(1))).tryWriteResponse(3, 3L);
    }

    private static void interceptResponseWriter(CommandResponseWriter mockCommandResponseWriter) {
        ((CommandResponseWriter)Mockito.doAnswer(invocation -> {
            Object[] arguments = invocation.getArguments();
            if (arguments != null && arguments.length == 1 && arguments[0] != null && arguments[0] instanceof ProcessInstanceResultRecord) {
                response = (ProcessInstanceResultRecord)arguments[0];
            }
            return mockCommandResponseWriter;
        }).when((Object)mockCommandResponseWriter)).valueWriter((BufferWriter)ArgumentMatchers.any());
    }
}

