/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.processinstance;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.engine.util.client.ProcessInstanceClient;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.AbstractActivityBuilder;
import io.camunda.zeebe.model.bpmn.builder.BoundaryEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.StartEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.UserTaskBuilder;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceModificationRecordValue;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.function.UnaryOperator;
import org.assertj.core.api.Assertions;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestWatcher;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ModifyProcessInstanceUnsupportedElementsTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    private static final String PROCESS_ID = "process";
    @Rule
    public final TestWatcher watcher = new RecordingExporterTestWatcher();
    private final Scenario scenario;

    public ModifyProcessInstanceUnsupportedElementsTest(Scenario scenario) {
        this.scenario = scenario;
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object> scenarios() {
        return List.of(new Scenario("Activate element that belongs to an event-based gateway", Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().eventBasedGateway("event_based_gateway").intermediateCatchEvent("gateway_timer_event", t -> t.timerWithDuration(Duration.ofHours(1L))).endEvent().moveToLastGateway().intermediateCatchEvent("gateway_message_event", m -> m.message(msg -> msg.name("msg").zeebeCorrelationKeyExpression("\"key\""))).endEvent().done(), instructionBuilder -> instructionBuilder.activateElement("gateway_timer_event"), new Rejection(RejectionType.INVALID_ARGUMENT, "'gateway_timer_event'", "The activation of events belonging to an event-based gateway is not supported")), new Scenario("Activate start events", Bpmn.createExecutableProcess((String)PROCESS_ID).eventSubProcess("event_sub_process", e -> e.startEvent("event_sub_start", s -> s.timerWithDuration(Duration.ofHours(1L)))).startEvent("root_start").userTask("A").subProcess("embedded_sub_process", e -> e.embeddedSubProcess().startEvent("embedded_sub_start").endEvent()).done(), instructionBuilder -> instructionBuilder.activateElement("root_start").activateElement("event_sub_start").activateElement("embedded_sub_start").activateElement("A"), new Rejection(RejectionType.INVALID_ARGUMENT, "'root_start', 'event_sub_start', 'embedded_sub_start'", "The activation of elements with type 'START_EVENT' is not supported. Supported element types are:")), new Scenario("Activate sequence flows", ((UserTaskBuilder)((StartEventBuilder)Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().sequenceFlowId("flow_to_A")).userTask("A").sequenceFlowId("flow_from_A")).endEvent().done(), instructionBuilder -> instructionBuilder.activateElement("flow_to_A").activateElement("flow_from_A").activateElement("A"), new Rejection(RejectionType.INVALID_ARGUMENT, "'flow_to_A', 'flow_from_A'", "The activation of elements with type 'SEQUENCE_FLOW' is not supported. Supported element types are:")), new Scenario("Activate boundary events", Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().userTask("A").boundaryEvent("timer_boundary_on_user_task", t -> t.timerWithDuration(Duration.ofHours(1L))).endEvent().moveToActivity("A").subProcess("subprocess", s -> s.embeddedSubProcess().startEvent().done()).boundaryEvent("non_interrupting_msg_boundary_on_subprocess", m -> ((BoundaryEventBuilder)m.cancelActivity(Boolean.valueOf(false))).message(msg -> msg.name("msg").zeebeCorrelationKeyExpression("key"))).endEvent().moveToActivity("subprocess").endEvent().done(), instructionBuilder -> instructionBuilder.activateElement("timer_boundary_on_user_task").activateElement("non_interrupting_msg_boundary_on_subprocess").activateElement("A"), new Rejection(RejectionType.INVALID_ARGUMENT, "'timer_boundary_on_user_task', 'non_interrupting_msg_boundary_on_subprocess'", "The activation of elements with type 'BOUNDARY_EVENT' is not supported. Supported element types are:")), new Scenario("Activate a combination of unsupported elements", ((AbstractActivityBuilder)Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent("root_start").userTask("A").boundaryEvent("timer_boundary_on_user_task", t -> t.timerWithDuration(Duration.ofHours(1L))).endEvent().moveToActivity("A").sequenceFlowId("flow_from_A")).endEvent().done(), instructionBuilder -> instructionBuilder.activateElement("root_start").activateElement("flow_from_A").activateElement("timer_boundary_on_user_task").activateElement("A"), new Rejection(RejectionType.INVALID_ARGUMENT, "'root_start', 'flow_from_A', 'timer_boundary_on_user_task'", "The activation of elements with type 'START_EVENT', 'SEQUENCE_FLOW', 'BOUNDARY_EVENT' is not supported. Supported element types are:")));
    }

    @Test
    public void shouldRejectCommandForScenario() {
        ENGINE.deployment().withXmlResource(this.scenario.model()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record<ProcessInstanceModificationRecordValue> rejection = ((ProcessInstanceClient.ProcessInstanceModificationClient)this.scenario.instructionBuilder().apply(ENGINE.processInstance().withInstanceKey(processInstanceKey).modification())).expectRejection().modify();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(rejection).hasRejectionType(this.scenario.expectation.type());
        Assertions.assertThat((String)rejection.getRejectionReason()).contains(new CharSequence[]{String.format("Expected to modify instance of process '%s' but it contains one or more activate instructions for elements that are unsupported: %s. %s", PROCESS_ID, this.scenario.expectation().elementIds(), this.scenario.expectation().reason())});
    }

    private record Scenario(String name, BpmnModelInstance model, UnaryOperator<ProcessInstanceClient.ProcessInstanceModificationClient> instructionBuilder, Rejection expectation) {
        @Override
        public String toString() {
            return this.name;
        }
    }

    private record Rejection(RejectionType type, String elementIds, String reason) {
    }
}

