/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.processinstance;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.builder.AbstractExclusiveGatewayBuilder;
import io.camunda.zeebe.model.bpmn.builder.BoundaryEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.EventSubProcessBuilder;
import io.camunda.zeebe.model.bpmn.builder.ExclusiveGatewayBuilder;
import io.camunda.zeebe.model.bpmn.builder.StartEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.SubProcessBuilder;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.MessageSubscriptionIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceModificationIntent;
import io.camunda.zeebe.protocol.record.intent.TimerIntent;
import io.camunda.zeebe.protocol.record.intent.VariableIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.DeploymentRecordValue;
import io.camunda.zeebe.protocol.record.value.MessageSubscriptionRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.protocol.record.value.VariableRecordValue;
import io.camunda.zeebe.protocol.record.value.VariableRecordValueAssert;
import io.camunda.zeebe.protocol.record.value.deployment.ProcessMetadataValue;
import io.camunda.zeebe.test.util.record.ProcessInstanceRecordStream;
import io.camunda.zeebe.test.util.record.RecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.OptionalAssert;
import org.assertj.core.groups.Tuple;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestWatcher;

public class ModifyProcessInstanceVariablesTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    private static final String PROCESS_ID = "process";
    @Rule
    public final TestWatcher watcher = new RecordingExporterTestWatcher();

    @Test
    public void shouldCreateGlobalVariables() {
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().userTask("A").userTask("B").endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).modification().activateElement("B").withGlobalVariables(Map.of("x", "variable")).modify();
        this.assertThatVariableCreatedInScope(processInstanceKey, ((ProcessMetadataValue)((DeploymentRecordValue)deployment.getValue()).getProcessesMetadata().get(0)).getProcessDefinitionKey(), processInstanceKey, "x", "\"variable\"");
    }

    @Test
    public void shouldUpdateGlobalVariablesIfTheyAlreadyExist() {
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().userTask("A").userTask("B").endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariables(Map.of("x", "variable")).create();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).modification().activateElement("B").withGlobalVariables(Map.of("x", "updated")).modify();
        ((VariableRecordValueAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat((VariableRecordValue)((VariableRecordValue)((Record)RecordingExporter.variableRecords((VariableIntent)VariableIntent.UPDATED).withProcessInstanceKey(processInstanceKey).getFirst()).getValue())).describedAs("Expect that variable is updated", new Object[0])).hasName("x").hasValue("\"updated\"").hasBpmnProcessId(PROCESS_ID).hasProcessDefinitionKey(((ProcessMetadataValue)((DeploymentRecordValue)deployment.getValue()).getProcessesMetadata().get(0)).getProcessDefinitionKey()).hasProcessInstanceKey(processInstanceKey).hasScopeKey(processInstanceKey);
    }

    @Test
    public void shouldCreateVariablesBeforeElementScopes() {
        ENGINE.deployment().withXmlResource(((AbstractExclusiveGatewayBuilder)((ExclusiveGatewayBuilder)Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().exclusiveGateway().defaultFlow()).userTask("A").endEvent().moveToLastExclusiveGateway().conditionExpression("false")).subProcess("subprocess", sp -> sp.embeddedSubProcess().startEvent().userTask("B").endEvent()).boundaryEvent("timer", b -> b.timerWithDurationExpression("duration( durationVar )")).endEvent().moveToActivity("subprocess").endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).modification().activateElement("B").withGlobalVariables(Map.of("durationVar", "PT1H")).modify();
        Assertions.assertThat((Stream)((RecordStream)((RecordStream)RecordingExporter.records().skipUntil(r -> r.getValueType() == ValueType.PROCESS_INSTANCE_MODIFICATION && r.getIntent() == ProcessInstanceModificationIntent.MODIFY)).onlyEvents()).limit(r -> r.getValueType() == ValueType.PROCESS_INSTANCE && ((ProcessInstanceRecordValue)r.getValue()).getElementId().equals("B") && r.getIntent() == ProcessInstanceIntent.ELEMENT_ACTIVATED)).extracting(new Function[]{Record::getValueType, r -> r.getValueType() == ValueType.PROCESS_INSTANCE ? ((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType() : null, Record::getIntent}).describedAs("Expect to create variable before element scopes", new Object[0]).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{ValueType.VARIABLE, null, VariableIntent.CREATED}), Assertions.tuple((Object[])new Object[]{ValueType.PROCESS_INSTANCE, BpmnElementType.SUB_PROCESS, ProcessInstanceIntent.ELEMENT_ACTIVATING}), Assertions.tuple((Object[])new Object[]{ValueType.PROCESS_INSTANCE, BpmnElementType.USER_TASK, ProcessInstanceIntent.ELEMENT_ACTIVATING})});
        ((OptionalAssert)Assertions.assertThat((Optional)RecordingExporter.timerRecords((TimerIntent)TimerIntent.CREATED).withProcessInstanceKey(processInstanceKey).withHandlerNodeId("timer").findAny()).describedAs("Expect timer boundary event subscription opened", new Object[0])).isPresent();
    }

    @Test
    public void shouldCreateLocalVariables() {
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().userTask("A").userTask("B").endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).modification().activateElement("B").withVariables("B", Map.of("x", "variable")).modify();
        Record activatedElement = (Record)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().onlyEvents()).withElementId("B").withProcessInstanceKey(processInstanceKey).limit("B", ProcessInstanceIntent.ELEMENT_ACTIVATED).getFirst();
        this.assertThatVariableCreatedInScope(processInstanceKey, ((ProcessMetadataValue)((DeploymentRecordValue)deployment.getValue()).getProcessesMetadata().get(0)).getProcessDefinitionKey(), activatedElement.getKey(), "x", "\"variable\"");
    }

    @Test
    public void shouldCreateLocalAndGlobalVariables() {
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().userTask("A").userTask("B").endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).modification().activateElement("B").withVariables("B", Map.of("x", "local")).withGlobalVariables(Map.of("y", "global")).modify();
        Record activatedElement = (Record)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().onlyEvents()).withElementId("B").withProcessInstanceKey(processInstanceKey).limit("B", ProcessInstanceIntent.ELEMENT_ACTIVATED).getFirst();
        this.assertThatVariableCreatedInScope(processInstanceKey, ((ProcessMetadataValue)((DeploymentRecordValue)deployment.getValue()).getProcessesMetadata().get(0)).getProcessDefinitionKey(), activatedElement.getKey(), "x", "\"local\"");
        this.assertThatVariableCreatedInScope(processInstanceKey, ((ProcessMetadataValue)((DeploymentRecordValue)deployment.getValue()).getProcessesMetadata().get(0)).getProcessDefinitionKey(), processInstanceKey, "y", "\"global\"");
    }

    @Test
    public void shouldCreateLocalVariablesInNonExistingFlowscope() {
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().userTask("A").subProcess("sp", sp -> sp.embeddedSubProcess().startEvent().userTask("B").endEvent()).endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).modification().activateElement("B").withVariables("sp", Map.of("x", "variable")).modify();
        Record activatedElement = (Record)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().onlyEvents()).withElementId("sp").withProcessInstanceKey(processInstanceKey).limit("sp", ProcessInstanceIntent.ELEMENT_ACTIVATED).getFirst();
        this.assertThatVariableCreatedInScope(processInstanceKey, ((ProcessMetadataValue)((DeploymentRecordValue)deployment.getValue()).getProcessesMetadata().get(0)).getProcessDefinitionKey(), activatedElement.getKey(), "x", "\"variable\"");
    }

    @Test
    public void shouldCreateLocalVariablesInExistingFlowscope() {
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().subProcess("sp", sp -> sp.embeddedSubProcess().startEvent().userTask("A").userTask("B").endEvent()).endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record activatedElement = (Record)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().onlyEvents()).withElementId("sp").withProcessInstanceKey(processInstanceKey).limit("sp", ProcessInstanceIntent.ELEMENT_ACTIVATED).getFirst();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).modification().activateElement("B").withVariables("sp", Map.of("x", "variable")).modify();
        this.assertThatVariableCreatedInScope(processInstanceKey, ((ProcessMetadataValue)((DeploymentRecordValue)deployment.getValue()).getProcessesMetadata().get(0)).getProcessDefinitionKey(), activatedElement.getKey(), "x", "\"variable\"");
    }

    @Test
    public void shouldCreateVariablesBeforeEventSubscriptions() {
        Consumer<EventSubProcessBuilder> eventSubProcess = esp -> ((StartEventBuilder)esp.startEvent().message(m -> m.name("event-subprocess-start").zeebeCorrelationKeyExpression("local"))).userTask("B").endEvent();
        Consumer<SubProcessBuilder> subprocess = sp -> sp.embeddedSubProcess().eventSubProcess("event-subprocess", eventSubProcess).startEvent().userTask("C").endEvent();
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(((BoundaryEventBuilder)Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().userTask("A").subProcess("sp", subprocess).boundaryEvent().message(m -> m.name("message").zeebeCorrelationKeyExpression("global"))).endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        ((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().onlyEvents()).withElementId("A").withProcessInstanceKey(processInstanceKey).limit("A", ProcessInstanceIntent.ELEMENT_ACTIVATED).getFirst();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).modification().activateElement("C").withVariables("sp", Map.of("local", "local")).withGlobalVariables(Map.of("global", "global")).modify();
        long subProcessKey = ((Record)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().onlyEvents()).withElementId("sp").withProcessInstanceKey(processInstanceKey).limit("sp", ProcessInstanceIntent.ELEMENT_ACTIVATED).getFirst()).getKey();
        this.assertThatVariableCreatedInScope(processInstanceKey, ((ProcessMetadataValue)((DeploymentRecordValue)deployment.getValue()).getProcessesMetadata().get(0)).getProcessDefinitionKey(), subProcessKey, "local", "\"local\"");
        this.assertThatVariableCreatedInScope(processInstanceKey, ((ProcessMetadataValue)((DeploymentRecordValue)deployment.getValue()).getProcessesMetadata().get(0)).getProcessDefinitionKey(), processInstanceKey, "global", "\"global\"");
        Assertions.assertThat((Stream)RecordingExporter.messageSubscriptionRecords((MessageSubscriptionIntent)MessageSubscriptionIntent.CREATED).withProcessInstanceKey(processInstanceKey).limit(2L)).extracting(Record::getValue).extracting(new Function[]{MessageSubscriptionRecordValue::getCorrelationKey, MessageSubscriptionRecordValue::getElementInstanceKey}).containsExactlyInAnyOrder((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"global", subProcessKey}), Assertions.tuple((Object[])new Object[]{"local", subProcessKey})});
    }

    private void assertThatVariableCreatedInScope(long processInstanceKey, long processDefinitionKey, long scopeKey, String name, String value) {
        ((VariableRecordValueAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat((VariableRecordValue)((VariableRecordValue)((Record)RecordingExporter.variableRecords((VariableIntent)VariableIntent.CREATED).withProcessInstanceKey(processInstanceKey).withScopeKey(scopeKey).getFirst()).getValue())).describedAs("Expect that variable is created", new Object[0])).hasName(name).hasValue(value).hasBpmnProcessId(PROCESS_ID).hasProcessDefinitionKey(processDefinitionKey).hasProcessInstanceKey(processInstanceKey).hasScopeKey(scopeKey);
    }
}

