/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.resource;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.intent.CommandDistributionIntent;
import io.camunda.zeebe.protocol.record.intent.DecisionIntent;
import io.camunda.zeebe.protocol.record.intent.DecisionRequirementsIntent;
import io.camunda.zeebe.protocol.record.intent.FormIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessIntent;
import io.camunda.zeebe.protocol.record.intent.ResourceDeletionIntent;
import io.camunda.zeebe.protocol.record.value.CommandDistributionRecordValue;
import io.camunda.zeebe.protocol.record.value.DeploymentRecordValue;
import io.camunda.zeebe.protocol.record.value.deployment.FormMetadataValue;
import io.camunda.zeebe.protocol.record.value.deployment.ProcessMetadataValue;
import io.camunda.zeebe.test.util.Strings;
import io.camunda.zeebe.test.util.record.DecisionRequirementsRecordStream;
import io.camunda.zeebe.test.util.record.RecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.groups.Tuple;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestWatcher;

public class ResourceDeletionMultiPartitionTest {
    private static final int PARTITION_COUNT = 3;
    private static final String DMN_RESOURCE = "/dmn/decision-table.dmn";
    private static final String FORM_RESOURCE = "/form/test-form-1.form";
    @Rule
    public final EngineRule engine = EngineRule.multiplePartition(3);
    @Rule
    public final TestWatcher watcher = new RecordingExporterTestWatcher();

    @Test
    public void shouldTestDmnLifecycle() {
        this.engine.deployment().withXmlClasspathResource(DMN_RESOURCE).deploy();
        long resourceKey = ((Record)((DecisionRequirementsRecordStream)RecordingExporter.decisionRequirementsRecords().withIntent((Intent)DecisionRequirementsIntent.CREATED)).withDecisionRequirementsId("force_users").getFirst()).getKey();
        this.engine.resourceDeletion().withResourceKey(resourceKey).delete();
        ((AbstractListAssert)((AbstractListAssert)((AbstractListAssert)Assertions.assertThat((Stream)((RecordStream)RecordingExporter.records().withPartitionId(1)).limitByCount(r -> r.getIntent().equals((Object)CommandDistributionIntent.FINISHED), 2)).extracting(new Function[]{Record::getIntent, Record::getRecordType, r -> r.getValue() instanceof CommandDistributionRecordValue ? ((CommandDistributionRecordValue)r.getValue()).getPartitionId() : r.getPartitionId()}).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{ResourceDeletionIntent.DELETE, RecordType.COMMAND, 1}), Assertions.tuple((Object[])new Object[]{DecisionIntent.DELETED, RecordType.EVENT, 1}), Assertions.tuple((Object[])new Object[]{DecisionRequirementsIntent.DELETED, RecordType.EVENT, 1}), Assertions.tuple((Object[])new Object[]{ResourceDeletionIntent.DELETED, RecordType.EVENT, 1}), Assertions.tuple((Object[])new Object[]{CommandDistributionIntent.STARTED, RecordType.EVENT, 1})})).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{CommandDistributionIntent.DISTRIBUTING, RecordType.EVENT, 2}), Assertions.tuple((Object[])new Object[]{CommandDistributionIntent.ACKNOWLEDGE, RecordType.COMMAND, 2}), Assertions.tuple((Object[])new Object[]{CommandDistributionIntent.ACKNOWLEDGED, RecordType.EVENT, 2})})).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{CommandDistributionIntent.DISTRIBUTING, RecordType.EVENT, 3}), Assertions.tuple((Object[])new Object[]{CommandDistributionIntent.ACKNOWLEDGE, RecordType.COMMAND, 3}), Assertions.tuple((Object[])new Object[]{CommandDistributionIntent.ACKNOWLEDGED, RecordType.EVENT, 3})})).endsWith((Object)Assertions.tuple((Object[])new Object[]{CommandDistributionIntent.FINISHED, RecordType.EVENT, 1}), (Object[])new Tuple[0]);
        for (int partitionId = 2; partitionId < 3; ++partitionId) {
            Assertions.assertThat((List)((List)((RecordStream)((RecordStream)RecordingExporter.records().withPartitionId(partitionId)).limit(r -> r.getIntent().equals((Object)ResourceDeletionIntent.DELETED))).collect(Collectors.toList()))).extracting(Record::getIntent).endsWith((Object)ResourceDeletionIntent.DELETE, (Object[])new Intent[]{ResourceDeletionIntent.DELETING, DecisionIntent.DELETED, DecisionRequirementsIntent.DELETED, ResourceDeletionIntent.DELETED});
        }
    }

    @Test
    public void shouldTestBpmnLifecycle() {
        String processId = Strings.newRandomValidBpmnId();
        long resourceKey = ((ProcessMetadataValue)((DeploymentRecordValue)this.engine.deployment().withXmlResource(Bpmn.createExecutableProcess((String)processId).startEvent().endEvent().done()).deploy().getValue()).getProcessesMetadata().get(0)).getProcessDefinitionKey();
        this.engine.resourceDeletion().withResourceKey(resourceKey).delete();
        ((AbstractListAssert)((AbstractListAssert)((AbstractListAssert)Assertions.assertThat((Stream)((RecordStream)RecordingExporter.records().withPartitionId(1)).limitByCount(r -> r.getIntent().equals((Object)CommandDistributionIntent.FINISHED), 2)).extracting(new Function[]{Record::getIntent, Record::getRecordType, r -> r.getValue() instanceof CommandDistributionRecordValue ? ((CommandDistributionRecordValue)r.getValue()).getPartitionId() : r.getPartitionId()}).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{ResourceDeletionIntent.DELETE, RecordType.COMMAND, 1}), Assertions.tuple((Object[])new Object[]{ProcessIntent.DELETING, RecordType.EVENT, 1}), Assertions.tuple((Object[])new Object[]{ProcessIntent.DELETED, RecordType.EVENT, 1}), Assertions.tuple((Object[])new Object[]{ResourceDeletionIntent.DELETED, RecordType.EVENT, 1}), Assertions.tuple((Object[])new Object[]{CommandDistributionIntent.STARTED, RecordType.EVENT, 1})})).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{CommandDistributionIntent.DISTRIBUTING, RecordType.EVENT, 2}), Assertions.tuple((Object[])new Object[]{CommandDistributionIntent.ACKNOWLEDGE, RecordType.COMMAND, 2}), Assertions.tuple((Object[])new Object[]{CommandDistributionIntent.ACKNOWLEDGED, RecordType.EVENT, 2})})).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{CommandDistributionIntent.DISTRIBUTING, RecordType.EVENT, 3}), Assertions.tuple((Object[])new Object[]{CommandDistributionIntent.ACKNOWLEDGE, RecordType.COMMAND, 3}), Assertions.tuple((Object[])new Object[]{CommandDistributionIntent.ACKNOWLEDGED, RecordType.EVENT, 3})})).endsWith((Object)Assertions.tuple((Object[])new Object[]{CommandDistributionIntent.FINISHED, RecordType.EVENT, 1}), (Object[])new Tuple[0]);
        for (int partitionId = 2; partitionId < 3; ++partitionId) {
            Assertions.assertThat((List)((List)((RecordStream)((RecordStream)RecordingExporter.records().withPartitionId(partitionId)).limit(r -> r.getIntent().equals((Object)ResourceDeletionIntent.DELETED))).collect(Collectors.toList()))).extracting(Record::getIntent).endsWith((Object)ResourceDeletionIntent.DELETE, (Object[])new Intent[]{ResourceDeletionIntent.DELETING, ProcessIntent.DELETING, ProcessIntent.DELETED, ResourceDeletionIntent.DELETED});
        }
    }

    @Test
    public void shouldTestFormLifecycle() {
        long resourceKey = ((FormMetadataValue)((DeploymentRecordValue)this.engine.deployment().withXmlClasspathResource(FORM_RESOURCE).deploy().getValue()).getFormMetadata().get(0)).getFormKey();
        this.engine.resourceDeletion().withResourceKey(resourceKey).delete();
        ((AbstractListAssert)((AbstractListAssert)((AbstractListAssert)Assertions.assertThat((Stream)((RecordStream)RecordingExporter.records().withPartitionId(1)).limitByCount(r -> r.getIntent().equals((Object)CommandDistributionIntent.FINISHED), 2)).extracting(new Function[]{Record::getIntent, Record::getRecordType, r -> r.getValue() instanceof CommandDistributionRecordValue ? ((CommandDistributionRecordValue)r.getValue()).getPartitionId() : r.getPartitionId()}).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{ResourceDeletionIntent.DELETE, RecordType.COMMAND, 1}), Assertions.tuple((Object[])new Object[]{FormIntent.DELETED, RecordType.EVENT, 1}), Assertions.tuple((Object[])new Object[]{ResourceDeletionIntent.DELETED, RecordType.EVENT, 1}), Assertions.tuple((Object[])new Object[]{CommandDistributionIntent.STARTED, RecordType.EVENT, 1})})).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{CommandDistributionIntent.DISTRIBUTING, RecordType.EVENT, 2}), Assertions.tuple((Object[])new Object[]{CommandDistributionIntent.ACKNOWLEDGE, RecordType.COMMAND, 2}), Assertions.tuple((Object[])new Object[]{CommandDistributionIntent.ACKNOWLEDGED, RecordType.EVENT, 2})})).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{CommandDistributionIntent.DISTRIBUTING, RecordType.EVENT, 3}), Assertions.tuple((Object[])new Object[]{CommandDistributionIntent.ACKNOWLEDGE, RecordType.COMMAND, 3}), Assertions.tuple((Object[])new Object[]{CommandDistributionIntent.ACKNOWLEDGED, RecordType.EVENT, 3})})).endsWith((Object)Assertions.tuple((Object[])new Object[]{CommandDistributionIntent.FINISHED, RecordType.EVENT, 1}), (Object[])new Tuple[0]);
        for (int partitionId = 2; partitionId < 3; ++partitionId) {
            Assertions.assertThat((List)((List)((RecordStream)((RecordStream)RecordingExporter.records().withPartitionId(partitionId)).limit(r -> r.getIntent().equals((Object)ResourceDeletionIntent.DELETED))).collect(Collectors.toList()))).extracting(Record::getIntent).endsWith((Object)ResourceDeletionIntent.DELETE, (Object[])new Intent[]{ResourceDeletionIntent.DELETING, FormIntent.DELETED, ResourceDeletionIntent.DELETED});
        }
    }
}

