/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.resource;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.protocol.record.Assertions;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RecordAssert;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceCreationIntent;
import io.camunda.zeebe.protocol.record.value.DeploymentRecordValue;
import io.camunda.zeebe.protocol.record.value.ResourceDeletionRecordValue;
import io.camunda.zeebe.protocol.record.value.deployment.ProcessMetadataValue;
import io.camunda.zeebe.test.util.BrokerClassRuleHelper;
import io.camunda.zeebe.test.util.record.ProcessInstanceCreationRecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import org.junit.Rule;
import org.junit.Test;

public class ResourceDeletionRejectionTest {
    @Rule
    public final EngineRule engine = EngineRule.singlePartition();
    @Rule
    public final BrokerClassRuleHelper helper = new BrokerClassRuleHelper();

    @Test
    public void shouldRejectCommandWhenResourceIsNotFound() {
        long key = 123L;
        Record<ResourceDeletionRecordValue> rejection = this.engine.resourceDeletion().withResourceKey(123L).expectRejection().delete();
        ((RecordAssert)RecordAssert.assertThat(rejection).describedAs("Expect resource is not found", new Object[0])).hasRejectionType(RejectionType.NOT_FOUND).hasRejectionReason("Expected to delete resource but no resource found with key `%d`".formatted(123L));
    }

    @Test
    public void shouldRejectCommandWhenResourceIsAlreadyDeleted() {
        String processId = this.helper.getBpmnProcessId();
        long processDefinitionKey = this.deployProcess(processId);
        this.engine.resourceDeletion().withResourceKey(processDefinitionKey).delete();
        Record<ResourceDeletionRecordValue> rejection = this.engine.resourceDeletion().withResourceKey(processDefinitionKey).expectRejection().delete();
        ((RecordAssert)RecordAssert.assertThat(rejection).describedAs("Expect resource is not found", new Object[0])).hasRejectionType(RejectionType.NOT_FOUND).hasRejectionReason("Expected to delete resource but no resource found with key `%d`".formatted(processDefinitionKey));
    }

    @Test
    public void shouldRejectCreateInstanceCommandWhenOnlyProcessVersionIsDeleted() {
        String processId = this.helper.getBpmnProcessId();
        long processDefinitionKey = this.deployProcess(processId);
        this.engine.resourceDeletion().withResourceKey(processDefinitionKey).delete();
        this.engine.processInstance().ofBpmnProcessId(processId).expectRejection().create();
        Record rejectionRecord = (Record)((ProcessInstanceCreationRecordStream)RecordingExporter.processInstanceCreationRecords().onlyCommandRejections()).getFirst();
        Assertions.assertThat((Record)rejectionRecord).hasIntent((Intent)ProcessInstanceCreationIntent.CREATE).hasRejectionType(RejectionType.NOT_FOUND).hasRejectionReason(String.format("Expected to find process definition with process ID '%s', but none found", processId));
    }

    @Test
    public void shouldRejectCreateInstanceByVersionCommandWhenDeletedProcessVersionIsDeleted() {
        String processId = this.helper.getBpmnProcessId();
        long firstProcessDefinitionKey = this.deployProcess(processId);
        this.deployProcess(processId);
        this.engine.resourceDeletion().withResourceKey(firstProcessDefinitionKey).delete();
        this.engine.processInstance().ofBpmnProcessId(processId).withVersion(1).expectRejection().create();
        Record rejectionRecord = (Record)((ProcessInstanceCreationRecordStream)RecordingExporter.processInstanceCreationRecords().onlyCommandRejections()).getFirst();
        Assertions.assertThat((Record)rejectionRecord).hasIntent((Intent)ProcessInstanceCreationIntent.CREATE).hasRejectionType(RejectionType.NOT_FOUND).hasRejectionReason(String.format("Expected to find process definition with process ID '%s' and version '%d', but none found", processId, 1));
    }

    @Test
    public void shouldRejectDeletionWhenRunningInstances() {
        String processId = this.helper.getBpmnProcessId();
        long processDefinitionKey = this.deployProcess(processId);
        this.engine.processInstance().ofBpmnProcessId(processId).create();
        Record<ResourceDeletionRecordValue> rejection = this.engine.resourceDeletion().withResourceKey(processDefinitionKey).expectRejection().delete();
        ((RecordAssert)RecordAssert.assertThat(rejection).describedAs("Expect running instances", new Object[0])).hasRejectionType(RejectionType.INVALID_STATE).hasRejectionReason("Expected to delete resource with key `%d` but there are still running instances".formatted(processDefinitionKey));
    }

    private long deployProcess(String processId) {
        return ((ProcessMetadataValue)((DeploymentRecordValue)this.engine.deployment().withXmlResource(Bpmn.createExecutableProcess((String)processId).startEvent().userTask().endEvent().done()).deploy().getValue()).getProcessesMetadata().get(0)).getProcessDefinitionKey();
    }
}

