/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.resource;

import io.camunda.zeebe.engine.state.mutable.MutableBannedInstanceState;
import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.builder.BusinessRuleTaskBuilder;
import io.camunda.zeebe.model.bpmn.builder.StartEventBuilder;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.DecisionEvaluationIntent;
import io.camunda.zeebe.protocol.record.intent.DecisionIntent;
import io.camunda.zeebe.protocol.record.intent.DecisionRequirementsIntent;
import io.camunda.zeebe.protocol.record.intent.DeploymentIntent;
import io.camunda.zeebe.protocol.record.intent.FormIntent;
import io.camunda.zeebe.protocol.record.intent.IncidentIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.MessageStartEventSubscriptionIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessIntent;
import io.camunda.zeebe.protocol.record.intent.ResourceDeletionIntent;
import io.camunda.zeebe.protocol.record.intent.SignalSubscriptionIntent;
import io.camunda.zeebe.protocol.record.intent.TimerIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.DecisionEvaluationRecordValue;
import io.camunda.zeebe.protocol.record.value.DeploymentRecordValue;
import io.camunda.zeebe.protocol.record.value.ErrorType;
import io.camunda.zeebe.protocol.record.value.IncidentRecordValue;
import io.camunda.zeebe.protocol.record.value.MessageStartEventSubscriptionRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.protocol.record.value.ResourceDeletionRecordValue;
import io.camunda.zeebe.protocol.record.value.SignalSubscriptionRecordValue;
import io.camunda.zeebe.protocol.record.value.TenantOwned;
import io.camunda.zeebe.protocol.record.value.TimerRecordValue;
import io.camunda.zeebe.protocol.record.value.deployment.DecisionRecordValue;
import io.camunda.zeebe.protocol.record.value.deployment.DecisionRequirementsMetadataValue;
import io.camunda.zeebe.protocol.record.value.deployment.DecisionRequirementsRecordValue;
import io.camunda.zeebe.protocol.record.value.deployment.Form;
import io.camunda.zeebe.protocol.record.value.deployment.FormMetadataValue;
import io.camunda.zeebe.protocol.record.value.deployment.Process;
import io.camunda.zeebe.protocol.record.value.deployment.ProcessMetadataValue;
import io.camunda.zeebe.test.util.BrokerClassRuleHelper;
import io.camunda.zeebe.test.util.record.DecisionRecordStream;
import io.camunda.zeebe.test.util.record.DecisionRequirementsRecordStream;
import io.camunda.zeebe.test.util.record.FormRecordStream;
import io.camunda.zeebe.test.util.record.MessageStartEventSubscriptionRecordStream;
import io.camunda.zeebe.test.util.record.ProcessInstanceRecordStream;
import io.camunda.zeebe.test.util.record.ProcessRecordStream;
import io.camunda.zeebe.test.util.record.RecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.SignalSubscriptionRecordStream;
import io.camunda.zeebe.test.util.record.TimerRecordStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.util.function.Function;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.groups.Tuple;
import org.junit.Rule;
import org.junit.Test;

public class ResourceDeletionTest {
    private static final String DRG_SINGLE_DECISION = "/dmn/decision-table.dmn";
    private static final String DRG_SINGLE_DECISION_V2 = "/dmn/decision-table_v2.dmn";
    private static final String DRG_MULTIPLE_DECISIONS = "/dmn/drg-force-user.dmn";
    private static final String RESULT_VARIABLE = "result";
    private static final String FORM = "/form/test-form-1.form";
    @Rule
    public final EngineRule engine = EngineRule.singlePartition();
    @Rule
    public final BrokerClassRuleHelper helper = new BrokerClassRuleHelper();

    @Test
    public void shouldWriteDeletedEventsForSingleDecision() {
        long drgKey = this.deployDrg(DRG_SINGLE_DECISION);
        this.engine.resourceDeletion().withResourceKey(drgKey).delete();
        this.verifyDecisionIdWithVersionIsDeleted(drgKey, "jedi_or_sith", 1);
        this.verifyDecisionRequirementsIsDeleted(drgKey);
        this.verifyResourceIsDeleted(drgKey);
    }

    @Test
    public void shouldWriteDeletedEventsForMultipleDecisions() {
        long drgKey = this.deployDrg(DRG_MULTIPLE_DECISIONS);
        this.engine.resourceDeletion().withResourceKey(drgKey).delete();
        this.verifyDecisionIdWithVersionIsDeleted(drgKey, "jedi_or_sith", 1);
        this.verifyDecisionIdWithVersionIsDeleted(drgKey, "force_user", 1);
        this.verifyDecisionRequirementsIsDeleted(drgKey);
        this.verifyResourceIsDeleted(drgKey);
    }

    @Test
    public void shouldCreateIncidentIfOnlyDecisionVersionIsDeleted() {
        long drgKey = this.deployDrg(DRG_SINGLE_DECISION);
        String processId = this.deployProcessWithBusinessRuleTask("jedi_or_sith");
        this.engine.resourceDeletion().withResourceKey(drgKey).delete();
        long processInstanceKey = this.engine.processInstance().ofBpmnProcessId(processId).create();
        ((ObjectAssert)Assertions.assertThat((Object)((Record)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst())).describedAs("Should create incident when the only version of a decision is deleted", new Object[0])).extracting(new Function[]{r -> ((IncidentRecordValue)r.getValue()).getBpmnProcessId(), r -> ((IncidentRecordValue)r.getValue()).getElementId(), r -> ((IncidentRecordValue)r.getValue()).getErrorType(), r -> ((IncidentRecordValue)r.getValue()).getErrorMessage()}).containsOnly(new Object[]{processId, "task", ErrorType.CALLED_DECISION_ERROR, "Expected to evaluate decision 'jedi_or_sith', but no decision found for id 'jedi_or_sith'"});
    }

    @Test
    public void shouldEvaluatePreviousDecisionVersionIfLatestVersionIsDeleted() {
        long drgKeyV1 = this.deployDrg(DRG_SINGLE_DECISION);
        long drgKeyV2 = this.deployDrg(DRG_SINGLE_DECISION_V2);
        String processId = this.deployProcessWithBusinessRuleTask("jedi_or_sith");
        this.engine.resourceDeletion().withResourceKey(drgKeyV2).delete();
        long processInstanceKey = this.engine.processInstance().ofBpmnProcessId(processId).withVariable("lightsaberColor", "blue").create();
        ((ListAssert)Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted()).describedAs("Process Instance should be completed", new Object[0])).extracting(new Function[]{r -> ((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType(), Record::getIntent}).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{BpmnElementType.BUSINESS_RULE_TASK, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.BUSINESS_RULE_TASK, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED})});
        ((ObjectAssert)Assertions.assertThat((Object)((Record)RecordingExporter.decisionEvaluationRecords((DecisionEvaluationIntent)DecisionEvaluationIntent.EVALUATED).withProcessInstanceKey(processInstanceKey).withDecisionId("jedi_or_sith").getFirst())).describedAs("Should evaluate version 1 of the decision", new Object[0])).extracting(Record::getValue).extracting(new Function[]{DecisionEvaluationRecordValue::getDecisionId, DecisionEvaluationRecordValue::getDecisionVersion, DecisionEvaluationRecordValue::getDecisionRequirementsKey}).containsOnly(new Object[]{"jedi_or_sith", 1, drgKeyV1});
    }

    @Test
    public void shouldEvaluateLatestVersionIfPreviousVersionIsDeleted() {
        long drgKeyV1 = this.deployDrg(DRG_SINGLE_DECISION);
        long drgKeyV2 = this.deployDrg(DRG_SINGLE_DECISION_V2);
        String processId = this.deployProcessWithBusinessRuleTask("jedi_or_sith");
        this.engine.resourceDeletion().withResourceKey(drgKeyV1).delete();
        long processInstanceKey = this.engine.processInstance().ofBpmnProcessId(processId).withVariable("lightsaberColor", "blue").create();
        ((ListAssert)Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted()).describedAs("Process Instance should be completed", new Object[0])).extracting(new Function[]{r -> ((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType(), Record::getIntent}).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{BpmnElementType.BUSINESS_RULE_TASK, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.BUSINESS_RULE_TASK, ProcessInstanceIntent.ELEMENT_COMPLETED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED})});
        ((ObjectAssert)Assertions.assertThat((Object)((Record)RecordingExporter.decisionEvaluationRecords((DecisionEvaluationIntent)DecisionEvaluationIntent.EVALUATED).withProcessInstanceKey(processInstanceKey).withDecisionId("jedi_or_sith").getFirst())).describedAs("Should evaluate version 2 of the decision", new Object[0])).extracting(Record::getValue).extracting(new Function[]{DecisionEvaluationRecordValue::getDecisionId, DecisionEvaluationRecordValue::getDecisionVersion, DecisionEvaluationRecordValue::getDecisionRequirementsKey}).containsOnly(new Object[]{"jedi_or_sith", 2, drgKeyV2});
    }

    @Test
    public void shouldHaveCorrectLifecycleWhenDeletingProcessWithoutRunningInstances() {
        String processId = this.helper.getBpmnProcessId();
        long processDefinitionKey = this.deployProcess(processId);
        this.engine.resourceDeletion().withResourceKey(processDefinitionKey).delete();
        ((ListAssert)Assertions.assertThat((Stream)((RecordStream)RecordingExporter.records().onlyEvents()).limit(r -> r.getIntent().equals((Object)ResourceDeletionIntent.DELETED))).describedAs("Should write events in correct order", new Object[0])).extracting(Record::getIntent).containsExactly((Object[])new Intent[]{ProcessIntent.CREATED, DeploymentIntent.CREATED, ResourceDeletionIntent.DELETING, ProcessIntent.DELETING, ProcessIntent.DELETED, ResourceDeletionIntent.DELETED});
    }

    @Test
    public void shouldWriteEventsForDeletedProcessWithoutRunningInstances() {
        String processId = this.helper.getBpmnProcessId();
        long processDefinitionKey = this.deployProcess(processId);
        this.engine.resourceDeletion().withResourceKey(processDefinitionKey).delete();
        this.verifyProcessIdWithVersionIsDeleted(processId, 1);
        this.verifyResourceIsDeleted(processDefinitionKey);
    }

    @Test
    public void shouldWriteEventsForDeletedProcessWithBannedInstances() {
        String processId = this.helper.getBpmnProcessId();
        long processDefinitionKey = ((ProcessMetadataValue)((DeploymentRecordValue)this.engine.deployment().withXmlResource(Bpmn.createExecutableProcess((String)processId).startEvent().userTask().endEvent().done()).deploy().getValue()).getProcessesMetadata().get(0)).getProcessDefinitionKey();
        long processInstanceKey = this.engine.processInstance().ofBpmnProcessId(processId).create();
        MutableBannedInstanceState bannedInstanceState = (MutableBannedInstanceState)this.engine.getProcessingState().getBannedInstanceState();
        bannedInstanceState.banProcessInstance(processInstanceKey);
        this.engine.resourceDeletion().withResourceKey(processDefinitionKey).delete();
        this.verifyProcessIdWithVersionIsDeleted(processId, 1);
        this.verifyResourceIsDeleted(processDefinitionKey);
    }

    @Test
    public void shouldCreateInstanceOfVersionOneWhenVersionTwoIsDeleted() {
        String processId = this.helper.getBpmnProcessId();
        this.deployProcess(processId);
        long secondProcessDefinitionKey = this.deployProcess(processId);
        this.engine.resourceDeletion().withResourceKey(secondProcessDefinitionKey).delete();
        long processInstanceKey = this.engine.processInstance().ofBpmnProcessId(processId).create();
        this.verifyProcessIdWithVersionIsDeleted(processId, 2);
        this.verifyResourceIsDeleted(secondProcessDefinitionKey);
        this.verifyInstanceOfProcessWithIdAndVersionIsCompleted(processId, 1, processInstanceKey);
    }

    @Test
    public void shouldCreateInstanceOfVersionTwoWhenVersionOneIsDeleted() {
        String processId = this.helper.getBpmnProcessId();
        long firstProcessDefinitionKey = this.deployProcess(processId);
        this.deployProcess(processId);
        this.engine.resourceDeletion().withResourceKey(firstProcessDefinitionKey).delete();
        long processInstanceKey = this.engine.processInstance().ofBpmnProcessId(processId).create();
        this.verifyProcessIdWithVersionIsDeleted(processId, 1);
        this.verifyResourceIsDeleted(firstProcessDefinitionKey);
        this.verifyInstanceOfProcessWithIdAndVersionIsCompleted(processId, 2, processInstanceKey);
    }

    @Test
    public void shouldCancelTimerStartEventOnDeletion() {
        String processId = this.helper.getBpmnProcessId();
        long processDefinitionKey = this.deployProcessWithTimerStartEvent(processId);
        this.engine.resourceDeletion().withResourceKey(processDefinitionKey).delete();
        this.verifyTimerIsCancelled(processDefinitionKey);
        this.verifyProcessIdWithVersionIsDeleted(processId, 1);
        this.verifyResourceIsDeleted(processDefinitionKey);
    }

    @Test
    public void shouldCancelAllTimerStartEventsOnDeletion() {
        String processId = this.helper.getBpmnProcessId();
        long processDefinitionKey = ((ProcessMetadataValue)((DeploymentRecordValue)this.engine.deployment().withXmlResource(((StartEventBuilder)((StartEventBuilder)Bpmn.createExecutableProcess((String)processId).startEvent("startEvent1").timerWithDuration(Duration.ofDays(1L))).endEvent("endEvent").moveToProcess(processId).startEvent("startEvent2").timerWithDuration(Duration.ofDays(1L))).connectTo("endEvent").done()).deploy().getValue()).getProcessesMetadata().get(0)).getProcessDefinitionKey();
        this.engine.resourceDeletion().withResourceKey(processDefinitionKey).delete();
        this.verifyTimersAreCancelled(processDefinitionKey, 2);
        this.verifyProcessIdWithVersionIsDeleted(processId, 1);
        this.verifyResourceIsDeleted(processDefinitionKey);
    }

    @Test
    public void shouldNotCancelTimersIfDeletedVersionIsNotLatest() {
        String processId = this.helper.getBpmnProcessId();
        long firstProcessDefinitionKey = this.deployProcess(processId);
        this.deployProcessWithTimerStartEvent(processId);
        this.engine.resourceDeletion().withResourceKey(firstProcessDefinitionKey).delete();
        this.verifyProcessIdWithVersionIsDeleted(processId, 1);
        this.verifyResourceIsDeleted(firstProcessDefinitionKey);
        this.verifyNoTimersAreCancelled();
    }

    @Test
    public void shouldReactivateTimerOfPreviousVersion() {
        String processId = this.helper.getBpmnProcessId();
        long versionOneProcessDefinitionKey = this.deployProcessWithTimerStartEvent(processId);
        long versionTwoProcessDefinitionKey = this.deployProcessWithTimerStartEvent(processId);
        this.engine.resourceDeletion().withResourceKey(versionTwoProcessDefinitionKey).delete();
        this.verifyTimerIsCancelled(versionTwoProcessDefinitionKey);
        this.verifyTimerIsCreated(versionOneProcessDefinitionKey, 2);
        this.verifyProcessIdWithVersionIsDeleted(processId, 2);
        this.verifyResourceIsDeleted(versionTwoProcessDefinitionKey);
    }

    @Test
    public void shouldReactivateAllTimersOfPreviousVersion() {
        String processId = this.helper.getBpmnProcessId();
        long versionOneProcessDefinitionKey = ((ProcessMetadataValue)((DeploymentRecordValue)this.engine.deployment().withXmlResource(((StartEventBuilder)((StartEventBuilder)Bpmn.createExecutableProcess((String)processId).startEvent("startEvent1").timerWithDuration(Duration.ofDays(1L))).endEvent("endEvent").moveToProcess(processId).startEvent("startEvent2").timerWithDuration(Duration.ofDays(1L))).connectTo("endEvent").done()).deploy().getValue()).getProcessesMetadata().get(0)).getProcessDefinitionKey();
        long versionTwoProcessDefinitionKey = this.deployProcessWithTimerStartEvent(processId);
        this.engine.resourceDeletion().withResourceKey(versionTwoProcessDefinitionKey).delete();
        this.verifyTimerIsCancelled(versionTwoProcessDefinitionKey);
        this.verifyTimerIsCreated(versionOneProcessDefinitionKey, 4);
        this.verifyProcessIdWithVersionIsDeleted(processId, 2);
        this.verifyResourceIsDeleted(versionTwoProcessDefinitionKey);
    }

    @Test
    public void shouldUnsubscribeMessageStartEventOnDeletion() {
        String processId = this.helper.getBpmnProcessId();
        long processDefinitionKey = this.deployProcessWithMessageStartEvent(processId);
        this.engine.resourceDeletion().withResourceKey(processDefinitionKey).delete();
        this.verifyMessageStartEventSubscriptionIsDeleted(processDefinitionKey);
        this.verifyProcessIdWithVersionIsDeleted(processId, 1);
        this.verifyResourceIsDeleted(processDefinitionKey);
    }

    @Test
    public void shouldUnsubscribeAllMessageStartEventsOnDeletion() {
        String processId = this.helper.getBpmnProcessId();
        long processDefinitionKey = ((ProcessMetadataValue)((DeploymentRecordValue)this.engine.deployment().withXmlResource(((StartEventBuilder)((StartEventBuilder)Bpmn.createExecutableProcess((String)processId).startEvent("startEvent1").message("message1")).endEvent("endEvent").moveToProcess(processId).startEvent("startEvent2").message("message2")).connectTo("endEvent").done()).deploy().getValue()).getProcessesMetadata().get(0)).getProcessDefinitionKey();
        this.engine.resourceDeletion().withResourceKey(processDefinitionKey).delete();
        this.verifyMessageStartEventSubscriptionIsDeleted(processDefinitionKey, 2);
        this.verifyProcessIdWithVersionIsDeleted(processId, 1);
        this.verifyResourceIsDeleted(processDefinitionKey);
    }

    @Test
    public void shouldNotUnsubscribeMessagesIfDeletedVersionIsNotLatest() {
        String processId = this.helper.getBpmnProcessId();
        long firstProcessDefinitionKey = this.deployProcess(processId);
        this.deployProcessWithMessageStartEvent(processId);
        this.engine.resourceDeletion().withResourceKey(firstProcessDefinitionKey).delete();
        this.verifyProcessIdWithVersionIsDeleted(processId, 1);
        this.verifyResourceIsDeleted(firstProcessDefinitionKey);
        this.verifyNoMessageStartEventSubscriptionsAreDeleted();
    }

    @Test
    public void shouldRecreateMessageSubscriptionOfPreviousVersion() {
        String processId = this.helper.getBpmnProcessId();
        long versionOneProcessDefinitionKey = this.deployProcessWithMessageStartEvent(processId);
        long versionTwoProcessDefinitionKey = this.deployProcessWithMessageStartEvent(processId);
        this.engine.resourceDeletion().withResourceKey(versionTwoProcessDefinitionKey).delete();
        this.verifyMessageStartEventSubscriptionIsDeleted(versionTwoProcessDefinitionKey);
        this.verifyMessageStartEventSubscriptionIsCreated(versionOneProcessDefinitionKey, 2);
        this.verifyProcessIdWithVersionIsDeleted(processId, 2);
        this.verifyResourceIsDeleted(versionTwoProcessDefinitionKey);
    }

    @Test
    public void shouldRecreateAllMessageSubscriptionsOfPreviousVersion() {
        String processId = this.helper.getBpmnProcessId();
        long versionOneProcessDefinitionKey = ((ProcessMetadataValue)((DeploymentRecordValue)this.engine.deployment().withXmlResource(((StartEventBuilder)((StartEventBuilder)Bpmn.createExecutableProcess((String)processId).startEvent("startEvent1").message("message1")).endEvent("endEvent").moveToProcess(processId).startEvent("startEvent2").message("message2")).connectTo("endEvent").done()).deploy().getValue()).getProcessesMetadata().get(0)).getProcessDefinitionKey();
        long versionTwoProcessDefinitionKey = this.deployProcessWithMessageStartEvent(processId);
        this.engine.resourceDeletion().withResourceKey(versionTwoProcessDefinitionKey).delete();
        this.verifyMessageStartEventSubscriptionIsDeleted(versionTwoProcessDefinitionKey);
        this.verifyMessageStartEventSubscriptionIsCreated(versionOneProcessDefinitionKey, 4);
        this.verifyProcessIdWithVersionIsDeleted(processId, 2);
        this.verifyResourceIsDeleted(versionTwoProcessDefinitionKey);
    }

    @Test
    public void shouldUnsubscribeSignalStartEventOnDeletion() {
        String processId = this.helper.getBpmnProcessId();
        long processDefinitionKey = this.deployProcessWithSignalStartEvent(processId);
        this.engine.resourceDeletion().withResourceKey(processDefinitionKey).delete();
        this.verifySignalStartEventSubscriptionIsDeleted(processDefinitionKey);
        this.verifyProcessIdWithVersionIsDeleted(processId, 1);
        this.verifyResourceIsDeleted(processDefinitionKey);
    }

    @Test
    public void shouldUnsubscribeAllSignalStartEventsOnDeletion() {
        String processId = this.helper.getBpmnProcessId();
        long processDefinitionKey = ((ProcessMetadataValue)((DeploymentRecordValue)this.engine.deployment().withXmlResource(((StartEventBuilder)((StartEventBuilder)Bpmn.createExecutableProcess((String)processId).startEvent("startEvent1").signal("signal1")).endEvent("endEvent").moveToProcess(processId).startEvent("startEvent2").signal("signal2")).connectTo("endEvent").done()).deploy().getValue()).getProcessesMetadata().get(0)).getProcessDefinitionKey();
        this.engine.resourceDeletion().withResourceKey(processDefinitionKey).delete();
        this.verifySignalStartEventSubscriptionIsDeleted(processDefinitionKey, 2);
        this.verifyProcessIdWithVersionIsDeleted(processId, 1);
        this.verifyResourceIsDeleted(processDefinitionKey);
    }

    @Test
    public void shouldNotUnsubscribeSignalsIfDeletedVersionIsNotLatest() {
        String processId = this.helper.getBpmnProcessId();
        long firstProcessDefinitionKey = this.deployProcess(processId);
        this.deployProcessWithSignalStartEvent(processId);
        this.engine.resourceDeletion().withResourceKey(firstProcessDefinitionKey).delete();
        this.verifyProcessIdWithVersionIsDeleted(processId, 1);
        this.verifyResourceIsDeleted(firstProcessDefinitionKey);
        this.verifyNoSignalStartEventSubscriptionsAreDeleted();
    }

    @Test
    public void shouldRecreateSignalSubscriptionOfPreviousVersion() {
        String processId = this.helper.getBpmnProcessId();
        long versionOneProcessDefinitionKey = this.deployProcessWithSignalStartEvent(processId);
        long versionTwoProcessDefinitionKey = this.deployProcessWithSignalStartEvent(processId);
        this.engine.resourceDeletion().withResourceKey(versionTwoProcessDefinitionKey).delete();
        this.verifySignalStartEventSubscriptionIsDeleted(versionTwoProcessDefinitionKey);
        this.verifySignalStartEventSubscriptionIsCreated(versionOneProcessDefinitionKey, 2);
        this.verifyProcessIdWithVersionIsDeleted(processId, 2);
        this.verifyResourceIsDeleted(versionTwoProcessDefinitionKey);
    }

    @Test
    public void shouldRecreateAllSignalSubscriptionsOfPreviousVersion() {
        String processId = this.helper.getBpmnProcessId();
        long versionOneProcessDefinitionKey = ((ProcessMetadataValue)((DeploymentRecordValue)this.engine.deployment().withXmlResource(((StartEventBuilder)((StartEventBuilder)Bpmn.createExecutableProcess((String)processId).startEvent("startEvent1").signal("signal1")).endEvent("endEvent").moveToProcess(processId).startEvent("startEvent2").signal("signal2")).connectTo("endEvent").done()).deploy().getValue()).getProcessesMetadata().get(0)).getProcessDefinitionKey();
        long versionTwoProcessDefinitionKey = this.deployProcessWithSignalStartEvent(processId);
        this.engine.resourceDeletion().withResourceKey(versionTwoProcessDefinitionKey).delete();
        this.verifySignalStartEventSubscriptionIsDeleted(versionTwoProcessDefinitionKey);
        this.verifySignalStartEventSubscriptionIsCreated(versionOneProcessDefinitionKey, 4);
        this.verifyProcessIdWithVersionIsDeleted(processId, 2);
        this.verifyResourceIsDeleted(versionTwoProcessDefinitionKey);
    }

    @Test
    public void shouldWriteDeletedEventsForForm() {
        long formKey = this.deployForm(FORM);
        this.engine.resourceDeletion().withResourceKey(formKey).delete();
        this.verifyFormIsDeleted(formKey);
        this.verifyResourceIsDeleted(formKey);
    }

    private long deployDrg(String drgResource) {
        return ((DecisionRequirementsMetadataValue)((DeploymentRecordValue)this.engine.deployment().withXmlResource(this.readResource(drgResource), drgResource).deploy().getValue()).getDecisionRequirementsMetadata().get(0)).getDecisionRequirementsKey();
    }

    private String deployProcessWithBusinessRuleTask(String decisionId) {
        String processId = this.helper.getBpmnProcessId();
        this.engine.deployment().withXmlResource(Bpmn.createExecutableProcess((String)processId).startEvent().businessRuleTask("task", t -> ((BusinessRuleTaskBuilder)t.zeebeCalledDecisionId(decisionId)).zeebeResultVariable(RESULT_VARIABLE)).done()).deploy();
        return processId;
    }

    private long deployProcess(String processId) {
        return ((ProcessMetadataValue)((DeploymentRecordValue)this.engine.deployment().withXmlResource(Bpmn.createExecutableProcess((String)processId).startEvent().endEvent().done()).deploy().getValue()).getProcessesMetadata().get(0)).getProcessDefinitionKey();
    }

    private long deployProcessWithTimerStartEvent(String processId) {
        return ((ProcessMetadataValue)((DeploymentRecordValue)this.engine.deployment().withXmlResource(((StartEventBuilder)Bpmn.createExecutableProcess((String)processId).startEvent().timerWithDuration(Duration.ofDays(1L))).endEvent().done()).deploy().getValue()).getProcessesMetadata().get(0)).getProcessDefinitionKey();
    }

    private long deployProcessWithMessageStartEvent(String processId) {
        return ((ProcessMetadataValue)((DeploymentRecordValue)this.engine.deployment().withXmlResource(((StartEventBuilder)Bpmn.createExecutableProcess((String)processId).startEvent().message("message")).endEvent().done()).deploy().getValue()).getProcessesMetadata().get(0)).getProcessDefinitionKey();
    }

    private long deployProcessWithSignalStartEvent(String processId) {
        return ((ProcessMetadataValue)((DeploymentRecordValue)this.engine.deployment().withXmlResource(((StartEventBuilder)Bpmn.createExecutableProcess((String)processId).startEvent().signal("signal")).endEvent().done()).deploy().getValue()).getProcessesMetadata().get(0)).getProcessDefinitionKey();
    }

    private byte[] readResource(String resourceName) {
        InputStream resourceAsStream = this.getClass().getResourceAsStream(resourceName);
        Assertions.assertThat((InputStream)resourceAsStream).isNotNull();
        try {
            return resourceAsStream.readAllBytes();
        }
        catch (IOException e) {
            Assertions.fail((String)"Failed to read resource '{}'", (Object[])new Object[]{resourceName, e});
            return new byte[0];
        }
    }

    private void verifyResourceIsDeleted(long key) {
        ((ListAssert)Assertions.assertThat((Stream)RecordingExporter.resourceDeletionRecords().limit(r -> r.getIntent().equals((Object)ResourceDeletionIntent.DELETED))).describedAs("Expect resource to be deleted", new Object[0])).extracting(new Function[]{Record::getIntent, r -> ((ResourceDeletionRecordValue)r.getValue()).getResourceKey()}).containsOnly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{ResourceDeletionIntent.DELETE, key}), Assertions.tuple((Object[])new Object[]{ResourceDeletionIntent.DELETING, key}), Assertions.tuple((Object[])new Object[]{ResourceDeletionIntent.DELETED, key})});
    }

    private void verifyDecisionRequirementsIsDeleted(long key) {
        DecisionRequirementsRecordValue drgCreatedRecord = (DecisionRequirementsRecordValue)((Record)((DecisionRequirementsRecordStream)RecordingExporter.decisionRequirementsRecords().withDecisionRequirementsKey(key).withIntent((Intent)DecisionRequirementsIntent.CREATED)).getFirst()).getValue();
        DecisionRequirementsRecordValue drgDeletedRecord = (DecisionRequirementsRecordValue)((Record)((DecisionRequirementsRecordStream)RecordingExporter.decisionRequirementsRecords().withDecisionRequirementsKey(key).withIntent((Intent)DecisionRequirementsIntent.DELETED)).getFirst()).getValue();
        ((ObjectAssert)Assertions.assertThat((Object)drgDeletedRecord).describedAs("Expect deleted DRG to match the created DRG", new Object[0])).extracting(new Function[]{DecisionRequirementsMetadataValue::getDecisionRequirementsId, DecisionRequirementsMetadataValue::getDecisionRequirementsName, DecisionRequirementsMetadataValue::getDecisionRequirementsVersion, DecisionRequirementsMetadataValue::getDecisionRequirementsKey, DecisionRequirementsMetadataValue::getResourceName, DecisionRequirementsMetadataValue::getChecksum}).containsOnly(new Object[]{drgCreatedRecord.getDecisionRequirementsId(), drgCreatedRecord.getDecisionRequirementsName(), drgCreatedRecord.getDecisionRequirementsVersion(), drgCreatedRecord.getDecisionRequirementsKey(), drgCreatedRecord.getResourceName(), drgCreatedRecord.getChecksum()});
    }

    private void verifyDecisionIdWithVersionIsDeleted(long drgKey, String decisionId, int version) {
        DecisionRecordValue decisionCreatedRecord = (DecisionRecordValue)((Record)((DecisionRecordStream)RecordingExporter.decisionRecords().withDecisionRequirementsKey(drgKey).withDecisionId(decisionId).withVersion(version).withIntent((Intent)DecisionIntent.CREATED)).getFirst()).getValue();
        DecisionRecordValue decisionDeletedRecord = (DecisionRecordValue)((Record)((DecisionRecordStream)RecordingExporter.decisionRecords().withDecisionRequirementsKey(drgKey).withDecisionId(decisionId).withVersion(version).withIntent((Intent)DecisionIntent.DELETED)).getFirst()).getValue();
        ((ObjectAssert)Assertions.assertThat((Object)decisionDeletedRecord).describedAs("Expect deleted decision to match the created decision", new Object[0])).extracting(new Function[]{DecisionRecordValue::getDecisionId, DecisionRecordValue::getDecisionName, DecisionRecordValue::getVersion, DecisionRecordValue::getDecisionKey, DecisionRecordValue::getDecisionRequirementsId, DecisionRecordValue::getDecisionRequirementsKey, DecisionRecordValue::isDuplicate}).containsOnly(new Object[]{decisionCreatedRecord.getDecisionId(), decisionCreatedRecord.getDecisionName(), decisionCreatedRecord.getVersion(), decisionCreatedRecord.getDecisionKey(), decisionCreatedRecord.getDecisionRequirementsId(), decisionCreatedRecord.getDecisionRequirementsKey(), decisionCreatedRecord.isDuplicate()});
    }

    private void verifyProcessIdWithVersionIsDeleted(String processId, int version) {
        Process processCreatedRecord = (Process)((Record)((ProcessRecordStream)RecordingExporter.processRecords().withIntent((Intent)ProcessIntent.CREATED)).withBpmnProcessId(processId).withVersion(version).getFirst()).getValue();
        ((ListAssert)((ListAssert)Assertions.assertThat((Stream)((ProcessRecordStream)RecordingExporter.processRecords().withIntents(new Intent[]{ProcessIntent.DELETING, ProcessIntent.DELETED})).withBpmnProcessId(processId).withVersion(version).limit(2L)).describedAs("Expect deleted process to match created process", new Object[0])).hasSize(2)).map(Record::getValue).extracting(new Function[]{ProcessMetadataValue::getBpmnProcessId, ProcessMetadataValue::getResourceName, ProcessMetadataValue::getVersion, ProcessMetadataValue::getProcessDefinitionKey}).containsOnly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{processCreatedRecord.getBpmnProcessId(), processCreatedRecord.getResourceName(), processCreatedRecord.getVersion(), processCreatedRecord.getProcessDefinitionKey()})});
    }

    private void verifyInstanceOfProcessWithIdAndVersionIsCompleted(String processId, int version, long processInstanceKey) {
        Assertions.assertThat((Stream)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).withBpmnProcessId(processId).withVersion(version).withElementType(BpmnElementType.PROCESS).onlyEvents()).limitToProcessInstanceCompleted()).extracting(new Function[]{r -> ((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType(), Record::getIntent}).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_ACTIVATING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_ACTIVATED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED})});
    }

    private void verifyTimerIsCancelled(long processDefinitionKey) {
        this.verifyTimersAreCancelled(processDefinitionKey, 1);
    }

    private void verifyTimersAreCancelled(long processDefinitionKey, int times) {
        ((ListAssert)((ListAssert)Assertions.assertThat((Stream)RecordingExporter.timerRecords((TimerIntent)TimerIntent.CANCELED).withProcessDefinitionKey(processDefinitionKey).limit((long)times)).describedAs("Timer(s) should be cancelled", new Object[0])).hasSize(times)).extracting(new Function[]{t -> ((TimerRecordValue)t.getValue()).getProcessDefinitionKey(), t -> ((TimerRecordValue)t.getValue()).getProcessInstanceKey(), t -> ((TimerRecordValue)t.getValue()).getElementInstanceKey()}).containsOnly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{processDefinitionKey, -1L, -1L})});
    }

    private void verifyNoTimersAreCancelled() {
        Assertions.assertThat((boolean)((TimerRecordStream)((RecordStream)RecordingExporter.records().limit(r -> r.getIntent() == ResourceDeletionIntent.DELETED)).timerRecords().withIntent((Intent)TimerIntent.CANCELED)).exists()).isFalse();
    }

    private void verifyTimerIsCreated(long processDefinitionKey, int times) {
        ((ListAssert)((ListAssert)Assertions.assertThat((Stream)RecordingExporter.timerRecords((TimerIntent)TimerIntent.CREATED).withProcessDefinitionKey(processDefinitionKey).limit((long)times)).describedAs("%d timers should be created".formatted(times), new Object[0])).hasSize(times)).extracting(new Function[]{t -> ((TimerRecordValue)t.getValue()).getProcessDefinitionKey(), t -> ((TimerRecordValue)t.getValue()).getProcessInstanceKey(), t -> ((TimerRecordValue)t.getValue()).getElementInstanceKey()}).containsOnly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{processDefinitionKey, -1L, -1L})});
    }

    private void verifyMessageStartEventSubscriptionIsDeleted(long processDefinitionKey) {
        this.verifyMessageStartEventSubscriptionIsDeleted(processDefinitionKey, 1);
    }

    private void verifyMessageStartEventSubscriptionIsDeleted(long processDefinitionKey, int times) {
        ((ListAssert)((ListAssert)Assertions.assertThat((Stream)RecordingExporter.messageStartEventSubscriptionRecords((MessageStartEventSubscriptionIntent)MessageStartEventSubscriptionIntent.DELETED).withProcessDefinitionKey(processDefinitionKey).limit((long)times)).describedAs("Message start event subscription(s) should be deleted", new Object[0])).hasSize(times)).extracting(t -> ((MessageStartEventSubscriptionRecordValue)t.getValue()).getProcessDefinitionKey()).containsOnly((Object[])new Long[]{processDefinitionKey});
    }

    private void verifyNoMessageStartEventSubscriptionsAreDeleted() {
        Assertions.assertThat((boolean)((MessageStartEventSubscriptionRecordStream)((RecordStream)RecordingExporter.records().limit(r -> r.getIntent() == ResourceDeletionIntent.DELETED)).messageStartEventSubscriptionRecords().withIntent((Intent)MessageStartEventSubscriptionIntent.DELETED)).exists()).isFalse();
    }

    private void verifyMessageStartEventSubscriptionIsCreated(long processDefinitionKey, int times) {
        ((ListAssert)((ListAssert)Assertions.assertThat((Stream)RecordingExporter.messageStartEventSubscriptionRecords((MessageStartEventSubscriptionIntent)MessageStartEventSubscriptionIntent.CREATED).withProcessDefinitionKey(processDefinitionKey).limit((long)times)).describedAs("%d message start event subscriptions should be created".formatted(times), new Object[0])).hasSize(times)).extracting(t -> ((MessageStartEventSubscriptionRecordValue)t.getValue()).getProcessDefinitionKey()).containsOnly((Object[])new Long[]{processDefinitionKey});
    }

    private void verifySignalStartEventSubscriptionIsDeleted(long processDefinitionKey) {
        this.verifySignalStartEventSubscriptionIsDeleted(processDefinitionKey, 1);
    }

    private void verifySignalStartEventSubscriptionIsDeleted(long processDefinitionKey, int times) {
        ((ListAssert)((ListAssert)Assertions.assertThat((Stream)RecordingExporter.signalSubscriptionRecords((SignalSubscriptionIntent)SignalSubscriptionIntent.DELETED).withProcessDefinitionKey(processDefinitionKey).limit((long)times)).describedAs("Signal start event subscription(s) should be deleted", new Object[0])).hasSize(times)).extracting(new Function[]{t -> ((SignalSubscriptionRecordValue)t.getValue()).getProcessDefinitionKey(), t -> ((SignalSubscriptionRecordValue)t.getValue()).getCatchEventInstanceKey()}).containsOnly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{processDefinitionKey, -1L})});
    }

    private void verifyNoSignalStartEventSubscriptionsAreDeleted() {
        Assertions.assertThat((boolean)((SignalSubscriptionRecordStream)((RecordStream)RecordingExporter.records().limit(r -> r.getIntent() == ResourceDeletionIntent.DELETED)).signalSubscriptionRecords().withIntent((Intent)SignalSubscriptionIntent.DELETED)).exists()).isFalse();
    }

    private void verifySignalStartEventSubscriptionIsCreated(long processDefinitionKey, int times) {
        ((ListAssert)((ListAssert)Assertions.assertThat((Stream)RecordingExporter.signalSubscriptionRecords((SignalSubscriptionIntent)SignalSubscriptionIntent.CREATED).withProcessDefinitionKey(processDefinitionKey).limit((long)times)).describedAs("%d signal start event subscriptions should be created".formatted(times), new Object[0])).hasSize(times)).extracting(new Function[]{t -> ((SignalSubscriptionRecordValue)t.getValue()).getProcessDefinitionKey(), t -> ((SignalSubscriptionRecordValue)t.getValue()).getCatchEventInstanceKey()}).containsOnly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{processDefinitionKey, -1L})});
    }

    private long deployForm(String formResource) {
        return ((FormMetadataValue)((DeploymentRecordValue)this.engine.deployment().withXmlResource(this.readResource(formResource), formResource).deploy().getValue()).getFormMetadata().get(0)).getFormKey();
    }

    private void verifyFormIsDeleted(long formKey) {
        Form formCreatedRecord = (Form)((Record)((FormRecordStream)RecordingExporter.formRecords().withFormKey(formKey).withIntent((Intent)FormIntent.CREATED)).getFirst()).getValue();
        Form formDeletedRecord = (Form)((Record)((FormRecordStream)RecordingExporter.formRecords().withFormKey(formKey).withIntent((Intent)FormIntent.DELETED)).getFirst()).getValue();
        ((ObjectAssert)Assertions.assertThat((Object)formDeletedRecord).describedAs("Expect deleted form to match the created form", new Object[0])).extracting(new Function[]{FormMetadataValue::getFormId, FormMetadataValue::getFormKey, FormMetadataValue::getVersion, FormMetadataValue::getResourceName, TenantOwned::getTenantId}).containsOnly(new Object[]{formCreatedRecord.getFormId(), formCreatedRecord.getFormKey(), formCreatedRecord.getVersion(), formCreatedRecord.getResourceName(), formCreatedRecord.getTenantId()});
    }
}

