/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.scheduled;

import io.camunda.zeebe.engine.processing.scheduled.DueDateChecker;
import io.camunda.zeebe.scheduler.clock.ActorClock;
import io.camunda.zeebe.stream.api.ReadonlyStreamProcessorContext;
import io.camunda.zeebe.stream.api.scheduling.ProcessingScheduleService;
import io.camunda.zeebe.stream.api.scheduling.SimpleProcessingScheduleService;
import io.camunda.zeebe.stream.api.scheduling.Task;
import io.camunda.zeebe.stream.api.scheduling.TaskResultBuilder;
import java.time.Duration;
import java.util.function.Function;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class DueDateCheckerTest {
    @Test
    public void shouldNotScheduleTwoTasks() {
        int timerResolution = 100;
        DueDateChecker dueDateChecker = new DueDateChecker(100L, false, builder -> 0L);
        ReadonlyStreamProcessorContext mockContext = (ReadonlyStreamProcessorContext)Mockito.mock(ReadonlyStreamProcessorContext.class);
        ProcessingScheduleService mockScheduleService = (ProcessingScheduleService)Mockito.mock(ProcessingScheduleService.class);
        Mockito.when((Object)mockContext.getScheduleService()).thenReturn((Object)mockScheduleService);
        dueDateChecker.onRecovered(mockContext);
        ((ProcessingScheduleService)Mockito.verify((Object)mockScheduleService)).runDelayed((Duration)ArgumentMatchers.eq((Object)Duration.ofMillis(100L)), (Task)ArgumentMatchers.any(Task.class));
        dueDateChecker.execute((TaskResultBuilder)Mockito.mock(TaskResultBuilder.class));
        Mockito.clearInvocations((Object[])new ProcessingScheduleService[]{mockScheduleService});
        long currentTimeMillis = System.currentTimeMillis();
        dueDateChecker.schedule(currentTimeMillis + 1000L);
        dueDateChecker.schedule(currentTimeMillis + 1000L);
        ((ProcessingScheduleService)Mockito.verify((Object)mockScheduleService)).runDelayed((Duration)ArgumentMatchers.any(), (Task)ArgumentMatchers.any(Task.class));
    }

    @Test
    public void shouldScheduleForAnEarlierTasks() {
        int timerResolution = 100;
        DueDateChecker dueDateChecker = new DueDateChecker(100L, false, builder -> 0L);
        ReadonlyStreamProcessorContext mockContext = (ReadonlyStreamProcessorContext)Mockito.mock(ReadonlyStreamProcessorContext.class);
        ProcessingScheduleService mockScheduleService = (ProcessingScheduleService)Mockito.mock(ProcessingScheduleService.class);
        SimpleProcessingScheduleService.ScheduledTask mockScheduledTask = (SimpleProcessingScheduleService.ScheduledTask)Mockito.mock(SimpleProcessingScheduleService.ScheduledTask.class);
        Mockito.when((Object)mockScheduleService.runDelayed((Duration)ArgumentMatchers.any(Duration.class), (Task)ArgumentMatchers.any(Task.class))).thenReturn((Object)mockScheduledTask);
        Mockito.when((Object)mockContext.getScheduleService()).thenReturn((Object)mockScheduleService);
        dueDateChecker.onRecovered(mockContext);
        ((ProcessingScheduleService)Mockito.verify((Object)mockScheduleService)).runDelayed((Duration)ArgumentMatchers.eq((Object)Duration.ofMillis(100L)), (Task)ArgumentMatchers.any(Task.class));
        dueDateChecker.execute((TaskResultBuilder)Mockito.mock(TaskResultBuilder.class));
        Mockito.clearInvocations((Object[])new ProcessingScheduleService[]{mockScheduleService});
        long currentTimeMillis = System.currentTimeMillis();
        dueDateChecker.schedule(currentTimeMillis + 1000L);
        dueDateChecker.schedule(currentTimeMillis + 100L);
        ((ProcessingScheduleService)Mockito.verify((Object)mockScheduleService, (VerificationMode)Mockito.times((int)2))).runDelayed((Duration)ArgumentMatchers.any(), (Task)ArgumentMatchers.any(Task.class));
        ((SimpleProcessingScheduleService.ScheduledTask)Mockito.verify((Object)mockScheduledTask)).cancel();
    }

    @Test
    public void shouldRescheduleAutomatically() {
        Function<TaskResultBuilder, Long> visitor = builder -> ActorClock.currentTimeMillis() + 1000L;
        int timerResolution = 100;
        DueDateChecker dueDateChecker = new DueDateChecker(100L, false, visitor);
        ReadonlyStreamProcessorContext mockContext = (ReadonlyStreamProcessorContext)Mockito.mock(ReadonlyStreamProcessorContext.class);
        ProcessingScheduleService mockScheduleService = (ProcessingScheduleService)Mockito.mock(ProcessingScheduleService.class);
        SimpleProcessingScheduleService.ScheduledTask mockScheduledTask = (SimpleProcessingScheduleService.ScheduledTask)Mockito.mock(SimpleProcessingScheduleService.ScheduledTask.class);
        Mockito.when((Object)mockScheduleService.runDelayed((Duration)ArgumentMatchers.any(Duration.class), (Task)ArgumentMatchers.any(Task.class))).thenReturn((Object)mockScheduledTask);
        Mockito.when((Object)mockContext.getScheduleService()).thenReturn((Object)mockScheduleService);
        dueDateChecker.onRecovered(mockContext);
        ((ProcessingScheduleService)Mockito.verify((Object)mockScheduleService)).runDelayed((Duration)ArgumentMatchers.eq((Object)Duration.ofMillis(100L)), (Task)ArgumentMatchers.any(Task.class));
        Mockito.clearInvocations((Object[])new ProcessingScheduleService[]{mockScheduleService});
        dueDateChecker.execute((TaskResultBuilder)Mockito.mock(TaskResultBuilder.class));
        ((ProcessingScheduleService)Mockito.verify((Object)mockScheduleService)).runDelayed((Duration)ArgumentMatchers.any(), (Task)ArgumentMatchers.any(Task.class));
    }

    @Test
    public void shouldScheduleEarlierIfRescheduledAutomatically() {
        Function<TaskResultBuilder, Long> visitor = builder -> ActorClock.currentTimeMillis() + 1000L;
        int timerResolution = 100;
        DueDateChecker dueDateChecker = new DueDateChecker(100L, false, visitor);
        ReadonlyStreamProcessorContext mockContext = (ReadonlyStreamProcessorContext)Mockito.mock(ReadonlyStreamProcessorContext.class);
        ProcessingScheduleService mockScheduleService = (ProcessingScheduleService)Mockito.mock(ProcessingScheduleService.class);
        SimpleProcessingScheduleService.ScheduledTask mockScheduledTask = (SimpleProcessingScheduleService.ScheduledTask)Mockito.mock(SimpleProcessingScheduleService.ScheduledTask.class);
        Mockito.when((Object)mockScheduleService.runDelayed((Duration)ArgumentMatchers.any(Duration.class), (Task)ArgumentMatchers.any(Task.class))).thenReturn((Object)mockScheduledTask);
        Mockito.when((Object)mockContext.getScheduleService()).thenReturn((Object)mockScheduleService);
        dueDateChecker.onRecovered(mockContext);
        ((ProcessingScheduleService)Mockito.verify((Object)mockScheduleService)).runDelayed((Duration)ArgumentMatchers.eq((Object)Duration.ofMillis(100L)), (Task)ArgumentMatchers.any(Task.class));
        Mockito.clearInvocations((Object[])new ProcessingScheduleService[]{mockScheduleService});
        dueDateChecker.execute((TaskResultBuilder)Mockito.mock(TaskResultBuilder.class));
        ((ProcessingScheduleService)Mockito.verify((Object)mockScheduleService)).runDelayed((Duration)ArgumentMatchers.any(), (Task)ArgumentMatchers.any(Task.class));
        Mockito.clearInvocations((Object[])new ProcessingScheduleService[]{mockScheduleService});
        dueDateChecker.schedule(ActorClock.currentTimeMillis() + 100L);
        ((ProcessingScheduleService)Mockito.verify((Object)mockScheduleService)).runDelayed((Duration)ArgumentMatchers.any(), (Task)ArgumentMatchers.any(Task.class));
        ((SimpleProcessingScheduleService.ScheduledTask)Mockito.verify((Object)mockScheduledTask)).cancel();
    }
}

