/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.signal;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.engine.util.client.SignalClient;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.SignalIntent;
import io.camunda.zeebe.protocol.record.value.SignalRecordValue;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class BroadcastSignalTest {
    @ClassRule
    public static final EngineRule ENGINE_RULE = EngineRule.singlePartition();
    private static final String SIGNAL_NAME = "a";
    @Rule
    public final RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();
    private SignalClient signalClient;

    @Before
    public void init() {
        this.signalClient = ENGINE_RULE.signal().withSignalName(SIGNAL_NAME);
    }

    @Test
    public void shouldBroadcastSignal() {
        Record<SignalRecordValue> record = this.signalClient.broadcast();
        Assertions.assertThat((Map)((SignalRecordValue)record.getValue()).getVariables()).isEmpty();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(record).hasIntent((Intent)SignalIntent.BROADCASTED).hasRecordType(RecordType.EVENT).hasValueType(ValueType.SIGNAL);
        io.camunda.zeebe.protocol.record.Assertions.assertThat((SignalRecordValue)((SignalRecordValue)record.getValue())).hasSignalName(SIGNAL_NAME);
    }

    @Test
    public void shouldBroadcastSignalWithVariables() {
        Record<SignalRecordValue> record = this.signalClient.withVariables("{'foo':'bar'}").broadcast();
        Assertions.assertThat((Map)((SignalRecordValue)record.getValue()).getVariables()).containsExactly(new Map.Entry[]{Assertions.entry((Object)"foo", (Object)"bar")});
    }

    @Test
    public void shouldBroadcastSignalWithDifferentName() {
        Record<SignalRecordValue> firstRecord = this.signalClient.withSignalName(SIGNAL_NAME).broadcast();
        Record<SignalRecordValue> secondRecord = this.signalClient.withSignalName("b").broadcast();
        Assertions.assertThat((long)firstRecord.getKey()).isLessThan(secondRecord.getKey());
    }
}

