/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.signal;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.ProcessBuilder;
import io.camunda.zeebe.model.bpmn.builder.StartEventBuilder;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.BpmnEventType;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.protocol.record.value.VariableRecordValue;
import io.camunda.zeebe.test.util.record.ProcessInstanceCreationRecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.groups.Tuple;
import org.junit.Rule;
import org.junit.Test;

public class SignalStartEventTest {
    private static final String SIGNAL_NAME_1 = "a";
    private static final String SIGNAL_NAME_2 = "b";
    @Rule
    public final EngineRule engine = EngineRule.singlePartition();

    @Test
    public void shouldBroadcastSignalToStartEvent() {
        BpmnModelInstance process = ((StartEventBuilder)Bpmn.createExecutableProcess((String)"wf").startEvent("start").signal(SIGNAL_NAME_1)).endEvent().done();
        this.engine.deployment().withXmlResource(process).deploy();
        this.engine.signal().withSignalName(SIGNAL_NAME_1).broadcast();
        Record processInstance = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATING).filterRootScope().getFirst();
        Record startEvent = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATING).withElementType(BpmnElementType.START_EVENT).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((ProcessInstanceRecordValue)((ProcessInstanceRecordValue)startEvent.getValue())).hasProcessDefinitionKey(((ProcessInstanceRecordValue)processInstance.getValue()).getProcessDefinitionKey()).hasBpmnProcessId(((ProcessInstanceRecordValue)processInstance.getValue()).getBpmnProcessId()).hasVersion(((ProcessInstanceRecordValue)processInstance.getValue()).getVersion()).hasProcessInstanceKey(processInstance.getKey()).hasBpmnEventType(BpmnEventType.SIGNAL).hasElementId("start").hasFlowScopeKey(processInstance.getKey());
    }

    @Test
    public void shouldCreateNewInstanceWithSignalVariables() {
        BpmnModelInstance process = ((StartEventBuilder)Bpmn.createExecutableProcess((String)"wf").startEvent("start").signal(SIGNAL_NAME_1)).endEvent().done();
        this.engine.deployment().withXmlResource(process).deploy();
        this.engine.signal().withSignalName(SIGNAL_NAME_1).withVariables(Map.of("x", 1, "y", 2)).broadcast();
        ((AbstractListAssert)Assertions.assertThat((Stream)RecordingExporter.variableRecords().limit(2L)).extracting(Record::getValue).extracting(new Function[]{VariableRecordValue::getName, VariableRecordValue::getValue}).hasSize(2)).contains((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"x", "1"}), Assertions.tuple((Object[])new Object[]{"y", "2"})});
    }

    @Test
    public void shouldApplyOutputMappings() {
        BpmnModelInstance process = ((StartEventBuilder)((StartEventBuilder)Bpmn.createExecutableProcess((String)"wf").startEvent("start").zeebeOutputExpression("x", "y")).signal(SIGNAL_NAME_1)).endEvent().done();
        this.engine.deployment().withXmlResource(process).deploy();
        this.engine.signal().withSignalName(SIGNAL_NAME_1).withVariables(Map.of("x", 1, "y", 2)).broadcast();
        Record processInstance = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).filterRootScope().getFirst();
        Assertions.assertThat((Stream)RecordingExporter.variableRecords().withScopeKey(processInstance.getKey()).limit(1L)).extracting(Record::getValue).extracting(new Function[]{VariableRecordValue::getName, VariableRecordValue::getValue}).contains((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"y", "1"})});
    }

    @Test
    public void shouldCreateInstanceOfLatestVersion() {
        BpmnModelInstance process1 = ((StartEventBuilder)Bpmn.createExecutableProcess((String)"wf").startEvent("v1").signal(SIGNAL_NAME_1)).endEvent().done();
        BpmnModelInstance process2 = ((StartEventBuilder)Bpmn.createExecutableProcess((String)"wf").startEvent("v2").signal(SIGNAL_NAME_1)).endEvent().done();
        this.engine.deployment().withXmlResource(process1).deploy();
        this.engine.deployment().withXmlResource(process2).deploy();
        this.engine.signal().withSignalName(SIGNAL_NAME_1).broadcast();
        Record startEvent = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withElementType(BpmnElementType.START_EVENT).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((ProcessInstanceRecordValue)((ProcessInstanceRecordValue)startEvent.getValue())).hasElementId("v2");
    }

    @Test
    public void shouldCreateNewInstanceWithMultipleStartEvents() {
        ProcessBuilder process = Bpmn.createExecutableProcess((String)"wf");
        ((StartEventBuilder)process.startEvent().signal(SIGNAL_NAME_1)).endEvent("end");
        ((StartEventBuilder)process.startEvent().signal(SIGNAL_NAME_2)).connectTo("end");
        this.engine.deployment().withXmlResource(process.done()).deploy();
        this.engine.signal().withSignalName(SIGNAL_NAME_1).withVariables(Map.of("x", 1)).broadcast();
        this.engine.signal().withSignalName(SIGNAL_NAME_2).withVariables(Map.of("x", 2)).broadcast();
        Assertions.assertThat((Stream)RecordingExporter.variableRecords().withName("x").filterProcessInstanceScope().limit(2L)).extracting(r -> ((VariableRecordValue)r.getValue()).getValue()).containsExactly((Object[])new String[]{"1", "2"});
    }

    @Test
    public void shouldTriggerOnlySignalStartEvent() {
        ProcessBuilder process = Bpmn.createExecutableProcess((String)"process");
        process.startEvent("none-start").endEvent();
        ((StartEventBuilder)process.startEvent("message-start").message("test")).endEvent();
        ((StartEventBuilder)process.startEvent("signal-start").signal(SIGNAL_NAME_1)).endEvent();
        ((StartEventBuilder)process.startEvent("timer-start").timerWithCycle("R/PT1H")).endEvent();
        this.engine.deployment().withXmlResource(process.done()).deploy();
        this.engine.signal().withSignalName(SIGNAL_NAME_1).broadcast();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().limitToProcessInstanceCompleted().withElementType(BpmnElementType.START_EVENT)).extracting(r -> ((ProcessInstanceRecordValue)r.getValue()).getElementId()).containsOnly((Object[])new String[]{"signal-start"});
    }

    @Test
    public void shouldCreateMultipleInstances() {
        BpmnModelInstance process = ((StartEventBuilder)Bpmn.createExecutableProcess((String)"wf").startEvent("start").signal(SIGNAL_NAME_1)).endEvent().done();
        this.engine.deployment().withXmlResource(process).deploy();
        this.engine.signal().withSignalName(SIGNAL_NAME_1).withVariables(Map.of("x", 1)).broadcast();
        this.engine.signal().withSignalName(SIGNAL_NAME_1).withVariables(Map.of("x", 2)).broadcast();
        Assertions.assertThat((Stream)RecordingExporter.variableRecords().withName("x").filterProcessInstanceScope().limit(2L)).extracting(r -> ((VariableRecordValue)r.getValue()).getValue()).containsExactly((Object[])new String[]{"1", "2"});
    }

    @Test
    public void shouldCreateMultipleInstancesForDifferentResources() {
        BpmnModelInstance process1 = ((StartEventBuilder)Bpmn.createExecutableProcess((String)"wf_1").startEvent("start").signal(SIGNAL_NAME_1)).endEvent().done();
        BpmnModelInstance process2 = ((StartEventBuilder)Bpmn.createExecutableProcess((String)"wf_2").startEvent("start").signal(SIGNAL_NAME_1)).endEvent().done();
        this.engine.deployment().withXmlResource(process1).withXmlResource(process2).deploy();
        this.engine.signal().withSignalName(SIGNAL_NAME_1).withVariables(Map.of("x", 1)).broadcast();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withElementType(BpmnElementType.START_EVENT).limit(2L)).extracting(r -> ((ProcessInstanceRecordValue)r.getValue()).getBpmnProcessId()).containsExactly((Object[])new String[]{"wf_1", "wf_2"});
    }

    @Test
    public void shouldNotCreateInstanceDirectly() {
        this.engine.deployment().withXmlResource(((StartEventBuilder)Bpmn.createExecutableProcess((String)"SignalStartEventOnly").startEvent("signal-start").signal("start")).endEvent().done()).deploy();
        this.engine.processInstance().ofBpmnProcessId("SignalStartEventOnly").expectRejection().create();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((Record)((Record)((ProcessInstanceCreationRecordStream)RecordingExporter.processInstanceCreationRecords().onlyCommandRejections()).withBpmnProcessId("SignalStartEventOnly").getFirst())).hasRejectionType(RejectionType.INVALID_STATE).hasRejectionReason("Expected to create instance of process with none start event, but there is no such event");
    }
}

