/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.streamprocessor;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import java.time.Duration;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.junit.Rule;
import org.junit.Test;

public class ReachEndOfLogTest {
    @Rule
    public final EngineRule engineRule = EngineRule.singlePartition();

    @Test
    public void shouldReturnTrueIfNothingProcessed() {
        boolean reachedEnd = this.engineRule.hasReachedEnd();
        Assertions.assertThat((boolean)reachedEnd).isTrue();
    }

    @Test
    public void shouldReturnTrueAfterReachingEndOfTheLog() {
        this.engineRule.deployment().withXmlResource(Bpmn.createExecutableProcess((String)"process").startEvent().endEvent().done()).deploy();
        this.engineRule.processInstance().ofBpmnProcessId("process").create();
        Awaitility.await((String)"Processor should reach the end").atLeast(Duration.ofMillis(100L)).until(this.engineRule::hasReachedEnd, Boolean.TRUE::equals);
    }

    @Test
    public void shouldReturnFalseIfNotReachedEndOfLog() {
        this.engineRule.deployment().withXmlResource(Bpmn.createExecutableProcess((String)"process").startEvent().intermediateThrowEvent("test").connectTo("test").endEvent().done()).deploy();
        this.engineRule.processInstance().ofBpmnProcessId("process").create();
        boolean reachedEnd = this.engineRule.hasReachedEnd();
        Assertions.assertThat((boolean)reachedEnd).isFalse();
    }
}

