/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.timer;

import io.camunda.zeebe.engine.processing.timer.CronTimer;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class CronTimerTest {
    @Test
    public void shouldFailToParseIfWrongExpression() {
        Assertions.assertThatThrownBy(() -> CronTimer.parse(null)).isInstanceOf(DateTimeParseException.class);
        Assertions.assertThatThrownBy(() -> CronTimer.parse((String)"")).isInstanceOf(DateTimeParseException.class);
        Assertions.assertThatThrownBy(() -> CronTimer.parse((String)"*")).isInstanceOf(DateTimeParseException.class);
        Assertions.assertThatThrownBy(() -> CronTimer.parse((String)"* * * * *")).isInstanceOf(DateTimeParseException.class);
        Assertions.assertThatThrownBy(() -> CronTimer.parse((String)"* * * * * * *")).isInstanceOf(DateTimeParseException.class);
        Assertions.assertThatThrownBy(() -> CronTimer.parse((String)"60 * * * * *")).isInstanceOf(DateTimeParseException.class);
        Assertions.assertThatThrownBy(() -> CronTimer.parse((String)"20-10 * * * * *")).isInstanceOf(DateTimeParseException.class);
        Assertions.assertThatThrownBy(() -> CronTimer.parse((String)"* 60 * * * *")).isInstanceOf(DateTimeParseException.class);
        Assertions.assertThatThrownBy(() -> CronTimer.parse((String)"* 20-10 * * * *")).isInstanceOf(DateTimeParseException.class);
        Assertions.assertThatThrownBy(() -> CronTimer.parse((String)"* * 24 * * *")).isInstanceOf(DateTimeParseException.class);
        Assertions.assertThatThrownBy(() -> CronTimer.parse((String)"* * 20-10 * * *")).isInstanceOf(DateTimeParseException.class);
        Assertions.assertThatThrownBy(() -> CronTimer.parse((String)"* * * 0 * *")).isInstanceOf(DateTimeParseException.class);
        Assertions.assertThatThrownBy(() -> CronTimer.parse((String)"* * * 32 * *")).isInstanceOf(DateTimeParseException.class);
        Assertions.assertThatThrownBy(() -> CronTimer.parse((String)"* * * * 0 *")).isInstanceOf(DateTimeParseException.class);
        Assertions.assertThatThrownBy(() -> CronTimer.parse((String)"* * * * 13 *")).isInstanceOf(DateTimeParseException.class);
        Assertions.assertThatThrownBy(() -> CronTimer.parse((String)"* * * * * 8")).isInstanceOf(DateTimeParseException.class);
        Assertions.assertThatThrownBy(() -> CronTimer.parse((String)"* * * * * *SUN")).isInstanceOf(DateTimeParseException.class);
        Assertions.assertThatThrownBy(() -> CronTimer.parse((String)"* * * * * SUN*")).isInstanceOf(DateTimeParseException.class);
    }

    @Test
    public void shouldParseWithCronExpression() {
        String text = "*/10 * * * * *";
        long now = System.currentTimeMillis();
        long expected = now + 10000L;
        CronTimer timer = CronTimer.parse((String)"*/10 * * * * *");
        long dueDate = timer.getDueDate(now);
        Assertions.assertThat((long)dueDate).isBetween(Long.valueOf(now), Long.valueOf(expected));
        Assertions.assertThat((int)timer.getRepetitions()).isEqualTo(-1);
    }

    @Test
    public void shouldMatchAll() {
        String text = "* * * * * *";
        ZonedDateTime last = ZonedDateTime.now(ZoneId.systemDefault());
        long expected = last.plusSeconds(1L).toInstant().toEpochMilli();
        CronTimer timer = CronTimer.parse((String)"* * * * * *");
        long dueDate = timer.getDueDate(last.toInstant().toEpochMilli());
        Assertions.assertThat((long)dueDate).isEqualTo(expected);
        Assertions.assertThat((int)timer.getRepetitions()).isEqualTo(-1);
    }

    @Test
    public void shouldMatchLastSecond() {
        String text = "* * * * * *";
        ZonedDateTime last = ZonedDateTime.now(ZoneId.systemDefault()).withSecond(58);
        long expected = last.plusSeconds(1L).toInstant().toEpochMilli();
        CronTimer timer = CronTimer.parse((String)"* * * * * *");
        long dueDate = timer.getDueDate(last.toInstant().toEpochMilli());
        Assertions.assertThat((long)dueDate).isEqualTo(expected);
        Assertions.assertThat((int)timer.getRepetitions()).isEqualTo(-1);
    }

    @Test
    public void shouldMatchSpecificSecond() {
        String text = "10 * * * * *";
        ZonedDateTime last = ZonedDateTime.now(ZoneId.systemDefault()).withSecond(9);
        long expected = last.withSecond(10).withNano(0).toInstant().toEpochMilli();
        CronTimer timer = CronTimer.parse((String)"10 * * * * *");
        long dueDate = timer.getDueDate(last.toInstant().toEpochMilli());
        Assertions.assertThat((long)dueDate).isEqualTo(expected);
        Assertions.assertThat((int)timer.getRepetitions()).isEqualTo(-1);
    }

    @Test
    public void shouldParseSecondRange() {
        String text = "10-15 * * * * *";
        CronTimer timer = CronTimer.parse((String)"10-15 * * * * *");
        ZonedDateTime now = ZonedDateTime.now(ZoneId.systemDefault()).withNano(0);
        for (int i = 9; i < 15; ++i) {
            ZonedDateTime last = now.withSecond(i);
            long expected = last.plusSeconds(1L).toInstant().toEpochMilli();
            Assertions.assertThat((long)timer.getDueDate(last.toInstant().toEpochMilli())).isEqualTo(expected);
            Assertions.assertThat((int)timer.getRepetitions()).isEqualTo(-1);
        }
    }

    @Test
    public void shouldParseSpecificMinuteSecond() {
        String text = "55 5 * * * *";
        CronTimer timer = CronTimer.parse((String)"55 5 * * * *");
        ZonedDateTime last = ZonedDateTime.now(ZoneId.systemDefault()).withMinute(4).withSecond(54);
        long fromEpochMilli = last.toInstant().toEpochMilli();
        ZonedDateTime expected = last.plusMinutes(1L).withSecond(55).withNano(0);
        long dueDate = timer.getDueDate(fromEpochMilli);
        Assertions.assertThat((long)dueDate).isEqualTo(expected.toInstant().toEpochMilli());
        Assertions.assertThat((int)timer.getRepetitions()).isEqualTo(-1);
        fromEpochMilli = dueDate;
        dueDate = timer.getDueDate(fromEpochMilli);
        Assertions.assertThat((long)dueDate).isEqualTo(expected.plusHours(1L).toInstant().toEpochMilli());
        Assertions.assertThat((int)timer.getRepetitions()).isEqualTo(-1);
    }

    @Test
    public void shouldParseSpecificHourSecond() {
        String text = "55 * 10 * * *";
        CronTimer timer = CronTimer.parse((String)"55 * 10 * * *");
        ZonedDateTime last = ZonedDateTime.now(ZoneId.systemDefault()).withHour(9).withSecond(54);
        long fromEpochMilli = last.toInstant().toEpochMilli();
        ZonedDateTime expected = last.plusHours(1L).withMinute(0).withSecond(55).withNano(0);
        long dueDate = timer.getDueDate(fromEpochMilli);
        Assertions.assertThat((long)dueDate).isEqualTo(expected.toInstant().toEpochMilli());
        Assertions.assertThat((int)timer.getRepetitions()).isEqualTo(-1);
        fromEpochMilli = dueDate;
        dueDate = timer.getDueDate(fromEpochMilli);
        Assertions.assertThat((long)dueDate).isEqualTo(expected.plusMinutes(1L).toInstant().toEpochMilli());
        Assertions.assertThat((int)timer.getRepetitions()).isEqualTo(-1);
    }

    @Test
    public void shouldParseSpecificMinuteHour() {
        String text = "* 5 10 * * *";
        CronTimer timer = CronTimer.parse((String)"* 5 10 * * *");
        ZonedDateTime last = ZonedDateTime.now(ZoneId.systemDefault()).withHour(9).withMinute(4);
        long fromEpochMilli = last.toInstant().toEpochMilli();
        ZonedDateTime expected = last.plusHours(1L).plusMinutes(1L).withSecond(0).withNano(0);
        long dueDate = timer.getDueDate(fromEpochMilli);
        Assertions.assertThat((long)dueDate).isEqualTo(expected.toInstant().toEpochMilli());
        Assertions.assertThat((int)timer.getRepetitions()).isEqualTo(-1);
        fromEpochMilli = dueDate;
        dueDate = timer.getDueDate(fromEpochMilli);
        Assertions.assertThat((long)dueDate).isEqualTo(expected.plusSeconds(1L).toInstant().toEpochMilli());
        Assertions.assertThat((int)timer.getRepetitions()).isEqualTo(-1);
    }

    @Test
    public void shouldParseSpecificDayOfMonthSecond() {
        String text = "55 * * 3 * *";
        CronTimer timer = CronTimer.parse((String)"55 * * 3 * *");
        ZonedDateTime last = ZonedDateTime.now(ZoneId.systemDefault()).withDayOfMonth(2).withSecond(54);
        long fromEpochMilli = last.toInstant().toEpochMilli();
        ZonedDateTime expected = last.plusDays(1L).withHour(0).withMinute(0).withSecond(55).withNano(0);
        long dueDate = timer.getDueDate(fromEpochMilli);
        Assertions.assertThat((long)dueDate).isEqualTo(expected.toInstant().toEpochMilli());
        Assertions.assertThat((int)timer.getRepetitions()).isEqualTo(-1);
        fromEpochMilli = dueDate;
        dueDate = timer.getDueDate(fromEpochMilli);
        Assertions.assertThat((long)dueDate).isEqualTo(expected.plusMinutes(1L).toInstant().toEpochMilli());
        Assertions.assertThat((int)timer.getRepetitions()).isEqualTo(-1);
    }

    @Test
    public void shouldParseSpecificDate() {
        String text = "* * * 3 11 *";
        CronTimer timer = CronTimer.parse((String)"* * * 3 11 *");
        ZonedDateTime last = ZonedDateTime.now(ZoneId.systemDefault()).withMonth(10).withDayOfMonth(2);
        long fromEpochMilli = last.toInstant().toEpochMilli();
        ZonedDateTime expected = ZonedDateTime.of(last.getYear(), 11, 3, 0, 0, 0, 0, ZoneId.systemDefault());
        long dueDate = timer.getDueDate(fromEpochMilli);
        Assertions.assertThat((long)dueDate).isEqualTo(expected.toInstant().toEpochMilli());
        Assertions.assertThat((int)timer.getRepetitions()).isEqualTo(-1);
        fromEpochMilli = dueDate;
        dueDate = timer.getDueDate(fromEpochMilli);
        Assertions.assertThat((long)dueDate).isEqualTo(expected.plusSeconds(1L).toInstant().toEpochMilli());
        Assertions.assertThat((int)timer.getRepetitions()).isEqualTo(-1);
    }

    @Test
    public void shouldParseNonExistentSpecificDate() {
        String text = "0 0 0 31 6 *";
        ZonedDateTime last = ZonedDateTime.now(ZoneId.systemDefault()).withMonth(3).withDayOfMonth(10);
        CronTimer timer = CronTimer.parse((String)"0 0 0 31 6 *");
        long dueDate = timer.getDueDate(last.toInstant().toEpochMilli());
        Assertions.assertThat((long)dueDate).isEqualTo(last.toInstant().toEpochMilli());
        Assertions.assertThat((int)timer.getRepetitions()).isEqualTo(0);
    }

    @Test
    public void shouldParseQuartzLastDayOfMonthEveryHour() {
        String text = "0 0 * L * *";
        CronTimer timer = CronTimer.parse((String)"0 0 * L * *");
        ZonedDateTime last = ZonedDateTime.of(2022, 1, 30, 0, 1, 0, 0, ZoneId.systemDefault());
        ZonedDateTime expected = ZonedDateTime.of(2022, 1, 31, 0, 0, 0, 0, ZoneId.systemDefault());
        long dueDate = timer.getDueDate(last.toInstant().toEpochMilli());
        Assertions.assertThat((long)dueDate).isEqualTo(expected.toInstant().toEpochMilli());
        Assertions.assertThat((int)timer.getRepetitions()).isEqualTo(-1);
        last = ZonedDateTime.of(2022, 1, 31, 1, 0, 0, 0, ZoneId.systemDefault());
        expected = ZonedDateTime.of(2022, 1, 31, 2, 0, 0, 0, ZoneId.systemDefault());
        dueDate = timer.getDueDate(last.toInstant().toEpochMilli());
        Assertions.assertThat((long)dueDate).isEqualTo(expected.toInstant().toEpochMilli());
        Assertions.assertThat((int)timer.getRepetitions()).isEqualTo(-1);
    }

    @Test
    public void shouldParseQuartzLastDayOfMonthOffset() {
        String text = "0 0 0 L-3 * *";
        CronTimer timer = CronTimer.parse((String)"0 0 0 L-3 * *");
        ZonedDateTime last = ZonedDateTime.now(ZoneId.systemDefault()).withYear(2022).withMonth(1).withDayOfMonth(10);
        long fromEpochMilli = last.toInstant().toEpochMilli();
        ZonedDateTime expected = ZonedDateTime.now(ZoneId.systemDefault()).withYear(2022).withMonth(1).withDayOfMonth(28).withHour(0).withMinute(0).withSecond(0).withNano(0);
        long dueDate = timer.getDueDate(fromEpochMilli);
        Assertions.assertThat((long)dueDate).isEqualTo(expected.toInstant().toEpochMilli());
        Assertions.assertThat((int)timer.getRepetitions()).isEqualTo(-1);
        fromEpochMilli = dueDate;
        expected = ZonedDateTime.now(ZoneId.systemDefault()).withYear(2022).withMonth(2).withDayOfMonth(25).withHour(0).withMinute(0).withSecond(0).withNano(0);
        dueDate = timer.getDueDate(fromEpochMilli);
        Assertions.assertThat((long)dueDate).isEqualTo(expected.toInstant().toEpochMilli());
        Assertions.assertThat((int)timer.getRepetitions()).isEqualTo(-1);
        fromEpochMilli = dueDate;
        expected = ZonedDateTime.now(ZoneId.systemDefault()).withYear(2022).withMonth(3).withDayOfMonth(28).withHour(0).withMinute(0).withSecond(0).withNano(0);
        dueDate = timer.getDueDate(fromEpochMilli);
        Assertions.assertThat((long)dueDate).isEqualTo(expected.toInstant().toEpochMilli());
        Assertions.assertThat((int)timer.getRepetitions()).isEqualTo(-1);
        fromEpochMilli = dueDate;
        expected = ZonedDateTime.now(ZoneId.systemDefault()).withYear(2022).withMonth(4).withDayOfMonth(27).withHour(0).withMinute(0).withSecond(0).withNano(0);
        dueDate = timer.getDueDate(fromEpochMilli);
        Assertions.assertThat((long)dueDate).isEqualTo(expected.toInstant().toEpochMilli());
        Assertions.assertThat((int)timer.getRepetitions()).isEqualTo(-1);
    }

    @Test
    public void shouldParseQuartzLastDayOfMonthOffsetEveryHour() {
        String text = "0 0 * L-1 * *";
        CronTimer timer = CronTimer.parse((String)"0 0 * L-1 * *");
        ZonedDateTime last = ZonedDateTime.of(2022, 1, 29, 0, 1, 0, 0, ZoneId.systemDefault());
        ZonedDateTime expected = ZonedDateTime.of(2022, 1, 30, 0, 0, 0, 0, ZoneId.systemDefault());
        long dueDate = timer.getDueDate(last.toInstant().toEpochMilli());
        Assertions.assertThat((long)dueDate).isEqualTo(expected.toInstant().toEpochMilli());
        Assertions.assertThat((int)timer.getRepetitions()).isEqualTo(-1);
        last = ZonedDateTime.of(2022, 1, 30, 1, 0, 0, 0, ZoneId.systemDefault());
        expected = ZonedDateTime.of(2022, 1, 30, 2, 0, 0, 0, ZoneId.systemDefault());
        dueDate = timer.getDueDate(last.toInstant().toEpochMilli());
        Assertions.assertThat((long)dueDate).isEqualTo(expected.toInstant().toEpochMilli());
        Assertions.assertThat((int)timer.getRepetitions()).isEqualTo(-1);
    }

    @Test
    public void shouldParseQuartzFirstWeekdayOfMonthEveryHour() {
        String text = "0 0 * 1W * *";
        CronTimer timer = CronTimer.parse((String)"0 0 * 1W * *");
        ZonedDateTime last = ZonedDateTime.of(2022, 6, 29, 0, 1, 0, 0, ZoneId.systemDefault());
        ZonedDateTime expected = ZonedDateTime.of(2022, 7, 1, 0, 0, 0, 0, ZoneId.systemDefault());
        long dueDate = timer.getDueDate(last.toInstant().toEpochMilli());
        Assertions.assertThat((long)dueDate).isEqualTo(expected.toInstant().toEpochMilli());
        Assertions.assertThat((int)timer.getRepetitions()).isEqualTo(-1);
        last = ZonedDateTime.of(2022, 7, 1, 1, 0, 0, 0, ZoneId.systemDefault());
        expected = ZonedDateTime.of(2022, 7, 1, 2, 0, 0, 0, ZoneId.systemDefault());
        dueDate = timer.getDueDate(last.toInstant().toEpochMilli());
        Assertions.assertThat((long)dueDate).isEqualTo(expected.toInstant().toEpochMilli());
        Assertions.assertThat((int)timer.getRepetitions()).isEqualTo(-1);
    }

    @Test
    public void shouldParseQuartzLastWeekdayOfMonthEveryHour() {
        String text = "0 0 * LW * *";
        CronTimer timer = CronTimer.parse((String)"0 0 * LW * *");
        ZonedDateTime last = ZonedDateTime.of(2022, 6, 29, 0, 1, 0, 0, ZoneId.systemDefault());
        ZonedDateTime expected = ZonedDateTime.of(2022, 6, 30, 0, 0, 0, 0, ZoneId.systemDefault());
        long dueDate = timer.getDueDate(last.toInstant().toEpochMilli());
        Assertions.assertThat((long)dueDate).isEqualTo(expected.toInstant().toEpochMilli());
        Assertions.assertThat((int)timer.getRepetitions()).isEqualTo(-1);
        last = ZonedDateTime.of(2022, 6, 30, 1, 0, 0, 0, ZoneId.systemDefault());
        expected = ZonedDateTime.of(2022, 6, 30, 2, 0, 0, 0, ZoneId.systemDefault());
        dueDate = timer.getDueDate(last.toInstant().toEpochMilli());
        Assertions.assertThat((long)dueDate).isEqualTo(expected.toInstant().toEpochMilli());
        Assertions.assertThat((int)timer.getRepetitions()).isEqualTo(-1);
    }
}

