/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.variable;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.intent.VariableDocumentIntent;
import io.camunda.zeebe.protocol.record.intent.VariableIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.protocol.record.value.VariableDocumentUpdateSemantic;
import io.camunda.zeebe.protocol.record.value.VariableRecordValue;
import io.camunda.zeebe.test.util.collection.Maps;
import io.camunda.zeebe.test.util.record.ProcessInstanceRecordStream;
import io.camunda.zeebe.test.util.record.RecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import io.camunda.zeebe.test.util.record.VariableDocumentRecordStream;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.groups.Tuple;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public final class UpdateVariableDocumentTest {
    @ClassRule
    public static final EngineRule ENGINE_RULE = EngineRule.singlePartition();
    @Rule
    public final RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();

    @Test
    public void shouldProduceCorrectSequenceOfEvents() {
        String processId = "process";
        String taskId = "task";
        String type = UUID.randomUUID().toString();
        BpmnModelInstance process = this.newProcess("process", "task", type);
        Map document = Maps.of((Map.Entry[])new Map.Entry[]{Assertions.entry((Object)"x", (Object)2), Assertions.entry((Object)"foo", (Object)"bar")});
        ENGINE_RULE.deployment().withXmlResource(process).deploy();
        long processInstanceKey = ENGINE_RULE.processInstance().ofBpmnProcessId("process").withVariables("{'x': 1}").create();
        Record<ProcessInstanceRecordValue> activatedEvent = this.waitForActivityActivatedEvent();
        ENGINE_RULE.variables().ofScope(activatedEvent.getKey()).withDocument(document).withUpdateSemantic(VariableDocumentUpdateSemantic.PROPAGATE).update();
        ENGINE_RULE.job().ofInstance(processInstanceKey).withType(type).complete();
        long completedPosition = this.getProcessInstanceCompletedPosition("process", processInstanceKey);
        Supplier<RecordStream> recordsSupplier = () -> RecordingExporter.records().between(activatedEvent.getPosition(), completedPosition);
        this.assertVariableRecordsProduced(processInstanceKey, recordsSupplier);
        this.assertVariableDocumentEventProduced(document, activatedEvent, recordsSupplier);
    }

    private void assertVariableDocumentEventProduced(Map<String, Object> document, Record<ProcessInstanceRecordValue> activatedEvent, Supplier<RecordStream> records) {
        Assertions.assertThat((Object)((Record)((VariableDocumentRecordStream)records.get().variableDocumentRecords().withIntent((Intent)VariableDocumentIntent.UPDATED)).withScopeKey(activatedEvent.getKey()).withUpdateSemantics(VariableDocumentUpdateSemantic.PROPAGATE).withVariables(document).getFirst())).isNotNull();
        Record updatedRecord = (Record)((VariableDocumentRecordStream)records.get().variableDocumentRecords().withIntent((Intent)VariableDocumentIntent.UPDATED)).getFirst();
        Assertions.assertThat((long)updatedRecord.getKey()).isGreaterThan(0L);
    }

    private void assertVariableRecordsProduced(long processInstanceKey, Supplier<RecordStream> records) {
        ((ListAssert)Assertions.assertThat((Stream)records.get().variableRecords().withProcessInstanceKey(processInstanceKey)).hasSize(2)).extracting(r -> Assertions.tuple((Object[])new Object[]{r.getIntent(), ((VariableRecordValue)r.getValue()).getScopeKey(), ((VariableRecordValue)r.getValue()).getName(), ((VariableRecordValue)r.getValue()).getValue()})).contains((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{VariableIntent.CREATED, processInstanceKey, "foo", "\"bar\""}), Assertions.tuple((Object[])new Object[]{VariableIntent.UPDATED, processInstanceKey, "x", "2"})});
    }

    private BpmnModelInstance newProcess(String processId, String taskId, String type) {
        return Bpmn.createExecutableProcess((String)processId).startEvent().serviceTask(taskId, b -> b.zeebeJobType(type)).endEvent().done();
    }

    private long getProcessInstanceCompletedPosition(String processId, long processInstanceKey) {
        return ((Record)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).withElementId(processId).withIntent((Intent)ProcessInstanceIntent.ELEMENT_COMPLETED)).getFirst()).getPosition();
    }

    private Record<ProcessInstanceRecordValue> waitForActivityActivatedEvent() {
        return (Record)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withIntent((Intent)ProcessInstanceIntent.ELEMENT_ACTIVATED)).withElementType(BpmnElementType.SERVICE_TASK).getFirst();
    }
}

