/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.variable.mapping;

import io.camunda.zeebe.engine.processing.variable.mapping.VariableValue;
import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.builder.ServiceTaskBuilder;
import io.camunda.zeebe.model.bpmn.builder.ZeebeVariablesMappingBuilder;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.intent.VariableIntent;
import io.camunda.zeebe.protocol.record.value.DeploymentRecordValue;
import io.camunda.zeebe.protocol.record.value.deployment.ProcessMetadataValue;
import io.camunda.zeebe.test.util.MsgPackUtil;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import io.camunda.zeebe.test.util.record.VariableRecordStream;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public final class JobOutputMappingTest {
    @ClassRule
    public static final EngineRule ENGINE_RULE = EngineRule.singlePartition();
    private static final String PROCESS_ID = "process";
    @Rule
    public final RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();
    @Parameterized.Parameter(value=0)
    public String jobVariables;
    @Parameterized.Parameter(value=1)
    public Consumer<ServiceTaskBuilder> mappings;
    @Parameterized.Parameter(value=2)
    public List<VariableValue> expectedActivityVariables;
    @Parameterized.Parameter(value=3)
    public List<VariableValue> expectedScopeVariables;
    private String jobType;

    @Parameterized.Parameters(name="from {0} to activity: {2} and scope: {3}")
    public static Object[][] parameters() {
        return new Object[][]{{"{'x': 1}", JobOutputMappingTest.mapping(b -> {}), JobOutputMappingTest.activityVariables(new VariableValue[0]), JobOutputMappingTest.scopeVariables(VariableValue.variable("x", "1"))}, {"{'x': 1}", JobOutputMappingTest.mapping(b -> b.zeebeOutputExpression("x", "x")), JobOutputMappingTest.activityVariables(VariableValue.variable("x", "1")), JobOutputMappingTest.scopeVariables(VariableValue.variable("x", "1"))}, {"{'x': 1}", JobOutputMappingTest.mapping(b -> b.zeebeOutputExpression("x", "y")), JobOutputMappingTest.activityVariables(VariableValue.variable("x", "1")), JobOutputMappingTest.scopeVariables(VariableValue.variable("y", "1"))}, {"{'x': 1, 'y': 2}", JobOutputMappingTest.mapping(b -> b.zeebeOutputExpression("y", "z")), JobOutputMappingTest.activityVariables(VariableValue.variable("x", "1"), VariableValue.variable("y", "2")), JobOutputMappingTest.scopeVariables(VariableValue.variable("z", "2"))}, {"{'x': {'y': 2}}", JobOutputMappingTest.mapping(b -> {}), JobOutputMappingTest.activityVariables(new VariableValue[0]), JobOutputMappingTest.scopeVariables(VariableValue.variable("x", "{\"y\":2}"))}, {"{'x': {'y': 2}}", JobOutputMappingTest.mapping(b -> b.zeebeOutputExpression("x", "y")), JobOutputMappingTest.activityVariables(VariableValue.variable("x", "{\"y\":2}")), JobOutputMappingTest.scopeVariables(VariableValue.variable("y", "{\"y\":2}"))}, {"{'x': {'y': 2}}", JobOutputMappingTest.mapping(b -> b.zeebeOutputExpression("x.y", "y")), JobOutputMappingTest.activityVariables(VariableValue.variable("x", "{\"y\":2}")), JobOutputMappingTest.scopeVariables(VariableValue.variable("y", "2"))}, {"{'x': 1, 'y': 2}", JobOutputMappingTest.mapping(b -> ((ServiceTaskBuilder)b.zeebeOutputExpression("x", "z.x")).zeebeOutputExpression("y", "z.y")), JobOutputMappingTest.activityVariables(VariableValue.variable("x", "1"), VariableValue.variable("y", "2")), JobOutputMappingTest.scopeVariables(VariableValue.variable("z", "{\"x\":1,\"y\":2}"))}, {"{'i': 1}", JobOutputMappingTest.mapping(b -> {}), JobOutputMappingTest.activityVariables(new VariableValue[0]), JobOutputMappingTest.scopeVariables(VariableValue.variable("i", "1"))}, {"{'x': 1}", JobOutputMappingTest.mapping(b -> b.zeebeOutputExpression("x", "i")), JobOutputMappingTest.activityVariables(VariableValue.variable("x", "1")), JobOutputMappingTest.scopeVariables(VariableValue.variable("i", "1"))}, {"{'x': 1}", JobOutputMappingTest.mapping(b -> ((ServiceTaskBuilder)b.zeebeInputExpression("i", "y")).zeebeOutputExpression("y", "z")), JobOutputMappingTest.activityVariables(VariableValue.variable("x", "1"), VariableValue.variable("y", "0")), JobOutputMappingTest.scopeVariables(VariableValue.variable("z", "0"))}, {"{'x': 1}", JobOutputMappingTest.mapping(b -> ((ServiceTaskBuilder)b.zeebeInputExpression("i", "x")).zeebeOutputExpression("x", "y")), JobOutputMappingTest.activityVariables(VariableValue.variable("x", "0"), VariableValue.variable("x", "1")), JobOutputMappingTest.scopeVariables(VariableValue.variable("y", "1"))}, {"{'x': 1, 'y': 2}", JobOutputMappingTest.mapping(b -> ((ServiceTaskBuilder)((ServiceTaskBuilder)b.zeebeInputExpression("i", "x")).zeebeInputExpression("i", "y")).zeebeOutputExpression("y", "z")), JobOutputMappingTest.activityVariables(VariableValue.variable("x", "0"), VariableValue.variable("y", "0"), VariableValue.variable("x", "1"), VariableValue.variable("y", "2")), JobOutputMappingTest.scopeVariables(VariableValue.variable("z", "2"))}, {"{'x': 1}", JobOutputMappingTest.mapping(b -> b.zeebeInputExpression("i", "y")), JobOutputMappingTest.activityVariables(VariableValue.variable("y", "0")), JobOutputMappingTest.scopeVariables(VariableValue.variable("x", "1"))}, {"{'z': 1, 'j': 1}", JobOutputMappingTest.mapping(b -> b.zeebeInputExpression("i", "z")), JobOutputMappingTest.activityVariables(VariableValue.variable("z", "0")), JobOutputMappingTest.scopeVariables(VariableValue.variable("j", "1"))}};
    }

    @Before
    public void init() {
        this.jobType = UUID.randomUUID().toString();
    }

    @Test
    public void shouldApplyOutputMappings() {
        ((ProcessMetadataValue)((DeploymentRecordValue)ENGINE_RULE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().serviceTask("task", builder -> {
            builder.zeebeJobType(this.jobType);
            this.mappings.accept((ServiceTaskBuilder)builder);
        }).endEvent().done()).deploy().getValue()).getProcessesMetadata().get(0)).getProcessDefinitionKey();
        long processInstanceKey = ENGINE_RULE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariable("i", 0).create();
        ENGINE_RULE.job().ofInstance(processInstanceKey).withType(this.jobType).withVariables(MsgPackUtil.asMsgPack((String)this.jobVariables)).complete();
        long elementInstanceKey = ((Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementId("task").getFirst()).getKey();
        Record initialVariable = (Record)RecordingExporter.variableRecords((VariableIntent)VariableIntent.CREATED).withProcessInstanceKey(processInstanceKey).withName("i").getFirst();
        ((AbstractListAssert)Assertions.assertThat((Stream)((VariableRecordStream)RecordingExporter.variableRecords().withProcessInstanceKey(processInstanceKey).skipUntil(r -> r.getPosition() > initialVariable.getPosition())).withScopeKey(elementInstanceKey).limit((long)this.expectedActivityVariables.size())).extracting(Record::getValue).extracting(v -> VariableValue.variable(v.getName(), v.getValue())).hasSize(this.expectedActivityVariables.size())).containsAll(this.expectedActivityVariables);
        ((AbstractListAssert)Assertions.assertThat((Stream)((VariableRecordStream)RecordingExporter.variableRecords().withProcessInstanceKey(processInstanceKey).skipUntil(r -> r.getPosition() > initialVariable.getPosition())).withScopeKey(processInstanceKey).limit((long)this.expectedScopeVariables.size())).extracting(Record::getValue).extracting(v -> VariableValue.variable(v.getName(), v.getValue())).hasSize(this.expectedScopeVariables.size())).containsAll(this.expectedScopeVariables);
    }

    private static Consumer<ZeebeVariablesMappingBuilder<ServiceTaskBuilder>> mapping(Consumer<ZeebeVariablesMappingBuilder<ServiceTaskBuilder>> mappingBuilder) {
        return mappingBuilder;
    }

    private static List<VariableValue> activityVariables(VariableValue ... variables) {
        return Arrays.asList(variables);
    }

    private static List<VariableValue> scopeVariables(VariableValue ... variables) {
        return Arrays.asList(variables);
    }
}

