/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.variable.mapping;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.BoundaryEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.EventBasedGatewayBuilder;
import io.camunda.zeebe.model.bpmn.builder.IntermediateCatchEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.ReceiveTaskBuilder;
import io.camunda.zeebe.model.bpmn.builder.StartEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.ZeebeVariablesMappingBuilder;
import io.camunda.zeebe.model.bpmn.instance.BoundaryEvent;
import io.camunda.zeebe.model.bpmn.instance.IntermediateCatchEvent;
import io.camunda.zeebe.model.bpmn.instance.ReceiveTask;
import io.camunda.zeebe.model.bpmn.instance.StartEvent;
import io.camunda.zeebe.model.bpmn.instance.SubProcess;
import io.camunda.zeebe.protocol.record.Assertions;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.intent.VariableIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.DeploymentRecordValue;
import io.camunda.zeebe.protocol.record.value.VariableRecordValue;
import io.camunda.zeebe.protocol.record.value.deployment.ProcessMetadataValue;
import io.camunda.zeebe.test.util.MsgPackUtil;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import java.util.UUID;
import java.util.function.Consumer;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public final class MessageCatchElementOutputMappingTest {
    @ClassRule
    public static final EngineRule ENGINE_RULE = EngineRule.singlePartition();
    private static final String PROCESS_ID = "process";
    private static final String MESSAGE_NAME = "message";
    private static final String CORRELATION_VARIABLE = "key";
    private static final String MAPPING_ELEMENT_ID = "catch";
    private static final BpmnModelInstance CATCH_EVENT_PROCESS = ((IntermediateCatchEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().intermediateCatchEvent("catch").message(m -> m.name(MESSAGE_NAME).zeebeCorrelationKeyExpression(CORRELATION_VARIABLE))).done();
    private static final BpmnModelInstance RECEIVE_TASK_PROCESS = ((ReceiveTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().receiveTask("catch").message(m -> m.name(MESSAGE_NAME).zeebeCorrelationKeyExpression(CORRELATION_VARIABLE))).done();
    private static final BpmnModelInstance INTERRUPTING_BOUNDARY_EVENT_PROCESS = ((BoundaryEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask("task", b -> b.zeebeJobType("type")).boundaryEvent("catch").message(m -> m.name(MESSAGE_NAME).zeebeCorrelationKeyExpression(CORRELATION_VARIABLE))).endEvent().done();
    private static final BpmnModelInstance NON_INTERRUPTING_BOUNDARY_EVENT_PROCESS = ((BoundaryEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask("task", b -> b.zeebeJobType("type")).boundaryEvent("catch", b -> b.cancelActivity(Boolean.valueOf(false))).message(m -> m.name(MESSAGE_NAME).zeebeCorrelationKeyExpression(CORRELATION_VARIABLE))).endEvent().done();
    private static final BpmnModelInstance EVENT_BASED_GATEWAY_PROCESS = ((IntermediateCatchEventBuilder)((IntermediateCatchEventBuilder)((EventBasedGatewayBuilder)Bpmn.createExecutableProcess((String)"process").startEvent("start").eventBasedGateway().id("gateway")).intermediateCatchEvent("catch", c -> c.message(m -> m.name(MESSAGE_NAME).zeebeCorrelationKeyExpression(CORRELATION_VARIABLE))).sequenceFlowId("to-end1")).endEvent("end1").moveToLastGateway().intermediateCatchEvent("timer", c -> c.timerWithDuration("PT10S")).sequenceFlowId("to-end2")).endEvent("end2").done();
    private static final BpmnModelInstance INTERRUPTING_EVENT_SUBPROCESS_PROCESS = Bpmn.createExecutableProcess((String)"process").eventSubProcess("event-subprocess", eventSubProcess -> ((StartEventBuilder)((StartEventBuilder)eventSubProcess.startEvent(MAPPING_ELEMENT_ID).message(m -> m.name(MESSAGE_NAME).zeebeCorrelationKeyExpression(CORRELATION_VARIABLE))).interrupting(true)).serviceTask("task-2", t -> t.zeebeJobType("type")).endEvent()).startEvent().serviceTask("task", t -> t.zeebeJobType("type")).endEvent().done();
    private static final BpmnModelInstance NON_INTERRUPTING_EVENT_SUBPROCESS_PROCESS = Bpmn.createExecutableProcess((String)"process").eventSubProcess("event-subprocess", eventSubProcess -> ((StartEventBuilder)((StartEventBuilder)eventSubProcess.startEvent(MAPPING_ELEMENT_ID).message(m -> m.name(MESSAGE_NAME).zeebeCorrelationKeyExpression(CORRELATION_VARIABLE))).interrupting(false)).serviceTask("task-2", t -> t.zeebeJobType("type")).endEvent()).startEvent().serviceTask("task", t -> t.zeebeJobType("type")).endEvent().done();
    private static final BpmnModelInstance INTERRUPTING_BOUNDARY_EVENT_ON_RECEIVE_TASK_PROCESS = ((BoundaryEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().receiveTask("task", t -> t.message(m -> m.name("other").zeebeCorrelationKeyExpression(CORRELATION_VARIABLE))).boundaryEvent("catch").message(m -> m.name(MESSAGE_NAME).zeebeCorrelationKeyExpression(CORRELATION_VARIABLE))).endEvent().done();
    private static final BpmnModelInstance NON_INTERRUPTING_BOUNDARY_EVENT_ON_RECEIVE_TASK_PROCESS = ((BoundaryEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().receiveTask("task", t -> t.message(m -> m.name("other").zeebeCorrelationKeyExpression(CORRELATION_VARIABLE))).boundaryEvent("catch", b -> b.cancelActivity(Boolean.valueOf(false))).message(m -> m.name(MESSAGE_NAME).zeebeCorrelationKeyExpression(CORRELATION_VARIABLE))).endEvent().done();
    private static final BpmnModelInstance MESSAGE_START_EVENT_PROCESS = ((StartEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent("catch").message(m -> m.name(MESSAGE_NAME).zeebeCorrelationKeyExpression(CORRELATION_VARIABLE))).endEvent().done();
    @Rule
    public final RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();
    @Parameterized.Parameter(value=0)
    public String elementType;
    @Parameterized.Parameter(value=1)
    public BpmnModelInstance process;
    @Parameterized.Parameter(value=2)
    public boolean createInstance;
    private String correlationKey;

    @Parameterized.Parameters(name="{0}")
    public static Object[][] parameters() {
        return new Object[][]{{"intermediate catch event", CATCH_EVENT_PROCESS, true}, {"receive task", RECEIVE_TASK_PROCESS, true}, {"event-based gateway", EVENT_BASED_GATEWAY_PROCESS, true}, {"interrupting boundary event", INTERRUPTING_BOUNDARY_EVENT_PROCESS, true}, {"non-interrupting boundary event", NON_INTERRUPTING_BOUNDARY_EVENT_PROCESS, true}, {"interrupting event subprocess", INTERRUPTING_EVENT_SUBPROCESS_PROCESS, true}, {"non-interrupting event subprocess", NON_INTERRUPTING_EVENT_SUBPROCESS_PROCESS, true}, {"interrupting boundary event on receive task", INTERRUPTING_BOUNDARY_EVENT_ON_RECEIVE_TASK_PROCESS, true}, {"non-interrupting boundary event on receive task", NON_INTERRUPTING_BOUNDARY_EVENT_ON_RECEIVE_TASK_PROCESS, true}, {"message start event", MESSAGE_START_EVENT_PROCESS, false}};
    }

    @Test
    public void shouldMergeMessageVariablesByDefault() {
        Record<DeploymentRecordValue> deploymentRecord = this.deployProcessWithMapping(e -> {});
        long processInstanceKey = this.triggerProcessInstance(deploymentRecord);
        Record variableEvent = (Record)RecordingExporter.variableRecords((VariableIntent)VariableIntent.CREATED).withScopeKey(processInstanceKey).withName("foo").getFirst();
        Assertions.assertThat((VariableRecordValue)((VariableRecordValue)variableEvent.getValue())).hasValue("\"bar\"").hasScopeKey(processInstanceKey);
    }

    @Test
    public void shouldMergeMessageVariables() {
        Record<DeploymentRecordValue> deploymentRecord = this.deployProcessWithMapping(e -> {});
        long processInstanceKey = this.triggerProcessInstance(deploymentRecord);
        Record variableEvent = (Record)RecordingExporter.variableRecords((VariableIntent)VariableIntent.CREATED).withScopeKey(processInstanceKey).withName("foo").getFirst();
        Assertions.assertThat((VariableRecordValue)((VariableRecordValue)variableEvent.getValue())).hasValue("\"bar\"").hasScopeKey(processInstanceKey);
    }

    @Test
    public void shouldMapMessageVariablesIntoInstanceVariables() {
        Record<DeploymentRecordValue> deploymentRecord = this.deployProcessWithMapping(e -> e.zeebeOutputExpression("foo", MESSAGE_NAME));
        long processInstanceKey = this.triggerProcessInstance(deploymentRecord);
        Record variableEvent = (Record)RecordingExporter.variableRecords((VariableIntent)VariableIntent.CREATED).withProcessInstanceKey(processInstanceKey).withName(MESSAGE_NAME).getFirst();
        Assertions.assertThat((VariableRecordValue)((VariableRecordValue)variableEvent.getValue())).hasValue("\"bar\"").hasScopeKey(processInstanceKey);
    }

    private Record<DeploymentRecordValue> deployProcessWithMapping(Consumer<ZeebeVariablesMappingBuilder<?>> c) {
        BpmnModelInstance modifiedProcess = this.process.clone();
        ModelElementInstance element = modifiedProcess.getModelElementById(MAPPING_ELEMENT_ID);
        if (element instanceof IntermediateCatchEvent) {
            c.accept((ZeebeVariablesMappingBuilder<?>)((IntermediateCatchEvent)element).builder());
        } else if (element instanceof StartEvent) {
            c.accept((ZeebeVariablesMappingBuilder<?>)((StartEvent)element).builder());
        } else if (element instanceof BoundaryEvent) {
            c.accept((ZeebeVariablesMappingBuilder<?>)((BoundaryEvent)element).builder());
        } else if (element instanceof SubProcess) {
            c.accept((ZeebeVariablesMappingBuilder<?>)((SubProcess)element).builder());
        } else {
            c.accept((ZeebeVariablesMappingBuilder<?>)((ReceiveTask)element).builder());
        }
        return ENGINE_RULE.deployment().withXmlResource(modifiedProcess).deploy();
    }

    private long triggerProcessInstance(Record<DeploymentRecordValue> deploymentRecord) {
        this.correlationKey = UUID.randomUUID().toString();
        ENGINE_RULE.message().withCorrelationKey(this.correlationKey).withName(MESSAGE_NAME).withVariables(MsgPackUtil.asMsgPack((String)"foo", (Object)"bar")).publish();
        if (this.createInstance) {
            return ENGINE_RULE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariable(CORRELATION_VARIABLE, this.correlationKey).create();
        }
        return ((Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATING).withProcessDefinitionKey(((ProcessMetadataValue)((DeploymentRecordValue)deploymentRecord.getValue()).getProcessesMetadata().get(0)).getProcessDefinitionKey()).withElementType(BpmnElementType.PROCESS).getFirst()).getKey();
    }
}

