/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.appliers;

import io.camunda.zeebe.engine.state.EventApplier;
import io.camunda.zeebe.engine.state.TypedEventApplier;
import io.camunda.zeebe.engine.state.appliers.EventAppliers;
import io.camunda.zeebe.engine.state.mutable.MutableProcessingState;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.intent.CompensationSubscriptionIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessIntent;
import io.camunda.zeebe.protocol.record.intent.management.CheckpointIntent;
import java.util.Arrays;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
public class EventAppliersTest {
    private EventAppliers eventAppliers;
    @Mock
    private TypedEventApplier<Intent, ? extends RecordValue> mockedApplier;
    @Mock
    private TypedEventApplier<Intent, ? extends RecordValue> anotherMockedApplier;

    @BeforeEach
    void setup() {
        this.eventAppliers = new EventAppliers();
    }

    @Test
    void shouldApplyStateUsingRegisteredApplier() {
        Intent intent = (Intent)Mockito.mock(Intent.class);
        Mockito.when((Object)intent.isEvent()).thenReturn((Object)true);
        this.eventAppliers.register(intent, 1, this.mockedApplier);
        this.eventAppliers.applyState(1L, intent, null, 1);
        ((TypedEventApplier)Mockito.verify(this.mockedApplier)).applyState(ArgumentMatchers.anyLong(), (RecordValue)ArgumentMatchers.any());
    }

    @Test
    void shouldNotApplyStateUsingUnregisteredApplier() {
        Assertions.assertThatExceptionOfType(EventApplier.NoSuchEventApplier.NoApplierForIntent.class).isThrownBy(() -> this.eventAppliers.applyState(1L, Intent.UNKNOWN, null, 1));
        ((TypedEventApplier)Mockito.verify(this.mockedApplier, (VerificationMode)Mockito.never())).applyState(ArgumentMatchers.anyLong(), (RecordValue)ArgumentMatchers.any());
    }

    @Test
    void shouldNotApplyStateUsingRegisteredApplierForOlderVersion() {
        Intent intent = (Intent)Mockito.mock(Intent.class);
        Mockito.when((Object)intent.isEvent()).thenReturn((Object)true);
        this.eventAppliers.register(intent, 1, this.mockedApplier);
        Assertions.assertThatExceptionOfType(EventApplier.NoSuchEventApplier.NoApplierForVersion.class).isThrownBy(() -> this.eventAppliers.applyState(1L, intent, null, 2));
        ((TypedEventApplier)Mockito.verify(this.mockedApplier, (VerificationMode)Mockito.never())).applyState(ArgumentMatchers.anyLong(), (RecordValue)ArgumentMatchers.any());
    }

    @Test
    void shouldApplyStateUsingRegisteredApplierForSpecificVersion() {
        Intent intent = (Intent)Mockito.mock(Intent.class);
        Mockito.when((Object)intent.isEvent()).thenReturn((Object)true);
        this.eventAppliers.register(intent, 1, this.mockedApplier);
        this.eventAppliers.register(intent, 2, this.anotherMockedApplier);
        this.eventAppliers.applyState(1L, intent, null, 2);
        ((TypedEventApplier)Mockito.verify(this.mockedApplier, (VerificationMode)Mockito.never())).applyState(ArgumentMatchers.anyLong(), (RecordValue)ArgumentMatchers.any());
        ((TypedEventApplier)Mockito.verify(this.anotherMockedApplier)).applyState(ArgumentMatchers.anyLong(), (RecordValue)ArgumentMatchers.any());
    }

    @Test
    void shouldGetLatestVersionOfOnlyRegisteredVersion() {
        Intent intent = (Intent)Mockito.mock(Intent.class);
        Mockito.when((Object)intent.isEvent()).thenReturn((Object)true);
        boolean expectedVersion = true;
        this.eventAppliers.register(intent, 1, this.mockedApplier);
        int actualVersion = this.eventAppliers.getLatestVersion(intent);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)actualVersion);
    }

    @Test
    void shouldGetLatestVersionOfTwoRegisteredVersions() {
        Intent intent = (Intent)Mockito.mock(Intent.class);
        Mockito.when((Object)intent.isEvent()).thenReturn((Object)true);
        int expectedVersion = 2;
        this.eventAppliers.register(intent, 1, this.mockedApplier);
        this.eventAppliers.register(intent, 2, this.mockedApplier);
        int actualVersion = this.eventAppliers.getLatestVersion(intent);
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)actualVersion);
    }

    @Test
    void shouldGetLatestVersionMinusOneWhenNoRegisteredVersion() {
        int expectedVersion = -1;
        int actualVersion = this.eventAppliers.getLatestVersion(Intent.UNKNOWN);
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)actualVersion);
    }

    @Test
    void shouldGetLatestVersionWhenMultipleRegisteredEventAppliersWithDifferentIntents() {
        Intent intent = (Intent)Mockito.mock(Intent.class);
        Mockito.when((Object)intent.isEvent()).thenReturn((Object)true);
        boolean expectedVersion = true;
        this.eventAppliers.register(intent, 1, this.mockedApplier);
        this.eventAppliers.register((Intent)ProcessIntent.CREATED, 1, this.mockedApplier);
        int actualVersion = this.eventAppliers.getLatestVersion(intent);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)actualVersion);
    }

    @Test
    void shouldRegisterApplierForAllIntents() {
        Stream<Intent> events = Intent.INTENT_CLASSES.stream().flatMap(c -> Arrays.stream((Intent[])c.getEnumConstants())).filter(Intent::isEvent).filter(intent -> !(intent instanceof CompensationSubscriptionIntent)).filter(intent -> !(intent instanceof CheckpointIntent));
        this.eventAppliers.registerEventAppliers((MutableProcessingState)Mockito.mock(MutableProcessingState.class));
        Assertions.assertThat(events).allSatisfy(intent -> ((AbstractIntegerAssert)Assertions.assertThat((int)this.eventAppliers.getLatestVersion(intent)).describedAs("Intent %s.%s has a registered event applier", new Object[]{intent.getClass().getSimpleName(), intent.name()})).isNotEqualTo(-1));
    }

    @Test
    void cannotRegisterNullApplier() {
        Intent intent = (Intent)Mockito.mock(Intent.class);
        Assertions.assertThatExceptionOfType(NullPointerException.class).isThrownBy(() -> this.eventAppliers.register(intent, 1, null));
    }

    @Test
    void cannotRegisterApplierForNullIntent() {
        Assertions.assertThatExceptionOfType(NullPointerException.class).isThrownBy(() -> this.eventAppliers.register(null, 1, this.mockedApplier));
    }

    @Test
    void cannotRegisterApplierForNegativeVersion() {
        Intent intent = (Intent)Mockito.mock(Intent.class);
        Assertions.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> this.eventAppliers.register(intent, -1, this.mockedApplier));
    }

    @Test
    void cannotRegisterApplierForNonEvent() {
        Intent nonEvent = (Intent)Mockito.mock(Intent.class);
        Mockito.when((Object)nonEvent.isEvent()).thenReturn((Object)false);
        Assertions.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> this.eventAppliers.register(nonEvent, 1, this.mockedApplier));
    }

    @Test
    void cannotOverrideApplierForSameIntentAndVersion() {
        Intent intent = (Intent)Mockito.mock(Intent.class);
        Mockito.when((Object)intent.isEvent()).thenReturn((Object)true);
        this.eventAppliers.register(intent, 1, this.mockedApplier);
        Assertions.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> this.eventAppliers.register(intent, 1, this.anotherMockedApplier));
    }

    @Test
    void shouldOnlyRegisterAppliersForEvents() {
        Stream<Intent> intents = Intent.INTENT_CLASSES.stream().flatMap(c -> Arrays.stream((Intent[])c.getEnumConstants())).filter(intent -> !(intent instanceof CheckpointIntent));
        this.eventAppliers.registerEventAppliers((MutableProcessingState)Mockito.mock(MutableProcessingState.class));
        Assertions.assertThat(intents).allSatisfy(intent -> {
            if (!intent.isEvent()) {
                ((AbstractIntegerAssert)Assertions.assertThat((int)this.eventAppliers.getLatestVersion(intent)).describedAs("Intent %s.%s is not an event but has a registered event applier", new Object[]{intent.getClass().getSimpleName(), intent.name()})).isEqualTo(-1);
            }
        });
    }
}

