/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.appliers;

import io.camunda.zeebe.engine.state.appliers.FormCreatedApplier;
import io.camunda.zeebe.engine.state.deployment.PersistedForm;
import io.camunda.zeebe.engine.state.mutable.MutableFormState;
import io.camunda.zeebe.engine.state.mutable.MutableProcessingState;
import io.camunda.zeebe.engine.util.ProcessingStateExtension;
import io.camunda.zeebe.protocol.impl.record.value.deployment.FormRecord;
import io.camunda.zeebe.stream.api.state.KeyGenerator;
import io.camunda.zeebe.test.util.Strings;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.Optional;
import java.util.function.Function;
import org.agrona.DirectBuffer;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ProcessingStateExtension.class})
public class FormCreatedApplierTest {
    private static final String TENANT_1 = "tenant1";
    private static final String TENANT_2 = "tenant2";
    private KeyGenerator keyGenerator;
    private MutableProcessingState processingState;
    private MutableFormState formState;
    private FormCreatedApplier formCreatedApplier;

    @BeforeEach
    public void setup() {
        this.formState = this.processingState.getFormState();
        this.formCreatedApplier = new FormCreatedApplier(this.formState);
        this.keyGenerator = this.processingState.getKeyGenerator();
    }

    @Test
    void shouldStoreForm() {
        FormRecord formRecord = this.sampleFormRecord();
        this.formCreatedApplier.applyState(formRecord.getFormKey(), formRecord);
        Optional maybePersistedForm = this.formState.findFormByKey(formRecord.getFormKey(), TENANT_1);
        Assertions.assertThat((Optional)maybePersistedForm).isNotEmpty();
        PersistedForm persistedForm = (PersistedForm)maybePersistedForm.get();
        Assertions.assertThat((String)BufferUtil.bufferAsString((DirectBuffer)persistedForm.getFormId())).isEqualTo(formRecord.getFormId());
        Assertions.assertThat((int)persistedForm.getVersion()).isEqualTo(formRecord.getVersion());
        Assertions.assertThat((long)persistedForm.getFormKey()).isEqualTo(formRecord.getFormKey());
        Assertions.assertThat((String)BufferUtil.bufferAsString((DirectBuffer)persistedForm.getResourceName())).isEqualTo(formRecord.getResourceName());
        Assertions.assertThat((byte[])BufferUtil.bufferAsArray((DirectBuffer)persistedForm.getChecksum())).isEqualTo((Object)formRecord.getChecksum());
        Assertions.assertThat((byte[])BufferUtil.bufferAsArray((DirectBuffer)persistedForm.getResource())).isEqualTo((Object)formRecord.getResource());
    }

    @Test
    void shouldFindLatestByFormId() {
        FormRecord formRecord1 = this.sampleFormRecord();
        this.formCreatedApplier.applyState(formRecord1.getFormKey(), formRecord1);
        FormRecord formRecord2 = this.sampleFormRecord(2L, "form-id", 2, TENANT_1);
        this.formCreatedApplier.applyState(formRecord2.getFormKey(), formRecord2);
        Optional maybePersistedForm = this.formState.findLatestFormById(formRecord1.getFormIdBuffer(), TENANT_1);
        Assertions.assertThat((Optional)maybePersistedForm).isNotEmpty();
        PersistedForm persistedForm = (PersistedForm)maybePersistedForm.get();
        Assertions.assertThat((String)BufferUtil.bufferAsString((DirectBuffer)persistedForm.getFormId())).isEqualTo(formRecord2.getFormId());
        Assertions.assertThat((int)persistedForm.getVersion()).isEqualTo(2);
        Assertions.assertThat((long)persistedForm.getFormKey()).isEqualTo(formRecord2.getFormKey());
        Assertions.assertThat((String)BufferUtil.bufferAsString((DirectBuffer)persistedForm.getResourceName())).isEqualTo(formRecord2.getResourceName());
        Assertions.assertThat((byte[])BufferUtil.bufferAsArray((DirectBuffer)persistedForm.getChecksum())).isEqualTo((Object)formRecord2.getChecksum());
        Assertions.assertThat((byte[])BufferUtil.bufferAsArray((DirectBuffer)persistedForm.getResource())).isEqualTo((Object)formRecord2.getResource());
    }

    @Test
    public void shouldPutFormForDifferentTenants() {
        long formKey = this.keyGenerator.nextKey();
        String formId = Strings.newRandomValidBpmnId();
        boolean version = true;
        FormRecord tenant1Form = this.sampleFormRecord(formKey, formId, 1, TENANT_1);
        FormRecord tenant2Form = this.sampleFormRecord(formKey, formId, 1, TENANT_2);
        this.formCreatedApplier.applyState(tenant1Form.getFormKey(), tenant1Form);
        this.formCreatedApplier.applyState(tenant2Form.getFormKey(), tenant2Form);
        PersistedForm form1 = (PersistedForm)this.formState.findFormByKey(formKey, TENANT_1).orElseThrow();
        PersistedForm form2 = (PersistedForm)this.formState.findFormByKey(formKey, TENANT_2).orElseThrow();
        this.assertPersistedForm(form1, formKey, formId, 1, TENANT_1);
        this.assertPersistedForm(form2, formKey, formId, 1, TENANT_2);
        form1 = (PersistedForm)this.formState.findLatestFormById(BufferUtil.wrapString((String)formId), TENANT_1).orElseThrow();
        form2 = (PersistedForm)this.formState.findLatestFormById(BufferUtil.wrapString((String)formId), TENANT_2).orElseThrow();
        this.assertPersistedForm(form1, formKey, formId, 1, TENANT_1);
        this.assertPersistedForm(form2, formKey, formId, 1, TENANT_2);
    }

    private FormRecord sampleFormRecord() {
        return this.sampleFormRecord(1L, "form-id", 1, TENANT_1);
    }

    private FormRecord sampleFormRecord(long key, String id, int version, String tenant) {
        return new FormRecord().setFormKey(key).setFormId(id).setVersion(version).setResourceName("resourceName").setResource(BufferUtil.wrapString((String)"resource")).setChecksum(BufferUtil.wrapString((String)"checksum")).setTenantId(tenant);
    }

    private void assertPersistedForm(PersistedForm persistedForm, long expectedKey, String expectedId, int expectedVersion, String expectedTenant) {
        Assertions.assertThat((Object)persistedForm).extracting(new Function[]{PersistedForm::getFormKey, form -> BufferUtil.bufferAsString((DirectBuffer)form.getFormId()), PersistedForm::getVersion, PersistedForm::getTenantId}).describedAs("Gets correct form for tenant", new Object[0]).containsExactly(new Object[]{expectedKey, expectedId, expectedVersion, expectedTenant});
    }
}

