/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.deployment;

import io.camunda.zeebe.engine.processing.deployment.model.element.AbstractFlowElement;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableProcess;
import io.camunda.zeebe.engine.state.deployment.DeployedProcess;
import io.camunda.zeebe.engine.state.deployment.PersistedProcess;
import io.camunda.zeebe.engine.state.mutable.MutableProcessState;
import io.camunda.zeebe.engine.state.mutable.MutableProcessingState;
import io.camunda.zeebe.engine.util.ProcessingStateRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.protocol.Protocol;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DeploymentRecord;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DeploymentResource;
import io.camunda.zeebe.protocol.impl.record.value.deployment.ProcessMetadata;
import io.camunda.zeebe.protocol.impl.record.value.deployment.ProcessRecord;
import io.camunda.zeebe.stream.api.state.KeyGenerator;
import io.camunda.zeebe.test.util.Strings;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.Optional;
import org.agrona.DirectBuffer;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public final class ProcessStateTest {
    private static final Long FIRST_PROCESS_KEY = Protocol.encodePartitionId((int)1, (long)1L);
    private static final String TENANT_ID = "defaultTenant";
    @Rule
    public final ProcessingStateRule stateRule = new ProcessingStateRule();
    private MutableProcessState processState;
    private MutableProcessingState processingState;

    @Before
    public void setUp() {
        this.processingState = this.stateRule.getProcessingState();
        this.processState = this.processingState.getProcessState();
    }

    @Test
    public void shouldGetInitialProcessVersion() {
        long nextProcessVersion = this.processState.getLatestProcessVersion("foo", TENANT_ID);
        Assertions.assertThat((long)nextProcessVersion).isZero();
    }

    @Test
    public void shouldGetProcessVersion() {
        ProcessRecord processRecord = ProcessStateTest.creatingProcessRecord(this.processingState);
        this.processState.putProcess(processRecord.getKey(), processRecord);
        long processVersion = this.processState.getLatestProcessVersion("processId", TENANT_ID);
        Assertions.assertThat((long)processVersion).isEqualTo(1L);
    }

    @Test
    public void shouldIncrementProcessVersion() {
        ProcessRecord processRecord = ProcessStateTest.creatingProcessRecord(this.processingState);
        this.processState.putProcess(processRecord.getKey(), processRecord);
        ProcessRecord processRecord2 = ProcessStateTest.creatingProcessRecord(this.processingState);
        this.processState.putProcess(processRecord2.getKey(), processRecord2);
        this.processState.putProcess(processRecord2.getKey(), processRecord2);
        long processVersion = this.processState.getLatestProcessVersion("processId", TENANT_ID);
        Assertions.assertThat((long)processVersion).isEqualTo(2L);
    }

    @Test
    public void shouldNotIncrementProcessVersionForDifferentProcessId() {
        ProcessRecord processRecord = ProcessStateTest.creatingProcessRecord(this.processingState);
        this.processState.putProcess(processRecord.getKey(), processRecord);
        ProcessRecord processRecord2 = ProcessStateTest.creatingProcessRecord(this.processingState, "other");
        this.processState.putProcess(processRecord2.getKey(), processRecord2);
        long processVersion = this.processState.getLatestProcessVersion("processId", TENANT_ID);
        Assertions.assertThat((long)processVersion).isEqualTo(1L);
        long otherversion = this.processState.getLatestProcessVersion("other", TENANT_ID);
        Assertions.assertThat((long)otherversion).isEqualTo(1L);
    }

    @Test
    public void shouldGetInitialNextProcessVersion() {
        long nextProcessVersion = this.processState.getNextProcessVersion("foo", TENANT_ID);
        Assertions.assertThat((long)nextProcessVersion).isEqualTo(1L);
    }

    @Test
    public void shouldGetNextProcessVersion() {
        ProcessRecord processRecord = ProcessStateTest.creatingProcessRecord(this.processingState);
        this.processState.putProcess(processRecord.getKey(), processRecord);
        long processVersion = this.processState.getNextProcessVersion("processId", TENANT_ID);
        Assertions.assertThat((long)processVersion).isEqualTo(2L);
    }

    @Test
    public void shouldIncrementNextProcessVersion() {
        ProcessRecord processRecord = ProcessStateTest.creatingProcessRecord(this.processingState);
        this.processState.putProcess(processRecord.getKey(), processRecord);
        ProcessRecord processRecord2 = ProcessStateTest.creatingProcessRecord(this.processingState);
        this.processState.putProcess(processRecord2.getKey(), processRecord2);
        long processVersion = this.processState.getNextProcessVersion("processId", TENANT_ID);
        Assertions.assertThat((long)processVersion).isEqualTo(3L);
    }

    @Test
    public void shouldNotIncrementOnNextProcessVersionOnDuplicate() {
        ProcessRecord processRecord = ProcessStateTest.creatingProcessRecord(this.processingState);
        this.processState.putProcess(processRecord.getKey(), processRecord);
        this.processState.putProcess(processRecord.getKey(), processRecord);
        long processVersion = this.processState.getNextProcessVersion("processId", TENANT_ID);
        Assertions.assertThat((long)processVersion).isEqualTo(2L);
    }

    @Test
    public void shouldFindPreviousProcessVersion() {
        ProcessRecord versionOneRecord = ProcessStateTest.creatingProcessRecord(this.processingState).setVersion(1);
        ProcessRecord versionTwoRecord = ProcessStateTest.creatingProcessRecord(this.processingState).setVersion(2);
        this.processState.putProcess(versionOneRecord.getKey(), versionOneRecord);
        this.processState.putProcess(versionTwoRecord.getKey(), versionTwoRecord);
        Optional processVersion = this.processState.findProcessVersionBefore("processId", 2L, TENANT_ID);
        Assertions.assertThat((Optional)processVersion).isNotEmpty();
        Assertions.assertThat((Integer)((Integer)processVersion.get())).isEqualTo(1);
    }

    @Test
    public void shouldReturnEmptyOptionalWhenFindingVersionWithoutPrevious() {
        ProcessRecord versionOneRecord = ProcessStateTest.creatingProcessRecord(this.processingState).setVersion(1);
        this.processState.putProcess(versionOneRecord.getKey(), versionOneRecord);
        Optional processVersion = this.processState.findProcessVersionBefore("processId", 1L, TENANT_ID);
        Assertions.assertThat((Optional)processVersion).isEmpty();
    }

    @Test
    public void shouldReturnEmptyOptionalWhenGivenVersionIsNotKnown() {
        ProcessRecord versionOneRecord = ProcessStateTest.creatingProcessRecord(this.processingState).setVersion(1);
        this.processState.putProcess(versionOneRecord.getKey(), versionOneRecord);
        Optional processVersion = this.processState.findProcessVersionBefore("processId", 2L, TENANT_ID);
        Assertions.assertThat((Optional)processVersion).isEmpty();
    }

    @Test
    public void shouldNotIncrementNextProcessVersionForDifferentProcessId() {
        ProcessRecord processRecord = ProcessStateTest.creatingProcessRecord(this.processingState);
        this.processState.putProcess(processRecord.getKey(), processRecord);
        ProcessRecord processRecord2 = ProcessStateTest.creatingProcessRecord(this.processingState, "other");
        this.processState.putProcess(processRecord2.getKey(), processRecord2);
        long processVersion = this.processState.getNextProcessVersion("processId", TENANT_ID);
        Assertions.assertThat((long)processVersion).isEqualTo(2L);
        long otherversion = this.processState.getNextProcessVersion("other", TENANT_ID);
        Assertions.assertThat((long)otherversion).isEqualTo(2L);
    }

    @Test
    public void shouldStoreVersionsInCacheSeparately() {
        ProcessRecord process1V1 = ProcessStateTest.creatingProcessRecord(this.processingState, "process1").setVersion(1);
        ProcessRecord process2V1 = ProcessStateTest.creatingProcessRecord(this.processingState, "process2").setVersion(1);
        ProcessRecord process2V2 = ProcessStateTest.creatingProcessRecord(this.processingState, "process2").setVersion(2);
        this.processState.putProcess(process1V1.getKey(), process1V1);
        this.processState.putProcess(process2V1.getKey(), process2V1);
        this.processState.putProcess(process2V2.getKey(), process2V2);
        this.processState.clearCache();
        this.processState.getNextProcessVersion("process1", TENANT_ID);
        this.processState.getNextProcessVersion("process2", TENANT_ID);
        Assertions.assertThat((int)this.processState.getNextProcessVersion("process1", TENANT_ID)).isEqualTo(2);
    }

    @Test
    public void shouldReturnNullOnGetLatest() {
        DeployedProcess deployedProcess = this.processState.getLatestProcessVersionByProcessId(BufferUtil.wrapString((String)"deployedProcess"), TENANT_ID);
        Assertions.assertThat((Object)deployedProcess).isNull();
    }

    @Test
    public void shouldReturnNullOnGetProcessByKey() {
        DeployedProcess deployedProcess = this.processState.getProcessByKeyAndTenant(0L, TENANT_ID);
        Assertions.assertThat((Object)deployedProcess).isNull();
    }

    @Test
    public void shouldReturnNullOnGetProcessByProcessIdAndVersion() {
        DeployedProcess deployedProcess = this.processState.getProcessByProcessIdAndVersion(BufferUtil.wrapString((String)"foo"), 0, TENANT_ID);
        Assertions.assertThat((Object)deployedProcess).isNull();
    }

    @Test
    public void shouldPutDeploymentToState() {
        DeploymentRecord deploymentRecord = ProcessStateTest.creatingDeploymentRecord(this.processingState);
        this.processState.putDeployment(deploymentRecord);
        DeployedProcess deployedProcess = this.processState.getProcessByProcessIdAndVersion(BufferUtil.wrapString((String)"processId"), 1, TENANT_ID);
        Assertions.assertThat((Object)deployedProcess).isNotNull();
    }

    @Test
    public void shouldPutProcessToState() {
        ProcessRecord processRecord = ProcessStateTest.creatingProcessRecord(this.processingState);
        this.processState.putProcess(processRecord.getKey(), processRecord);
        DeployedProcess deployedProcess = this.processState.getProcessByProcessIdAndVersion(BufferUtil.wrapString((String)"processId"), 1, TENANT_ID);
        Assertions.assertThat((Object)deployedProcess).isNotNull();
        Assertions.assertThat((Comparable)deployedProcess.getBpmnProcessId()).isEqualTo((Object)BufferUtil.wrapString((String)"processId"));
        Assertions.assertThat((int)deployedProcess.getVersion()).isEqualTo(1);
        Assertions.assertThat((long)deployedProcess.getKey()).isEqualTo(processRecord.getKey());
        Assertions.assertThat((Comparable)deployedProcess.getResource()).isEqualTo((Object)processRecord.getResourceBuffer());
        Assertions.assertThat((Comparable)deployedProcess.getResourceName()).isEqualTo((Object)processRecord.getResourceNameBuffer());
        DeployedProcess processByKey = this.processState.getProcessByKeyAndTenant(processRecord.getKey(), processRecord.getTenantId());
        Assertions.assertThat((Object)processByKey).isNotNull();
        Assertions.assertThat((Comparable)processByKey.getBpmnProcessId()).isEqualTo((Object)BufferUtil.wrapString((String)"processId"));
        Assertions.assertThat((int)processByKey.getVersion()).isEqualTo(1);
        Assertions.assertThat((long)processByKey.getKey()).isEqualTo(processRecord.getKey());
        Assertions.assertThat((Comparable)processByKey.getResource()).isEqualTo((Object)processRecord.getResourceBuffer());
        Assertions.assertThat((Comparable)processByKey.getResourceName()).isEqualTo((Object)processRecord.getResourceNameBuffer());
    }

    @Test
    public void shouldUpdateLatestDigestOnPutProcessToState() {
        ProcessRecord processRecord = ProcessStateTest.creatingProcessRecord(this.processingState);
        this.processState.putProcess(processRecord.getKey(), processRecord);
        DirectBuffer checksum = this.processState.getLatestVersionDigest(BufferUtil.wrapString((String)"processId"), TENANT_ID);
        Assertions.assertThat((Comparable)checksum).isEqualTo((Object)processRecord.getChecksumBuffer());
    }

    @Test
    public void shouldUpdateLatestProcessOnPutProcessToState() {
        ProcessRecord processRecord = ProcessStateTest.creatingProcessRecord(this.processingState);
        this.processState.putProcess(processRecord.getKey(), processRecord);
        DeployedProcess deployedProcess = this.processState.getLatestProcessVersionByProcessId(BufferUtil.wrapString((String)"processId"), TENANT_ID);
        Assertions.assertThat((Object)deployedProcess).isNotNull();
        Assertions.assertThat((Comparable)deployedProcess.getBpmnProcessId()).isEqualTo((Object)BufferUtil.wrapString((String)"processId"));
        Assertions.assertThat((int)deployedProcess.getVersion()).isEqualTo(1);
        Assertions.assertThat((long)deployedProcess.getKey()).isEqualTo(processRecord.getKey());
        Assertions.assertThat((Comparable)deployedProcess.getResource()).isEqualTo((Object)processRecord.getResourceBuffer());
        Assertions.assertThat((Comparable)deployedProcess.getResourceName()).isEqualTo((Object)processRecord.getResourceNameBuffer());
    }

    @Test
    public void shouldNotOverwritePreviousRecord() {
        DeploymentRecord deploymentRecord = ProcessStateTest.creatingDeploymentRecord(this.processingState);
        this.processState.putDeployment(deploymentRecord);
        ((ProcessMetadata)deploymentRecord.processesMetadata().iterator().next()).setKey(212L).setBpmnProcessId("other");
        DeployedProcess deployedProcess = this.processState.getProcessByProcessIdAndVersion(BufferUtil.wrapString((String)"processId"), 1, TENANT_ID);
        Assertions.assertThat((long)deployedProcess.getKey()).isNotEqualTo(((ProcessMetadata)deploymentRecord.processesMetadata().iterator().next()).getKey());
        Assertions.assertThat((Comparable)((ProcessMetadata)deploymentRecord.processesMetadata().iterator().next()).getBpmnProcessIdBuffer()).isEqualTo((Object)BufferUtil.wrapString((String)"other"));
        Assertions.assertThat((Comparable)deployedProcess.getBpmnProcessId()).isEqualTo((Object)BufferUtil.wrapString((String)"processId"));
    }

    @Test
    public void shouldStoreDifferentProcessVersionsOnPutDeployments() {
        this.processState.putDeployment(ProcessStateTest.creatingDeploymentRecord(this.processingState));
        this.processState.putDeployment(ProcessStateTest.creatingDeploymentRecord(this.processingState));
        DeployedProcess deployedProcess = this.processState.getProcessByProcessIdAndVersion(BufferUtil.wrapString((String)"processId"), 1, TENANT_ID);
        DeployedProcess secondProcess = this.processState.getProcessByProcessIdAndVersion(BufferUtil.wrapString((String)"processId"), 2, TENANT_ID);
        Assertions.assertThat((Object)deployedProcess).isNotNull();
        Assertions.assertThat((Object)secondProcess).isNotNull();
        Assertions.assertThat((Comparable)deployedProcess.getBpmnProcessId()).isEqualTo((Object)secondProcess.getBpmnProcessId());
        Assertions.assertThat((Comparable)deployedProcess.getResourceName()).isEqualTo((Object)secondProcess.getResourceName());
        Assertions.assertThat((long)deployedProcess.getKey()).isNotEqualTo(secondProcess.getKey());
        Assertions.assertThat((int)deployedProcess.getVersion()).isEqualTo(1);
        Assertions.assertThat((int)secondProcess.getVersion()).isEqualTo(2);
    }

    @Test
    public void shouldRestartVersionCountOnDifferentProcessId() {
        this.processState.putDeployment(ProcessStateTest.creatingDeploymentRecord(this.processingState));
        this.processState.putDeployment(ProcessStateTest.creatingDeploymentRecord(this.processingState, "otherId"));
        DeployedProcess deployedProcess = this.processState.getProcessByProcessIdAndVersion(BufferUtil.wrapString((String)"processId"), 1, TENANT_ID);
        DeployedProcess secondProcess = this.processState.getProcessByProcessIdAndVersion(BufferUtil.wrapString((String)"otherId"), 1, TENANT_ID);
        Assertions.assertThat((Object)deployedProcess).isNotNull();
        Assertions.assertThat((Object)secondProcess).isNotNull();
        Assertions.assertThat((long)deployedProcess.getKey()).isEqualTo((Object)FIRST_PROCESS_KEY);
        Assertions.assertThat((long)secondProcess.getKey()).isEqualTo(FIRST_PROCESS_KEY + 1L);
        Assertions.assertThat((int)deployedProcess.getVersion()).isEqualTo(1);
        Assertions.assertThat((int)secondProcess.getVersion()).isEqualTo(1);
    }

    @Test
    public void shouldGetLatestDeployedProcess() {
        this.processState.putDeployment(ProcessStateTest.creatingDeploymentRecord(this.processingState));
        this.processState.putDeployment(ProcessStateTest.creatingDeploymentRecord(this.processingState));
        DeployedProcess latestProcess = this.processState.getLatestProcessVersionByProcessId(BufferUtil.wrapString((String)"processId"), TENANT_ID);
        DeployedProcess firstProcess = this.processState.getProcessByProcessIdAndVersion(BufferUtil.wrapString((String)"processId"), 1, TENANT_ID);
        DeployedProcess secondProcess = this.processState.getProcessByProcessIdAndVersion(BufferUtil.wrapString((String)"processId"), 2, TENANT_ID);
        Assertions.assertThat((Object)latestProcess).isNotNull();
        Assertions.assertThat((Object)firstProcess).isNotNull();
        Assertions.assertThat((Object)secondProcess).isNotNull();
        Assertions.assertThat((Comparable)latestProcess.getBpmnProcessId()).isEqualTo((Object)secondProcess.getBpmnProcessId());
        Assertions.assertThat((long)firstProcess.getKey()).isNotEqualTo(latestProcess.getKey());
        Assertions.assertThat((long)latestProcess.getKey()).isEqualTo(secondProcess.getKey());
        Assertions.assertThat((Comparable)latestProcess.getResourceName()).isEqualTo((Object)secondProcess.getResourceName());
        Assertions.assertThat((Comparable)latestProcess.getResource()).isEqualTo((Object)secondProcess.getResource());
        Assertions.assertThat((int)firstProcess.getVersion()).isEqualTo(1);
        Assertions.assertThat((int)latestProcess.getVersion()).isEqualTo(2);
        Assertions.assertThat((int)secondProcess.getVersion()).isEqualTo(2);
    }

    @Test
    public void shouldGetLatestDeployedProcessAfterDeploymentWasAdded() {
        this.processState.putDeployment(ProcessStateTest.creatingDeploymentRecord(this.processingState));
        DeployedProcess firstLatest = this.processState.getLatestProcessVersionByProcessId(BufferUtil.wrapString((String)"processId"), TENANT_ID);
        this.processState.putDeployment(ProcessStateTest.creatingDeploymentRecord(this.processingState));
        DeployedProcess latestProcess = this.processState.getLatestProcessVersionByProcessId(BufferUtil.wrapString((String)"processId"), TENANT_ID);
        Assertions.assertThat((Object)firstLatest).isNotNull();
        Assertions.assertThat((Object)latestProcess).isNotNull();
        Assertions.assertThat((Comparable)firstLatest.getBpmnProcessId()).isEqualTo((Object)latestProcess.getBpmnProcessId());
        Assertions.assertThat((long)latestProcess.getKey()).isNotEqualTo(firstLatest.getKey());
        Assertions.assertThat((Comparable)firstLatest.getResourceName()).isEqualTo((Object)latestProcess.getResourceName());
        Assertions.assertThat((int)latestProcess.getVersion()).isEqualTo(2);
        Assertions.assertThat((int)firstLatest.getVersion()).isEqualTo(1);
    }

    @Test
    public void shouldGetExecutableProcess() {
        DeploymentRecord deploymentRecord = ProcessStateTest.creatingDeploymentRecord(this.processingState);
        this.processState.putDeployment(deploymentRecord);
        DeployedProcess deployedProcess = this.processState.getProcessByProcessIdAndVersion(BufferUtil.wrapString((String)"processId"), 1, TENANT_ID);
        ExecutableProcess process = deployedProcess.getProcess();
        Assertions.assertThat((Object)process).isNotNull();
        AbstractFlowElement serviceTask = process.getElementById(BufferUtil.wrapString((String)"test"));
        Assertions.assertThat((Object)serviceTask).isNotNull();
    }

    @Test
    public void shouldGetExecutableProcessByKey() {
        DeploymentRecord deploymentRecord = ProcessStateTest.creatingDeploymentRecord(this.processingState);
        this.processState.putDeployment(deploymentRecord);
        long processDefinitionKey = FIRST_PROCESS_KEY;
        DeployedProcess deployedProcess = this.processState.getProcessByKeyAndTenant(processDefinitionKey, deploymentRecord.getTenantId());
        ExecutableProcess process = deployedProcess.getProcess();
        Assertions.assertThat((Object)process).isNotNull();
        AbstractFlowElement serviceTask = process.getElementById(BufferUtil.wrapString((String)"test"));
        Assertions.assertThat((Object)serviceTask).isNotNull();
    }

    @Test
    public void shouldGetExecutableProcessByLatestProcess() {
        DeploymentRecord deploymentRecord = ProcessStateTest.creatingDeploymentRecord(this.processingState);
        this.processState.putDeployment(deploymentRecord);
        DeployedProcess deployedProcess = this.processState.getLatestProcessVersionByProcessId(BufferUtil.wrapString((String)"processId"), TENANT_ID);
        ExecutableProcess process = deployedProcess.getProcess();
        Assertions.assertThat((Object)process).isNotNull();
        AbstractFlowElement serviceTask = process.getElementById(BufferUtil.wrapString((String)"test"));
        Assertions.assertThat((Object)serviceTask).isNotNull();
    }

    @Test
    public void shouldReturnHighestVersionInsteadOfMostRecent() {
        String processId = "process";
        this.processState.putDeployment(ProcessStateTest.creatingDeploymentRecord(this.processingState, "process", 2));
        this.processState.putDeployment(ProcessStateTest.creatingDeploymentRecord(this.processingState, "process", 1));
        DeployedProcess latestProcess = this.processState.getLatestProcessVersionByProcessId(BufferUtil.wrapString((String)"process"), TENANT_ID);
        Assertions.assertThat((int)latestProcess.getVersion()).isEqualTo(2);
    }

    @Test
    public void shouldUpdateProcessState() {
        long processDefinitionKey = 100L;
        ProcessRecord processRecord = ProcessStateTest.creatingProcessRecord(this.processingState).setKey(100L);
        this.processState.putProcess(100L, processRecord);
        DeployedProcess initialProcess = this.processState.getProcessByKeyAndTenant(100L, processRecord.getTenantId());
        this.processState.updateProcessState(processRecord, PersistedProcess.PersistedProcessState.PENDING_DELETION);
        Assertions.assertThat((Comparable)initialProcess.getState()).isEqualTo((Object)PersistedProcess.PersistedProcessState.ACTIVE);
        DeployedProcess updatedProcess = this.processState.getProcessByKeyAndTenant(100L, processRecord.getTenantId());
        Assertions.assertThat((Comparable)updatedProcess.getState()).isEqualTo((Object)PersistedProcess.PersistedProcessState.PENDING_DELETION);
    }

    @Test
    public void shouldDeleteLatestProcess() {
        String processId = Strings.newRandomValidBpmnId();
        ProcessRecord processRecord = ProcessStateTest.creatingProcessRecord(this.processingState, processId, 1);
        long processDefinitionKey = processRecord.getProcessDefinitionKey();
        this.processState.putProcess(processDefinitionKey, processRecord);
        this.processState.deleteProcess(processRecord);
        Assertions.assertThat((Object)this.processState.getProcessByKeyAndTenant(processDefinitionKey, processRecord.getTenantId())).isNull();
        Assertions.assertThat((Object)this.processState.getLatestProcessVersionByProcessId(BufferUtil.wrapString((String)processId), TENANT_ID)).isNull();
        Assertions.assertThat((Object)this.processState.getProcessByProcessIdAndVersion(BufferUtil.wrapString((String)processId), 1, TENANT_ID)).isNull();
        Assertions.assertThat((Comparable)this.processState.getLatestVersionDigest(BufferUtil.wrapString((String)processId), TENANT_ID)).isNull();
        Assertions.assertThat((int)this.processState.getLatestProcessVersion(processId, TENANT_ID)).isEqualTo(0);
        Assertions.assertThat((int)this.processState.getNextProcessVersion(processId, TENANT_ID)).isEqualTo(2);
    }

    @Test
    public void shouldDeleteOldProcess() {
        String processId = Strings.newRandomValidBpmnId();
        ProcessRecord oldProcess = ProcessStateTest.creatingProcessRecord(this.processingState, processId, 1).setChecksum(BufferUtil.wrapString((String)"oldChecksum"));
        ProcessRecord newProcess = ProcessStateTest.creatingProcessRecord(this.processingState, processId, 2).setChecksum(BufferUtil.wrapString((String)"newChecksum"));
        long oldDefinitionKey = oldProcess.getProcessDefinitionKey();
        long newDefinitionKey = newProcess.getProcessDefinitionKey();
        this.processState.putProcess(oldDefinitionKey, oldProcess);
        this.processState.putProcess(newDefinitionKey, newProcess);
        this.processState.deleteProcess(oldProcess);
        Assertions.assertThat((Object)this.processState.getProcessByKeyAndTenant(oldDefinitionKey, oldProcess.getTenantId())).isNull();
        Assertions.assertThat((Object)this.processState.getLatestProcessVersionByProcessId(BufferUtil.wrapString((String)processId), TENANT_ID)).extracting(DeployedProcess::getKey).isEqualTo((Object)newDefinitionKey);
        Assertions.assertThat((Object)this.processState.getProcessByProcessIdAndVersion(BufferUtil.wrapString((String)processId), 1, TENANT_ID)).isNull();
        Assertions.assertThat((Object)this.processState.getProcessByProcessIdAndVersion(BufferUtil.wrapString((String)processId), 2, TENANT_ID)).isNotNull();
        Assertions.assertThat((Comparable)this.processState.getLatestVersionDigest(BufferUtil.wrapString((String)processId), TENANT_ID)).isEqualTo((Object)BufferUtil.wrapString((String)"newChecksum"));
        Assertions.assertThat((int)this.processState.getLatestProcessVersion(processId, TENANT_ID)).isEqualTo(2);
        Assertions.assertThat((int)this.processState.getNextProcessVersion(processId, TENANT_ID)).isEqualTo(3);
    }

    @Test
    public void shouldDeleteNewProcess() {
        String processId = "processId";
        ProcessRecord oldProcess = ProcessStateTest.creatingProcessRecord(this.processingState, "processId", 1).setChecksum(BufferUtil.wrapString((String)"oldChecksum"));
        ProcessRecord newProcess = ProcessStateTest.creatingProcessRecord(this.processingState, "processId", 2).setChecksum(BufferUtil.wrapString((String)"newChecksum"));
        long oldDefinitionKey = oldProcess.getProcessDefinitionKey();
        long newDefinitionKey = newProcess.getProcessDefinitionKey();
        this.processState.putProcess(oldDefinitionKey, oldProcess);
        this.processState.putProcess(newDefinitionKey, newProcess);
        this.processState.deleteProcess(newProcess);
        Assertions.assertThat((Object)this.processState.getProcessByKeyAndTenant(newDefinitionKey, newProcess.getTenantId())).isNull();
        Assertions.assertThat((Object)this.processState.getLatestProcessVersionByProcessId(BufferUtil.wrapString((String)"processId"), TENANT_ID)).extracting(DeployedProcess::getKey).isEqualTo((Object)oldDefinitionKey);
        Assertions.assertThat((Object)this.processState.getProcessByProcessIdAndVersion(BufferUtil.wrapString((String)"processId"), 1, TENANT_ID)).isNotNull();
        Assertions.assertThat((Object)this.processState.getProcessByProcessIdAndVersion(BufferUtil.wrapString((String)"processId"), 2, TENANT_ID)).isNull();
        Assertions.assertThat((Comparable)this.processState.getLatestVersionDigest(BufferUtil.wrapString((String)"processId"), TENANT_ID)).isNull();
        Assertions.assertThat((int)this.processState.getLatestProcessVersion("processId", TENANT_ID)).isEqualTo(1);
        Assertions.assertThat((int)this.processState.getNextProcessVersion("processId", TENANT_ID)).isEqualTo(3);
    }

    @Test
    public void shouldDeleteMidProcessBeforeLatestProcess() {
        String processId = "processId";
        ProcessRecord oldProcess = ProcessStateTest.creatingProcessRecord(this.processingState, "processId", 1).setChecksum(BufferUtil.wrapString((String)"oldChecksum"));
        ProcessRecord midProcess = ProcessStateTest.creatingProcessRecord(this.processingState, "processId", 2).setChecksum(BufferUtil.wrapString((String)"midChecksum"));
        ProcessRecord newProcess = ProcessStateTest.creatingProcessRecord(this.processingState, "processId", 3).setChecksum(BufferUtil.wrapString((String)"newChecksum"));
        long oldDefinitionKey = oldProcess.getProcessDefinitionKey();
        long midDefinitionKey = midProcess.getProcessDefinitionKey();
        long newDefinitionKey = newProcess.getProcessDefinitionKey();
        this.processState.putProcess(oldDefinitionKey, oldProcess);
        this.processState.putProcess(midDefinitionKey, midProcess);
        this.processState.putProcess(newDefinitionKey, newProcess);
        this.processState.deleteProcess(midProcess);
        this.processState.deleteProcess(newProcess);
        Assertions.assertThat((Object)this.processState.getProcessByKeyAndTenant(midDefinitionKey, midProcess.getTenantId())).isNull();
        Assertions.assertThat((Object)this.processState.getProcessByKeyAndTenant(newDefinitionKey, midProcess.getTenantId())).isNull();
        Assertions.assertThat((Object)this.processState.getLatestProcessVersionByProcessId(BufferUtil.wrapString((String)"processId"), TENANT_ID)).extracting(DeployedProcess::getKey).isEqualTo((Object)oldDefinitionKey);
        Assertions.assertThat((Object)this.processState.getProcessByProcessIdAndVersion(BufferUtil.wrapString((String)"processId"), 1, TENANT_ID)).isNotNull();
        Assertions.assertThat((Object)this.processState.getProcessByProcessIdAndVersion(BufferUtil.wrapString((String)"processId"), 2, TENANT_ID)).isNull();
        Assertions.assertThat((Object)this.processState.getProcessByProcessIdAndVersion(BufferUtil.wrapString((String)"processId"), 3, TENANT_ID)).isNull();
        Assertions.assertThat((Comparable)this.processState.getLatestVersionDigest(BufferUtil.wrapString((String)"processId"), TENANT_ID)).isNull();
        Assertions.assertThat((int)this.processState.getLatestProcessVersion("processId", TENANT_ID)).isEqualTo(1);
        Assertions.assertThat((int)this.processState.getNextProcessVersion("processId", TENANT_ID)).isEqualTo(4);
    }

    @Test
    public void shouldAddProcessAfterOnlyVersionIsDeleted() {
        String processId = Strings.newRandomValidBpmnId();
        ProcessRecord oldProcessRecord = ProcessStateTest.creatingProcessRecord(this.processingState, processId, 1);
        long oldProcessDefinitionKey = oldProcessRecord.getProcessDefinitionKey();
        ProcessRecord newProcessRecord = ProcessStateTest.creatingProcessRecord(this.processingState, processId, 2);
        long newProcessDefinitionKey = newProcessRecord.getProcessDefinitionKey();
        this.processState.putProcess(oldProcessDefinitionKey, oldProcessRecord);
        this.processState.deleteProcess(oldProcessRecord);
        this.processState.putProcess(newProcessDefinitionKey, newProcessRecord);
        DeployedProcess deployedProcess = this.processState.getProcessByProcessIdAndVersion(BufferUtil.wrapString((String)processId), 2, TENANT_ID);
        Assertions.assertThat((Object)deployedProcess).isNotNull();
        Assertions.assertThat((Comparable)deployedProcess.getBpmnProcessId()).isEqualTo((Object)BufferUtil.wrapString((String)processId));
        Assertions.assertThat((int)deployedProcess.getVersion()).isEqualTo(2);
        Assertions.assertThat((long)deployedProcess.getKey()).isEqualTo(newProcessDefinitionKey);
        Assertions.assertThat((Comparable)deployedProcess.getResource()).isEqualTo((Object)newProcessRecord.getResourceBuffer());
        Assertions.assertThat((Comparable)deployedProcess.getResourceName()).isEqualTo((Object)newProcessRecord.getResourceNameBuffer());
        DeployedProcess processByKey = this.processState.getProcessByKeyAndTenant(newProcessRecord.getKey(), newProcessRecord.getTenantId());
        Assertions.assertThat((Object)processByKey).isNotNull();
        Assertions.assertThat((Comparable)processByKey.getBpmnProcessId()).isEqualTo((Object)BufferUtil.wrapString((String)processId));
        Assertions.assertThat((int)processByKey.getVersion()).isEqualTo(2);
        Assertions.assertThat((long)processByKey.getKey()).isEqualTo(newProcessDefinitionKey);
        Assertions.assertThat((Comparable)processByKey.getResource()).isEqualTo((Object)newProcessRecord.getResourceBuffer());
        Assertions.assertThat((Comparable)processByKey.getResourceName()).isEqualTo((Object)newProcessRecord.getResourceNameBuffer());
        Assertions.assertThat((int)this.processState.getLatestProcessVersion(processId, TENANT_ID)).isEqualTo(2);
        Assertions.assertThat((int)this.processState.getNextProcessVersion(processId, TENANT_ID)).isEqualTo(3);
    }

    public static DeploymentRecord creatingDeploymentRecord(MutableProcessingState processingState) {
        return ProcessStateTest.creatingDeploymentRecord(processingState, "processId");
    }

    public static DeploymentRecord creatingDeploymentRecord(MutableProcessingState processingState, String processId) {
        MutableProcessState processState = processingState.getProcessState();
        int version = processState.getNextProcessVersion(processId, TENANT_ID);
        return ProcessStateTest.creatingDeploymentRecord(processingState, processId, version);
    }

    public static DeploymentRecord creatingDeploymentRecord(MutableProcessingState processingState, String processId, int version) {
        BpmnModelInstance modelInstance = Bpmn.createExecutableProcess((String)processId).startEvent().serviceTask("test", task -> task.zeebeJobType("type")).endEvent().done();
        DeploymentRecord deploymentRecord = new DeploymentRecord();
        String resourceName = "process.bpmn";
        DirectBuffer resource = BufferUtil.wrapString((String)Bpmn.convertToString((BpmnModelInstance)modelInstance));
        DirectBuffer checksum = BufferUtil.wrapString((String)"checksum");
        ((DeploymentResource)deploymentRecord.setTenantId(TENANT_ID).resources().add()).setResourceName(BufferUtil.wrapString((String)"process.bpmn")).setResource(resource);
        KeyGenerator keyGenerator = processingState.getKeyGenerator();
        long key = keyGenerator.nextKey();
        ((ProcessMetadata)deploymentRecord.processesMetadata().add()).setBpmnProcessId(BufferUtil.wrapString((String)processId)).setVersion(version).setKey(key).setResourceName("process.bpmn").setChecksum(checksum).setTenantId(TENANT_ID);
        return deploymentRecord;
    }

    public static ProcessRecord creatingProcessRecord(MutableProcessingState processingState) {
        return ProcessStateTest.creatingProcessRecord(processingState, "processId");
    }

    public static ProcessRecord creatingProcessRecord(MutableProcessingState processingState, String processId) {
        MutableProcessState processState = processingState.getProcessState();
        int version = processState.getNextProcessVersion(processId, TENANT_ID);
        return ProcessStateTest.creatingProcessRecord(processingState, processId, version);
    }

    public static ProcessRecord creatingProcessRecord(MutableProcessingState processingState, String processId, int version) {
        BpmnModelInstance modelInstance = Bpmn.createExecutableProcess((String)processId).startEvent("startEvent").serviceTask("test", task -> task.zeebeJobType("type")).endEvent("endEvent").done();
        ProcessRecord processRecord = new ProcessRecord();
        String resourceName = "process.bpmn";
        DirectBuffer resource = BufferUtil.wrapString((String)Bpmn.convertToString((BpmnModelInstance)modelInstance));
        DirectBuffer checksum = BufferUtil.wrapString((String)"checksum");
        KeyGenerator keyGenerator = processingState.getKeyGenerator();
        long key = keyGenerator.nextKey();
        processRecord.setResourceName(BufferUtil.wrapString((String)"process.bpmn")).setResource(resource).setBpmnProcessId(BufferUtil.wrapString((String)processId)).setVersion(version).setKey(key).setResourceName("process.bpmn").setChecksum(checksum).setTenantId(TENANT_ID);
        return processRecord;
    }
}

