/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.instance;

import io.camunda.zeebe.engine.state.mutable.MutableBannedInstanceState;
import io.camunda.zeebe.engine.state.mutable.MutableProcessingState;
import io.camunda.zeebe.engine.util.ProcessingStateExtension;
import io.camunda.zeebe.logstreams.log.LoggedEvent;
import io.camunda.zeebe.protocol.impl.record.RecordMetadata;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.stream.api.records.TypedRecord;
import io.camunda.zeebe.stream.impl.records.TypedRecordImpl;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={ProcessingStateExtension.class})
public final class BannedInstanceStateTest {
    private MutableProcessingState processingState;
    private MutableBannedInstanceState bannedInstanceState;

    @BeforeEach
    public void setup() {
        this.bannedInstanceState = this.processingState.getBannedInstanceState();
    }

    @Test
    public void shouldBanInstanceWithKey() {
        TypedRecordImpl processInstanceRecord = this.createRecord();
        this.bannedInstanceState.banProcessInstance(1000L);
        Assertions.assertThat((boolean)this.bannedInstanceState.isBanned((TypedRecord)processInstanceRecord)).isTrue();
    }

    @Test
    public void shouldBanInstanceWithRecord() {
        TypedRecordImpl processInstanceRecord = this.createRecord();
        this.bannedInstanceState.tryToBanInstance((TypedRecord)processInstanceRecord, pi -> {});
        Assertions.assertThat((boolean)this.bannedInstanceState.isBanned((TypedRecord)processInstanceRecord)).isTrue();
    }

    @Test
    public void shouldReturnFalseIfNotBanned() {
        TypedRecordImpl processInstanceRecord = this.createRecord();
        Assertions.assertThat((boolean)this.bannedInstanceState.isBanned((TypedRecord)processInstanceRecord)).isFalse();
    }

    @Test
    public void shouldCallCallbackIfBanned() {
        TypedRecordImpl processInstanceRecord = this.createRecord();
        Consumer consumer = (Consumer)Mockito.mock(Consumer.class);
        this.bannedInstanceState.tryToBanInstance((TypedRecord)processInstanceRecord, consumer);
        Assertions.assertThat((boolean)this.bannedInstanceState.isBanned((TypedRecord)processInstanceRecord)).isTrue();
        ((Consumer)Mockito.verify((Object)consumer, (VerificationMode)Mockito.times((int)1))).accept(1000L);
    }

    @Test
    public void shouldNotCallCallbackIfNotProcessInstanceIntent() {
        ProcessInstanceRecord processInstanceRecord = new ProcessInstanceRecord();
        processInstanceRecord.setElementId("PI");
        processInstanceRecord.setBpmnProcessId(BufferUtil.wrapString((String)"process1"));
        processInstanceRecord.setProcessInstanceKey(1000L);
        processInstanceRecord.setVersion(1);
        processInstanceRecord.setProcessDefinitionKey(2L);
        processInstanceRecord.setBpmnElementType(BpmnElementType.START_EVENT);
        RecordMetadata metadata = new RecordMetadata();
        metadata.intent((Intent)ProcessInstanceIntent.CANCEL);
        metadata.valueType(ValueType.PROCESS_INSTANCE);
        TypedRecordImpl typedEvent = new TypedRecordImpl(1);
        LoggedEvent loggedEvent = (LoggedEvent)Mockito.mock(LoggedEvent.class);
        Mockito.when((Object)loggedEvent.getPosition()).thenReturn((Object)1024L);
        typedEvent.wrap(loggedEvent, metadata, (UnifiedRecordValue)processInstanceRecord);
        Consumer consumer = (Consumer)Mockito.mock(Consumer.class);
        this.bannedInstanceState.tryToBanInstance((TypedRecord)typedEvent, consumer);
        Assertions.assertThat((boolean)this.bannedInstanceState.isBanned((TypedRecord)typedEvent)).isFalse();
        ((Consumer)Mockito.verify((Object)consumer, (VerificationMode)Mockito.never())).accept(1000L);
    }

    @Test
    public void shouldReturnFalseIfDifferentInstanceIsBanned() {
        TypedRecordImpl processInstanceRecord = this.createRecord();
        TypedRecordImpl differentProcessInstanceRecord = this.createRecord(1001L);
        this.bannedInstanceState.tryToBanInstance((TypedRecord)processInstanceRecord, pi -> {});
        Assertions.assertThat((boolean)this.bannedInstanceState.isBanned((TypedRecord)processInstanceRecord)).isTrue();
        Assertions.assertThat((boolean)this.bannedInstanceState.isBanned((TypedRecord)differentProcessInstanceRecord)).isFalse();
    }

    private TypedRecordImpl createRecord() {
        return this.createRecord(1000L);
    }

    private TypedRecordImpl createRecord(long processInstanceKey) {
        ProcessInstanceRecord processInstanceRecord = new ProcessInstanceRecord();
        processInstanceRecord.setElementId("startEvent");
        processInstanceRecord.setBpmnProcessId(BufferUtil.wrapString((String)"process1"));
        processInstanceRecord.setProcessInstanceKey(processInstanceKey);
        processInstanceRecord.setFlowScopeKey(1001L);
        processInstanceRecord.setVersion(1);
        processInstanceRecord.setProcessDefinitionKey(2L);
        processInstanceRecord.setBpmnElementType(BpmnElementType.START_EVENT);
        RecordMetadata metadata = new RecordMetadata();
        metadata.intent((Intent)ProcessInstanceIntent.ACTIVATE_ELEMENT);
        metadata.valueType(ValueType.PROCESS_INSTANCE);
        TypedRecordImpl typedEvent = new TypedRecordImpl(1);
        LoggedEvent loggedEvent = (LoggedEvent)Mockito.mock(LoggedEvent.class);
        Mockito.when((Object)loggedEvent.getPosition()).thenReturn((Object)1024L);
        typedEvent.wrap(loggedEvent, metadata, (UnifiedRecordValue)processInstanceRecord);
        return typedEvent;
    }
}

