/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.instance;

import io.camunda.zeebe.engine.state.instance.ElementInstance;
import io.camunda.zeebe.engine.state.mutable.MutableElementInstanceState;
import io.camunda.zeebe.engine.state.mutable.MutableIncidentState;
import io.camunda.zeebe.engine.state.mutable.MutableJobState;
import io.camunda.zeebe.engine.state.mutable.MutableProcessingState;
import io.camunda.zeebe.engine.util.ProcessingStateRule;
import io.camunda.zeebe.protocol.impl.record.value.incident.IncidentRecord;
import io.camunda.zeebe.protocol.impl.record.value.job.JobRecord;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.ErrorType;
import io.camunda.zeebe.util.buffer.BufferUtil;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public final class IncidentStateTest {
    @Rule
    public final ProcessingStateRule stateRule = new ProcessingStateRule();
    private MutableIncidentState incidentState;
    private MutableElementInstanceState elementInstanceState;
    private MutableJobState jobState;
    private MutableProcessingState processingState;

    @Before
    public void setUp() {
        this.processingState = this.stateRule.getProcessingState();
        this.elementInstanceState = this.processingState.getElementInstanceState();
        this.jobState = this.processingState.getJobState();
        this.incidentState = this.processingState.getIncidentState();
    }

    @Test
    public void shouldCreateProcessIncident() {
        IncidentRecord expectedRecord = this.createProcessInstanceIncident();
        this.incidentState.createIncident(5000L, expectedRecord);
        IncidentRecord storedRecord = this.incidentState.getIncidentRecord(5000L);
        this.assertIncident(expectedRecord, storedRecord);
    }

    @Test
    public void shouldFindIncidentByElementInstanceKey() {
        IncidentRecord expectedRecord = this.createProcessInstanceIncident();
        this.incidentState.createIncident(5000L, expectedRecord);
        long processInstanceIncidentKey = this.incidentState.getProcessInstanceIncidentKey(1234L);
        Assertions.assertThat((long)processInstanceIncidentKey).isEqualTo(5000L);
        IncidentRecord storedRecord = this.incidentState.getIncidentRecord(processInstanceIncidentKey);
        this.assertIncident(expectedRecord, storedRecord);
    }

    @Test
    public void shouldNotFindIncidentByElementInstanceKey() {
        IncidentRecord expectedRecord = this.createJobIncident();
        this.incidentState.createIncident(5000L, expectedRecord);
        long processInstanceIncidentKey = this.incidentState.getProcessInstanceIncidentKey(1234L);
        Assertions.assertThat((long)processInstanceIncidentKey).isEqualTo(-1L);
    }

    @Test
    public void shouldDeleteProcessInstanceIncident() {
        IncidentRecord expectedRecord = this.createProcessInstanceIncident();
        this.incidentState.createIncident(5000L, expectedRecord);
        this.incidentState.deleteIncident(5000L);
        IncidentRecord incidentRecord = this.incidentState.getIncidentRecord(5000L);
        Assertions.assertThat((Object)incidentRecord).isNull();
        long processInstanceIncidentKey = this.incidentState.getProcessInstanceIncidentKey(1234L);
        Assertions.assertThat((long)processInstanceIncidentKey).isEqualTo(-1L);
    }

    @Test
    public void shouldCreateJobIncident() {
        IncidentRecord expectedRecord = this.createJobIncident();
        this.incidentState.createIncident(5000L, expectedRecord);
        IncidentRecord storedRecord = this.incidentState.getIncidentRecord(5000L);
        this.assertIncident(expectedRecord, storedRecord);
    }

    @Test
    public void shouldFindIncidentByJobKey() {
        IncidentRecord expectedRecord = this.createJobIncident();
        this.incidentState.createIncident(5000L, expectedRecord);
        long jobIncidentKey = this.incidentState.getJobIncidentKey(1234L);
        Assertions.assertThat((long)jobIncidentKey).isEqualTo(5000L);
        IncidentRecord storedRecord = this.incidentState.getIncidentRecord(jobIncidentKey);
        this.assertIncident(expectedRecord, storedRecord);
    }

    @Test
    public void shouldNotFindIncidentByJobKey() {
        IncidentRecord expectedRecord = this.createProcessInstanceIncident();
        this.incidentState.createIncident(5000L, expectedRecord);
        long jobIncidentKey = this.incidentState.getJobIncidentKey(1234L);
        Assertions.assertThat((long)jobIncidentKey).isEqualTo(-1L);
    }

    @Test
    public void shouldDeleteJobIncident() {
        IncidentRecord expectedRecord = this.createJobIncident();
        this.incidentState.createIncident(5000L, expectedRecord);
        this.incidentState.deleteIncident(5000L);
        IncidentRecord incidentRecord = this.incidentState.getIncidentRecord(5000L);
        Assertions.assertThat((Object)incidentRecord).isNull();
        long jobIncidentKey = this.incidentState.getJobIncidentKey(1234L);
        Assertions.assertThat((long)jobIncidentKey).isEqualTo(-1L);
    }

    @Test
    public void shouldNotOverwritePreviousRecord() {
        long key = 1L;
        IncidentRecord writtenRecord = this.createJobIncident();
        this.incidentState.createIncident(1L, writtenRecord);
        writtenRecord.setJobKey(2048L);
        IncidentRecord readRecord = this.incidentState.getIncidentRecord(1L);
        Assertions.assertThat((long)readRecord.getJobKey()).isNotEqualTo(writtenRecord.getJobKey()).isEqualTo(1234L);
        Assertions.assertThat((long)writtenRecord.getJobKey()).isEqualTo(2048L);
    }

    public IncidentRecord createJobIncident() {
        this.jobState.create(1234L, new JobRecord().setType("test"));
        IncidentRecord expectedRecord = new IncidentRecord();
        expectedRecord.setJobKey(1234L);
        expectedRecord.setErrorMessage("Error because of error");
        expectedRecord.setErrorType(ErrorType.EXTRACT_VALUE_ERROR);
        return expectedRecord;
    }

    public IncidentRecord createProcessInstanceIncident() {
        this.elementInstanceState.createInstance(new ElementInstance(1234L, ProcessInstanceIntent.ELEMENT_ACTIVATED, new ProcessInstanceRecord()));
        IncidentRecord expectedRecord = new IncidentRecord();
        expectedRecord.setElementInstanceKey(1234L);
        expectedRecord.setBpmnProcessId(BufferUtil.wrapString((String)"process"));
        expectedRecord.setElementId(BufferUtil.wrapString((String)"process"));
        expectedRecord.setProcessInstanceKey(4321L);
        expectedRecord.setErrorMessage("Error because of error");
        expectedRecord.setErrorType(ErrorType.EXTRACT_VALUE_ERROR);
        return expectedRecord;
    }

    public void assertIncident(IncidentRecord expectedRecord, IncidentRecord storedRecord) {
        Assertions.assertThat((long)expectedRecord.getJobKey()).isEqualTo(storedRecord.getJobKey());
        Assertions.assertThat((long)expectedRecord.getElementInstanceKey()).isEqualTo(storedRecord.getElementInstanceKey());
        Assertions.assertThat((Comparable)expectedRecord.getBpmnProcessIdBuffer()).isEqualTo((Object)storedRecord.getBpmnProcessIdBuffer());
        Assertions.assertThat((Comparable)expectedRecord.getElementIdBuffer()).isEqualTo((Object)storedRecord.getElementIdBuffer());
        Assertions.assertThat((Comparable)expectedRecord.getErrorMessageBuffer()).isEqualTo((Object)storedRecord.getErrorMessageBuffer());
        Assertions.assertThat((Comparable)expectedRecord.getErrorType()).isEqualTo((Object)storedRecord.getErrorType());
        Assertions.assertThat((String)expectedRecord.getTenantId()).isEqualTo(storedRecord.getTenantId());
    }
}

