/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.message;

import io.camunda.zeebe.engine.state.immutable.PendingMessageSubscriptionState;
import io.camunda.zeebe.engine.state.message.MessageSubscription;
import io.camunda.zeebe.engine.state.mutable.MutableMessageSubscriptionState;
import io.camunda.zeebe.engine.state.mutable.MutableProcessingState;
import io.camunda.zeebe.engine.util.ProcessingStateRule;
import io.camunda.zeebe.protocol.impl.record.value.message.MessageSubscriptionRecord;
import io.camunda.zeebe.test.util.MsgPackUtil;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.ArrayList;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public final class PendingMessageSubscriptionStateTest {
    private static final String DEFAULT_TENANT = "<default>";
    @Rule
    public final ProcessingStateRule stateRule = new ProcessingStateRule();
    private MutableMessageSubscriptionState persistentState;
    private PendingMessageSubscriptionState transientState;

    @Before
    public void setUp() {
        MutableProcessingState processingState = this.stateRule.getProcessingState();
        this.persistentState = processingState.getMessageSubscriptionState();
        this.transientState = processingState.getPendingMessageSubscriptionState();
    }

    @Test
    public void shouldNoVisitMessageSubscriptionBeforeTime() {
        MessageSubscriptionRecord subscription1 = this.subscriptionWithElementInstanceKey(1L);
        this.persistentState.put(1L, subscription1);
        this.persistentState.updateToCorrelatingState(subscription1);
        this.transientState.onSent(subscription1, 1000L);
        MessageSubscriptionRecord subscription2 = this.subscriptionWithElementInstanceKey(2L);
        this.persistentState.put(2L, subscription2);
        this.persistentState.updateToCorrelatingState(subscription2);
        this.transientState.onSent(subscription2, 3000L);
        ArrayList keys = new ArrayList();
        this.transientState.visitPending(1000L, s -> keys.add(s.getRecord().getElementInstanceKey()));
        Assertions.assertThat(keys).isEmpty();
    }

    @Test
    public void shouldVisitMessageSubscriptionBeforeTime() {
        MessageSubscriptionRecord subscription1 = this.subscriptionWithElementInstanceKey(1L);
        this.persistentState.put(1L, subscription1);
        this.persistentState.updateToCorrelatingState(subscription1);
        this.transientState.onSent(subscription1, 1000L);
        MessageSubscriptionRecord subscription2 = this.subscriptionWithElementInstanceKey(2L);
        this.persistentState.put(2L, subscription2);
        this.persistentState.updateToCorrelatingState(subscription2);
        this.transientState.onSent(subscription2, 3000L);
        ArrayList keys = new ArrayList();
        this.transientState.visitPending(2000L, s -> keys.add(s.getRecord().getElementInstanceKey()));
        ((ListAssert)Assertions.assertThat(keys).hasSize(1)).contains((Object[])new Long[]{1L});
    }

    @Test
    public void shouldFindMessageSubscriptionBeforeTimeInOrder() {
        MessageSubscriptionRecord subscription1 = this.subscriptionWithElementInstanceKey(1L);
        this.persistentState.put(1L, subscription1);
        this.persistentState.updateToCorrelatingState(subscription1);
        this.transientState.onSent(subscription1, 1000L);
        MessageSubscriptionRecord subscription2 = this.subscriptionWithElementInstanceKey(2L);
        this.persistentState.put(2L, subscription2);
        this.persistentState.updateToCorrelatingState(subscription2);
        this.transientState.onSent(subscription2, 2000L);
        ArrayList keys = new ArrayList();
        this.transientState.visitPending(3000L, s -> keys.add(s.getRecord().getElementInstanceKey()));
        ((ListAssert)Assertions.assertThat(keys).hasSize(2)).containsExactly((Object[])new Long[]{1L, 2L});
    }

    @Test
    public void shouldNotVisitMessageSubscriptionIfSentTimeNotSet() {
        MessageSubscriptionRecord subscription1 = this.subscriptionWithElementInstanceKey(1L);
        this.persistentState.put(1L, subscription1);
        this.persistentState.updateToCorrelatingState(subscription1);
        this.transientState.onSent(subscription1, 1000L);
        MessageSubscriptionRecord subscription2 = this.subscriptionWithElementInstanceKey(2L);
        this.persistentState.put(2L, subscription2);
        ArrayList keys = new ArrayList();
        this.transientState.visitPending(2000L, s -> keys.add(s.getRecord().getElementInstanceKey()));
        ((ListAssert)Assertions.assertThat(keys).hasSize(1)).contains((Object[])new Long[]{1L});
    }

    @Test
    public void shouldUpdateMessageSubscriptionSentTime() {
        MessageSubscriptionRecord record = this.subscriptionWithElementInstanceKey(1L);
        this.persistentState.put(1L, record);
        MessageSubscription subscription = this.persistentState.get(record.getElementInstanceKey(), record.getMessageNameBuffer());
        this.persistentState.updateToCorrelatingState(subscription.getRecord());
        this.transientState.onSent(subscription.getRecord(), 1000L);
        ArrayList keys = new ArrayList();
        this.transientState.visitPending(2000L, s -> keys.add(s.getRecord().getElementInstanceKey()));
        ((ListAssert)Assertions.assertThat(keys).hasSize(1)).contains((Object[])new Long[]{1L});
        this.transientState.onSent(subscription.getRecord(), 1500L);
        keys.clear();
        this.transientState.visitPending(2000L, s -> keys.add(s.getRecord().getElementInstanceKey()));
        ((ListAssert)Assertions.assertThat(keys).hasSize(1)).contains((Object[])new Long[]{1L});
    }

    @Test
    public void shouldUpdateCorrelationState() {
        MessageSubscriptionRecord subscription = this.subscriptionWithElementInstanceKey(1L);
        this.persistentState.put(1L, subscription);
        Assertions.assertThat((boolean)this.persistentState.get(subscription.getElementInstanceKey(), subscription.getMessageNameBuffer()).isCorrelating()).isFalse();
        subscription.setVariables(MsgPackUtil.asMsgPack((String)"{\"foo\":\"bar\"}")).setMessageKey(5L);
        this.persistentState.updateToCorrelatingState(subscription);
        this.transientState.onSent(subscription, 1000L);
        Assertions.assertThat((boolean)this.persistentState.get(subscription.getElementInstanceKey(), subscription.getMessageNameBuffer()).isCorrelating()).isTrue();
        ArrayList subscriptions = new ArrayList();
        this.persistentState.visitSubscriptions(DEFAULT_TENANT, subscription.getMessageNameBuffer(), subscription.getCorrelationKeyBuffer(), subscriptions::add);
        Assertions.assertThat(subscriptions).hasSize(1);
        Assertions.assertThat((Map)((MessageSubscription)subscriptions.get(0)).getRecord().getVariables()).isEqualTo((Object)subscription.getVariables());
        Assertions.assertThat((long)((MessageSubscription)subscriptions.get(0)).getRecord().getMessageKey()).isEqualTo(subscription.getMessageKey());
        ArrayList keys = new ArrayList();
        this.transientState.visitPending(2000L, s -> keys.add(s.getRecord().getElementInstanceKey()));
        ((ListAssert)Assertions.assertThat(keys).hasSize(1)).contains((Object[])new Long[]{1L});
    }

    @Test
    public void shouldRemoveSubscription() {
        MessageSubscriptionRecord subscription = this.subscriptionWithElementInstanceKey(1L);
        this.persistentState.put(1L, subscription);
        this.persistentState.updateToCorrelatingState(subscription);
        this.transientState.onSent(subscription, 1000L);
        this.persistentState.remove(1L, subscription.getMessageNameBuffer());
        ArrayList keys = new ArrayList();
        this.persistentState.visitSubscriptions(DEFAULT_TENANT, subscription.getMessageNameBuffer(), subscription.getCorrelationKeyBuffer(), s -> keys.add(s.getRecord().getElementInstanceKey()));
        Assertions.assertThat(keys).isEmpty();
        this.transientState.visitPending(2000L, s -> keys.add(s.getRecord().getElementInstanceKey()));
        Assertions.assertThat(keys).isEmpty();
        Assertions.assertThat((boolean)this.persistentState.existSubscriptionForElementInstance(1L, subscription.getMessageNameBuffer())).isFalse();
    }

    private MessageSubscriptionRecord subscriptionWithElementInstanceKey(long elementInstanceKey) {
        return this.subscription("messageName", "correlationKey", elementInstanceKey);
    }

    private MessageSubscriptionRecord subscription(String name, String correlationKey, long elementInstanceKey) {
        return new MessageSubscriptionRecord().setProcessInstanceKey(1L).setElementInstanceKey(elementInstanceKey).setBpmnProcessId(BufferUtil.wrapString((String)"process")).setMessageName(BufferUtil.wrapString((String)name)).setCorrelationKey(BufferUtil.wrapString((String)correlationKey)).setInterrupting(true);
    }
}

