/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.message;

import io.camunda.zeebe.engine.state.immutable.PendingProcessMessageSubscriptionState;
import io.camunda.zeebe.engine.state.message.ProcessMessageSubscription;
import io.camunda.zeebe.engine.state.mutable.MutableProcessMessageSubscriptionState;
import io.camunda.zeebe.engine.util.ProcessingStateRule;
import io.camunda.zeebe.protocol.impl.record.value.message.ProcessMessageSubscriptionRecord;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.ArrayList;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public final class PendingProcessMessageSubscriptionStateTest {
    @Rule
    public final ProcessingStateRule stateRule = new ProcessingStateRule();
    private MutableProcessMessageSubscriptionState persistentState;
    private PendingProcessMessageSubscriptionState transientState;

    @Before
    public void setUp() {
        this.persistentState = this.stateRule.getProcessingState().getProcessMessageSubscriptionState();
        this.transientState = this.stateRule.getProcessingState().getPendingProcessMessageSubscriptionState();
    }

    @Test
    public void shouldNoVisitSubscriptionBeforeTime() {
        ProcessMessageSubscriptionRecord record1 = this.subscriptionRecordWithElementInstanceKey(1L);
        this.persistentState.put(1L, record1);
        this.transientState.onSent(record1, 1000L);
        ProcessMessageSubscriptionRecord record2 = this.subscriptionRecordWithElementInstanceKey(2L);
        this.transientState.onSent(record2, 3000L);
        ArrayList keys = new ArrayList();
        this.transientState.visitPending(1000L, s -> keys.add(s.getRecord().getElementInstanceKey()));
        Assertions.assertThat(keys).isEmpty();
    }

    @Test
    public void shouldVisitSubscriptionBeforeTime() {
        ProcessMessageSubscriptionRecord record1 = this.subscriptionRecordWithElementInstanceKey(1L);
        this.persistentState.put(1L, record1);
        this.transientState.onSent(record1, 1000L);
        ProcessMessageSubscriptionRecord record2 = this.subscriptionRecordWithElementInstanceKey(2L);
        this.persistentState.put(2L, record2);
        this.transientState.onSent(record2, 3000L);
        ArrayList keys = new ArrayList();
        this.transientState.visitPending(2000L, s -> keys.add(s.getRecord().getElementInstanceKey()));
        ((ListAssert)Assertions.assertThat(keys).hasSize(1)).contains((Object[])new Long[]{1L});
    }

    @Test
    public void shouldFindSubscriptionBeforeTimeInOrder() {
        ProcessMessageSubscriptionRecord record1 = this.subscriptionRecordWithElementInstanceKey(1L);
        this.persistentState.put(1L, record1);
        this.transientState.onSent(record1, 1000L);
        ProcessMessageSubscriptionRecord record2 = this.subscriptionRecordWithElementInstanceKey(2L);
        this.persistentState.put(2L, record2);
        this.transientState.onSent(record2, 2000L);
        ArrayList keys = new ArrayList();
        this.transientState.visitPending(3000L, s -> keys.add(s.getRecord().getElementInstanceKey()));
        ((ListAssert)Assertions.assertThat(keys).hasSize(2)).containsExactly((Object[])new Long[]{1L, 2L});
    }

    @Test
    public void shouldNotVisitSubscriptionIfOpened() {
        ProcessMessageSubscriptionRecord record1 = this.subscriptionRecordWithElementInstanceKey(1L);
        this.persistentState.put(1L, record1);
        this.transientState.onSent(record1, 1000L);
        ProcessMessageSubscriptionRecord record2 = this.subscriptionRecordWithElementInstanceKey(2L);
        this.persistentState.put(2L, record2);
        this.transientState.onSent(record2, 2000L);
        this.persistentState.updateToOpenedState(record2.setSubscriptionPartitionId(3));
        ArrayList keys = new ArrayList();
        this.transientState.visitPending(2000L, s -> keys.add(s.getRecord().getElementInstanceKey()));
        ((ListAssert)Assertions.assertThat(keys).hasSize(1)).contains((Object[])new Long[]{1L});
    }

    @Test
    public void shouldUpdateSubscriptionSentTime() {
        ProcessMessageSubscriptionRecord record = this.subscriptionRecordWithElementInstanceKey(1L);
        this.persistentState.put(1L, record);
        this.transientState.onSent(record, 1000L);
        ArrayList keys = new ArrayList();
        this.transientState.visitPending(2000L, s -> keys.add(s.getRecord().getElementInstanceKey()));
        ((ListAssert)Assertions.assertThat(keys).hasSize(1)).contains((Object[])new Long[]{1L});
        ProcessMessageSubscription existingSubscription = this.persistentState.getSubscription(record.getElementInstanceKey(), record.getMessageNameBuffer(), "<default>");
        this.transientState.onSent(existingSubscription.getRecord(), 1500L);
        keys.clear();
        this.transientState.visitPending(2000L, s -> keys.add(s.getRecord().getElementInstanceKey()));
        ((ListAssert)Assertions.assertThat(keys).hasSize(1)).contains((Object[])new Long[]{1L});
    }

    @Test
    public void shouldUpdateOpenState() {
        ProcessMessageSubscriptionRecord record = this.subscriptionRecordWithElementInstanceKey(1L);
        this.persistentState.put(1L, record);
        this.transientState.onSent(record, 1000L);
        ProcessMessageSubscription subscription = this.persistentState.getSubscription(record.getElementInstanceKey(), record.getMessageNameBuffer(), "<default>");
        Assertions.assertThat((boolean)subscription.isOpening()).isTrue();
        this.persistentState.updateToOpenedState(record.setSubscriptionPartitionId(3));
        ProcessMessageSubscription updatedSubscription = this.persistentState.getSubscription(record.getElementInstanceKey(), record.getMessageNameBuffer(), "<default>");
        Assertions.assertThat((boolean)updatedSubscription.isOpening()).isFalse();
        Assertions.assertThat((int)updatedSubscription.getRecord().getSubscriptionPartitionId()).isEqualTo(3);
        ArrayList keys = new ArrayList();
        this.transientState.visitPending(2000L, s -> keys.add(s.getRecord().getElementInstanceKey()));
        Assertions.assertThat(keys).isEmpty();
    }

    @Test
    public void shouldUpdateCloseState() {
        ProcessMessageSubscriptionRecord record = this.subscriptionRecordWithElementInstanceKey(1L);
        this.persistentState.put(1L, record);
        this.transientState.onSent(record, 1000L);
        this.persistentState.updateToOpenedState(record.setSubscriptionPartitionId(3));
        ProcessMessageSubscription subscription = this.persistentState.getSubscription(record.getElementInstanceKey(), record.getMessageNameBuffer(), "<default>");
        Assertions.assertThat((boolean)subscription.isClosing()).isFalse();
        this.persistentState.updateToClosingState(record);
        this.transientState.onSent(record, 1000L);
        ProcessMessageSubscription updatedSubscription = this.persistentState.getSubscription(record.getElementInstanceKey(), record.getMessageNameBuffer(), "<default>");
        Assertions.assertThat((boolean)updatedSubscription.isClosing()).isTrue();
        ArrayList keys = new ArrayList();
        this.transientState.visitPending(2000L, s -> keys.add(s.getRecord().getElementInstanceKey()));
        ((ListAssert)Assertions.assertThat(keys).hasSize(1)).contains((Object[])new Long[]{1L});
    }

    private ProcessMessageSubscriptionRecord subscriptionRecordWithElementInstanceKey(long elementInstanceKey) {
        return this.subscriptionRecord("handler", "messageName", "correlationKey", elementInstanceKey);
    }

    private ProcessMessageSubscriptionRecord subscriptionRecord(String name, String correlationKey, long elementInstanceKey) {
        return this.subscriptionRecord("handler", name, correlationKey, elementInstanceKey);
    }

    private ProcessMessageSubscriptionRecord subscriptionRecord(String handlerId, String name, String correlationKey, long elementInstanceKey) {
        return new ProcessMessageSubscriptionRecord().setProcessInstanceKey(1L).setElementInstanceKey(elementInstanceKey).setBpmnProcessId(BufferUtil.wrapString((String)"process")).setElementId(BufferUtil.wrapString((String)handlerId)).setMessageName(BufferUtil.wrapString((String)name)).setCorrelationKey(BufferUtil.wrapString((String)correlationKey)).setInterrupting(true).setSubscriptionPartitionId(1);
    }
}

