/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.message;

import io.camunda.zeebe.engine.state.message.ProcessMessageSubscription;
import io.camunda.zeebe.engine.state.mutable.MutableProcessMessageSubscriptionState;
import io.camunda.zeebe.engine.util.ProcessingStateRule;
import io.camunda.zeebe.protocol.impl.record.value.message.ProcessMessageSubscriptionRecord;
import io.camunda.zeebe.util.buffer.BufferUtil;
import io.camunda.zeebe.util.collection.Tuple;
import java.util.ArrayList;
import org.agrona.DirectBuffer;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public final class ProcessMessageSubscriptionStateTest {
    @Rule
    public final ProcessingStateRule stateRule = new ProcessingStateRule();
    private MutableProcessMessageSubscriptionState state;

    @Before
    public void setUp() {
        this.state = this.stateRule.getProcessingState().getProcessMessageSubscriptionState();
    }

    @Test
    public void shouldNotExist() {
        ProcessMessageSubscriptionRecord record = this.subscriptionRecordWithElementInstanceKey(1L);
        this.state.put(1L, record);
        boolean exist = this.state.existSubscriptionForElementInstance(2L, record.getMessageNameBuffer(), "<default>");
        Assertions.assertThat((boolean)exist).isFalse();
    }

    @Test
    public void shouldExistSubscription() {
        ProcessMessageSubscriptionRecord record = this.subscriptionRecordWithElementInstanceKey(1L);
        this.state.put(1L, record);
        boolean exist = this.state.existSubscriptionForElementInstance(1L, record.getMessageNameBuffer(), "<default>");
        Assertions.assertThat((boolean)exist).isTrue();
    }

    @Test
    public void shouldGetSubscription() {
        ProcessMessageSubscriptionRecord record = this.subscriptionRecordWithElementInstanceKey(1L);
        this.state.put(1L, record);
        ProcessMessageSubscription subscription = this.state.getSubscription(record.getElementInstanceKey(), record.getMessageNameBuffer(), "<default>");
        Assertions.assertThat((Object)subscription).isNotNull();
        Assertions.assertThat((long)subscription.getKey()).isEqualTo(1L);
        Assertions.assertThat((Object)subscription.getRecord()).isEqualTo((Object)record);
    }

    @Test
    public void shouldNotFailOnRemoveSubscriptionTwice() {
        ProcessMessageSubscriptionRecord record = this.subscriptionRecordWithElementInstanceKey(1L);
        this.state.put(1L, record);
        this.state.remove(1L, record.getMessageNameBuffer(), "<default>");
        this.state.remove(1L, record.getMessageNameBuffer(), "<default>");
        Assertions.assertThat((boolean)this.state.existSubscriptionForElementInstance(1L, record.getMessageNameBuffer(), "<default>")).isFalse();
    }

    @Test
    public void shouldNotRemoveSubscriptionOnDifferentKey() {
        this.state.put(1L, this.subscriptionRecord("messageName", "correlationKey", 1L));
        this.state.put(2L, this.subscriptionRecord("messageName", "correlationKey", 2L));
        this.state.remove(2L, BufferUtil.wrapString((String)"messageName"), "<default>");
        Assertions.assertThat((boolean)this.state.existSubscriptionForElementInstance(1L, BufferUtil.wrapString((String)"messageName"), "<default>")).isTrue();
    }

    @Test
    public void shouldVisitAllSubscriptionsInTheState() {
        this.state.put(1L, this.subscriptionRecord("message1", "correlationKey", 1L));
        this.state.put(2L, this.subscriptionRecord("message2", "correlationKey", 1L));
        this.state.put(3L, this.subscriptionRecord("message3", "correlationKey", 2L));
        ArrayList visited = new ArrayList();
        this.state.visitElementSubscriptions(1L, s -> visited.add(new Tuple((Object)s.getRecord().getElementInstanceKey(), (Object)BufferUtil.cloneBuffer((DirectBuffer)s.getRecord().getMessageNameBuffer()))));
        Assertions.assertThat(visited).containsExactly((Object[])new Tuple[]{new Tuple((Object)1L, (Object)BufferUtil.wrapString((String)"message1")), new Tuple((Object)1L, (Object)BufferUtil.wrapString((String)"message2"))});
    }

    @Test
    public void shouldRemoveSubscription() {
        ProcessMessageSubscriptionRecord record = this.subscriptionRecordWithElementInstanceKey(1L);
        this.state.put(1L, record);
        this.state.remove(1L, record.getMessageNameBuffer(), "<default>");
        ProcessMessageSubscription subscription = this.state.getSubscription(record.getElementInstanceKey(), record.getMessageNameBuffer(), "<default>");
        Assertions.assertThat((Object)subscription).isNull();
    }

    private ProcessMessageSubscriptionRecord subscriptionRecordWithElementInstanceKey(long elementInstanceKey) {
        return this.subscriptionRecord("handler", "messageName", "correlationKey", elementInstanceKey);
    }

    private ProcessMessageSubscriptionRecord subscriptionRecord(String name, String correlationKey, long elementInstanceKey) {
        return this.subscriptionRecord("handler", name, correlationKey, elementInstanceKey);
    }

    private ProcessMessageSubscriptionRecord subscriptionRecord(String handlerId, String name, String correlationKey, long elementInstanceKey) {
        return new ProcessMessageSubscriptionRecord().setProcessInstanceKey(1L).setElementInstanceKey(elementInstanceKey).setBpmnProcessId(BufferUtil.wrapString((String)"process")).setElementId(BufferUtil.wrapString((String)handlerId)).setMessageName(BufferUtil.wrapString((String)name)).setCorrelationKey(BufferUtil.wrapString((String)correlationKey)).setInterrupting(true).setSubscriptionPartitionId(1);
    }
}

