/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.migration;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbCompositeKey;
import io.camunda.zeebe.db.impl.DbForeignKey;
import io.camunda.zeebe.db.impl.DbLong;
import io.camunda.zeebe.db.impl.DbNil;
import io.camunda.zeebe.engine.state.instance.JobRecordValue;
import io.camunda.zeebe.engine.state.migration.JobTimeoutCleanupMigration;
import io.camunda.zeebe.engine.state.mutable.MutableProcessingState;
import io.camunda.zeebe.engine.util.ProcessingStateExtension;
import io.camunda.zeebe.protocol.ZbColumnFamilies;
import io.camunda.zeebe.protocol.impl.record.value.job.JobRecord;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ProcessingStateExtension.class})
public class JobTimeoutCleanupMigrationTest {
    final JobTimeoutCleanupMigration jobTimeoutCleanupMigration = new JobTimeoutCleanupMigration();
    private ZeebeDb<ZbColumnFamilies> zeebeDb;
    private MutableProcessingState processingState;
    private TransactionContext transactionContext;
    private final JobRecordValue jobRecordToRead = new JobRecordValue();
    private DbLong jobKey;
    private DbForeignKey<DbLong> fkJob;
    private ColumnFamily<DbLong, JobRecordValue> jobsColumnFamily;
    private DbLong deadlineKey;
    private DbCompositeKey<DbLong, DbForeignKey<DbLong>> deadlineJobKey;
    private ColumnFamily<DbCompositeKey<DbLong, DbForeignKey<DbLong>>, DbNil> deadlinesColumnFamily;

    @BeforeEach
    public void setup() {
        this.jobKey = new DbLong();
        this.fkJob = new DbForeignKey((DbKey)this.jobKey, (Enum)ZbColumnFamilies.JOBS);
        this.jobsColumnFamily = this.zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.JOBS, this.transactionContext, (DbKey)this.jobKey, (DbValue)this.jobRecordToRead);
        this.deadlineKey = new DbLong();
        this.deadlineJobKey = new DbCompositeKey((DbKey)this.deadlineKey, this.fkJob);
        this.deadlinesColumnFamily = this.zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.JOB_DEADLINES, this.transactionContext, this.deadlineJobKey, (DbValue)DbNil.INSTANCE);
        this.jobKey.wrapLong(1L);
    }

    @Test
    public void afterCleanupValidTimeoutIsStillPresent() {
        int deadline = 123;
        this.jobsColumnFamily.upsert((DbKey)this.jobKey, (DbValue)JobTimeoutCleanupMigrationTest.createJobRecordValue(123L));
        this.deadlineKey.wrapLong(123L);
        this.deadlinesColumnFamily.upsert(this.deadlineJobKey, (DbValue)DbNil.INSTANCE);
        this.jobTimeoutCleanupMigration.runMigration(this.processingState);
        Assertions.assertThat((boolean)this.deadlinesColumnFamily.exists(this.deadlineJobKey)).isTrue();
    }

    @Test
    public void afterCleanupOrphanedTimeoutIsDeleted() {
        this.jobsColumnFamily.upsert((DbKey)this.jobKey, (DbValue)new JobRecordValue());
        this.deadlineKey.wrapLong(123L);
        this.deadlinesColumnFamily.upsert(this.deadlineJobKey, (DbValue)DbNil.INSTANCE);
        this.jobsColumnFamily.deleteExisting((DbKey)this.jobKey);
        this.jobTimeoutCleanupMigration.runMigration(this.processingState);
        Assertions.assertThat((boolean)this.deadlinesColumnFamily.exists(this.deadlineJobKey)).isFalse();
    }

    @Test
    public void afterCleanupTimeoutWithNonMatchingDeadlineIsDeleted() {
        int firstDeadline = 123;
        int secondDeadline = 456;
        this.jobsColumnFamily.upsert((DbKey)this.jobKey, (DbValue)JobTimeoutCleanupMigrationTest.createJobRecordValue(456L));
        this.deadlineKey.wrapLong(123L);
        this.deadlinesColumnFamily.upsert(this.deadlineJobKey, (DbValue)DbNil.INSTANCE);
        this.deadlineKey.wrapLong(456L);
        this.deadlinesColumnFamily.upsert(this.deadlineJobKey, (DbValue)DbNil.INSTANCE);
        this.jobTimeoutCleanupMigration.runMigration(this.processingState);
        this.deadlineKey.wrapLong(123L);
        Assertions.assertThat((boolean)this.deadlinesColumnFamily.exists(this.deadlineJobKey)).isFalse();
        this.deadlineKey.wrapLong(456L);
        Assertions.assertThat((boolean)this.deadlinesColumnFamily.exists(this.deadlineJobKey)).isTrue();
    }

    private static JobRecordValue createJobRecordValue(long deadline) {
        JobRecordValue jobRecordValue = new JobRecordValue();
        jobRecordValue.setRecordWithoutVariables(new JobRecord().setDeadline(deadline));
        return jobRecordValue;
    }
}

