/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.migration;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.db.KeyValuePairVisitor;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbLong;
import io.camunda.zeebe.engine.state.DefaultZeebeDbFactory;
import io.camunda.zeebe.engine.state.migration.MemoryBoundedColumnIteration;
import io.camunda.zeebe.protocol.ZbColumnFamilies;
import java.io.File;
import java.util.HashMap;
import java.util.stream.LongStream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

final class MemoryBoundedColumnIterationTest {
    MemoryBoundedColumnIterationTest() {
    }

    @Test
    void shouldDrainAllValues(@TempDir File tmpDir) {
        MemoryBoundedColumnIteration iteration = new MemoryBoundedColumnIteration(0x100000L);
        ZeebeDb db = DefaultZeebeDbFactory.defaultFactory().createDb(tmpDir);
        DbLong key = new DbLong();
        DbLong value = new DbLong();
        ColumnFamily column = db.createColumnFamily((Enum)ZbColumnFamilies.DEFAULT, db.createContext(), (DbKey)key, (DbValue)value);
        HashMap expected = new HashMap();
        LongStream.range(0L, 100L).forEach(i -> {
            key.wrapLong(i);
            value.wrapLong(i);
            column.upsert((DbKey)key, (DbValue)value);
            expected.put(i, i);
        });
        HashMap drainedValues = new HashMap();
        iteration.drain(column, (k, v) -> drainedValues.put(k.getValue(), v.getValue()));
        Assertions.assertThat(drainedValues).isEqualTo(expected);
        Assertions.assertThat((boolean)column.isEmpty()).isTrue();
    }

    @Test
    void shouldIterateInBoundedChunks(@TempDir File tmpDir) {
        MemoryBoundedColumnIteration iteration = new MemoryBoundedColumnIteration(400L);
        ZeebeDb db = DefaultZeebeDbFactory.defaultFactory().createDb(tmpDir);
        DbLong key = new DbLong();
        DbLong value = new DbLong();
        ColumnFamily column = db.createColumnFamily((Enum)ZbColumnFamilies.DEFAULT, db.createContext(), (DbKey)key, (DbValue)value);
        LongStream.range(0L, 100L).forEach(i -> {
            key.wrapLong(i);
            value.wrapLong(i);
            column.upsert((DbKey)key, (DbValue)value);
        });
        ColumnFamily spiedColumn = (ColumnFamily)Mockito.spy((Object)column);
        iteration.drain(spiedColumn, (k, v) -> {});
        ((ColumnFamily)Mockito.verify((Object)spiedColumn, (VerificationMode)Mockito.times((int)4))).whileTrue((KeyValuePairVisitor)Mockito.any());
    }
}

