/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.migration.to_1_3;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbLong;
import io.camunda.zeebe.engine.state.migration.TemporaryVariables;
import io.camunda.zeebe.protocol.ZbColumnFamilies;
import org.agrona.DirectBuffer;

public class LegacyDbTemporaryVariablesState {
    private final DbLong temporaryVariablesKeyInstance = new DbLong();
    private final TemporaryVariables temporaryVariables = new TemporaryVariables();
    private final ColumnFamily<DbLong, TemporaryVariables> temporaryVariableColumnFamily;

    public LegacyDbTemporaryVariablesState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext) {
        this.temporaryVariableColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.TEMPORARY_VARIABLE_STORE, transactionContext, (DbKey)this.temporaryVariablesKeyInstance, (DbValue)this.temporaryVariables);
    }

    public void put(long key, DirectBuffer variables) {
        this.temporaryVariables.reset();
        this.temporaryVariables.set(variables);
        this.temporaryVariablesKeyInstance.wrapLong(key);
        this.temporaryVariableColumnFamily.upsert((DbKey)this.temporaryVariablesKeyInstance, (DbValue)this.temporaryVariables);
    }

    public boolean isEmpty() {
        return this.temporaryVariableColumnFamily.isEmpty();
    }
}

