/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.migration.to_8_3;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbString;
import io.camunda.zeebe.db.impl.DbTenantAwareKey;
import io.camunda.zeebe.engine.EngineConfiguration;
import io.camunda.zeebe.engine.state.deployment.DbDecisionState;
import io.camunda.zeebe.engine.state.deployment.DbProcessState;
import io.camunda.zeebe.engine.state.deployment.DeployedDrg;
import io.camunda.zeebe.engine.state.deployment.DeployedProcess;
import io.camunda.zeebe.engine.state.deployment.PersistedDecision;
import io.camunda.zeebe.engine.state.deployment.PersistedProcess;
import io.camunda.zeebe.engine.state.deployment.VersionInfo;
import io.camunda.zeebe.engine.state.instance.DbJobState;
import io.camunda.zeebe.engine.state.message.DbMessageStartEventSubscriptionState;
import io.camunda.zeebe.engine.state.message.DbMessageState;
import io.camunda.zeebe.engine.state.message.DbMessageSubscriptionState;
import io.camunda.zeebe.engine.state.message.DbProcessMessageSubscriptionState;
import io.camunda.zeebe.engine.state.message.MessageStartEventSubscription;
import io.camunda.zeebe.engine.state.message.MessageSubscription;
import io.camunda.zeebe.engine.state.message.ProcessMessageSubscription;
import io.camunda.zeebe.engine.state.message.StoredMessage;
import io.camunda.zeebe.engine.state.migration.to_8_3.MultiTenancyDecisionStateMigration;
import io.camunda.zeebe.engine.state.migration.to_8_3.MultiTenancyJobStateMigration;
import io.camunda.zeebe.engine.state.migration.to_8_3.MultiTenancyMessageStartEventSubscriptionStateMigration;
import io.camunda.zeebe.engine.state.migration.to_8_3.MultiTenancyMessageStateMigration;
import io.camunda.zeebe.engine.state.migration.to_8_3.MultiTenancyMessageSubscriptionStateMigration;
import io.camunda.zeebe.engine.state.migration.to_8_3.MultiTenancyProcessMessageSubscriptionStateMigration;
import io.camunda.zeebe.engine.state.migration.to_8_3.MultiTenancyProcessStateMigration;
import io.camunda.zeebe.engine.state.migration.to_8_3.legacy.LegacyDecisionState;
import io.camunda.zeebe.engine.state.migration.to_8_3.legacy.LegacyJobState;
import io.camunda.zeebe.engine.state.migration.to_8_3.legacy.LegacyMessageStartEventSubscriptionState;
import io.camunda.zeebe.engine.state.migration.to_8_3.legacy.LegacyMessageState;
import io.camunda.zeebe.engine.state.migration.to_8_3.legacy.LegacyMessageSubscriptionState;
import io.camunda.zeebe.engine.state.migration.to_8_3.legacy.LegacyProcessMessageSubscriptionState;
import io.camunda.zeebe.engine.state.migration.to_8_3.legacy.LegacyProcessState;
import io.camunda.zeebe.engine.state.mutable.MutableProcessingState;
import io.camunda.zeebe.engine.util.ProcessingStateExtension;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.protocol.ZbColumnFamilies;
import io.camunda.zeebe.protocol.impl.encoding.MsgPackConverter;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DecisionRecord;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DecisionRequirementsRecord;
import io.camunda.zeebe.protocol.impl.record.value.deployment.ProcessRecord;
import io.camunda.zeebe.protocol.impl.record.value.job.JobRecord;
import io.camunda.zeebe.protocol.impl.record.value.message.MessageRecord;
import io.camunda.zeebe.protocol.impl.record.value.message.MessageStartEventSubscriptionRecord;
import io.camunda.zeebe.protocol.impl.record.value.message.MessageSubscriptionRecord;
import io.camunda.zeebe.protocol.impl.record.value.message.ProcessMessageSubscriptionRecord;
import io.camunda.zeebe.protocol.record.value.JobRecordValue;
import io.camunda.zeebe.test.util.MsgPackUtil;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.agrona.DirectBuffer;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

public class MultiTenancyMigrationTest {

    @Nested
    @ExtendWith(value={ProcessingStateExtension.class})
    class ProcessVersionMigrationTest {
        final MultiTenancyProcessStateMigration sut = new MultiTenancyProcessStateMigration();
        private ZeebeDb<ZbColumnFamilies> zeebeDb;
        private MutableProcessingState processingState;
        private TransactionContext transactionContext;
        private LegacyProcessState.LegacyProcessVersionManager legacyState;
        private DbString processIdKey;
        private ColumnFamily<DbTenantAwareKey<DbString>, VersionInfo> processVersionColumnFamily;
        private DbTenantAwareKey<DbString> tenantAwareProcessId;

        ProcessVersionMigrationTest(MultiTenancyMigrationTest this$0) {
        }

        @BeforeEach
        void setup() {
            this.legacyState = new LegacyProcessState.LegacyProcessVersionManager(1L, this.zeebeDb, this.transactionContext);
            this.processIdKey = new DbString();
            DbString tenantKey = new DbString();
            tenantKey.wrapString("<default>");
            this.tenantAwareProcessId = new DbTenantAwareKey(tenantKey, (DbKey)this.processIdKey, DbTenantAwareKey.PlacementType.PREFIX);
            this.processVersionColumnFamily = this.zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.PROCESS_VERSION, this.transactionContext, this.tenantAwareProcessId, (DbValue)new VersionInfo());
        }

        @Test
        void shouldMigrateProcessVersion() {
            String processId = "processId";
            this.legacyState.insertProcessVersion("processId", 5);
            this.sut.runMigration(this.processingState);
            this.processIdKey.wrapString("processId");
            VersionInfo versionInfo = (VersionInfo)this.processVersionColumnFamily.get(this.tenantAwareProcessId);
            Assertions.assertThat((long)versionInfo.getHighestVersion()).isEqualTo(5L);
            Assertions.assertThat((List)versionInfo.getKnownVersions()).containsExactly((Object[])new Long[]{1L, 2L, 3L, 4L, 5L});
        }

        @Test
        void shouldNotSetKnownVersionsIfHighestVersionIsZero() {
            String processId = "processId";
            this.legacyState.insertProcessVersion("processId", 0);
            this.sut.runMigration(this.processingState);
            this.processIdKey.wrapString("processId");
            VersionInfo versionInfo = (VersionInfo)this.processVersionColumnFamily.get(this.tenantAwareProcessId);
            Assertions.assertThat((long)versionInfo.getHighestVersion()).isEqualTo(0L);
            Assertions.assertThat((List)versionInfo.getKnownVersions()).isEmpty();
        }
    }

    @Nested
    @ExtendWith(value={ProcessingStateExtension.class})
    class MigrateJobStateForMultiTenancyTest {
        final MultiTenancyJobStateMigration sut = new MultiTenancyJobStateMigration();
        private ZeebeDb<ZbColumnFamilies> zeebeDb;
        private MutableProcessingState processingState;
        private TransactionContext transactionContext;
        private LegacyJobState legacyState;
        private DbJobState jobState;

        MigrateJobStateForMultiTenancyTest(MultiTenancyMigrationTest this$0) {
        }

        @BeforeEach
        void setup() {
            this.legacyState = new LegacyJobState(this.zeebeDb, this.transactionContext);
            this.jobState = new DbJobState(this.zeebeDb, this.transactionContext);
        }

        @Test
        void shouldMigrateActivatableJobsColumnFamily() {
            long jobKey = 1L;
            String jobWorker = "jobWorker";
            String jobType = "jobType";
            int retries = 5;
            long deadline = 111L;
            long recurringTime = 222L;
            long retryBackoff = 333L;
            String errorMessage = "jobErrorMessage";
            String errorCode = "jobErrorCode";
            String processId = "jobProcess";
            long processDefinitionKey = 444L;
            long processInstanceKey = 555L;
            int version = 3;
            String elementId = "jobElement";
            long elementInstanceKey = 666L;
            Map<String, String> customHeaders = Collections.singletonMap("workerVersion", "42");
            JobRecord jobRecord = new JobRecord().setWorker("jobWorker").setType("jobType").setRetries(5).setDeadline(111L).setRecurringTime(222L).setRetryBackoff(333L).setErrorMessage("jobErrorMessage").setErrorCode(BufferUtil.wrapString((String)"jobErrorCode")).setBpmnProcessId("jobProcess").setProcessDefinitionKey(444L).setProcessInstanceKey(555L).setProcessDefinitionVersion(3).setElementId("jobElement").setElementInstanceKey(666L).setCustomHeaders((DirectBuffer)BufferUtil.wrapArray((byte[])MsgPackConverter.convertToMsgPack(customHeaders)));
            this.legacyState.create(1L, jobRecord);
            this.sut.runMigration(this.processingState);
            ArrayList actualJobs = new ArrayList();
            this.jobState.forEachActivatableJobs(BufferUtil.wrapString((String)"jobType"), List.of("<default>"), (key, job) -> {
                Assertions.assertThat((Long)key).isEqualTo(1L);
                io.camunda.zeebe.protocol.record.Assertions.assertThat((JobRecordValue)job).hasWorker("jobWorker").hasType("jobType").hasRetries(5).hasDeadline(111L).hasRecurringTime(222L).hasRetryBackoff(333L).hasErrorCode("jobErrorCode").hasErrorMessage("jobErrorMessage").hasBpmnProcessId("jobProcess").hasElementId("jobElement").hasElementInstanceKey(666L).hasProcessDefinitionKey(444L).hasProcessInstanceKey(555L).hasProcessDefinitionVersion(3).hasCustomHeaders(customHeaders).hasTenantId("<default>");
                actualJobs.add(job);
                return true;
            });
            Assertions.assertThat(actualJobs).hasSize(1);
        }
    }

    @Nested
    @ExtendWith(value={ProcessingStateExtension.class})
    class MigrateProcessMessageSubscriptionStateForMultiTenancyTest {
        final MultiTenancyProcessMessageSubscriptionStateMigration sut = new MultiTenancyProcessMessageSubscriptionStateMigration();
        private ZeebeDb<ZbColumnFamilies> zeebeDb;
        private MutableProcessingState processingState;
        private TransactionContext transactionContext;
        private LegacyProcessMessageSubscriptionState legacyState;
        private DbProcessMessageSubscriptionState state;

        MigrateProcessMessageSubscriptionStateForMultiTenancyTest(MultiTenancyMigrationTest this$0) {
        }

        @BeforeEach
        void setup() {
            this.legacyState = new LegacyProcessMessageSubscriptionState(this.zeebeDb, this.transactionContext);
            this.state = new DbProcessMessageSubscriptionState(this.zeebeDb, this.transactionContext, null);
        }

        @Test
        void shouldMigrateProcessSubscriptionByKeyColumnFamily() {
            ProcessMessageSubscriptionRecord record = new ProcessMessageSubscriptionRecord().setSubscriptionPartitionId(8).setProcessInstanceKey(123L).setElementInstanceKey(456L).setBpmnProcessId(BufferUtil.wrapString((String)"processId")).setMessageKey(789L).setMessageName(BufferUtil.wrapString((String)"messageName")).setCorrelationKey(BufferUtil.wrapString((String)"correlationKey")).setInterrupting(false).setVariables(MsgPackUtil.asMsgPack((String)"foo", (Object)"bar")).setElementId(BufferUtil.wrapString((String)"elementId"));
            int key = 111;
            this.legacyState.put(111L, record);
            this.sut.runMigration(this.processingState);
            ProcessMessageSubscription subscription = this.state.getSubscription(record.getElementInstanceKey(), record.getMessageNameBuffer(), "<default>");
            Assertions.assertThat((Object)subscription).isNotNull();
            Assertions.assertThat((long)subscription.getKey()).isEqualTo(111L);
            Assertions.assertThat((Object)subscription.getRecord()).extracting(new Function[]{ProcessMessageSubscriptionRecord::getSubscriptionPartitionId, ProcessMessageSubscriptionRecord::getProcessInstanceKey, ProcessMessageSubscriptionRecord::getElementInstanceKey, ProcessMessageSubscriptionRecord::getBpmnProcessId, ProcessMessageSubscriptionRecord::getMessageKey, ProcessMessageSubscriptionRecord::getMessageName, ProcessMessageSubscriptionRecord::getCorrelationKey, ProcessMessageSubscriptionRecord::isInterrupting, ProcessMessageSubscriptionRecord::getVariables, ProcessMessageSubscriptionRecord::getElementId, ProcessMessageSubscriptionRecord::getTenantId}).containsExactly(new Object[]{record.getSubscriptionPartitionId(), record.getProcessInstanceKey(), record.getElementInstanceKey(), record.getBpmnProcessId(), record.getMessageKey(), record.getMessageName(), record.getCorrelationKey(), record.isInterrupting(), record.getVariables(), record.getElementId(), "<default>"});
        }
    }

    @Nested
    @ExtendWith(value={ProcessingStateExtension.class})
    class MigrateMessageSubscriptionStateForMultiTenancyTest {
        final MultiTenancyMessageSubscriptionStateMigration sut = new MultiTenancyMessageSubscriptionStateMigration();
        private ZeebeDb<ZbColumnFamilies> zeebeDb;
        private MutableProcessingState processingState;
        private TransactionContext transactionContext;
        private LegacyMessageSubscriptionState legacyState;
        private DbMessageSubscriptionState state;

        MigrateMessageSubscriptionStateForMultiTenancyTest(MultiTenancyMigrationTest this$0) {
        }

        @BeforeEach
        void setup() {
            this.legacyState = new LegacyMessageSubscriptionState(this.zeebeDb, this.transactionContext);
            this.state = new DbMessageSubscriptionState(this.zeebeDb, this.transactionContext, null);
        }

        @Test
        void shouldMigrateMessageSubscriptionByNameAndCorrelationKeyColumnFamily() {
            MessageSubscriptionRecord record = new MessageSubscriptionRecord().setProcessInstanceKey(123L).setElementInstanceKey(456L).setBpmnProcessId(BufferUtil.wrapString((String)"processId")).setMessageKey(789L).setMessageName(BufferUtil.wrapString((String)"messageName")).setCorrelationKey(BufferUtil.wrapString((String)"correlationKey")).setInterrupting(false).setVariables(MsgPackUtil.asMsgPack((String)"foo", (Object)"bar"));
            int key = 111;
            this.legacyState.put(111L, record);
            this.sut.runMigration(this.processingState);
            AtomicReference subscriptionRef = new AtomicReference();
            this.state.visitSubscriptions("<default>", record.getMessageNameBuffer(), record.getCorrelationKeyBuffer(), subscription -> {
                subscriptionRef.set(subscription);
                return false;
            });
            MessageSubscription subscription2 = (MessageSubscription)subscriptionRef.get();
            Assertions.assertThat((Object)subscription2).isNotNull();
            Assertions.assertThat((long)subscription2.getKey()).isEqualTo(111L);
            Assertions.assertThat((Object)subscription2.getRecord()).extracting(new Function[]{MessageSubscriptionRecord::getProcessInstanceKey, MessageSubscriptionRecord::getElementInstanceKey, MessageSubscriptionRecord::getBpmnProcessId, MessageSubscriptionRecord::getMessageKey, MessageSubscriptionRecord::getMessageName, MessageSubscriptionRecord::getCorrelationKey, MessageSubscriptionRecord::isInterrupting, MessageSubscriptionRecord::getVariables, MessageSubscriptionRecord::getTenantId}).containsExactly(new Object[]{record.getProcessInstanceKey(), record.getElementInstanceKey(), record.getBpmnProcessId(), record.getMessageKey(), record.getMessageName(), record.getCorrelationKey(), record.isInterrupting(), record.getVariables(), "<default>"});
        }
    }

    @Nested
    @ExtendWith(value={ProcessingStateExtension.class})
    class MigrateMessageStartEventSubscriptionStateForMultiTenancyTest {
        final MultiTenancyMessageStartEventSubscriptionStateMigration sut = new MultiTenancyMessageStartEventSubscriptionStateMigration();
        private ZeebeDb<ZbColumnFamilies> zeebeDb;
        private MutableProcessingState processingState;
        private TransactionContext transactionContext;
        private LegacyMessageStartEventSubscriptionState legacyState;
        private DbMessageStartEventSubscriptionState state;

        MigrateMessageStartEventSubscriptionStateForMultiTenancyTest(MultiTenancyMigrationTest this$0) {
        }

        @BeforeEach
        void setup() {
            this.legacyState = new LegacyMessageStartEventSubscriptionState(this.zeebeDb, this.transactionContext);
            this.state = new DbMessageStartEventSubscriptionState(this.zeebeDb, this.transactionContext);
        }

        @Test
        void shouldMigrateMessageStartEventSubscriptionByNameAndKeyColumnFamily() {
            int processDefinitionKey = 123;
            MessageStartEventSubscriptionRecord record = this.putMessageStartSubscriptionRecord(123);
            this.sut.runMigration(this.processingState);
            AtomicReference subscriptionRef = new AtomicReference();
            this.state.visitSubscriptionsByMessageName("<default>", record.getMessageNameBuffer(), subscriptionRef::set);
            MessageStartEventSubscription subscription = (MessageStartEventSubscription)subscriptionRef.get();
            Assertions.assertThat((Object)subscription).isNotNull();
            Assertions.assertThat((long)subscription.getKey()).isEqualTo(123L);
            this.assertMessageStartSubscription(record, subscription);
        }

        @Test
        void shouldMigrateMessageStartEventSubscriptionByKeyAndNameColumnFamily() {
            int processDefinitionKey = 123;
            MessageStartEventSubscriptionRecord record = this.putMessageStartSubscriptionRecord(123);
            this.sut.runMigration(this.processingState);
            AtomicReference subscriptionRef = new AtomicReference();
            this.state.visitSubscriptionsByProcessDefinition(record.getProcessDefinitionKey(), subscriptionRef::set);
            MessageStartEventSubscription subscription = (MessageStartEventSubscription)subscriptionRef.get();
            Assertions.assertThat((Object)subscription).isNotNull();
            Assertions.assertThat((long)subscription.getKey()).isEqualTo(123L);
            this.assertMessageStartSubscription(record, subscription);
        }

        private MessageStartEventSubscriptionRecord putMessageStartSubscriptionRecord(int processDefinitionKey) {
            MessageStartEventSubscriptionRecord record = new MessageStartEventSubscriptionRecord().setProcessDefinitionKey((long)processDefinitionKey).setBpmnProcessId(BufferUtil.wrapString((String)"processId")).setMessageName(BufferUtil.wrapString((String)"messageName")).setStartEventId(BufferUtil.wrapString((String)"startEventId")).setProcessInstanceKey(456L).setMessageKey(789L).setCorrelationKey(BufferUtil.wrapString((String)"correlationKey")).setVariables(MsgPackUtil.asMsgPack((String)"foo", (Object)"bar"));
            this.legacyState.put((long)processDefinitionKey, record);
            return record;
        }

        private void assertMessageStartSubscription(MessageStartEventSubscriptionRecord record, MessageStartEventSubscription subscription) {
            Assertions.assertThat((Object)subscription.getRecord()).extracting(new Function[]{MessageStartEventSubscriptionRecord::getProcessDefinitionKey, MessageStartEventSubscriptionRecord::getBpmnProcessId, MessageStartEventSubscriptionRecord::getMessageName, MessageStartEventSubscriptionRecord::getStartEventId, MessageStartEventSubscriptionRecord::getProcessInstanceKey, MessageStartEventSubscriptionRecord::getMessageKey, MessageStartEventSubscriptionRecord::getCorrelationKey, MessageStartEventSubscriptionRecord::getVariables, MessageStartEventSubscriptionRecord::getTenantId}).containsExactly(new Object[]{record.getProcessDefinitionKey(), record.getBpmnProcessId(), record.getMessageName(), record.getStartEventId(), record.getProcessInstanceKey(), record.getMessageKey(), record.getCorrelationKey(), record.getVariables(), "<default>"});
        }
    }

    @Nested
    @ExtendWith(value={ProcessingStateExtension.class})
    class MigrateMessageStateForMultiTenancyTest {
        final MultiTenancyMessageStateMigration sut = new MultiTenancyMessageStateMigration();
        private ZeebeDb<ZbColumnFamilies> zeebeDb;
        private MutableProcessingState processingState;
        private TransactionContext transactionContext;
        private LegacyMessageState legacyState;
        private DbMessageState messageState;

        MigrateMessageStateForMultiTenancyTest(MultiTenancyMigrationTest this$0) {
        }

        @BeforeEach
        void setup() {
            this.legacyState = new LegacyMessageState(this.zeebeDb, this.transactionContext, 1);
            this.messageState = new DbMessageState(this.zeebeDb, this.transactionContext, 1);
        }

        @Test
        void shouldMigrateMessagesColumnFamily() {
            MessageRecord messageRecord = new MessageRecord().setName("messageName").setCorrelationKey("correlationKey").setTimeToLive(1000L).setDeadline(2000L).setVariables(MsgPackUtil.asMsgPack((String)"foo", (Object)"bar")).setMessageId("messageId");
            this.legacyState.put(123L, messageRecord);
            this.sut.runMigration(this.processingState);
            AtomicReference message = new AtomicReference();
            this.messageState.visitMessages("<default>", messageRecord.getNameBuffer(), messageRecord.getCorrelationKeyBuffer(), storedMessage -> {
                message.set(storedMessage);
                return false;
            });
            StoredMessage actualMessage = (StoredMessage)message.get();
            Assertions.assertThat((Object)actualMessage).isNotNull();
            Assertions.assertThat((long)actualMessage.getMessageKey()).isEqualTo(123L);
            Assertions.assertThat((Object)actualMessage.getMessage()).extracting(new Function[]{MessageRecord::getName, MessageRecord::getCorrelationKey, MessageRecord::getTimeToLive, MessageRecord::getDeadline, MessageRecord::getVariables, MessageRecord::getMessageId, MessageRecord::getTenantId}).containsExactly(new Object[]{messageRecord.getName(), messageRecord.getCorrelationKey(), messageRecord.getTimeToLive(), messageRecord.getDeadline(), messageRecord.getVariables(), messageRecord.getMessageId(), "<default>"});
        }
    }

    @Nested
    @ExtendWith(value={ProcessingStateExtension.class})
    class MigrateDecisionStateForMultiTenancyTest {
        final MultiTenancyDecisionStateMigration sut = new MultiTenancyDecisionStateMigration();
        private ZeebeDb<ZbColumnFamilies> zeebeDb;
        private MutableProcessingState processingState;
        private TransactionContext transactionContext;
        private LegacyDecisionState legacyState;
        private DbDecisionState decisionState;

        MigrateDecisionStateForMultiTenancyTest(MultiTenancyMigrationTest this$0) {
        }

        @BeforeEach
        void setup() {
            EngineConfiguration cfg = new EngineConfiguration();
            this.legacyState = new LegacyDecisionState(this.zeebeDb, this.transactionContext, cfg);
            this.decisionState = new DbDecisionState(this.zeebeDb, this.transactionContext, cfg);
        }

        @Test
        void shouldMigrateDecisionsByKeyColumnFamily() {
            this.legacyState.storeDecisionRequirements(new DecisionRequirementsRecord().setDecisionRequirementsId("drgId").setDecisionRequirementsName("drgName").setDecisionRequirementsVersion(1).setDecisionRequirementsKey(123L).setNamespace("namespace").setResourceName("resourceName").setResource(BufferUtil.wrapString((String)"resource")).setChecksum(BufferUtil.wrapString((String)"checksum")));
            this.legacyState.storeDecisionRecord(new DecisionRecord().setDecisionRequirementsId("drgId").setDecisionRequirementsKey(123L).setDecisionId("decisionId").setDecisionName("decisionName").setVersion(1).setDecisionKey(456L).setTenantId(""));
            this.sut.runMigration(this.processingState);
            PersistedDecision persistedDecision = (PersistedDecision)this.decisionState.findDecisionByTenantAndKey("<default>", 456L).orElseThrow();
            Assertions.assertThat((String)BufferUtil.bufferAsString((DirectBuffer)persistedDecision.getDecisionRequirementsId())).isEqualTo("drgId");
            Assertions.assertThat((long)persistedDecision.getDecisionRequirementsKey()).isEqualTo(123L);
            Assertions.assertThat((String)BufferUtil.bufferAsString((DirectBuffer)persistedDecision.getDecisionId())).isEqualTo("decisionId");
            Assertions.assertThat((String)BufferUtil.bufferAsString((DirectBuffer)persistedDecision.getDecisionName())).isEqualTo("decisionName");
            Assertions.assertThat((long)persistedDecision.getDecisionKey()).isEqualTo(456L);
            Assertions.assertThat((int)persistedDecision.getVersion()).isEqualTo(1);
            Assertions.assertThat((String)persistedDecision.getTenantId()).isEqualTo("<default>");
        }

        @Test
        void shouldMigrateDecisionRequirementsByKeyColumnFamily() {
            this.legacyState.storeDecisionRequirements(new DecisionRequirementsRecord().setDecisionRequirementsId("drgId").setDecisionRequirementsName("drgName").setDecisionRequirementsVersion(1).setDecisionRequirementsKey(123L).setNamespace("namespace").setResourceName("resourceName").setResource(BufferUtil.wrapString((String)"resource")).setChecksum(BufferUtil.wrapString((String)"checksum")));
            this.legacyState.storeDecisionRecord(new DecisionRecord().setDecisionRequirementsId("drgId").setDecisionRequirementsKey(123L).setDecisionId("decisionId").setDecisionName("decisionName").setVersion(1).setDecisionKey(456L).setTenantId(""));
            this.sut.runMigration(this.processingState);
            DeployedDrg deployedDrg = (DeployedDrg)this.decisionState.findDecisionRequirementsByTenantAndKey("<default>", 123L).orElseThrow();
            Assertions.assertThat((String)BufferUtil.bufferAsString((DirectBuffer)deployedDrg.getDecisionRequirementsId())).isEqualTo("drgId");
            Assertions.assertThat((long)deployedDrg.getDecisionRequirementsKey()).isEqualTo(123L);
            Assertions.assertThat((String)BufferUtil.bufferAsString((DirectBuffer)deployedDrg.getDecisionRequirementsName())).isEqualTo("drgName");
            Assertions.assertThat((int)deployedDrg.getDecisionRequirementsVersion()).isEqualTo(1);
            Assertions.assertThat((String)BufferUtil.bufferAsString((DirectBuffer)deployedDrg.getResourceName())).isEqualTo("resourceName");
            Assertions.assertThat((String)BufferUtil.bufferAsString((DirectBuffer)deployedDrg.getResource())).isEqualTo("resource");
            Assertions.assertThat((String)BufferUtil.bufferAsString((DirectBuffer)deployedDrg.getChecksum())).isEqualTo("checksum");
            Assertions.assertThat((String)deployedDrg.getTenantId()).isEqualTo("<default>");
        }

        @Test
        void shouldMigrateDecisionKeyByDecisionRequirementsKeyColumnFamily() {
            this.legacyState.storeDecisionRequirements(new DecisionRequirementsRecord().setDecisionRequirementsId("drgId").setDecisionRequirementsName("drgName").setDecisionRequirementsVersion(1).setDecisionRequirementsKey(123L).setNamespace("namespace").setResourceName("resourceName").setResource(BufferUtil.wrapString((String)"resource")).setChecksum(BufferUtil.wrapString((String)"checksum")));
            this.legacyState.storeDecisionRecord(new DecisionRecord().setDecisionRequirementsId("drgId").setDecisionRequirementsKey(123L).setDecisionId("decisionId").setDecisionName("decisionName").setVersion(1).setDecisionKey(456L).setTenantId(""));
            this.sut.runMigration(this.processingState);
            List persistedDecisions = this.decisionState.findDecisionsByTenantAndDecisionRequirementsKey("<default>", 123L);
            Assertions.assertThat((List)persistedDecisions).hasSize(1);
            PersistedDecision persistedDecision = (PersistedDecision)persistedDecisions.get(0);
            Assertions.assertThat((String)BufferUtil.bufferAsString((DirectBuffer)persistedDecision.getDecisionRequirementsId())).isEqualTo("drgId");
            Assertions.assertThat((long)persistedDecision.getDecisionRequirementsKey()).isEqualTo(123L);
            Assertions.assertThat((String)BufferUtil.bufferAsString((DirectBuffer)persistedDecision.getDecisionId())).isEqualTo("decisionId");
            Assertions.assertThat((String)BufferUtil.bufferAsString((DirectBuffer)persistedDecision.getDecisionName())).isEqualTo("decisionName");
            Assertions.assertThat((long)persistedDecision.getDecisionKey()).isEqualTo(456L);
            Assertions.assertThat((int)persistedDecision.getVersion()).isEqualTo(1);
            Assertions.assertThat((String)persistedDecision.getTenantId()).isEqualTo("<default>");
        }

        @Test
        void shouldMigrateLatestDecisionKeysByDecisionIdColumnFamily() {
            this.legacyState.storeDecisionRequirements(new DecisionRequirementsRecord().setDecisionRequirementsId("drgId").setDecisionRequirementsName("drgName").setDecisionRequirementsVersion(1).setDecisionRequirementsKey(123L).setNamespace("namespace").setResourceName("resourceName").setResource(BufferUtil.wrapString((String)"resource")).setChecksum(BufferUtil.wrapString((String)"checksum")));
            this.legacyState.storeDecisionRecord(new DecisionRecord().setDecisionRequirementsId("drgId").setDecisionRequirementsKey(123L).setDecisionId("decisionId").setDecisionName("decisionName").setVersion(1).setDecisionKey(456L).setTenantId(""));
            this.sut.runMigration(this.processingState);
            PersistedDecision persistedDecision = (PersistedDecision)this.decisionState.findLatestDecisionByIdAndTenant(BufferUtil.wrapString((String)"decisionId"), "<default>").orElseThrow();
            Assertions.assertThat((String)BufferUtil.bufferAsString((DirectBuffer)persistedDecision.getDecisionRequirementsId())).isEqualTo("drgId");
            Assertions.assertThat((long)persistedDecision.getDecisionRequirementsKey()).isEqualTo(123L);
            Assertions.assertThat((String)BufferUtil.bufferAsString((DirectBuffer)persistedDecision.getDecisionId())).isEqualTo("decisionId");
            Assertions.assertThat((String)BufferUtil.bufferAsString((DirectBuffer)persistedDecision.getDecisionName())).isEqualTo("decisionName");
            Assertions.assertThat((long)persistedDecision.getDecisionKey()).isEqualTo(456L);
            Assertions.assertThat((int)persistedDecision.getVersion()).isEqualTo(1);
            Assertions.assertThat((String)persistedDecision.getTenantId()).isEqualTo("<default>");
        }

        @Test
        void shouldMigrateLatestDecisionRequirementsKeysByIdColumnFamily() {
            this.legacyState.storeDecisionRequirements(new DecisionRequirementsRecord().setDecisionRequirementsId("drgId").setDecisionRequirementsName("drgName").setDecisionRequirementsVersion(1).setDecisionRequirementsKey(123L).setNamespace("namespace").setResourceName("resourceName").setResource(BufferUtil.wrapString((String)"resource")).setChecksum(BufferUtil.wrapString((String)"checksum")));
            this.legacyState.storeDecisionRecord(new DecisionRecord().setDecisionRequirementsId("drgId").setDecisionRequirementsKey(123L).setDecisionId("decisionId").setDecisionName("decisionName").setVersion(1).setDecisionKey(456L).setTenantId(""));
            this.sut.runMigration(this.processingState);
            DeployedDrg deployedDrg = (DeployedDrg)this.decisionState.findLatestDecisionRequirementsByTenantAndId("<default>", BufferUtil.wrapString((String)"drgId")).orElseThrow();
            Assertions.assertThat((String)BufferUtil.bufferAsString((DirectBuffer)deployedDrg.getDecisionRequirementsId())).isEqualTo("drgId");
            Assertions.assertThat((long)deployedDrg.getDecisionRequirementsKey()).isEqualTo(123L);
            Assertions.assertThat((String)BufferUtil.bufferAsString((DirectBuffer)deployedDrg.getDecisionRequirementsName())).isEqualTo("drgName");
            Assertions.assertThat((int)deployedDrg.getDecisionRequirementsVersion()).isEqualTo(1);
            Assertions.assertThat((String)BufferUtil.bufferAsString((DirectBuffer)deployedDrg.getResourceName())).isEqualTo("resourceName");
            Assertions.assertThat((String)BufferUtil.bufferAsString((DirectBuffer)deployedDrg.getResource())).isEqualTo("resource");
            Assertions.assertThat((String)BufferUtil.bufferAsString((DirectBuffer)deployedDrg.getChecksum())).isEqualTo("checksum");
            Assertions.assertThat((String)deployedDrg.getTenantId()).isEqualTo("<default>");
        }

        @Test
        void shouldMigrateDecisionKeyByDecisionIdAndVersionColumnFamily() {
            this.legacyState.storeDecisionRequirements(new DecisionRequirementsRecord().setDecisionRequirementsId("drgId").setDecisionRequirementsName("drgName").setDecisionRequirementsVersion(1).setDecisionRequirementsKey(123L).setNamespace("namespace").setResourceName("resourceName").setResource(BufferUtil.wrapString((String)"resource")).setChecksum(BufferUtil.wrapString((String)"checksum")));
            this.legacyState.storeDecisionRecord(new DecisionRecord().setDecisionRequirementsId("drgId").setDecisionRequirementsKey(123L).setDecisionId("decisionId").setDecisionName("decisionName").setVersion(1).setDecisionKey(456L).setTenantId(""));
            DecisionRequirementsRecord drgV2 = new DecisionRequirementsRecord().setDecisionRequirementsId("drgId").setDecisionRequirementsName("drgName").setDecisionRequirementsVersion(2).setDecisionRequirementsKey(234L).setNamespace("namespace").setResourceName("resourceName").setResource(BufferUtil.wrapString((String)"resource2")).setChecksum(BufferUtil.wrapString((String)"checksum2"));
            this.legacyState.storeDecisionRequirements(drgV2);
            DecisionRecord decisionV2 = new DecisionRecord().setDecisionRequirementsId("drgId").setDecisionRequirementsKey(234L).setDecisionId("decisionId").setDecisionName("decisionName").setVersion(2).setDecisionKey(567L).setTenantId("");
            this.legacyState.storeDecisionRecord(decisionV2);
            this.sut.runMigration(this.processingState);
            this.decisionState.deleteDecision(decisionV2.setTenantId("<default>"));
            this.decisionState.deleteDecisionRequirements(drgV2.setTenantId("<default>"));
            PersistedDecision persistedDecision = (PersistedDecision)this.decisionState.findLatestDecisionByIdAndTenant(BufferUtil.wrapString((String)"decisionId"), "<default>").orElseThrow();
            Assertions.assertThat((String)BufferUtil.bufferAsString((DirectBuffer)persistedDecision.getDecisionRequirementsId())).isEqualTo("drgId");
            Assertions.assertThat((long)persistedDecision.getDecisionRequirementsKey()).isEqualTo(123L);
            Assertions.assertThat((String)BufferUtil.bufferAsString((DirectBuffer)persistedDecision.getDecisionId())).isEqualTo("decisionId");
            Assertions.assertThat((String)BufferUtil.bufferAsString((DirectBuffer)persistedDecision.getDecisionName())).isEqualTo("decisionName");
            Assertions.assertThat((long)persistedDecision.getDecisionKey()).isEqualTo(456L);
            Assertions.assertThat((int)persistedDecision.getVersion()).isEqualTo(1);
            Assertions.assertThat((String)persistedDecision.getTenantId()).isEqualTo("<default>");
        }
    }

    @Nested
    @ExtendWith(value={ProcessingStateExtension.class})
    class MigrateProcessStateForMultiTenancyTest {
        final MultiTenancyProcessStateMigration sut = new MultiTenancyProcessStateMigration();
        private ZeebeDb<ZbColumnFamilies> zeebeDb;
        private MutableProcessingState processingState;
        private TransactionContext transactionContext;
        private LegacyProcessState legacyState;
        private DbProcessState processState;

        MigrateProcessStateForMultiTenancyTest(MultiTenancyMigrationTest this$0) {
        }

        @BeforeEach
        void setup() {
            this.legacyState = new LegacyProcessState(this.zeebeDb, this.transactionContext);
            this.processState = new DbProcessState(this.zeebeDb, this.transactionContext);
        }

        @Test
        void shouldMigrateProcessColumnFamily() {
            BpmnModelInstance model = Bpmn.createExecutableProcess((String)"processId").startEvent().done();
            this.legacyState.putProcess(123L, new ProcessRecord().setKey(123L).setBpmnProcessId("processId").setVersion(1).setResourceName("resourceName").setResource(BufferUtil.wrapString((String)Bpmn.convertToString((BpmnModelInstance)model))).setChecksum(BufferUtil.wrapString((String)"checksum")));
            this.sut.runMigration(this.processingState);
            this.assertProcessPersisted(this.processState.getProcessByKeyAndTenant(123L, "<default>"), new PersistedProcess("processId", 1, PersistedProcess.PersistedProcessState.ACTIVE, "resourceName", "<default>", model));
            Assertions.assertThat((Object)this.legacyState.getProcessByKey(123L)).isNull();
        }

        @Test
        void shouldMigrateProcessByIdAndVersionColumnFamily() {
            BpmnModelInstance model = Bpmn.createExecutableProcess((String)"processId").startEvent().done();
            this.legacyState.putProcess(123L, new ProcessRecord().setKey(123L).setBpmnProcessId("processId").setVersion(1).setResourceName("resourceName").setResource(BufferUtil.wrapString((String)Bpmn.convertToString((BpmnModelInstance)model))).setChecksum(BufferUtil.wrapString((String)"checksum")));
            this.sut.runMigration(this.processingState);
            this.assertProcessPersisted(this.processState.getProcessByProcessIdAndVersion(BufferUtil.wrapString((String)"processId"), 1, "<default>"), new PersistedProcess("processId", 1, PersistedProcess.PersistedProcessState.ACTIVE, "resourceName", "<default>", model));
            Assertions.assertThat((Object)this.legacyState.getProcessByProcessIdAndVersion(BufferUtil.wrapString((String)"processId"), 1)).isNull();
        }

        @Test
        void shouldMigrateProcessByIdAndVersionColumnFamilyUsingVersionManager() {
            BpmnModelInstance model = Bpmn.createExecutableProcess((String)"processId").startEvent().done();
            this.legacyState.putProcess(123L, new ProcessRecord().setKey(123L).setBpmnProcessId("processId").setVersion(1).setResourceName("resourceName").setResource(BufferUtil.wrapString((String)Bpmn.convertToString((BpmnModelInstance)model))).setChecksum(BufferUtil.wrapString((String)"checksum")));
            this.sut.runMigration(this.processingState);
            this.assertProcessPersisted(this.processState.getLatestProcessVersionByProcessId(BufferUtil.wrapString((String)"processId"), "<default>"), new PersistedProcess("processId", 1, PersistedProcess.PersistedProcessState.ACTIVE, "resourceName", "<default>", model));
            Assertions.assertThat((Object)this.legacyState.getLatestProcessVersionByProcessId(BufferUtil.wrapString((String)"processId"))).isNull();
        }

        @Test
        void shouldMigrateDigestByIdColumnFamily() {
            BpmnModelInstance model = Bpmn.createExecutableProcess((String)"processId").startEvent().done();
            this.legacyState.putProcess(123L, new ProcessRecord().setKey(123L).setBpmnProcessId("processId").setVersion(1).setResourceName("resourceName").setResource(BufferUtil.wrapString((String)Bpmn.convertToString((BpmnModelInstance)model))).setChecksum(BufferUtil.wrapString((String)"checksum")));
            this.sut.runMigration(this.processingState);
            Assertions.assertThat((Comparable)this.processState.getLatestVersionDigest(BufferUtil.wrapString((String)"processId"), "<default>")).extracting(BufferUtil::bufferAsString).isEqualTo((Object)"checksum");
            Assertions.assertThat((Comparable)this.legacyState.getLatestVersionDigest(BufferUtil.wrapString((String)"processId"))).isNull();
        }

        void assertProcessPersisted(DeployedProcess actual, PersistedProcess expected) {
            Assertions.assertThat((Object)actual).extracting(new Function[]{p -> BufferUtil.bufferAsString((DirectBuffer)p.getBpmnProcessId()), DeployedProcess::getVersion, DeployedProcess::getState, p -> BufferUtil.bufferAsString((DirectBuffer)p.getResourceName()), DeployedProcess::getTenantId, p -> BufferUtil.bufferAsString((DirectBuffer)p.getResource())}).containsExactly(new Object[]{expected.bpmnProcessId(), expected.version(), expected.state(), expected.resourceName(), expected.tenantId(), Bpmn.convertToString((BpmnModelInstance)expected.model())});
        }

        record PersistedProcess(String bpmnProcessId, int version, PersistedProcess.PersistedProcessState state, String resourceName, String tenantId, BpmnModelInstance model) {
        }
    }
}

