/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.variable;

import io.camunda.zeebe.engine.state.immutable.VariableState;
import io.camunda.zeebe.engine.state.instance.ElementInstance;
import io.camunda.zeebe.engine.state.mutable.MutableElementInstanceState;
import io.camunda.zeebe.engine.state.mutable.MutableProcessingState;
import io.camunda.zeebe.engine.state.mutable.MutableVariableState;
import io.camunda.zeebe.engine.state.variable.VariableInstance;
import io.camunda.zeebe.engine.util.ProcessingStateRule;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.stream.api.records.TypedRecord;
import io.camunda.zeebe.test.util.MsgPackUtil;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.agrona.DirectBuffer;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.groups.Tuple;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Mockito;

public final class VariableStateTest {
    @ClassRule
    public static final ProcessingStateRule ZEEBE_STATE_RULE = new ProcessingStateRule();
    private static final long PROCESS_KEY = 123L;
    private static final AtomicLong PARENT_KEY = new AtomicLong(0L);
    private static final AtomicLong CHILD_KEY = new AtomicLong(1L);
    private static final AtomicLong SECOND_CHILD_KEY = new AtomicLong(2L);
    private static final AtomicLong KEY_GENERATOR = new AtomicLong();
    private static MutableElementInstanceState elementInstanceState;
    private static MutableVariableState variableState;
    private long parent;
    private long child;
    private long child2;

    @BeforeClass
    public static void setUp() {
        MutableProcessingState processingState = ZEEBE_STATE_RULE.getProcessingState();
        elementInstanceState = processingState.getElementInstanceState();
        variableState = processingState.getVariableState();
    }

    @Before
    public void beforeTest() {
        this.parent = PARENT_KEY.getAndIncrement();
        this.child = CHILD_KEY.getAndIncrement();
        this.child2 = SECOND_CHILD_KEY.getAndIncrement();
    }

    @After
    public void cleanUp() {
        elementInstanceState.removeInstance(this.child2);
        elementInstanceState.removeInstance(this.child);
        elementInstanceState.removeInstance(this.parent);
    }

    @Test
    public void shouldCollectVariablesAsDocument() {
        this.declareScope(this.parent);
        DirectBuffer var1Value = MsgPackUtil.asMsgPack((String)"a", (Object)1);
        this.setVariableLocal(this.parent, BufferUtil.wrapString((String)"var1"), var1Value);
        DirectBuffer var2Value = MsgPackUtil.asMsgPack((String)"x", (Object)10);
        this.setVariableLocal(this.parent, BufferUtil.wrapString((String)"var2"), var2Value);
        DirectBuffer variablesDocument = variableState.getVariablesAsDocument(this.parent);
        MsgPackUtil.assertEquality((DirectBuffer)variablesDocument, (String)"{'var1': {'a': 1}, 'var2': {'x': 10}}");
    }

    @Test
    public void shouldCollectNoVariablesAsEmptyDocument() {
        this.declareScope(this.parent);
        DirectBuffer variablesDocument = variableState.getVariablesAsDocument(this.parent);
        MsgPackUtil.assertEquality((DirectBuffer)variablesDocument, (String)"{}");
    }

    @Test
    public void shouldCollectVariablesFromMultipleScopes() {
        long grandparent = this.parent;
        long parent = this.child;
        long child = this.child2;
        this.declareScope(grandparent);
        this.declareScope(grandparent, parent);
        this.declareScope(parent, child);
        this.setVariableLocal(grandparent, BufferUtil.wrapString((String)"a"), MsgPackUtil.asMsgPack((String)"1"));
        this.setVariableLocal(parent, BufferUtil.wrapString((String)"b"), MsgPackUtil.asMsgPack((String)"2"));
        this.setVariableLocal(child, BufferUtil.wrapString((String)"c"), MsgPackUtil.asMsgPack((String)"3"));
        DirectBuffer variablesDocument = variableState.getVariablesAsDocument(child);
        MsgPackUtil.assertEquality((DirectBuffer)variablesDocument, (String)"{'a': 1, 'b': 2, 'c': 3}");
    }

    @Test
    public void shouldNotCollectHiddenVariables() {
        this.declareScope(this.parent);
        this.declareScope(this.parent, this.child);
        this.setVariableLocal(this.parent, BufferUtil.wrapString((String)"a"), MsgPackUtil.asMsgPack((String)"1"));
        this.setVariableLocal(this.parent, BufferUtil.wrapString((String)"b"), MsgPackUtil.asMsgPack((String)"2"));
        this.setVariableLocal(this.child, BufferUtil.wrapString((String)"b"), MsgPackUtil.asMsgPack((String)"3"));
        DirectBuffer variablesDocument = variableState.getVariablesAsDocument(this.child);
        MsgPackUtil.assertEquality((DirectBuffer)variablesDocument, (String)"{'a': 1, 'b': 3}");
    }

    @Test
    public void shouldNotCollectVariablesFromChildScope() {
        this.declareScope(this.parent);
        this.declareScope(this.parent, this.child);
        this.setVariableLocal(this.parent, BufferUtil.wrapString((String)"a"), MsgPackUtil.asMsgPack((String)"1"));
        this.setVariableLocal(this.child, BufferUtil.wrapString((String)"b"), MsgPackUtil.asMsgPack((String)"3"));
        DirectBuffer variablesDocument = variableState.getVariablesAsDocument(this.parent);
        MsgPackUtil.assertEquality((DirectBuffer)variablesDocument, (String)"{'a': 1}");
    }

    @Test
    public void shouldNotCollectVariablesInSiblingScope() {
        this.declareScope(this.parent);
        this.declareScope(this.parent, this.child);
        this.declareScope(this.parent, this.child2);
        this.setVariableLocal(this.parent, BufferUtil.wrapString((String)"a"), MsgPackUtil.asMsgPack((String)"1"));
        this.setVariableLocal(this.child, BufferUtil.wrapString((String)"b"), MsgPackUtil.asMsgPack((String)"2"));
        this.setVariableLocal(this.child2, BufferUtil.wrapString((String)"c"), MsgPackUtil.asMsgPack((String)"3"));
        DirectBuffer variablesDocument = variableState.getVariablesAsDocument(this.child);
        MsgPackUtil.assertEquality((DirectBuffer)variablesDocument, (String)"{'a': 1, 'b': 2}");
    }

    @Test
    public void shouldCollectLocalVariables() {
        this.declareScope(this.parent);
        this.declareScope(this.parent, this.child);
        this.setVariableLocal(this.parent, BufferUtil.wrapString((String)"a"), MsgPackUtil.asMsgPack((String)"1"));
        this.setVariableLocal(this.child, BufferUtil.wrapString((String)"b"), MsgPackUtil.asMsgPack((String)"3"));
        MsgPackUtil.assertEquality((DirectBuffer)variableState.getVariablesLocalAsDocument(this.parent), (String)"{'a': 1}");
        MsgPackUtil.assertEquality((DirectBuffer)variableState.getVariablesLocalAsDocument(this.child), (String)"{'b': 3}");
    }

    @Test
    public void shouldCollectVariablesByName() {
        this.declareScope(this.parent);
        this.setVariableLocal(this.parent, BufferUtil.wrapString((String)"a"), MsgPackUtil.asMsgPack((String)"1"));
        this.setVariableLocal(this.parent, BufferUtil.wrapString((String)"b"), MsgPackUtil.asMsgPack((String)"2"));
        this.setVariableLocal(this.parent, BufferUtil.wrapString((String)"c"), MsgPackUtil.asMsgPack((String)"3"));
        DirectBuffer variablesDocument = variableState.getVariablesAsDocument(this.parent, Arrays.asList(BufferUtil.wrapString((String)"a"), BufferUtil.wrapString((String)"c")));
        MsgPackUtil.assertEquality((DirectBuffer)variablesDocument, (String)"{'a': 1, 'c': 3}");
    }

    @Test
    public void shouldCollectVariablesByNameFromMultipleScopes() {
        this.declareScope(this.parent);
        this.declareScope(this.parent, this.child);
        this.declareScope(this.child, this.child2);
        this.setVariableLocal(this.parent, BufferUtil.wrapString((String)"a"), MsgPackUtil.asMsgPack((String)"1"));
        this.setVariableLocal(this.child, BufferUtil.wrapString((String)"b"), MsgPackUtil.asMsgPack((String)"2"));
        this.setVariableLocal(this.child2, BufferUtil.wrapString((String)"c"), MsgPackUtil.asMsgPack((String)"3"));
        DirectBuffer variablesDocument = variableState.getVariablesAsDocument(this.child2, Arrays.asList(BufferUtil.wrapString((String)"a"), BufferUtil.wrapString((String)"c")));
        MsgPackUtil.assertEquality((DirectBuffer)variablesDocument, (String)"{'a': 1, 'c': 3}");
    }

    @Test
    public void shouldCollectOnlyExistingVariablesByName() {
        this.declareScope(this.parent);
        this.setVariableLocal(this.parent, BufferUtil.wrapString((String)"a"), MsgPackUtil.asMsgPack((String)"1"));
        DirectBuffer variablesDocument = variableState.getVariablesAsDocument(this.parent, Arrays.asList(BufferUtil.wrapString((String)"a"), BufferUtil.wrapString((String)"c")));
        MsgPackUtil.assertEquality((DirectBuffer)variablesDocument, (String)"{'a': 1}");
    }

    @Test
    public void shouldSetLocalVariable() {
        this.declareScope(this.parent);
        long keyVarA = this.setVariableLocal(this.parent, BufferUtil.wrapString((String)"a"), MsgPackUtil.asMsgPack((String)"1"));
        long keyVarB = this.setVariableLocal(this.parent, BufferUtil.wrapString((String)"b"), MsgPackUtil.asMsgPack((String)"2"));
        VariableInstance varA = variableState.getVariableInstanceLocal(this.parent, BufferUtil.wrapString((String)"a"));
        Assertions.assertThat((long)varA.getKey()).isEqualTo(keyVarA);
        MsgPackUtil.assertEquality((DirectBuffer)varA.getValue(), (String)"1");
        VariableInstance varB = variableState.getVariableInstanceLocal(this.parent, BufferUtil.wrapString((String)"b"));
        Assertions.assertThat((long)varB.getKey()).isEqualTo(keyVarB);
        MsgPackUtil.assertEquality((DirectBuffer)varB.getValue(), (String)"2");
    }

    @Test
    public void shouldGetNullForNonExistingVariable() {
        this.declareScope(this.parent);
        DirectBuffer variableValue = variableState.getVariableLocal(this.parent, BufferUtil.wrapString((String)"a"));
        Assertions.assertThat((Comparable)variableValue).isNull();
    }

    @Test
    public void shouldRemoveAllVariablesForScope() {
        this.declareScope(this.parent);
        this.declareScope(this.parent, this.child);
        this.setVariableLocal(this.parent, BufferUtil.wrapString((String)"parentVar1"), MsgPackUtil.asMsgPack((String)"1"));
        this.setVariableLocal(this.child, BufferUtil.wrapString((String)"childVar1"), MsgPackUtil.asMsgPack((String)"2"));
        this.setVariableLocal(this.child, BufferUtil.wrapString((String)"childVar2"), MsgPackUtil.asMsgPack((String)"3"));
        variableState.removeAllVariables(this.child);
        DirectBuffer document = variableState.getVariablesAsDocument(this.child);
        MsgPackUtil.assertEquality((DirectBuffer)document, (String)"{'parentVar1': 1}");
    }

    @Test
    public void shouldRemoveScope() {
        this.declareScope(this.parent);
        this.declareScope(this.parent, this.child);
        this.setVariableLocal(this.parent, BufferUtil.wrapString((String)"parentVar1"), MsgPackUtil.asMsgPack((String)"1"));
        this.setVariableLocal(this.child, BufferUtil.wrapString((String)"childVar1"), MsgPackUtil.asMsgPack((String)"2"));
        this.setVariableLocal(this.child, BufferUtil.wrapString((String)"childVar2"), MsgPackUtil.asMsgPack((String)"3"));
        variableState.removeScope(this.child);
        DirectBuffer document = variableState.getVariablesAsDocument(this.child);
        MsgPackUtil.assertEquality((DirectBuffer)document, (String)"{}");
    }

    @Test
    public void shouldReturnParentScopeKey() {
        this.declareScope(this.parent);
        this.declareScope(this.parent, this.child);
        long parentScopeKey = variableState.getParentScopeKey(this.child);
        Assertions.assertThat((long)parentScopeKey).isEqualTo(this.parent);
    }

    @Test
    public void shouldReturnNoParentForRootScopeKey() {
        this.declareScope(this.parent);
        long parentScopeKey = variableState.getParentScopeKey(this.parent);
        Assertions.assertThat((long)parentScopeKey).isEqualTo(-1L);
    }

    @Test
    public void shouldGetVariableByName() {
        this.declareScope(this.parent);
        this.declareScope(this.parent, this.child);
        this.declareScope(this.child, this.child2);
        this.setVariableLocal(this.parent, BufferUtil.wrapString((String)"a"), MsgPackUtil.asMsgPack((String)"1"));
        this.setVariableLocal(this.child, BufferUtil.wrapString((String)"b"), MsgPackUtil.asMsgPack((String)"2"));
        this.setVariableLocal(this.child2, BufferUtil.wrapString((String)"c"), MsgPackUtil.asMsgPack((String)"3"));
        DirectBuffer variableFromLocalScope = BufferUtil.cloneBuffer((DirectBuffer)variableState.getVariable(this.child2, BufferUtil.wrapString((String)"c")));
        DirectBuffer variableFromParentScope = BufferUtil.cloneBuffer((DirectBuffer)variableState.getVariable(this.child2, BufferUtil.wrapString((String)"b")));
        DirectBuffer variableFromRootScope = BufferUtil.cloneBuffer((DirectBuffer)variableState.getVariable(this.child2, BufferUtil.wrapString((String)"a")));
        DirectBuffer variableFromChildScope = variableState.getVariable(this.parent, BufferUtil.wrapString((String)"b"));
        MsgPackUtil.assertEquality((DirectBuffer)variableFromLocalScope, (String)"3");
        MsgPackUtil.assertEquality((DirectBuffer)variableFromParentScope, (String)"2");
        MsgPackUtil.assertEquality((DirectBuffer)variableFromRootScope, (String)"1");
        Assertions.assertThat((Comparable)variableFromChildScope).isNull();
    }

    @Test
    public void shouldNotGetVariableInstanceLocal() {
        this.declareScope(this.parent);
        this.declareScope(this.parent, this.child);
        this.setVariableLocal(this.parent, BufferUtil.wrapString((String)"x"), BufferUtil.wrapString((String)"foo"));
        this.setVariableLocal(this.child, BufferUtil.wrapString((String)"y"), BufferUtil.wrapString((String)"foo"));
        VariableInstance variable = variableState.getVariableInstanceLocal(this.child, BufferUtil.wrapString((String)"x"));
        Assertions.assertThat((Object)variable).isNull();
    }

    @Test
    public void shouldGetVariableInstanceLocal() {
        this.declareScope(this.parent);
        this.declareScope(this.parent, this.child);
        long expectedKey = this.setVariableLocal(this.parent, BufferUtil.wrapString((String)"x"), BufferUtil.wrapString((String)"foo"));
        this.setVariableLocal(this.child, BufferUtil.wrapString((String)"x"), BufferUtil.wrapString((String)"foo"));
        VariableInstance variable = variableState.getVariableInstanceLocal(this.parent, BufferUtil.wrapString((String)"x"));
        Assertions.assertThat((Object)variable).isNotNull();
        Assertions.assertThat((Comparable)variable.getValue()).isEqualTo((Object)BufferUtil.wrapString((String)"foo"));
        Assertions.assertThat((long)variable.getKey()).isEqualTo(expectedKey);
    }

    @Test
    public void shouldNotGetVariableInstanceLocalIfScopeDoesNotExist() {
        long scopeKey = this.child + 1L;
        this.declareScope(scopeKey);
        this.setVariableLocal(scopeKey, BufferUtil.wrapString((String)"x"), BufferUtil.wrapString((String)"foo"));
        variableState.removeScope(scopeKey);
        VariableInstance variable = variableState.getVariableInstanceLocal(scopeKey, BufferUtil.wrapString((String)"x"));
        Assertions.assertThat((Object)variable).isNull();
    }

    @Test
    public void shouldGetVariablesLocalAtGlobalScope() {
        this.declareScope(this.parent);
        long keyVariableA = this.setVariableLocal(this.parent, BufferUtil.wrapString((String)"a"), BufferUtil.wrapString((String)"1"));
        long keyVariableB = this.setVariableLocal(this.parent, BufferUtil.wrapString((String)"b"), BufferUtil.wrapString((String)"2"));
        long keyVariableC = this.setVariableLocal(this.parent, BufferUtil.wrapString((String)"c"), BufferUtil.wrapString((String)"3"));
        List variablesLocal = variableState.getVariablesLocal(this.parent);
        ((ListAssert)Assertions.assertThat((List)variablesLocal).hasSize(3)).extracting(new Function[]{VariableState.Variable::key, VariableState.Variable::scopeKey, VariableState.Variable::name, VariableState.Variable::value}).containsExactlyInAnyOrder((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{keyVariableA, this.parent, BufferUtil.wrapString((String)"a"), BufferUtil.wrapString((String)"1")}), Assertions.tuple((Object[])new Object[]{keyVariableB, this.parent, BufferUtil.wrapString((String)"b"), BufferUtil.wrapString((String)"2")}), Assertions.tuple((Object[])new Object[]{keyVariableC, this.parent, BufferUtil.wrapString((String)"c"), BufferUtil.wrapString((String)"3")})});
    }

    @Test
    public void shouldGetVariablesLocalAtLocalScopeOnly() {
        this.declareScope(this.parent);
        this.declareScope(this.parent, this.child);
        this.declareScope(this.child, this.child2);
        this.setVariableLocal(this.parent, BufferUtil.wrapString((String)"a"), BufferUtil.wrapString((String)"1"));
        long keyVariableB = this.setVariableLocal(this.child, BufferUtil.wrapString((String)"b"), BufferUtil.wrapString((String)"2"));
        long keyVariableC = this.setVariableLocal(this.child, BufferUtil.wrapString((String)"c"), BufferUtil.wrapString((String)"3"));
        this.setVariableLocal(this.child2, BufferUtil.wrapString((String)"d"), BufferUtil.wrapString((String)"4"));
        List variablesLocal = variableState.getVariablesLocal(this.child);
        ((ListAssert)Assertions.assertThat((List)variablesLocal).hasSize(2)).extracting(new Function[]{VariableState.Variable::key, VariableState.Variable::scopeKey, VariableState.Variable::name, VariableState.Variable::value}).describedAs("Expected to encounter only the variables scoped at the child scope", new Object[0]).containsExactlyInAnyOrder((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{keyVariableB, this.child, BufferUtil.wrapString((String)"b"), BufferUtil.wrapString((String)"2")}), Assertions.tuple((Object[])new Object[]{keyVariableC, this.child, BufferUtil.wrapString((String)"c"), BufferUtil.wrapString((String)"3")})});
    }

    private void declareScope(long key) {
        this.declareScope(-1L, key);
    }

    private void declareScope(long parentKey, long key) {
        ElementInstance parent = elementInstanceState.getInstance(parentKey);
        TypedRecord<ProcessInstanceRecord> record = this.mockTypedRecord(key, parentKey);
        elementInstanceState.newInstance(parent, key, (ProcessInstanceRecord)record.getValue(), ProcessInstanceIntent.ELEMENT_ACTIVATING);
    }

    private TypedRecord<ProcessInstanceRecord> mockTypedRecord(long key, long parentKey) {
        ProcessInstanceRecord processInstanceRecord = this.createProcessInstanceRecord(parentKey);
        TypedRecord typedRecord = (TypedRecord)Mockito.mock(TypedRecord.class);
        Mockito.when((Object)typedRecord.getKey()).thenReturn((Object)key);
        Mockito.when((Object)((ProcessInstanceRecord)typedRecord.getValue())).thenReturn((Object)processInstanceRecord);
        return typedRecord;
    }

    private ProcessInstanceRecord createProcessInstanceRecord(long parentKey) {
        ProcessInstanceRecord processInstanceRecord = new ProcessInstanceRecord();
        if (parentKey >= 0L) {
            processInstanceRecord.setFlowScopeKey(parentKey);
        }
        return processInstanceRecord;
    }

    public long setVariableLocal(long scopeKey, DirectBuffer name, DirectBuffer value) {
        long key = KEY_GENERATOR.incrementAndGet();
        variableState.setVariableLocal(key, scopeKey, 123L, name, value);
        return key;
    }
}

