/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.util;

import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.engine.EngineConfiguration;
import io.camunda.zeebe.engine.state.DefaultZeebeDbFactory;
import io.camunda.zeebe.engine.state.ProcessingDbState;
import io.camunda.zeebe.engine.state.message.TransientPendingSubscriptionState;
import io.camunda.zeebe.engine.state.mutable.MutableProcessingState;
import io.camunda.zeebe.protocol.ZbColumnFamilies;
import io.camunda.zeebe.stream.api.state.KeyGenerator;
import io.camunda.zeebe.stream.impl.state.DbKeyGenerator;
import org.junit.rules.ExternalResource;
import org.junit.rules.TemporaryFolder;

public final class ProcessingStateRule
extends ExternalResource {
    private final TemporaryFolder tempFolder = new TemporaryFolder();
    private final int partition;
    private ZeebeDb<ZbColumnFamilies> db;
    private MutableProcessingState processingState;

    public ProcessingStateRule() {
        this(1);
    }

    public ProcessingStateRule(int partition) {
        this.partition = partition;
    }

    protected void before() throws Throwable {
        this.tempFolder.create();
        this.db = this.createNewDb();
        TransactionContext context = this.db.createContext();
        DbKeyGenerator keyGenerator = new DbKeyGenerator(this.partition, this.db, context);
        this.processingState = new ProcessingDbState(this.partition, this.db, context, (KeyGenerator)keyGenerator, new TransientPendingSubscriptionState(), new TransientPendingSubscriptionState(), new EngineConfiguration());
    }

    protected void after() {
        try {
            this.db.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.tempFolder.delete();
    }

    public MutableProcessingState getProcessingState() {
        return this.processingState;
    }

    public ZeebeDb<ZbColumnFamilies> createNewDb() {
        try {
            return DefaultZeebeDbFactory.defaultFactory().createDb(this.tempFolder.newFolder());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

