/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.util;

import io.camunda.zeebe.logstreams.log.LoggedEvent;
import io.camunda.zeebe.stream.api.records.TypedRecord;
import io.camunda.zeebe.stream.impl.StreamProcessorListener;
import java.util.Collections;
import java.util.List;

final class StreamProcessorListenerRelay
implements StreamProcessorListener {
    private final List<StreamProcessorListener> delegates;

    StreamProcessorListenerRelay(List<StreamProcessorListener> delegates) {
        this.delegates = Collections.unmodifiableList(delegates);
    }

    public void onProcessed(TypedRecord<?> processedCommand) {
        this.delegates.forEach(l -> l.onProcessed(processedCommand));
    }

    public void onSkipped(LoggedEvent skippedRecord) {
        this.delegates.forEach(l -> l.onSkipped(skippedRecord));
    }
}

