/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.util;

import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.test.util.stream.StreamWrapper;
import java.util.stream.Stream;

public final class TypedRecordStream<T extends UnifiedRecordValue>
extends StreamWrapper<Record<T>, TypedRecordStream<T>> {
    public TypedRecordStream(Stream<Record<T>> wrappedStream) {
        super(wrappedStream);
    }

    protected TypedRecordStream<T> supply(Stream<Record<T>> wrappedStream) {
        return new TypedRecordStream<T>(wrappedStream);
    }

    public TypedRecordStream<T> onlyCommands() {
        return new TypedRecordStream<T>(this.filter(r -> r.getRecordType() == RecordType.COMMAND));
    }

    public TypedRecordStream<T> onlyEvents() {
        return new TypedRecordStream<T>(this.filter(r -> r.getRecordType() == RecordType.EVENT));
    }

    public TypedRecordStream<T> onlyRejections() {
        return new TypedRecordStream<T>(this.filter(r -> r.getRecordType() == RecordType.COMMAND_REJECTION));
    }

    public TypedRecordStream<T> withIntent(Intent intent) {
        return new TypedRecordStream<T>(this.filter(r -> r.getIntent() == intent));
    }
}

