/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.util.client;

import io.camunda.zeebe.engine.util.client.CommandWriter;
import io.camunda.zeebe.protocol.impl.encoding.MsgPackConverter;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.impl.record.value.job.JobRecord;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.protocol.record.value.JobRecordValue;
import io.camunda.zeebe.test.util.MsgPackUtil;
import io.camunda.zeebe.test.util.record.JobRecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class JobClient {
    private static final long DEFAULT_KEY = -1L;
    private static final Function<Long, Record<JobRecordValue>> SUCCESS_SUPPLIER = position -> (Record)((JobRecordStream)RecordingExporter.jobRecords().withSourceRecordPosition(position.longValue())).getFirst();
    private static final Function<Long, Record<JobRecordValue>> REJECTION_SUPPLIER = position -> (Record)((JobRecordStream)((JobRecordStream)RecordingExporter.jobRecords().onlyCommandRejections()).withSourceRecordPosition(position.longValue())).getFirst();
    private final JobRecord jobRecord;
    private final CommandWriter writer;
    private long processInstanceKey;
    private long jobKey = -1L;
    private List<String> authorizedTenantIds = List.of("<default>");
    private Function<Long, Record<JobRecordValue>> expectation = SUCCESS_SUPPLIER;

    public JobClient(CommandWriter writer) {
        this.writer = writer;
        this.jobRecord = new JobRecord();
    }

    public JobClient ofInstance(long processInstanceKey) {
        this.processInstanceKey = processInstanceKey;
        return this;
    }

    public JobClient withType(String jobType) {
        this.jobRecord.setType(jobType);
        return this;
    }

    public JobClient withKey(long jobKey) {
        this.jobKey = jobKey;
        return this;
    }

    public JobClient withVariables(String variables) {
        this.jobRecord.setVariables((DirectBuffer)new UnsafeBuffer(MsgPackConverter.convertToMsgPack((String)variables)));
        return this;
    }

    public JobClient withVariables(DirectBuffer variables) {
        this.jobRecord.setVariables(variables);
        return this;
    }

    public JobClient withVariable(String key, Object value) {
        this.jobRecord.setVariables(MsgPackUtil.asMsgPack((String)key, (Object)value));
        return this;
    }

    public JobClient withVariables(Map<String, Object> variables) {
        this.jobRecord.setVariables(MsgPackUtil.asMsgPack(variables));
        return this;
    }

    public JobClient withRetries(int retries) {
        this.jobRecord.setRetries(retries);
        return this;
    }

    public JobClient withTimeout(long timeout) {
        this.jobRecord.setTimeout(timeout);
        return this;
    }

    public JobClient withBackOff(Duration backOff) {
        this.jobRecord.setRetryBackoff(backOff.toMillis());
        return this;
    }

    public JobClient withErrorMessage(String errorMessage) {
        this.jobRecord.setErrorMessage(errorMessage);
        return this;
    }

    public JobClient withErrorCode(String errorCode) {
        this.jobRecord.setErrorCode(BufferUtil.wrapString((String)errorCode));
        return this;
    }

    public JobClient withAuthorizedTenantIds(String ... tenantIds) {
        this.authorizedTenantIds = List.of(tenantIds);
        return this;
    }

    public JobClient expectRejection() {
        this.expectation = REJECTION_SUPPLIER;
        return this;
    }

    private long findJobKey() {
        if (this.jobKey == -1L) {
            Record createdJob = (Record)((JobRecordStream)RecordingExporter.jobRecords().withType(this.jobRecord.getType()).withIntent((Intent)JobIntent.CREATED)).withProcessInstanceKey(this.processInstanceKey).getFirst();
            return createdJob.getKey();
        }
        return this.jobKey;
    }

    public Record<JobRecordValue> complete() {
        long jobKey = this.findJobKey();
        long position = this.writer.writeCommand(jobKey, (Intent)JobIntent.COMPLETE, (UnifiedRecordValue)this.jobRecord, this.authorizedTenantIds.toArray(new String[0]));
        return this.expectation.apply(position);
    }

    public Record<JobRecordValue> fail() {
        long jobKey = this.findJobKey();
        long position = this.writer.writeCommand(jobKey, (Intent)JobIntent.FAIL, (UnifiedRecordValue)this.jobRecord, this.authorizedTenantIds.toArray(new String[0]));
        return this.expectation.apply(position);
    }

    public Record<JobRecordValue> yield() {
        long jobKey = this.findJobKey();
        long position = this.writer.writeCommand(jobKey, (Intent)JobIntent.YIELD, (UnifiedRecordValue)this.jobRecord);
        return this.expectation.apply(position);
    }

    public Record<JobRecordValue> updateRetries() {
        long jobKey = this.findJobKey();
        long position = this.writer.writeCommand(jobKey, (Intent)JobIntent.UPDATE_RETRIES, (UnifiedRecordValue)this.jobRecord, this.authorizedTenantIds.toArray(new String[0]));
        return this.expectation.apply(position);
    }

    public Record<JobRecordValue> updateTimeout() {
        long jobKey = this.findJobKey();
        long position = this.writer.writeCommand(jobKey, (Intent)JobIntent.UPDATE_TIMEOUT, (UnifiedRecordValue)this.jobRecord, this.authorizedTenantIds.toArray(new String[0]));
        return this.expectation.apply(position);
    }

    public Record<JobRecordValue> throwError() {
        long jobKey = this.findJobKey();
        long position = this.writer.writeCommand(jobKey, (Intent)JobIntent.THROW_ERROR, (UnifiedRecordValue)this.jobRecord, this.authorizedTenantIds.toArray(new String[0]));
        return this.expectation.apply(position);
    }
}

