/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.util.client;

import io.camunda.zeebe.engine.util.client.CommandWriter;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.impl.record.value.resource.ResourceDeletionRecord;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ResourceDeletionIntent;
import io.camunda.zeebe.protocol.record.value.ResourceDeletionRecordValue;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.ResourceDeletionRecordStream;
import java.util.List;
import java.util.function.Function;

public class ResourceDeletionClient {
    private static final Function<Long, Record<ResourceDeletionRecordValue>> SUCCESS_EXPECTATION = position -> (Record)((ResourceDeletionRecordStream)RecordingExporter.resourceDeletionRecords((ResourceDeletionIntent)ResourceDeletionIntent.DELETED).withSourceRecordPosition(position.longValue())).getFirst();
    private static final Function<Long, Record<ResourceDeletionRecordValue>> REJECTION_EXPECTATION = position -> (Record)((ResourceDeletionRecordStream)((ResourceDeletionRecordStream)((ResourceDeletionRecordStream)RecordingExporter.resourceDeletionRecords().onlyCommandRejections()).withIntent((Intent)ResourceDeletionIntent.DELETE)).withSourceRecordPosition(position.longValue())).getFirst();
    private final CommandWriter writer;
    private final ResourceDeletionRecord resourceDeletionRecord = new ResourceDeletionRecord();
    private Function<Long, Record<ResourceDeletionRecordValue>> expectation = SUCCESS_EXPECTATION;
    private List<String> authorizedTenantIds = List.of("<default>");

    public ResourceDeletionClient(CommandWriter writer) {
        this.writer = writer;
    }

    public ResourceDeletionClient withResourceKey(long resourceKey) {
        this.resourceDeletionRecord.setResourceKey(resourceKey);
        return this;
    }

    public ResourceDeletionClient withAuthorizedTenantIds(String ... tenantIds) {
        this.authorizedTenantIds = List.of(tenantIds);
        return this;
    }

    public Record<ResourceDeletionRecordValue> delete() {
        long position = this.writer.writeCommand((Intent)ResourceDeletionIntent.DELETE, (UnifiedRecordValue)this.resourceDeletionRecord, this.authorizedTenantIds.toArray(new String[0]));
        return this.expectation.apply(position);
    }

    public ResourceDeletionClient expectRejection() {
        this.expectation = REJECTION_EXPECTATION;
        return this;
    }
}

