/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.logstreams.util.ListLogStorage;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.protocol.ZbColumnFamilies;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.stream.impl.StreamProcessorMode;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import java.util.Map;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.SoftAssertions;
import org.awaitility.Awaitility;
import org.junit.Rule;
import org.junit.Test;

public class ContinuouslyReplayTest {
    private final ListLogStorage sharedStorage = new ListLogStorage();
    @Rule
    public final EngineRule replay = EngineRule.withSharedStorage(this.sharedStorage).withStreamProcessorMode(StreamProcessorMode.REPLAY);
    @Rule
    public final EngineRule processing = EngineRule.withSharedStorage(this.sharedStorage);

    @Test
    public void shouldBuildTheSameStateOnProcessingAndReplay() {
        this.processing.deployment().withXmlResource(Bpmn.createExecutableProcess((String)"process").startEvent().endEvent().done()).deploy();
        long processInstanceKey = this.processing.processInstance().ofBpmnProcessId("process").create();
        RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_COMPLETED).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.PROCESS).await();
        this.assertStates();
    }

    private void assertStates() {
        Awaitility.await((String)"await that the replay state is equal to the processing state").untilAsserted(() -> {
            Map<ZbColumnFamilies, Map<Object, Object>> replayState = this.replay.collectState();
            Map<ZbColumnFamilies, Map<Object, Object>> processingState = this.processing.collectState();
            SoftAssertions softly = new SoftAssertions();
            processingState.entrySet().stream().filter(entry -> entry.getKey() != ZbColumnFamilies.DEFAULT).filter(entry -> entry.getKey() != ZbColumnFamilies.MIGRATIONS_STATE).forEach(entry -> {
                ZbColumnFamilies column = (ZbColumnFamilies)entry.getKey();
                Map processingEntries = (Map)entry.getValue();
                Map replayEntries = (Map)replayState.get(column);
                if (processingEntries.isEmpty()) {
                    ((MapAssert)softly.assertThat(replayEntries).describedAs("The state column '%s' should be empty after replay", new Object[]{column})).isEmpty();
                } else {
                    ((MapAssert)softly.assertThat(replayEntries).describedAs("The state column '%s' has different entries after replay", new Object[]{column})).containsExactlyInAnyOrderEntriesOf(processingEntries);
                }
            });
            softly.assertAll();
        });
    }
}

