/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.StartEventBuilder;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.DeploymentIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.DeploymentRecordValue;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import java.util.function.Function;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.groups.Tuple;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class StartEventFormTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    private static final String PROCESS_ID = "process";
    private static final String TEST_FORM = "/form/test-form-1.form";
    private static final String FORM_ID = "Form_0w7r08e";
    @Rule
    public final RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();

    @Test
    public void shouldDeployProcessWithFormIdWhenFormIsNotYetDeployed() {
        this.deployProcess("form-id");
        this.assertProcessDeployed();
    }

    @Test
    public void shouldDeployProcessWithFormIdWithFormDeployed() {
        this.deployForm();
        this.deployProcess(FORM_ID);
        this.assertProcessDeployed();
    }

    @Test
    public void shouldStartAncCompleteProcessWithForm() {
        this.deployForm();
        this.deployProcess(FORM_ID);
        this.assertProcessDeployed();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        this.assertProcessInstanceCompleted(processInstanceKey);
    }

    private void deployProcess(String formId) {
        BpmnModelInstance processWithFormId = ((StartEventBuilder)Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().zeebeFormId(formId)).endEvent().done();
        ENGINE.deployment().withXmlResource(processWithFormId).deploy();
    }

    private void deployForm() {
        Record<DeploymentRecordValue> deploymentEvent = ENGINE.deployment().withJsonClasspathResource(TEST_FORM).deploy();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(deploymentEvent).hasIntent((Intent)DeploymentIntent.CREATED).hasValueType(ValueType.DEPLOYMENT).hasRecordType(RecordType.EVENT);
    }

    private void assertProcessDeployed() {
        Assertions.assertThat((Stream)RecordingExporter.deploymentRecords()).extracting(new Function[]{Record::getRecordType, Record::getIntent}).containsSequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{RecordType.COMMAND, DeploymentIntent.CREATE}), Assertions.tuple((Object[])new Object[]{RecordType.EVENT, DeploymentIntent.CREATED})});
    }

    private void assertProcessInstanceCompleted(long processInstanceKey) {
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey)).extracting(new Function[]{Record::getRecordType, Record::getIntent}).containsSequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{RecordType.EVENT, ProcessInstanceIntent.ELEMENT_COMPLETING}), Assertions.tuple((Object[])new Object[]{RecordType.EVENT, ProcessInstanceIntent.ELEMENT_COMPLETED})});
    }
}

