/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.compensation;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.BpmnEventType;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import java.util.function.Function;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.groups.Tuple;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class CompensationEventExecutionTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    private static final String PROCESS_ID = "compensation-process";
    @Rule
    public final RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();

    @Test
    public void shouldExecuteAProcessWithCompensationIntermediateEvent() {
        BpmnModelInstance process = Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().userTask().intermediateThrowEvent("compensation-event", i -> i.compensateEventDefinition().compensateEventDefinitionDone()).endEvent().done();
        ENGINE.deployment().withXmlResource(process).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        ENGINE.job().ofInstance(processInstanceKey).withType("io.camunda.zeebe:userTask").complete();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted()).extracting(new Function[]{r -> ((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType(), Record::getIntent, r -> ((ProcessInstanceRecordValue)r.getValue()).getBpmnEventType()}).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{BpmnElementType.USER_TASK, ProcessInstanceIntent.ELEMENT_COMPLETED, BpmnEventType.UNSPECIFIED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.INTERMEDIATE_THROW_EVENT, ProcessInstanceIntent.ELEMENT_ACTIVATED, BpmnEventType.COMPENSATION}), Assertions.tuple((Object[])new Object[]{BpmnElementType.INTERMEDIATE_THROW_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETED, BpmnEventType.COMPENSATION}), Assertions.tuple((Object[])new Object[]{BpmnElementType.END_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETED, BpmnEventType.NONE}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED, BpmnEventType.UNSPECIFIED})});
    }

    @Test
    public void shouldExecuteAProcessWithCompensationEndEvent() {
        BpmnModelInstance process = Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().userTask().endEvent("compensation-event", e -> e.compensateEventDefinition().compensateEventDefinitionDone()).done();
        ENGINE.deployment().withXmlResource(process).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        ENGINE.job().ofInstance(processInstanceKey).withType("io.camunda.zeebe:userTask").complete();
        Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).limitToProcessInstanceCompleted()).extracting(new Function[]{r -> ((ProcessInstanceRecordValue)r.getValue()).getBpmnElementType(), Record::getIntent, r -> ((ProcessInstanceRecordValue)r.getValue()).getBpmnEventType()}).containsSubsequence((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{BpmnElementType.USER_TASK, ProcessInstanceIntent.ELEMENT_COMPLETED, BpmnEventType.UNSPECIFIED}), Assertions.tuple((Object[])new Object[]{BpmnElementType.END_EVENT, ProcessInstanceIntent.ELEMENT_ACTIVATED, BpmnEventType.COMPENSATION}), Assertions.tuple((Object[])new Object[]{BpmnElementType.END_EVENT, ProcessInstanceIntent.ELEMENT_COMPLETED, BpmnEventType.COMPENSATION}), Assertions.tuple((Object[])new Object[]{BpmnElementType.PROCESS, ProcessInstanceIntent.ELEMENT_COMPLETED, BpmnEventType.UNSPECIFIED})});
    }
}

