/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.job;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.engine.util.RecordingJobStreamer;
import io.camunda.zeebe.msgpack.value.StringValue;
import io.camunda.zeebe.protocol.impl.record.value.job.JobRecord;
import io.camunda.zeebe.protocol.impl.stream.job.ActivatedJob;
import io.camunda.zeebe.protocol.impl.stream.job.JobActivationProperties;
import io.camunda.zeebe.protocol.impl.stream.job.JobActivationPropertiesImpl;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.JobBatchIntent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.protocol.record.value.JobBatchRecordValue;
import io.camunda.zeebe.protocol.record.value.JobRecordValue;
import io.camunda.zeebe.test.util.Strings;
import io.camunda.zeebe.test.util.record.RecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.agrona.DirectBuffer;
import org.assertj.core.api.Assertions;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class MultiTenancyActivatableJobsPushTest {
    private static final String PROCESS_ID = "process";
    private static final RecordingJobStreamer JOB_STREAMER = new RecordingJobStreamer();
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition().withJobStreamer(JOB_STREAMER);
    @Rule
    public final RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();
    private final List<Long> activeProcessInstances = new ArrayList<Long>();

    @Test
    public void shouldPushWhenJobCreatedForAuthorizedTenant() {
        String jobType = Strings.newRandomValidBpmnId();
        DirectBuffer jobTypeBuffer = BufferUtil.wrapString((String)jobType);
        DirectBuffer worker = BufferUtil.wrapString((String)"test");
        Map<String, Object> variables = Map.of("a", "valA", "b", "valB", "c", "valC");
        long timeout = 30000L;
        String tenantIdA = "tenant-a";
        String tenantIdB = "tenant-a";
        JobActivationPropertiesImpl jobActivationProperties = new JobActivationPropertiesImpl().setWorker(worker, 0, worker.capacity()).setTimeout(30000L).setFetchVariables(List.of(new StringValue("a"), new StringValue("b"), new StringValue("c")));
        RecordingJobStreamer.RecordingJobStream jobStreamA = JOB_STREAMER.addJobStream(jobTypeBuffer, (JobActivationProperties)jobActivationProperties.setTenantIds(List.of("tenant-a")));
        RecordingJobStreamer.RecordingJobStream jobStreamB = JOB_STREAMER.addJobStream(jobTypeBuffer, (JobActivationProperties)jobActivationProperties.setTenantIds(List.of("tenant-a")));
        boolean activationCount = true;
        long jobKey = this.createJob(jobType, PROCESS_ID, variables, "tenant-a");
        Record batchRecord = (Record)RecordingExporter.jobBatchRecords((JobBatchIntent)JobBatchIntent.ACTIVATED).withType(jobType).getFirst();
        JobBatchRecordValue batch = (JobBatchRecordValue)batchRecord.getValue();
        List jobs = batch.getJobs();
        Assertions.assertThat((List)jobs).hasSize(1);
        Assertions.assertThat((List)batch.getJobKeys()).contains((Object[])new Long[]{jobKey});
        this.assertEventOrder(new Intent[]{JobIntent.CREATED, JobBatchIntent.ACTIVATED});
        this.assertActivatedJob(jobStreamA, jobKey, worker, variables, 1, "tenant-a");
        this.assertNoActivatedJobs(jobStreamB);
    }

    private Long createJob(String jobType, String processId, Map<String, Object> variables, String tenantId) {
        Record<JobRecordValue> jobRecord = ENGINE.createJob(jobType, processId, variables, tenantId);
        this.activeProcessInstances.add(((JobRecordValue)jobRecord.getValue()).getProcessInstanceKey());
        return jobRecord.getKey();
    }

    private void assertEventOrder(Intent ... eventOrder) {
        for (long piKey : this.activeProcessInstances) {
            RecordStream processInstanceRecordStream = RecordingExporter.records().betweenProcessInstance(piKey);
            Assertions.assertThat((Stream)processInstanceRecordStream).extracting(Record::getIntent).containsSequence((Object[])eventOrder);
        }
    }

    private void assertActivatedJob(RecordingJobStreamer.RecordingJobStream jobStream, Long jobKey, DirectBuffer worker, Map variables, int activationCount, String tenantId) {
        List<ActivatedJob> activatedJobs = jobStream.getActivatedJobs();
        Assertions.assertThat(activatedJobs).hasSize(activationCount);
        activatedJobs.stream().forEach(activatedJob -> {
            Assertions.assertThat((long)activatedJob.jobKey()).isEqualTo((Object)jobKey);
            JobRecord jobRecord = activatedJob.jobRecord();
            Assertions.assertThat((Comparable)jobRecord.getWorkerBuffer()).isEqualTo((Object)worker);
            Assertions.assertThat((Map)jobRecord.getVariables()).isEqualTo((Object)variables);
            Assertions.assertThat((String)jobRecord.getTenantId()).isEqualTo(tenantId);
        });
    }

    private void assertNoActivatedJobs(RecordingJobStreamer.RecordingJobStream jobStream) {
        Assertions.assertThat(jobStream.getActivatedJobs()).isEmpty();
    }
}

