/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.multitenancy;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.protocol.record.Assertions;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RecordAssert;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestWatcher;

public class TenantAwareCancelProcessInstanceTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    @Rule
    public final TestWatcher watcher = new RecordingExporterTestWatcher();

    @Test
    public void shouldCancelInstanceForDefaultTenant() {
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask("task", t -> t.zeebeJobType("test")).endEvent().done()).withTenantId("<default>").deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("process").withTenantId("<default>").create();
        Record<ProcessInstanceRecordValue> cancelled = ENGINE.processInstance().withInstanceKey(processInstanceKey).forAuthorizedTenants("<default>").cancel();
        ((RecordAssert)Assertions.assertThat(cancelled).describedAs("Expect that cancellation was successful", new Object[0])).hasIntent((Intent)ProcessInstanceIntent.ELEMENT_TERMINATED);
    }

    @Test
    public void shouldRejectCancelInstanceForUnauthorizedTenant() {
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask("task", t -> t.zeebeJobType("test")).endEvent().done()).withTenantId("custom-tenant").deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("process").withTenantId("custom-tenant").create();
        Record<ProcessInstanceRecordValue> rejection = ENGINE.processInstance().withInstanceKey(processInstanceKey).forAuthorizedTenants("another-tenant").expectRejection().cancel();
        Assertions.assertThat(rejection).hasRejectionType(RejectionType.NOT_FOUND).hasRejectionReason("Expected to cancel a process instance with key '%s', but no such process was found".formatted(processInstanceKey));
    }

    @Test
    public void shouldCancelInstanceForSpecificTenant() {
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask("task", t -> t.zeebeJobType("test")).endEvent().done()).withTenantId("custom-tenant").deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("process").withTenantId("custom-tenant").create();
        Record<ProcessInstanceRecordValue> cancelled = ENGINE.processInstance().withInstanceKey(processInstanceKey).forAuthorizedTenants("custom-tenant").cancel();
        ((RecordAssert)Assertions.assertThat(cancelled).describedAs("Expect that cancellation was successful", new Object[0])).hasIntent((Intent)ProcessInstanceIntent.ELEMENT_TERMINATED);
    }
}

