/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.processinstance;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.builder.BoundaryEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.ServiceTaskBuilder;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.IncidentIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.protocol.record.intent.MessageSubscriptionIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceMigrationIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.DeploymentRecordValue;
import io.camunda.zeebe.protocol.record.value.JobRecordValue;
import io.camunda.zeebe.test.util.record.ProcessInstanceMigrationRecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.OptionalAssert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestWatcher;

public class MigrateProcessInstanceRejectionTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    @Rule
    public final TestWatcher watcher = new RecordingExporterTestWatcher();

    @Test
    public void shouldRejectCommandWhenProcessInstanceIsUnknown() {
        long unknownKey = 12345L;
        ENGINE.processInstance().withInstanceKey(12345L).migration().withTargetProcessDefinitionKey(1L).expectRejection().migrate();
        Record rejectionRecord = (Record)((ProcessInstanceMigrationRecordStream)RecordingExporter.processInstanceMigrationRecords().onlyCommandRejections()).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((Record)rejectionRecord).hasIntent((Intent)ProcessInstanceMigrationIntent.MIGRATE).hasRejectionType(RejectionType.NOT_FOUND).hasRejectionReason(String.format("Expected to migrate process instance but no process instance found with key '%d'", 12345L)).hasKey(12345L);
    }

    @Test
    public void shouldRejectCommandWhenTargetProcessDefinitionIsUnknown() {
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask("task", t -> t.zeebeJobType("task")).endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("process").create();
        long unknownKey = 12345L;
        ENGINE.processInstance().withInstanceKey(processInstanceKey).migration().withTargetProcessDefinitionKey(12345L).expectRejection().migrate();
        Record rejectionRecord = (Record)((ProcessInstanceMigrationRecordStream)RecordingExporter.processInstanceMigrationRecords().onlyCommandRejections()).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((Record)rejectionRecord).hasIntent((Intent)ProcessInstanceMigrationIntent.MIGRATE).hasRejectionType(RejectionType.NOT_FOUND).hasRejectionReason(String.format("Expected to migrate process instance to process definition but no process definition found with key '%d'", 12345L)).hasKey(processInstanceKey);
    }

    @Test
    public void shouldRejectCommandWhenActiveElementIsNotMapped() {
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask("A", t -> t.zeebeJobType("task")).endEvent().done()).withXmlResource(Bpmn.createExecutableProcess((String)"process2").startEvent().serviceTask("A", t -> t.zeebeJobType("task")).userTask("B").endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("process").create();
        long targetProcessDefinitionKey = MigrateProcessInstanceRejectionTest.extractTargetProcessDefinitionKey(deployment, "process2");
        ENGINE.processInstance().withInstanceKey(processInstanceKey).migration().withTargetProcessDefinitionKey(targetProcessDefinitionKey).expectRejection().migrate();
        Record rejectionRecord = (Record)((ProcessInstanceMigrationRecordStream)RecordingExporter.processInstanceMigrationRecords().onlyCommandRejections()).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((Record)rejectionRecord).hasIntent((Intent)ProcessInstanceMigrationIntent.MIGRATE).hasRejectionType(RejectionType.INVALID_STATE).hasRejectionReason(String.format("Expected to migrate process instance '%d' but no mapping instruction defined for active element with id 'A'. Elements cannot be migrated without a mapping.", processInstanceKey)).hasKey(processInstanceKey);
    }

    @Test
    public void shouldRejectCommandWhenActiveElementHasAJobIncident() {
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask("A", t -> t.zeebeJobType("jobType")).endEvent().done()).withXmlResource(Bpmn.createExecutableProcess((String)"process2").startEvent().serviceTask("A", t -> t.zeebeJobType("jobType")).endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("process").create();
        ENGINE.jobs().withType("jobType").withMaxJobsToActivate(1).activate();
        RecordingExporter.jobRecords((JobIntent)JobIntent.CREATED).withType("jobType").await();
        Record<JobRecordValue> failedEvent = ENGINE.job().withType("jobType").ofInstance(processInstanceKey).withRetries(0).fail();
        Record incident = (Record)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withJobKey(failedEvent.getKey()).getFirst();
        long targetProcessDefinitionKey = MigrateProcessInstanceRejectionTest.extractTargetProcessDefinitionKey(deployment, "process2");
        ENGINE.processInstance().withInstanceKey(processInstanceKey).migration().withTargetProcessDefinitionKey(targetProcessDefinitionKey).addMappingInstruction("A", "A").expectRejection().migrate();
        Record rejectionRecord = (Record)((ProcessInstanceMigrationRecordStream)RecordingExporter.processInstanceMigrationRecords().onlyCommandRejections()).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((Record)rejectionRecord).hasIntent((Intent)ProcessInstanceMigrationIntent.MIGRATE).hasRejectionType(RejectionType.INVALID_STATE).hasRejectionReason(String.format("Expected to migrate process instance '%d' but active element with id 'A' has an incident. Elements cannot be migrated with an incident yet. Please retry migration after resolving the incident.", processInstanceKey)).hasKey(processInstanceKey);
        ENGINE.incident().ofInstance(processInstanceKey).withKey(incident.getKey()).resolve();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).migration().withTargetProcessDefinitionKey(targetProcessDefinitionKey).addMappingInstruction("A", "A").migrate();
        ((OptionalAssert)Assertions.assertThat((Optional)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_MIGRATED).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.PROCESS).findAny()).describedAs("Expected to have migrated the process instance", new Object[0])).isPresent();
    }

    @Test
    public void shouldRejectCommandWhenActiveElementHasAProcessIncident() {
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask("A", b -> ((ServiceTaskBuilder)b.zeebeJobType("jobType")).zeebeInputExpression("assert(x, x != null)", "y")).endEvent().done()).withXmlResource(Bpmn.createExecutableProcess((String)"process2").startEvent().serviceTask("A", t -> t.zeebeJobType("jobType")).endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("process").create();
        Record incident = (Record)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst();
        long targetProcessDefinitionKey = MigrateProcessInstanceRejectionTest.extractTargetProcessDefinitionKey(deployment, "process2");
        ENGINE.processInstance().withInstanceKey(processInstanceKey).migration().withTargetProcessDefinitionKey(targetProcessDefinitionKey).addMappingInstruction("A", "A").expectRejection().migrate();
        Record rejectionRecord = (Record)((ProcessInstanceMigrationRecordStream)RecordingExporter.processInstanceMigrationRecords().onlyCommandRejections()).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((Record)rejectionRecord).hasIntent((Intent)ProcessInstanceMigrationIntent.MIGRATE).hasRejectionType(RejectionType.INVALID_STATE).hasRejectionReason(String.format("Expected to migrate process instance '%d' but active element with id 'A' has an incident. Elements cannot be migrated with an incident yet. Please retry migration after resolving the incident.", processInstanceKey)).hasKey(processInstanceKey);
        ENGINE.variables().ofScope(processInstanceKey).withDocument(Map.of("x", 1)).update();
        ENGINE.incident().ofInstance(processInstanceKey).withKey(incident.getKey()).resolve();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).migration().withTargetProcessDefinitionKey(targetProcessDefinitionKey).addMappingInstruction("A", "A").migrate();
        ((OptionalAssert)Assertions.assertThat((Optional)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_MIGRATED).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.PROCESS).findAny()).describedAs("Expected to have migrated the process instance", new Object[0])).isPresent();
    }

    @Test
    public void shouldRejectCommandWhenAnyElementsMappedToADifferentBpmnElementType() {
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask("A", t -> t.zeebeJobType("task")).endEvent().done()).withXmlResource(Bpmn.createExecutableProcess((String)"process2").startEvent().userTask("A").endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("process").create();
        long targetProcessDefinitionKey = MigrateProcessInstanceRejectionTest.extractTargetProcessDefinitionKey(deployment, "process2");
        ENGINE.processInstance().withInstanceKey(processInstanceKey).migration().withTargetProcessDefinitionKey(targetProcessDefinitionKey).addMappingInstruction("A", "A").expectRejection().migrate();
        Record rejectionRecord = (Record)((ProcessInstanceMigrationRecordStream)RecordingExporter.processInstanceMigrationRecords().onlyCommandRejections()).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((Record)rejectionRecord).hasIntent((Intent)ProcessInstanceMigrationIntent.MIGRATE).hasRejectionType(RejectionType.INVALID_STATE).hasRejectionReason(String.format("Expected to migrate process instance '%s' but active element with id 'A' and type 'SERVICE_TASK' is mapped to an element with id 'A' and different type 'USER_TASK'. Elements must be mapped to elements of the same type.", processInstanceKey)).hasKey(processInstanceKey);
    }

    @Test
    public void shouldRejectCommandWhenMappingInstructionContainsANonExistingSourceElementId() {
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask("A", t -> t.zeebeJobType("jobType")).endEvent().done()).withXmlResource(Bpmn.createExecutableProcess((String)"process2").startEvent().serviceTask("A", t -> t.zeebeJobType("jobType")).endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("process").create();
        long targetProcessDefinitionKey = MigrateProcessInstanceRejectionTest.extractTargetProcessDefinitionKey(deployment, "process2");
        ENGINE.processInstance().withInstanceKey(processInstanceKey).migration().withTargetProcessDefinitionKey(targetProcessDefinitionKey).addMappingInstruction("B", "A").expectRejection().migrate();
        Record rejectionRecord = (Record)((ProcessInstanceMigrationRecordStream)RecordingExporter.processInstanceMigrationRecords().onlyCommandRejections()).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((Record)rejectionRecord).hasIntent((Intent)ProcessInstanceMigrationIntent.MIGRATE).hasRejectionType(RejectionType.INVALID_ARGUMENT).hasRejectionReason(String.format("Expected to migrate process instance '%s' but mapping instructions contain a non-existing source element id 'B'. Elements provided in mapping instructions must exist in the source process definition.", processInstanceKey)).hasKey(processInstanceKey);
    }

    @Test
    public void shouldRejectCommandWhenMappingInstructionContainsANonExistingTargetElementId() {
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask("A", t -> t.zeebeJobType("jobType")).endEvent().done()).withXmlResource(Bpmn.createExecutableProcess((String)"process2").startEvent().serviceTask("A", t -> t.zeebeJobType("jobType")).endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("process").create();
        long targetProcessDefinitionKey = MigrateProcessInstanceRejectionTest.extractTargetProcessDefinitionKey(deployment, "process2");
        ENGINE.processInstance().withInstanceKey(processInstanceKey).migration().withTargetProcessDefinitionKey(targetProcessDefinitionKey).addMappingInstruction("A", "B").expectRejection().migrate();
        Record rejectionRecord = (Record)((ProcessInstanceMigrationRecordStream)RecordingExporter.processInstanceMigrationRecords().onlyCommandRejections()).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((Record)rejectionRecord).hasIntent((Intent)ProcessInstanceMigrationIntent.MIGRATE).hasRejectionType(RejectionType.INVALID_ARGUMENT).hasRejectionReason(String.format("Expected to migrate process instance '%s' but mapping instructions contain a non-existing target element id 'B'. Elements provided in mapping instructions must exist in the target process definition.", processInstanceKey)).hasKey(processInstanceKey);
    }

    @Test
    public void shouldRejectCommandWhenElementFlowScopeIsChangedInTargetProcessDefinition() {
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)"process").startEvent("start").serviceTask("A", t -> t.zeebeJobType("task")).endEvent("end").done()).withXmlResource(Bpmn.createExecutableProcess((String)"process2").startEvent("start").subProcess("sub", s -> s.embeddedSubProcess().startEvent().serviceTask("A", t -> t.zeebeJobType("task")).endEvent()).endEvent("end").done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("process").create();
        long targetProcessDefinitionKey = MigrateProcessInstanceRejectionTest.extractTargetProcessDefinitionKey(deployment, "process2");
        ENGINE.processInstance().withInstanceKey(processInstanceKey).migration().withTargetProcessDefinitionKey(targetProcessDefinitionKey).addMappingInstruction("A", "A").expectRejection().migrate();
        Record rejectionRecord = (Record)((ProcessInstanceMigrationRecordStream)RecordingExporter.processInstanceMigrationRecords().onlyCommandRejections()).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((Record)rejectionRecord).hasIntent((Intent)ProcessInstanceMigrationIntent.MIGRATE).hasRejectionType(RejectionType.INVALID_STATE).hasRejectionReason(String.format("Expected to migrate process instance '%s' but the flow scope of active element with id 'A' is changed. The flow scope of the active element is expected to be 'process2' but was 'sub'. The flow scope of an element cannot be changed during migration yet.", processInstanceKey)).hasKey(processInstanceKey);
    }

    @Test
    public void shouldRejectCommandWhenElementFlowScopeIsChangedInTargetProcessDefinitionDeeper() {
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)"process").startEvent("start").serviceTask("A", t -> t.zeebeJobType("task")).endEvent("end").done()).withXmlResource(Bpmn.createExecutableProcess((String)"process2").startEvent("start").subProcess("sub1", s -> s.embeddedSubProcess().startEvent().subProcess("sub2", s2 -> s2.embeddedSubProcess().startEvent().serviceTask("A", t -> t.zeebeJobType("task")).endEvent()).endEvent()).endEvent("end").done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("process").create();
        long targetProcessDefinitionKey = MigrateProcessInstanceRejectionTest.extractTargetProcessDefinitionKey(deployment, "process2");
        ENGINE.processInstance().withInstanceKey(processInstanceKey).migration().withTargetProcessDefinitionKey(targetProcessDefinitionKey).addMappingInstruction("A", "A").expectRejection().migrate();
        Record rejectionRecord = (Record)((ProcessInstanceMigrationRecordStream)RecordingExporter.processInstanceMigrationRecords().onlyCommandRejections()).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((Record)rejectionRecord).hasIntent((Intent)ProcessInstanceMigrationIntent.MIGRATE).hasRejectionType(RejectionType.INVALID_STATE).hasRejectionReason(String.format("Expected to migrate process instance '%s' but the flow scope of active element with id 'A' is changed. The flow scope of the active element is expected to be 'process2' but was 'sub2'. The flow scope of an element cannot be changed during migration yet.", processInstanceKey)).hasKey(processInstanceKey);
    }

    @Test
    public void shouldRejectCommandWhenTheMigratedProcessInstanceIsAChildProcessInstance() {
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)"process").startEvent().callActivity("call", c -> c.zeebeProcessId("childProcess")).endEvent().done()).withXmlResource(Bpmn.createExecutableProcess((String)"childProcess").startEvent().serviceTask("A", t -> t.zeebeJobType("A")).endEvent().done()).withXmlResource(Bpmn.createExecutableProcess((String)"process2").startEvent().serviceTask("A", t -> t.zeebeJobType("A")).endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("process").create();
        RecordingExporter.processInstanceRecords().withParentProcessInstanceKey(processInstanceKey).withBpmnProcessId("childProcess").await();
        long childProcessInstanceKey = ((Record)RecordingExporter.processInstanceRecords().withParentProcessInstanceKey(processInstanceKey).withBpmnProcessId("childProcess").getFirst()).getKey();
        long targetProcessDefinitionKey = MigrateProcessInstanceRejectionTest.extractTargetProcessDefinitionKey(deployment, "process2");
        ENGINE.processInstance().withInstanceKey(childProcessInstanceKey).migration().withTargetProcessDefinitionKey(targetProcessDefinitionKey).addMappingInstruction("A", "A").expectRejection().migrate();
        Record rejectionRecord = (Record)((ProcessInstanceMigrationRecordStream)RecordingExporter.processInstanceMigrationRecords().onlyCommandRejections()).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((Record)rejectionRecord).hasIntent((Intent)ProcessInstanceMigrationIntent.MIGRATE).hasRejectionType(RejectionType.INVALID_STATE).hasRejectionReason(String.format("Expected to migrate process instance '%s' but process instance is a child process instance. Child process instances cannot be migrated.", childProcessInstanceKey)).hasKey(childProcessInstanceKey);
    }

    @Test
    public void shouldRejectCommandWhenSourceElementIdIsMappedInMultipleMappingInstructions() {
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask("A", t -> t.zeebeJobType("task")).endEvent().done()).withXmlResource(Bpmn.createExecutableProcess((String)"process2").startEvent().serviceTask("A", t -> t.zeebeJobType("task")).serviceTask("B", t -> t.zeebeJobType("task")).endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("process").create();
        long targetProcessDefinitionKey = MigrateProcessInstanceRejectionTest.extractTargetProcessDefinitionKey(deployment, "process2");
        ENGINE.processInstance().withInstanceKey(processInstanceKey).migration().withTargetProcessDefinitionKey(targetProcessDefinitionKey).addMappingInstruction("A", "A").addMappingInstruction("A", "B").expectRejection().migrate();
        Record rejectionRecord = (Record)((ProcessInstanceMigrationRecordStream)RecordingExporter.processInstanceMigrationRecords().onlyCommandRejections()).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((Record)rejectionRecord).hasIntent((Intent)ProcessInstanceMigrationIntent.MIGRATE).hasRejectionType(RejectionType.INVALID_ARGUMENT).hasRejectionReason(String.format("Expected to migrate process instance '%s' but the mapping instructions contain duplicate source element ids '%s'.", processInstanceKey, "[A]")).hasKey(processInstanceKey);
    }

    @Test
    public void shouldRejectCommandWhenTheMigratedProcessInstanceContainsATaskSubscribedToABoundaryEvent() {
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(((BoundaryEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent("start").serviceTask("A", t -> t.zeebeJobType("A")).boundaryEvent("boundary").message(m -> m.name("message").zeebeCorrelationKeyExpression("\"correlationKey\""))).endEvent().moveToActivity("A").endEvent("end").done()).withXmlResource(Bpmn.createExecutableProcess((String)"process2").startEvent("start").serviceTask("A", t -> t.zeebeJobType("A")).endEvent("end").done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("process").create();
        RecordingExporter.messageSubscriptionRecords((MessageSubscriptionIntent)MessageSubscriptionIntent.CREATED).withProcessInstanceKey(processInstanceKey).withMessageName("message").withCorrelationKey("correlationKey").await();
        long targetProcessDefinitionKey = MigrateProcessInstanceRejectionTest.extractTargetProcessDefinitionKey(deployment, "process2");
        ENGINE.processInstance().withInstanceKey(processInstanceKey).migration().withTargetProcessDefinitionKey(targetProcessDefinitionKey).addMappingInstruction("A", "A").expectRejection().migrate();
        Record rejectionRecord = (Record)((ProcessInstanceMigrationRecordStream)RecordingExporter.processInstanceMigrationRecords().onlyCommandRejections()).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((Record)rejectionRecord).hasIntent((Intent)ProcessInstanceMigrationIntent.MIGRATE).hasRejectionType(RejectionType.INVALID_STATE).hasRejectionReason("Expected to migrate process instance '%s' but active element with id 'A' has a boundary event. Migrating active elements with boundary events is not possible yet.".formatted(processInstanceKey)).hasKey(processInstanceKey);
    }

    @Test
    public void shouldRejectCommandWhenTheMigratedProcessInstanceSubscribedToAnEventSubprocess() {
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)"process").eventSubProcess("eventSubProcess", sub -> sub.startEvent("eventSubProcessStart", s -> s.message(m -> m.name("message").zeebeCorrelationKeyExpression("\"correlationKey\""))).endEvent()).startEvent().serviceTask("A", a -> a.zeebeJobType("A")).endEvent().done()).withXmlResource(Bpmn.createExecutableProcess((String)"process2").startEvent().serviceTask("A", a -> a.zeebeJobType("A")).endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("process").create();
        RecordingExporter.messageSubscriptionRecords((MessageSubscriptionIntent)MessageSubscriptionIntent.CREATED).withProcessInstanceKey(processInstanceKey).withMessageName("message").withCorrelationKey("correlationKey").await();
        long targetProcessDefinitionKey = MigrateProcessInstanceRejectionTest.extractTargetProcessDefinitionKey(deployment, "process2");
        ENGINE.processInstance().withInstanceKey(processInstanceKey).migration().withTargetProcessDefinitionKey(targetProcessDefinitionKey).addMappingInstruction("A", "A").expectRejection().migrate();
        Record rejectionRecord = (Record)((ProcessInstanceMigrationRecordStream)RecordingExporter.processInstanceMigrationRecords().onlyCommandRejections()).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((Record)rejectionRecord).hasIntent((Intent)ProcessInstanceMigrationIntent.MIGRATE).hasRejectionType(RejectionType.INVALID_STATE).hasRejectionReason("Expected to migrate process instance but process instance has an event subprocess. Process instances with event subprocesses cannot be migrated yet.").hasKey(processInstanceKey);
    }

    @Test
    public void shouldRejectCommandWhenTheTargetProcessDefinitionContainsATaskSubscribedToABoundaryEvent() {
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask("A", a -> a.zeebeJobType("A")).endEvent().done()).withXmlResource(((BoundaryEventBuilder)Bpmn.createExecutableProcess((String)"process2").startEvent().serviceTask("A", t -> t.zeebeJobType("A")).boundaryEvent("boundary").message(m -> m.name("message").zeebeCorrelationKeyExpression("\"correlationKey\""))).endEvent().moveToActivity("A").endEvent("end").done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("process").create();
        long targetProcessDefinitionKey = MigrateProcessInstanceRejectionTest.extractTargetProcessDefinitionKey(deployment, "process2");
        ENGINE.processInstance().withInstanceKey(processInstanceKey).migration().withTargetProcessDefinitionKey(targetProcessDefinitionKey).addMappingInstruction("A", "A").expectRejection().migrate();
        Record rejectionRecord = (Record)((ProcessInstanceMigrationRecordStream)RecordingExporter.processInstanceMigrationRecords().onlyCommandRejections()).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((Record)rejectionRecord).hasIntent((Intent)ProcessInstanceMigrationIntent.MIGRATE).hasRejectionType(RejectionType.INVALID_STATE).hasRejectionReason("Expected to migrate process instance '%s' but target element with id 'A' has a boundary event. Migrating target elements with boundary events is not possible yet.".formatted(processInstanceKey)).hasKey(processInstanceKey);
    }

    @Test
    public void shouldRejectCommandWhenTheTargetProcessDefinitionSubscribedToAnEventSubprocess() {
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask("A", a -> a.zeebeJobType("A")).endEvent().done()).withXmlResource(Bpmn.createExecutableProcess((String)"process2").eventSubProcess("eventSubProcess", sub -> sub.startEvent("eventSubProcessStart", s -> s.message(m -> m.name("message").zeebeCorrelationKeyExpression("\"correlationKey\""))).endEvent()).startEvent().serviceTask("A", a -> a.zeebeJobType("A")).endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId("process").create();
        long targetProcessDefinitionKey = MigrateProcessInstanceRejectionTest.extractTargetProcessDefinitionKey(deployment, "process2");
        ENGINE.processInstance().withInstanceKey(processInstanceKey).migration().withTargetProcessDefinitionKey(targetProcessDefinitionKey).addMappingInstruction("A", "A").expectRejection().migrate();
        Record rejectionRecord = (Record)((ProcessInstanceMigrationRecordStream)RecordingExporter.processInstanceMigrationRecords().onlyCommandRejections()).getFirst();
        io.camunda.zeebe.protocol.record.Assertions.assertThat((Record)rejectionRecord).hasIntent((Intent)ProcessInstanceMigrationIntent.MIGRATE).hasRejectionType(RejectionType.INVALID_STATE).hasRejectionReason("Expected to migrate process instance but target process has an event subprocess. Target processes with event subprocesses cannot be migrated yet.").hasKey(processInstanceKey);
    }

    private static long extractTargetProcessDefinitionKey(Record<DeploymentRecordValue> deployment, String bpmnProcessId) {
        return ((DeploymentRecordValue)deployment.getValue()).getProcessesMetadata().stream().filter(p -> p.getBpmnProcessId().equals(bpmnProcessId)).findAny().orElseThrow().getProcessDefinitionKey();
    }
}

