/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.processinstance;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.builder.ServiceTaskBuilder;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceMigrationMappingInstruction;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceMigrationIntent;
import io.camunda.zeebe.protocol.record.intent.VariableIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.DeploymentRecordValue;
import io.camunda.zeebe.protocol.record.value.JobRecordValue;
import io.camunda.zeebe.protocol.record.value.JobRecordValueAssert;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceMigrationRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValueAssert;
import io.camunda.zeebe.protocol.record.value.VariableRecordValue;
import io.camunda.zeebe.protocol.record.value.VariableRecordValueAssert;
import io.camunda.zeebe.test.util.BrokerClassRuleHelper;
import io.camunda.zeebe.test.util.record.ProcessInstanceRecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.OptionalAssert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestWatcher;

public class MigrateProcessInstanceTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    @Rule
    public final TestWatcher watcher = new RecordingExporterTestWatcher();
    @Rule
    public final BrokerClassRuleHelper helper = new BrokerClassRuleHelper();

    @Test
    public void shouldWriteMigratedEventForProcessInstance() {
        String processId1 = this.helper.getBpmnProcessId();
        String processId2 = this.helper.getBpmnProcessId() + "2";
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)processId1).startEvent().serviceTask("A", a -> a.zeebeJobType("A")).endEvent().done()).withXmlResource(Bpmn.createExecutableProcess((String)processId2).startEvent().serviceTask("B", a -> a.zeebeJobType("B")).endEvent().done()).deploy();
        long otherProcessDefinitionKey = MigrateProcessInstanceTest.extractProcessDefinitionKeyByProcessId(deployment, processId2);
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(processId1).create();
        Record<ProcessInstanceMigrationRecordValue> event = ENGINE.processInstance().withInstanceKey(processInstanceKey).migration().withTargetProcessDefinitionKey(otherProcessDefinitionKey).addMappingInstruction("A", "B").migrate();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(event).hasKey(processInstanceKey).hasRecordType(RecordType.EVENT).hasIntent((Intent)ProcessInstanceMigrationIntent.MIGRATED);
        io.camunda.zeebe.protocol.record.Assertions.assertThat((ProcessInstanceMigrationRecordValue)((ProcessInstanceMigrationRecordValue)event.getValue())).hasProcessInstanceKey(processInstanceKey).hasTargetProcessDefinitionKey(otherProcessDefinitionKey).hasMappingInstructions(new ProcessInstanceMigrationRecordValue.ProcessInstanceMigrationMappingInstructionValue[]{new ProcessInstanceMigrationMappingInstruction().setSourceElementId("A").setTargetElementId("B")});
    }

    @Test
    public void shouldWriteElementMigratedEventForProcessInstance() {
        String processId = this.helper.getBpmnProcessId();
        String otherProcessId = this.helper.getBpmnProcessId() + "2";
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)processId).startEvent().serviceTask("A", a -> a.zeebeJobType("A")).endEvent().done()).withXmlResource(Bpmn.createExecutableProcess((String)otherProcessId).startEvent().serviceTask("B", a -> a.zeebeJobType("B")).endEvent().done()).deploy();
        long otherProcessDefinitionKey = MigrateProcessInstanceTest.extractProcessDefinitionKeyByProcessId(deployment, otherProcessId);
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(processId).create();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).migration().withTargetProcessDefinitionKey(otherProcessDefinitionKey).addMappingInstruction("A", "B").migrate();
        ((ProcessInstanceRecordValueAssert)((ProcessInstanceRecordValueAssert)((ProcessInstanceRecordValueAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat((ProcessInstanceRecordValue)((ProcessInstanceRecordValue)((Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_MIGRATED).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.PROCESS).getFirst()).getValue())).describedAs("Expect that process definition key changed", new Object[0])).hasProcessDefinitionKey(otherProcessDefinitionKey).describedAs("Expect that bpmn process id and element id changed", new Object[0])).hasBpmnProcessId(otherProcessId).hasElementId(otherProcessId).describedAs("Expect that version number did not change", new Object[0])).hasVersion(1);
    }

    @Test
    public void shouldWriteElementMigratedEventForProcessInstanceToNewVersion() {
        String processId = this.helper.getBpmnProcessId();
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)processId).startEvent().serviceTask("A", a -> a.zeebeJobType("A")).endEvent().done()).deploy();
        Record<DeploymentRecordValue> secondVersionDeployment = ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)processId).startEvent().serviceTask("A", a -> a.zeebeJobType("A")).userTask().endEvent().done()).deploy();
        long v2ProcessDefinitionKey = MigrateProcessInstanceTest.extractProcessDefinitionKeyByProcessId(secondVersionDeployment, processId);
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(processId).withVersion(1).create();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).migration().withTargetProcessDefinitionKey(v2ProcessDefinitionKey).addMappingInstruction("A", "A").migrate();
        ((ProcessInstanceRecordValueAssert)((ProcessInstanceRecordValueAssert)((ProcessInstanceRecordValueAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat((ProcessInstanceRecordValue)((ProcessInstanceRecordValue)((Record)((ProcessInstanceRecordStream)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.PROCESS).onlyEvents()).withIntent((Intent)ProcessInstanceIntent.ELEMENT_MIGRATED)).getFirst()).getValue())).describedAs("Expect that process definition key changed", new Object[0])).hasProcessDefinitionKey(v2ProcessDefinitionKey).describedAs("Expect that version number changed", new Object[0])).hasVersion(2).describedAs("Expect that bpmn process id and element id did not change", new Object[0])).hasBpmnProcessId(processId).hasElementId(processId);
    }

    @Test
    public void shouldWriteElementMigratedEventForServiceTask() {
        String processId = this.helper.getBpmnProcessId();
        String targetProcessId = this.helper.getBpmnProcessId() + "2";
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)processId).startEvent().serviceTask("A", a -> a.zeebeJobType("A")).endEvent().done()).withXmlResource(Bpmn.createExecutableProcess((String)targetProcessId).startEvent().serviceTask("A", a -> a.zeebeJobType("A")).userTask().endEvent().done()).deploy();
        long targetProcessDefinitionKey = MigrateProcessInstanceTest.extractProcessDefinitionKeyByProcessId(deployment, targetProcessId);
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(processId).create();
        RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.SERVICE_TASK).await();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).migration().withTargetProcessDefinitionKey(targetProcessDefinitionKey).addMappingInstruction("A", "A").migrate();
        ((ProcessInstanceRecordValueAssert)((ProcessInstanceRecordValueAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat((ProcessInstanceRecordValue)((ProcessInstanceRecordValue)((Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_MIGRATED).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.SERVICE_TASK).getFirst()).getValue())).describedAs("Expect that process definition is updated", new Object[0])).hasProcessDefinitionKey(targetProcessDefinitionKey).hasBpmnProcessId(targetProcessId).hasVersion(1).describedAs("Expect that element id is left unchanged", new Object[0])).hasElementId("A");
    }

    @Test
    public void shouldWriteElementMigratedEventForServiceTaskWithNewId() {
        String processId = this.helper.getBpmnProcessId();
        String targetProcessId = this.helper.getBpmnProcessId() + "2";
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)processId).startEvent().serviceTask("A", a -> a.zeebeJobType("A")).endEvent().done()).withXmlResource(Bpmn.createExecutableProcess((String)targetProcessId).startEvent().serviceTask("B", a -> a.zeebeJobType("B")).endEvent().done()).deploy();
        long targetProcessDefinitionKey = MigrateProcessInstanceTest.extractProcessDefinitionKeyByProcessId(deployment, targetProcessId);
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(processId).create();
        RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.SERVICE_TASK).await();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).migration().withTargetProcessDefinitionKey(targetProcessDefinitionKey).addMappingInstruction("A", "B").migrate();
        ((ProcessInstanceRecordValueAssert)((ProcessInstanceRecordValueAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat((ProcessInstanceRecordValue)((ProcessInstanceRecordValue)((Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_MIGRATED).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.SERVICE_TASK).getFirst()).getValue())).describedAs("Expect that process definition is updated", new Object[0])).hasProcessDefinitionKey(targetProcessDefinitionKey).hasBpmnProcessId(targetProcessId).hasVersion(1).describedAs("Expect that element id changed due to mapping", new Object[0])).hasElementId("B");
    }

    @Test
    public void shouldWriteMigratedEventForJob() {
        String processId = this.helper.getBpmnProcessId();
        String targetProcessId = this.helper.getBpmnProcessId() + "2";
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)processId).startEvent().serviceTask("A", a -> a.zeebeJobType("A")).endEvent().done()).withXmlResource(Bpmn.createExecutableProcess((String)targetProcessId).startEvent().serviceTask("B", a -> a.zeebeJobType("B")).endEvent().done()).deploy();
        long targetProcessDefinitionKey = MigrateProcessInstanceTest.extractProcessDefinitionKeyByProcessId(deployment, targetProcessId);
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(processId).create();
        RecordingExporter.jobRecords((JobIntent)JobIntent.CREATED).withProcessInstanceKey(processInstanceKey).await();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).migration().withTargetProcessDefinitionKey(targetProcessDefinitionKey).addMappingInstruction("A", "B").migrate();
        ((JobRecordValueAssert)((JobRecordValueAssert)((JobRecordValueAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat((JobRecordValue)((JobRecordValue)((Record)RecordingExporter.jobRecords((JobIntent)JobIntent.MIGRATED).withProcessInstanceKey(processInstanceKey).getFirst()).getValue())).describedAs("Expect that process definition is updated", new Object[0])).hasProcessDefinitionKey(targetProcessDefinitionKey).hasBpmnProcessId(targetProcessId).hasProcessDefinitionVersion(1).describedAs("Expect that element id changed due to mapping", new Object[0])).hasElementId("B").describedAs("Expect that the type did not change even though it's different in the target process. Re-evaluation of the job type expression is not enabled for this migration", new Object[0])).hasType("A");
    }

    @Test
    public void shouldContinueFlowInTargetProcessForMigratedJob() {
        String processId = this.helper.getBpmnProcessId();
        String targetProcessId = this.helper.getBpmnProcessId() + "2";
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)processId).startEvent().serviceTask("A", a -> a.zeebeJobType("A")).endEvent("source_process_end").done()).withXmlResource(Bpmn.createExecutableProcess((String)targetProcessId).startEvent().serviceTask("B", a -> a.zeebeJobType("B")).endEvent("target_process_end").done()).deploy();
        long targetProcessDefinitionKey = MigrateProcessInstanceTest.extractProcessDefinitionKeyByProcessId(deployment, targetProcessId);
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(processId).create();
        RecordingExporter.jobRecords((JobIntent)JobIntent.CREATED).withProcessInstanceKey(processInstanceKey).await();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).migration().withTargetProcessDefinitionKey(targetProcessDefinitionKey).addMappingInstruction("A", "B").migrate();
        ENGINE.job().ofInstance(processInstanceKey).withType("A").yield();
        ENGINE.job().ofInstance(processInstanceKey).withType("A").withRetries(2).fail();
        ENGINE.job().ofInstance(processInstanceKey).withType("A").withRetries(3).updateRetries();
        ENGINE.job().ofInstance(processInstanceKey).withType("A").withErrorCode("A1").throwError();
        ENGINE.incident().ofInstance(processInstanceKey).resolve();
        ENGINE.job().ofInstance(processInstanceKey).withType("A").complete();
        ((OptionalAssert)Assertions.assertThat((Optional)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.END_EVENT).withElementId("target_process_end").findAny()).describedAs("Expect that the process instance is continued in the target process", new Object[0])).isPresent();
    }

    @Test
    public void shouldWriteMigratedEventForGlobalVariable() {
        String processId = this.helper.getBpmnProcessId();
        String targetProcessId = this.helper.getBpmnProcessId() + "2";
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)processId).startEvent().serviceTask("A", a -> a.zeebeJobType("A")).endEvent().done()).withXmlResource(Bpmn.createExecutableProcess((String)targetProcessId).startEvent().serviceTask("A", a -> a.zeebeJobType("A")).endEvent().done()).deploy();
        long targetProcessDefinitionKey = MigrateProcessInstanceTest.extractProcessDefinitionKeyByProcessId(deployment, targetProcessId);
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(processId).withVariables(Map.of("variable_to_migrate", "This is just a string", "another_variable_to_migrate", Map.of("this", "is", "a", "context"))).create();
        VariableRecordValue variable = (VariableRecordValue)((Record)RecordingExporter.variableRecords((VariableIntent)VariableIntent.CREATED).withProcessInstanceKey(processInstanceKey).withName("variable_to_migrate").getFirst()).getValue();
        VariableRecordValue variable2 = (VariableRecordValue)((Record)RecordingExporter.variableRecords((VariableIntent)VariableIntent.CREATED).withProcessInstanceKey(processInstanceKey).withName("another_variable_to_migrate").getFirst()).getValue();
        RecordingExporter.jobRecords((JobIntent)JobIntent.CREATED).withProcessInstanceKey(processInstanceKey).await();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).migration().withTargetProcessDefinitionKey(targetProcessDefinitionKey).addMappingInstruction("A", "A").migrate();
        ((VariableRecordValueAssert)((VariableRecordValueAssert)((VariableRecordValueAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat((VariableRecordValue)((VariableRecordValue)((Record)RecordingExporter.variableRecords((VariableIntent)VariableIntent.MIGRATED).withProcessInstanceKey(processInstanceKey).withName("variable_to_migrate").getFirst()).getValue())).describedAs("Expect that process definition is updated", new Object[0])).hasProcessDefinitionKey(targetProcessDefinitionKey).hasBpmnProcessId(targetProcessId).describedAs("Expect that the value is unset to avoid exceeding the max record size", new Object[0])).hasValue("null").describedAs("Expect that the other variable data did not change", new Object[0])).hasName(variable.getName()).hasProcessInstanceKey(variable.getProcessInstanceKey()).hasScopeKey(variable.getScopeKey()).hasTenantId(variable.getTenantId());
        ((VariableRecordValueAssert)((VariableRecordValueAssert)((VariableRecordValueAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat((VariableRecordValue)((VariableRecordValue)((Record)RecordingExporter.variableRecords((VariableIntent)VariableIntent.MIGRATED).withProcessInstanceKey(processInstanceKey).withName("another_variable_to_migrate").getFirst()).getValue())).describedAs("Expect that process definition is updated", new Object[0])).hasProcessDefinitionKey(targetProcessDefinitionKey).hasBpmnProcessId(targetProcessId).describedAs("Expect that the value is unset to avoid exceeding the max record size", new Object[0])).hasValue("null").describedAs("Expect that the other variable data did not change", new Object[0])).hasName(variable2.getName()).hasProcessInstanceKey(variable2.getProcessInstanceKey()).hasScopeKey(variable2.getScopeKey()).hasTenantId(variable2.getTenantId());
    }

    @Test
    public void shouldWriteMigratedEventForLocalVariable() {
        String processId = this.helper.getBpmnProcessId();
        String targetProcessId = this.helper.getBpmnProcessId() + "2";
        Record<DeploymentRecordValue> deployment = ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)processId).startEvent().serviceTask("A", a -> ((ServiceTaskBuilder)((ServiceTaskBuilder)a.zeebeJobType("A")).zeebeInputExpression("\"This is just a string\"", "variable_to_migrate")).zeebeInputExpression("{\"this\": \"is\", \"a\": \"context\"}", "another_variable_to_migrate")).endEvent().done()).withXmlResource(Bpmn.createExecutableProcess((String)targetProcessId).startEvent().serviceTask("A", a -> a.zeebeJobType("A")).endEvent().done()).deploy();
        long targetProcessDefinitionKey = MigrateProcessInstanceTest.extractProcessDefinitionKeyByProcessId(deployment, targetProcessId);
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(processId).create();
        VariableRecordValue variable = (VariableRecordValue)((Record)RecordingExporter.variableRecords((VariableIntent)VariableIntent.CREATED).withProcessInstanceKey(processInstanceKey).withName("variable_to_migrate").getFirst()).getValue();
        VariableRecordValue variable2 = (VariableRecordValue)((Record)RecordingExporter.variableRecords((VariableIntent)VariableIntent.CREATED).withProcessInstanceKey(processInstanceKey).withName("another_variable_to_migrate").getFirst()).getValue();
        RecordingExporter.jobRecords((JobIntent)JobIntent.CREATED).withProcessInstanceKey(processInstanceKey).await();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).migration().withTargetProcessDefinitionKey(targetProcessDefinitionKey).addMappingInstruction("A", "A").migrate();
        ((VariableRecordValueAssert)((VariableRecordValueAssert)((VariableRecordValueAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat((VariableRecordValue)((VariableRecordValue)((Record)RecordingExporter.variableRecords((VariableIntent)VariableIntent.MIGRATED).withProcessInstanceKey(processInstanceKey).withName("variable_to_migrate").getFirst()).getValue())).describedAs("Expect that process definition is updated", new Object[0])).hasProcessDefinitionKey(targetProcessDefinitionKey).hasBpmnProcessId(targetProcessId).describedAs("Expect that the value is unset to avoid exceeding the max record size", new Object[0])).hasValue("null").describedAs("Expect that the other variable data did not change", new Object[0])).hasName(variable.getName()).hasProcessInstanceKey(variable.getProcessInstanceKey()).hasScopeKey(variable.getScopeKey()).hasTenantId(variable.getTenantId());
        ((VariableRecordValueAssert)((VariableRecordValueAssert)((VariableRecordValueAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat((VariableRecordValue)((VariableRecordValue)((Record)RecordingExporter.variableRecords((VariableIntent)VariableIntent.MIGRATED).withProcessInstanceKey(processInstanceKey).withName("another_variable_to_migrate").getFirst()).getValue())).describedAs("Expect that process definition is updated", new Object[0])).hasProcessDefinitionKey(targetProcessDefinitionKey).hasBpmnProcessId(targetProcessId).describedAs("Expect that the value is unset to avoid exceeding the max record size", new Object[0])).hasValue("null").describedAs("Expect that the other variable data did not change", new Object[0])).hasName(variable2.getName()).hasProcessInstanceKey(variable2.getProcessInstanceKey()).hasScopeKey(variable2.getScopeKey()).hasTenantId(variable2.getTenantId());
    }

    private static long extractProcessDefinitionKeyByProcessId(Record<DeploymentRecordValue> deployment, String processId) {
        return ((DeploymentRecordValue)deployment.getValue()).getProcessesMetadata().stream().filter(p -> p.getBpmnProcessId().equals(processId)).findAny().orElseThrow().getProcessDefinitionKey();
    }
}

