/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.processinstance;

import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.AbstractExclusiveGatewayBuilder;
import io.camunda.zeebe.model.bpmn.builder.BoundaryEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.CallActivityBuilder;
import io.camunda.zeebe.model.bpmn.builder.EventSubProcessBuilder;
import io.camunda.zeebe.model.bpmn.builder.ExclusiveGatewayBuilder;
import io.camunda.zeebe.model.bpmn.builder.MultiInstanceLoopCharacteristicsBuilder;
import io.camunda.zeebe.model.bpmn.builder.StartEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.SubProcessBuilder;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.intent.IncidentIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceModificationIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessMessageSubscriptionIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.IncidentRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceModificationRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValueAssert;
import io.camunda.zeebe.protocol.record.value.ProcessMessageSubscriptionRecordValue;
import io.camunda.zeebe.protocol.record.value.VariableRecordValue;
import io.camunda.zeebe.test.util.BrokerClassRuleHelper;
import io.camunda.zeebe.test.util.record.JobRecordStream;
import io.camunda.zeebe.test.util.record.ProcessInstanceRecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import io.camunda.zeebe.test.util.record.VariableRecordStream;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.OptionalAssert;
import org.assertj.core.groups.Tuple;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestWatcher;

public class ModifyProcessInstanceTest {
    @ClassRule
    public static final EngineRule ENGINE = EngineRule.singlePartition();
    private static final String PROCESS_ID = "process";
    @Rule
    public final TestWatcher watcher = new RecordingExporterTestWatcher();
    @Rule
    public final BrokerClassRuleHelper helper = new BrokerClassRuleHelper();

    @Test
    public void shouldWriteModifiedEventForProcessInstance() {
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().serviceTask("A", a -> a.zeebeJobType("A")).endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record<ProcessInstanceModificationRecordValue> event = ENGINE.processInstance().withInstanceKey(processInstanceKey).modification().modify();
        io.camunda.zeebe.protocol.record.Assertions.assertThat(event).hasKey(processInstanceKey).hasRecordType(RecordType.EVENT).hasIntent((Intent)ProcessInstanceModificationIntent.MODIFIED);
        io.camunda.zeebe.protocol.record.Assertions.assertThat((ProcessInstanceModificationRecordValue)((ProcessInstanceModificationRecordValue)event.getValue())).hasProcessInstanceKey(processInstanceKey).hasNoActivateInstructions().hasNoTerminateInstructions();
    }

    @Test
    public void shouldActivateRootElement() {
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().serviceTask("A", a -> a.zeebeJobType("A")).serviceTask("B", b -> b.zeebeJobType("B")).endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).modification().activateElement("B").modify();
        ModifyProcessInstanceTest.verifyThatRootElementIsActivated(processInstanceKey, "B", BpmnElementType.SERVICE_TASK);
    }

    @Test
    public void shouldActivateMultipleRootElement() {
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().serviceTask("A", a -> a.zeebeJobType("A")).parallelGateway().serviceTask("B", b -> b.zeebeJobType("B")).moveToLastGateway().userTask("C").endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        ((Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.PROCESS).getFirst()).getValue();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).modification().activateElement("B").activateElement("C").modify();
        ModifyProcessInstanceTest.verifyThatRootElementIsActivated(processInstanceKey, "B", BpmnElementType.SERVICE_TASK);
        ModifyProcessInstanceTest.verifyThatRootElementIsActivated(processInstanceKey, "C", BpmnElementType.USER_TASK);
    }

    @Test
    public void shouldCompleteModifiedProcessInstanceWithActivatedRootElements() {
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().serviceTask("A", a -> a.zeebeJobType("A")).serviceTask("B", b -> b.zeebeJobType("B")).endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.PROCESS).await();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).modification().activateElement("B").modify();
        ModifyProcessInstanceTest.completeJobs(processInstanceKey, 3);
        ModifyProcessInstanceTest.verifyThatElementIsCompleted(processInstanceKey, "B");
        ModifyProcessInstanceTest.verifyThatProcessInstanceIsCompleted(processInstanceKey);
    }

    @Test
    public void shouldActivateInsideExistingFlowScope() {
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().subProcess("subprocess", sp -> sp.embeddedSubProcess().startEvent().serviceTask("A", a -> a.zeebeJobType("A")).serviceTask("B", b -> b.zeebeJobType("B")).endEvent()).endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record subProcessInstance = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.SUB_PROCESS).getFirst();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).modification().activateElement("B").modify();
        ModifyProcessInstanceTest.verifyThatElementIsActivated(processInstanceKey, "B", BpmnElementType.SERVICE_TASK, subProcessInstance.getKey());
    }

    @Test
    public void shouldActivateMultipleElementInsideExistingFlowScope() {
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().subProcess("subprocess", sp -> sp.embeddedSubProcess().startEvent().serviceTask("A", a -> a.zeebeJobType("A")).parallelGateway().serviceTask("B", b -> b.zeebeJobType("B")).moveToLastGateway().userTask("C").endEvent()).endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        long subprocessScopeKey = ((Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.SUB_PROCESS).getFirst()).getKey();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).modification().activateElement("B").activateElement("C").modify();
        ModifyProcessInstanceTest.verifyThatElementIsActivated(processInstanceKey, "B", BpmnElementType.SERVICE_TASK, subprocessScopeKey);
        ModifyProcessInstanceTest.verifyThatElementIsActivated(processInstanceKey, "C", BpmnElementType.USER_TASK, subprocessScopeKey);
    }

    @Test
    public void shouldCompleteModifiedProcessInstanceWithActivatedElementsInExistingFlowScope() {
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().subProcess("subprocess", sp -> sp.embeddedSubProcess().startEvent().serviceTask("A", a -> a.zeebeJobType("A")).serviceTask("B", b -> b.zeebeJobType("B")).endEvent()).endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.SUB_PROCESS).await();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).modification().activateElement("B").modify();
        ModifyProcessInstanceTest.completeJobs(processInstanceKey, 3);
        ModifyProcessInstanceTest.verifyThatElementIsCompleted(processInstanceKey, "B");
        ModifyProcessInstanceTest.verifyThatProcessInstanceIsCompleted(processInstanceKey);
    }

    @Test
    public void shouldActivateElementsInsideSameNonExistingFlowScope() {
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).eventSubProcess("event-subprocess", s -> ((StartEventBuilder)s.startEvent().message(m -> m.name("start").zeebeCorrelationKeyExpression("key"))).parallelGateway("fork").serviceTask("B", t -> t.zeebeJobType("B")).moveToNode("fork").userTask("C")).startEvent().userTask("A").endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariable("key", "1").create();
        RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementId("A").await();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).modification().activateElement("B").activateElement("C").modify();
        ModifyProcessInstanceTest.verifyThatElementIsActivated(processInstanceKey, "event-subprocess", BpmnElementType.EVENT_SUB_PROCESS, processInstanceKey);
        long eventSubprocessKey = ((Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.EVENT_SUB_PROCESS).getFirst()).getKey();
        ModifyProcessInstanceTest.verifyThatElementIsActivated(processInstanceKey, "B", BpmnElementType.SERVICE_TASK, eventSubprocessKey);
        ModifyProcessInstanceTest.verifyThatElementIsActivated(processInstanceKey, "C", BpmnElementType.USER_TASK, eventSubprocessKey);
        ModifyProcessInstanceTest.completeJobs(processInstanceKey, 3);
        ModifyProcessInstanceTest.verifyThatElementIsCompleted(processInstanceKey, "B");
        ModifyProcessInstanceTest.verifyThatElementIsCompleted(processInstanceKey, "C");
        ModifyProcessInstanceTest.verifyThatElementIsCompleted(processInstanceKey, "event-subprocess");
        ModifyProcessInstanceTest.verifyThatProcessInstanceIsCompleted(processInstanceKey);
    }

    @Test
    public void shouldActivateElementsInsideDifferentNonExistingFlowScopes() {
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).eventSubProcess("event-subprocess-1", s -> ((StartEventBuilder)s.startEvent().message(m -> m.name("start-1").zeebeCorrelationKeyExpression("key"))).serviceTask("B", t -> t.zeebeJobType("B"))).eventSubProcess("event-subprocess-2", s -> ((StartEventBuilder)s.startEvent().message(m -> m.name("start-2").zeebeCorrelationKeyExpression("key"))).userTask("C")).startEvent().userTask("A").endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariable("key", "1").create();
        RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementId("A").await();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).modification().activateElement("B").activateElement("C").modify();
        ModifyProcessInstanceTest.verifyThatElementIsActivated(processInstanceKey, "event-subprocess-1", BpmnElementType.EVENT_SUB_PROCESS, processInstanceKey);
        ModifyProcessInstanceTest.verifyThatElementIsActivated(processInstanceKey, "event-subprocess-2", BpmnElementType.EVENT_SUB_PROCESS, processInstanceKey);
        Map eventSubprocessKeysByElementId = (Map)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.EVENT_SUB_PROCESS).limit(2L)).collect(Collectors.toMap(r -> ((ProcessInstanceRecordValue)r.getValue()).getElementId(), Record::getKey));
        ModifyProcessInstanceTest.verifyThatElementIsActivated(processInstanceKey, "B", BpmnElementType.SERVICE_TASK, (Long)eventSubprocessKeysByElementId.get("event-subprocess-1"));
        ModifyProcessInstanceTest.verifyThatElementIsActivated(processInstanceKey, "C", BpmnElementType.USER_TASK, (Long)eventSubprocessKeysByElementId.get("event-subprocess-2"));
        ModifyProcessInstanceTest.completeJobs(processInstanceKey, 3);
        ModifyProcessInstanceTest.verifyThatElementIsCompleted(processInstanceKey, "B");
        ModifyProcessInstanceTest.verifyThatElementIsCompleted(processInstanceKey, "C");
        ModifyProcessInstanceTest.verifyThatElementIsCompleted(processInstanceKey, "event-subprocess-1");
        ModifyProcessInstanceTest.verifyThatElementIsCompleted(processInstanceKey, "event-subprocess-2");
        ModifyProcessInstanceTest.verifyThatProcessInstanceIsCompleted(processInstanceKey);
    }

    @Test
    public void shouldActivateElementsInsideNestedNonExistingFlowScopes() {
        Consumer<SubProcessBuilder> subprocessBuilder = subprocess -> subprocess.embeddedSubProcess().eventSubProcess("event-subprocess", eventSubprocess -> ((StartEventBuilder)eventSubprocess.startEvent().message(m -> m.name("start").zeebeCorrelationKeyExpression("key"))).serviceTask("B", t -> t.zeebeJobType("B"))).startEvent().userTask("C").endEvent();
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().userTask("A").subProcess("subprocess", subprocessBuilder).endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariable("key", "1").create();
        RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementId("A").await();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).modification().activateElement("B").activateElement("C").modify();
        ModifyProcessInstanceTest.verifyThatElementIsActivated(processInstanceKey, "subprocess", BpmnElementType.SUB_PROCESS, processInstanceKey);
        long subprocessKey = ((Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.SUB_PROCESS).getFirst()).getKey();
        ModifyProcessInstanceTest.verifyThatElementIsActivated(processInstanceKey, "event-subprocess", BpmnElementType.EVENT_SUB_PROCESS, subprocessKey);
        long eventSubprocessKey = ((Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.EVENT_SUB_PROCESS).getFirst()).getKey();
        ModifyProcessInstanceTest.verifyThatElementIsActivated(processInstanceKey, "B", BpmnElementType.SERVICE_TASK, eventSubprocessKey);
        ModifyProcessInstanceTest.verifyThatElementIsActivated(processInstanceKey, "C", BpmnElementType.USER_TASK, subprocessKey);
        ModifyProcessInstanceTest.completeJobs(processInstanceKey, 4);
        ModifyProcessInstanceTest.verifyThatElementIsCompleted(processInstanceKey, "B");
        ModifyProcessInstanceTest.verifyThatElementIsCompleted(processInstanceKey, "C");
        ModifyProcessInstanceTest.verifyThatElementIsCompleted(processInstanceKey, "subprocess");
        ModifyProcessInstanceTest.verifyThatElementIsCompleted(processInstanceKey, "event-subprocess");
        ModifyProcessInstanceTest.verifyThatProcessInstanceIsCompleted(processInstanceKey);
    }

    @Test
    public void shouldCreateEventSubscriptionsWhenActivatingElementsInsideNonExistingFlowScopes() {
        Consumer<SubProcessBuilder> subprocessBuilder1 = subprocess -> subprocess.embeddedSubProcess().eventSubProcess("event-subprocess-1", eventSubprocess -> ((StartEventBuilder)eventSubprocess.startEvent().message(m -> m.name("start-1").zeebeCorrelationKeyExpression("key"))).endEvent()).startEvent().serviceTask("B", t -> t.zeebeJobType("B"));
        Consumer<SubProcessBuilder> subprocessBuilder2 = subprocess -> subprocess.embeddedSubProcess().eventSubProcess("event-subprocess-2", eventSubprocess -> ((StartEventBuilder)eventSubprocess.startEvent().message(m -> m.name("start-2").zeebeCorrelationKeyExpression("key"))).endEvent()).startEvent().userTask("C");
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().userTask("A").subProcess("subprocess-1", subprocessBuilder1).subProcess("subprocess-2", subprocessBuilder2).endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariable("key", "1").create();
        RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementId("A").await();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).modification().activateElement("B").activateElement("C").modify();
        Map subprocessKeysByElementId = (Map)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.SUB_PROCESS).limit(2L)).collect(Collectors.toMap(r -> ((ProcessInstanceRecordValue)r.getValue()).getElementId(), Record::getKey));
        Assertions.assertThat((Stream)RecordingExporter.processMessageSubscriptionRecords((ProcessMessageSubscriptionIntent)ProcessMessageSubscriptionIntent.CREATED).withProcessInstanceKey(processInstanceKey).limit(2L)).extracting(Record::getValue).extracting(new Function[]{ProcessMessageSubscriptionRecordValue::getMessageName, ProcessMessageSubscriptionRecordValue::getElementInstanceKey}).describedAs("Expect one message subscription for each subprocess to be created", new Object[0]).contains((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"start-1", subprocessKeysByElementId.get("subprocess-1")}), Assertions.tuple((Object[])new Object[]{"start-2", subprocessKeysByElementId.get("subprocess-2")})});
        ENGINE.message().withName("start-1").withCorrelationKey("1").publish();
        ENGINE.message().withName("start-2").withCorrelationKey("1").publish();
        ModifyProcessInstanceTest.verifyThatElementIsCompleted(processInstanceKey, "event-subprocess-1");
        ModifyProcessInstanceTest.verifyThatElementIsCompleted(processInstanceKey, "event-subprocess-2");
    }

    @Test
    public void shouldSetVariablesFromMultipleInstructions() {
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().parallelGateway().userTask("A").moveToLastGateway().userTask("B").moveToLastGateway().userTask("C").endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).modification().activateElement("A").withGlobalVariables(Map.of("foo", 1)).withGlobalVariables(Map.of("bar", 2)).activateElement("B").withGlobalVariables(Map.of("baz", 3)).withGlobalVariables(Map.of("fizz", 4)).withGlobalVariables(Map.of("buzz", 5)).activateElement("C").withGlobalVariables(Map.of("foo", "updated")).withGlobalVariables(Map.of("bar", true)).modify();
        Assertions.assertThat((Stream)((VariableRecordStream)RecordingExporter.variableRecords().onlyEvents()).limit(7L)).extracting(Record::getValue).extracting(new Function[]{VariableRecordValue::getName, VariableRecordValue::getValue}).containsExactlyInAnyOrder((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"foo", "1"}), Assertions.tuple((Object[])new Object[]{"bar", "2"}), Assertions.tuple((Object[])new Object[]{"baz", "3"}), Assertions.tuple((Object[])new Object[]{"fizz", "4"}), Assertions.tuple((Object[])new Object[]{"buzz", "5"}), Assertions.tuple((Object[])new Object[]{"foo", "\"updated\""}), Assertions.tuple((Object[])new Object[]{"bar", "true"})});
    }

    @Test
    public void shouldTerminateAndActivateElementInTheSameScope() {
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().subProcess("sp", sp -> sp.embeddedSubProcess().startEvent().userTask("A").userTask("B").endEvent()).endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record terminateElement = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementId("A").getFirst();
        long terminatedElementScope = ((ProcessInstanceRecordValue)terminateElement.getValue()).getFlowScopeKey();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).modification().terminateElement(terminateElement.getKey()).activateElement("B").modify();
        Assertions.assertThat((Stream)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().onlyEvents()).withProcessInstanceKey(processInstanceKey).withElementId("A").limit("A", ProcessInstanceIntent.ELEMENT_TERMINATED)).extracting(Record::getIntent).containsSequence((Object[])new Intent[]{ProcessInstanceIntent.ELEMENT_TERMINATING, ProcessInstanceIntent.ELEMENT_TERMINATED});
        ModifyProcessInstanceTest.verifyThatElementIsActivated(processInstanceKey, "B", BpmnElementType.USER_TASK, terminatedElementScope);
        ((JobRecordStream)RecordingExporter.jobRecords((JobIntent)JobIntent.CREATED).withProcessInstanceKey(processInstanceKey).withElementId("B").limit(1L)).map(Record::getKey).forEach(jobKey -> ENGINE.job().withKey((long)jobKey).complete());
        ModifyProcessInstanceTest.verifyThatElementIsCompleted(processInstanceKey, "B");
        ModifyProcessInstanceTest.verifyThatElementIsCompleted(processInstanceKey, "sp");
        ModifyProcessInstanceTest.verifyThatProcessInstanceIsCompleted(processInstanceKey);
    }

    @Test
    public void shouldActivateElementInInterruptedFlowScope() {
        Consumer<EventSubProcessBuilder> eventSubProcess = eventSubprocess -> ((StartEventBuilder)((StartEventBuilder)eventSubprocess.startEvent().interrupting(true)).message(message -> message.name("interrupt").zeebeCorrelationKeyExpression("key"))).userTask("A").endEvent();
        Consumer<SubProcessBuilder> subProcess = subprocess -> subprocess.embeddedSubProcess().startEvent().userTask("C").endEvent();
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).eventSubProcess("event-subprocess", eventSubProcess).startEvent().userTask("B").subProcess("subprocess", subProcess).endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariable("key", this.helper.getCorrelationValue()).create();
        RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementId("B").await();
        ENGINE.message().withName("interrupt").withCorrelationKey(this.helper.getCorrelationValue()).withTimeToLive(Duration.ofMinutes(1L)).publish();
        RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementId("A").await();
        ENGINE.processInstance().withInstanceKey(processInstanceKey).modification().activateElement("C").activateElement("subprocess").modify();
        Assertions.assertThat((boolean)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementId("C").exists()).isTrue();
        Assertions.assertThat((long)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementId("subprocess").limit(2L)).count()).isEqualTo(2L);
    }

    @Test
    public void shouldActivateInsideSpecificFlowScopeUsingAncestorSelection() {
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).eventSubProcess("event-sub", sub -> ((StartEventBuilder)((StartEventBuilder)sub.startEvent().message(m -> m.name("msg").zeebeCorrelationKeyExpression("key"))).interrupting(false)).userTask("A").userTask("B").endEvent()).startEvent().userTask("C").done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariable("key", this.helper.getCorrelationValue()).create();
        ENGINE.message().withName("msg").withCorrelationKey(this.helper.getCorrelationValue()).publish();
        ENGINE.message().withName("msg").withCorrelationKey(this.helper.getCorrelationValue()).publish();
        List eventSubProcessKeys = ((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.EVENT_SUB_PROCESS).limit(2L)).map(Record::getKey).toList();
        ((ListAssert)Assertions.assertThat(eventSubProcessKeys).describedAs("Expect that there are 2 active instances of the event sub process", new Object[0])).hasSize(2);
        Long ancestorScopeKey = (Long)eventSubProcessKeys.get(1);
        ENGINE.processInstance().withInstanceKey(processInstanceKey).modification().activateElement("B", ancestorScopeKey).modify();
        Optional activatedTaskB = RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementId("B").findAny();
        ((OptionalAssert)Assertions.assertThat((Optional)activatedTaskB).describedAs("Expect that task B is activated", new Object[0])).isPresent();
        ((ProcessInstanceRecordValueAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat((ProcessInstanceRecordValue)((ProcessInstanceRecordValue)((Record)activatedTaskB.get()).getValue())).describedAs("Expect that task B exists inside of flow scope " + ancestorScopeKey, new Object[0])).hasFlowScopeKey(ancestorScopeKey.longValue());
    }

    @Test
    public void shouldActivateInsideNestedSpecificFlowScopeUsingAncestorSelection() {
        ENGINE.deployment().withXmlResource(((AbstractExclusiveGatewayBuilder)((ExclusiveGatewayBuilder)Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().subProcess("sub").embeddedSubProcess().startEvent().exclusiveGateway("split").defaultFlow()).userTask("A").userTask("C").exclusiveGateway("join").moveToLastExclusiveGateway().conditionExpression("false")).userTask("B").connectTo("join").endEvent().subProcessDone().endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Optional activatedTaskA = RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementId("A").findAny();
        Assertions.assertThat((Optional)activatedTaskA).isPresent();
        long ancestorScopeKey = processInstanceKey;
        Record<ProcessInstanceModificationRecordValue> modifiedRecord = ENGINE.processInstance().withInstanceKey(processInstanceKey).modification().activateElement("B", ancestorScopeKey).modify();
        Assertions.assertThat((Stream)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).skipUntil(r -> r.getPosition() >= modifiedRecord.getSourceRecordPosition())).limit(2L)).extracting(Record::getValue).extracting(ProcessInstanceRecordValue::getElementId).describedAs("Expect that a new instance of the sub process and task B have been activated", new Object[0]).containsExactly((Object[])new String[]{"sub", "B"});
    }

    @Test
    public void shouldActivateInsideNestedSpecificFlowScopeUsingAncestorSelectionWhenMultipleExist() {
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).eventSubProcess("event-sub", sub -> ((StartEventBuilder)((StartEventBuilder)sub.startEvent().message(m -> m.name("msg").zeebeCorrelationKeyExpression("key"))).interrupting(false)).userTask("A").userTask("B").endEvent()).startEvent().userTask("C").endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariable("key", this.helper.getCorrelationValue()).create();
        ENGINE.message().withName("msg").withCorrelationKey(this.helper.getCorrelationValue()).publish();
        ENGINE.message().withName("msg").withCorrelationKey(this.helper.getCorrelationValue()).publish();
        ((ListAssert)Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementId("A").limit(2L)).describedAs("Expect that task A activated twice and there are 2 active instances of the event sub process", new Object[0])).hasSize(2);
        long ancestorScopeKey = processInstanceKey;
        Record<ProcessInstanceModificationRecordValue> modifiedRecord = ENGINE.processInstance().withInstanceKey(processInstanceKey).modification().activateElement("B", ancestorScopeKey).modify();
        Assertions.assertThat((Stream)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).skipUntil(r -> r.getPosition() >= modifiedRecord.getSourceRecordPosition())).limit(2L)).extracting(Record::getValue).extracting(ProcessInstanceRecordValue::getElementId).describedAs("Expect that a new instance of the sub process and task B have been activated", new Object[0]).containsExactly((Object[])new String[]{"event-sub", "B"});
    }

    @Test
    public void shouldUseAncestorSelectionWithMultiInstancesOfNestedInstances() {
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).eventSubProcess("event-sub", sub -> ((StartEventBuilder)((StartEventBuilder)((EventSubProcessBuilder)sub.zeebeInputExpression("null", "key2")).startEvent().message(m -> m.name("msg").zeebeCorrelationKeyExpression("key"))).interrupting(false)).userTask("A").boundaryEvent("boundary", b -> ((BoundaryEventBuilder)((BoundaryEventBuilder)b.cancelActivity(Boolean.valueOf(false))).message(m -> m.name("msg2").zeebeCorrelationKeyExpression("key2"))).subProcess("sub").embeddedSubProcess().startEvent().userTask("B").userTask("C").endEvent().subProcessDone().endEvent())).startEvent().userTask("D").endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariable("key", this.helper.getCorrelationValue()).create();
        ENGINE.message().withName("msg").withCorrelationKey(this.helper.getCorrelationValue()).withVariables(Map.of("key2", this.helper.getCorrelationValue() + "1")).publish();
        ENGINE.message().withName("msg").withCorrelationKey(this.helper.getCorrelationValue()).withVariables(Map.of("key2", this.helper.getCorrelationValue() + "2")).publish();
        ((ListAssert)Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementId("A").limit(2L)).describedAs("Expect that task A activated 2 times", new Object[0])).hasSize(2);
        ENGINE.message().withName("msg2").withCorrelationKey(this.helper.getCorrelationValue() + "1").publish();
        ENGINE.message().withName("msg2").withCorrelationKey(this.helper.getCorrelationValue() + "1").publish();
        ENGINE.message().withName("msg2").withCorrelationKey(this.helper.getCorrelationValue() + "2").publish();
        ENGINE.message().withName("msg2").withCorrelationKey(this.helper.getCorrelationValue() + "2").publish();
        List<Long> flowscopekeys = ((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementId("B").limit(4L)).map(Record::getValue).map(ProcessInstanceRecordValue::getFlowScopeKey).toList();
        ((ListAssert)Assertions.assertThat(flowscopekeys).describedAs("Expect that task B activated 4 times, twice per event-subprocess instance", new Object[0])).hasSize(4);
        Long ancestorScopeKey = flowscopekeys.get(0);
        Record<ProcessInstanceModificationRecordValue> modifiedRecord = ENGINE.processInstance().withInstanceKey(processInstanceKey).modification().activateElement("C", ancestorScopeKey).modify();
        Record activatedTask = (Record)((ProcessInstanceRecordStream)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).skipUntil(r -> r.getPosition() >= modifiedRecord.getSourceRecordPosition())).limit(1L)).getFirst();
        ((ProcessInstanceRecordValueAssert)io.camunda.zeebe.protocol.record.Assertions.assertThat((ProcessInstanceRecordValue)((ProcessInstanceRecordValue)activatedTask.getValue())).describedAs("Expect that task C has been activated", new Object[0])).hasElementId("C").hasFlowScopeKey(ancestorScopeKey.longValue());
    }

    @Test
    public void shouldActivateParallelGateway() {
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().parallelGateway("fork").serviceTask("A", a -> a.zeebeJobType("A")).endEvent().moveToNode("fork").serviceTask("B", b -> b.zeebeJobType("B")).endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Assertions.assertThat((Stream)RecordingExporter.jobRecords((JobIntent)JobIntent.CREATED).withProcessInstanceKey(processInstanceKey).limit(2L)).hasSize(2);
        ENGINE.processInstance().withInstanceKey(processInstanceKey).modification().activateElement("fork").modify();
        Assertions.assertThat((Stream)RecordingExporter.jobRecords((JobIntent)JobIntent.CREATED).withProcessInstanceKey(processInstanceKey).limit(4L)).hasSize(4);
    }

    @Test
    public void verifyCallActivityWithIncidentInOutputMappingCanBeTerminated() {
        BpmnModelInstance child = Bpmn.createExecutableProcess((String)"child").startEvent().endEvent().done();
        BpmnModelInstance parent = ((CallActivityBuilder)Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().callActivity("callActivity", c -> c.zeebeProcessId("child")).zeebeOutputExpression("assert(x, x != null)", "y")).manualTask("task").endEvent().done();
        ENGINE.deployment().withXmlResource(child).withXmlResource(parent).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        Record callActivityElement = (Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementId("callActivity").withElementType(BpmnElementType.CALL_ACTIVITY).getFirst();
        Assertions.assertThat((Object)((Record)RecordingExporter.incidentRecords((IncidentIntent)IncidentIntent.CREATED).withProcessInstanceKey(processInstanceKey).getFirst())).extracting(r -> ((IncidentRecordValue)r.getValue()).getElementId()).isEqualTo((Object)"callActivity");
        ENGINE.processInstance().withInstanceKey(processInstanceKey).modification().activateElement("task").terminateElement(callActivityElement.getKey()).modify();
        ModifyProcessInstanceTest.verifyThatRootElementIsActivated(processInstanceKey, "task", BpmnElementType.MANUAL_TASK);
        ModifyProcessInstanceTest.verifyThatProcessInstanceIsCompleted(processInstanceKey);
        Assertions.assertThat((boolean)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_TERMINATED).withProcessInstanceKey(processInstanceKey).withElementId(((ProcessInstanceRecordValue)callActivityElement.getValue()).getElementId()).exists()).isTrue();
    }

    @Test
    public void shouldTerminateProcessIfProcessInstanceKeyIsPassedAsTerminateInstruction() {
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().userTask("A").userTask("B").endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        ModifyProcessInstanceTest.getElementInstanceKeyOfElement(processInstanceKey, "A");
        ENGINE.processInstance().withInstanceKey(processInstanceKey).modification().activateElement("B").terminateElement(processInstanceKey).modify();
        this.assertThatElementIsTerminated(processInstanceKey, PROCESS_ID);
        ((ListAssert)Assertions.assertThat((Stream)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withProcessInstanceKey(processInstanceKey).onlyCommandRejections()).limit("B", ProcessInstanceIntent.ACTIVATE_ELEMENT)).describedAs("Activation of User Task B should be rejected", new Object[0])).isNotEmpty();
    }

    private static void verifyThatRootElementIsActivated(long processInstanceKey, String elementId, BpmnElementType elementType) {
        ModifyProcessInstanceTest.verifyThatElementIsActivated(processInstanceKey, elementId, elementType, processInstanceKey);
    }

    private static void verifyThatElementIsActivated(long processInstanceKey, String elementId, BpmnElementType elementType, long flowScopeKey) {
        ProcessInstanceRecordValue processActivatedEvent = (ProcessInstanceRecordValue)((Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.PROCESS).getFirst()).getValue();
        List elementInstanceEvents = ((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().onlyEvents()).withElementId(elementId).withProcessInstanceKey(processInstanceKey).limit(elementId, ProcessInstanceIntent.ELEMENT_ACTIVATED).toList();
        Assertions.assertThat((List)elementInstanceEvents).extracting(Record::getIntent).describedAs("Expect the element instance to have been activated", new Object[0]).containsExactly((Object[])new Intent[]{ProcessInstanceIntent.ELEMENT_ACTIVATING, ProcessInstanceIntent.ELEMENT_ACTIVATED});
        Assertions.assertThat((List)elementInstanceEvents).extracting(Record::getKey).describedAs("Expect each element instance event to refer to the same entity", new Object[0]).containsOnly((Object[])new Long[]{((Record)elementInstanceEvents.get(0)).getKey()});
        Assertions.assertThat((List)elementInstanceEvents).extracting(Record::getValue).describedAs("Expect each element instance event to contain the complete record value", new Object[0]).extracting(new Function[]{ProcessInstanceRecordValue::getProcessDefinitionKey, ProcessInstanceRecordValue::getBpmnProcessId, ProcessInstanceRecordValue::getVersion, ProcessInstanceRecordValue::getProcessInstanceKey, ProcessInstanceRecordValue::getBpmnElementType, ProcessInstanceRecordValue::getElementId, ProcessInstanceRecordValue::getFlowScopeKey, ProcessInstanceRecordValue::getParentProcessInstanceKey, ProcessInstanceRecordValue::getParentElementInstanceKey}).containsOnly((Object[])new Tuple[]{Tuple.tuple((Object[])new Object[]{processActivatedEvent.getProcessDefinitionKey(), processActivatedEvent.getBpmnProcessId(), processActivatedEvent.getVersion(), processActivatedEvent.getProcessInstanceKey(), elementType, elementId, flowScopeKey, -1L, -1L})});
    }

    @Test
    public void shouldUseAncestorSelectionInsideMultiInstances() throws InterruptedException {
        ENGINE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().subProcess("SubProcess", sub -> sub.multiInstance(m -> ((MultiInstanceLoopCharacteristicsBuilder)((MultiInstanceLoopCharacteristicsBuilder)m.zeebeInputCollectionExpression("[1,2,3]")).zeebeInputElement("index")).parallel())).embeddedSubProcess().startEvent().serviceTask("A", t -> t.zeebeJobType("A")).serviceTask("B", t -> t.zeebeJobType("B")).endEvent().subProcessDone().endEvent().done()).deploy();
        long processInstanceKey = ENGINE.processInstance().ofBpmnProcessId(PROCESS_ID).create();
        List aTasks = ((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withElementId("A").limit(3L)).toList();
        Assertions.assertThat((List)aTasks).hasSize(3);
        ENGINE.processInstance().withInstanceKey(processInstanceKey).modification().terminateElement(((Record)aTasks.get(0)).getKey()).activateElement("B", ((ProcessInstanceRecordValue)((Record)aTasks.get(0)).getValue()).getFlowScopeKey()).terminateElement(((Record)aTasks.get(2)).getKey()).activateElement("B", ((ProcessInstanceRecordValue)((Record)aTasks.get(2)).getValue()).getFlowScopeKey()).modify();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_TERMINATED).withRecordKey(((Record)aTasks.get(0)).getKey())).exists()).describedAs("Expect first A Task to be terminated", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_TERMINATED).withRecordKey(((Record)aTasks.get(2)).getKey())).exists()).describedAs("Expect third A Task to be terminated", new Object[0])).isTrue();
        ((ListAssert)((ListAssert)Assertions.assertThat((Stream)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withElementId("B").limit(2L)).describedAs("Expect 2 B Tasks to be activated", new Object[0])).hasSize(2)).extracting(Record::getValue).extracting(ProcessInstanceRecordValue::getFlowScopeKey).describedAs("Expect each B Task to be activated inside specific flow scopes", new Object[0]).containsExactlyInAnyOrder((Object[])new Long[]{((ProcessInstanceRecordValue)((Record)aTasks.get(0)).getValue()).getFlowScopeKey(), ((ProcessInstanceRecordValue)((Record)aTasks.get(2)).getValue()).getFlowScopeKey()});
    }

    private static void verifyThatElementIsCompleted(long processInstanceKey, String elementId) {
        ((ListAssert)Assertions.assertThat((Stream)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().onlyEvents()).withElementId(elementId).withProcessInstanceKey(processInstanceKey).limit(elementId, ProcessInstanceIntent.ELEMENT_COMPLETED)).describedAs("Expect the element instance to have been completed", new Object[0])).extracting(Record::getIntent).containsSequence((Object[])new Intent[]{ProcessInstanceIntent.ELEMENT_COMPLETING, ProcessInstanceIntent.ELEMENT_COMPLETED});
    }

    private static void verifyThatProcessInstanceIsCompleted(long processInstanceKey) {
        ((OptionalAssert)Assertions.assertThat((Optional)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_COMPLETED).withProcessInstanceKey(processInstanceKey).withElementType(BpmnElementType.PROCESS).limitToProcessInstanceCompleted().findAny()).describedAs("Expect the process instance to have been completed", new Object[0])).isPresent();
    }

    private static void completeJobs(long processInstanceKey, int numberOfJobs) {
        ((JobRecordStream)RecordingExporter.jobRecords((JobIntent)JobIntent.CREATED).withProcessInstanceKey(processInstanceKey).limit((long)numberOfJobs)).map(Record::getKey).forEach(jobKey -> ENGINE.job().withKey((long)jobKey).complete());
    }

    private static long getElementInstanceKeyOfElement(long processInstanceKey, String elementId) {
        return ((Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementId(elementId).getFirst()).getKey();
    }

    private void assertThatElementIsTerminated(long processInstanceKey, String elementId) {
        Assertions.assertThat((List)((ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().onlyEvents()).withProcessInstanceKey(processInstanceKey).withElementId(elementId).limit(elementId, ProcessInstanceIntent.ELEMENT_TERMINATED).toList()).extracting(Record::getIntent).containsSequence((Object[])new Intent[]{ProcessInstanceIntent.ELEMENT_TERMINATING, ProcessInstanceIntent.ELEMENT_TERMINATED});
    }

    private void assertThatJobIsCancelled(long processInstanceKey, String elementId) {
        Assertions.assertThat((boolean)RecordingExporter.jobRecords((JobIntent)JobIntent.CANCELED).withProcessInstanceKey(processInstanceKey).withElementId(elementId).exists()).isTrue();
    }
}

