/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.variable.mapping;

import io.camunda.zeebe.engine.processing.variable.mapping.VariableValue;
import io.camunda.zeebe.engine.util.EngineRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.builder.SubProcessBuilder;
import io.camunda.zeebe.model.bpmn.builder.ZeebeVariablesMappingBuilder;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.DeploymentRecordValue;
import io.camunda.zeebe.protocol.record.value.deployment.ProcessMetadataValue;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.camunda.zeebe.test.util.record.RecordingExporterTestWatcher;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.Assertions;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public final class ActivityInputMappingTest {
    @ClassRule
    public static final EngineRule ENGINE_RULE = EngineRule.singlePartition();
    private static final String PROCESS_ID = "process";
    private static final String A_TIME_VALUE = "\"04:20:00@Europe/Berlin\"";
    private static final String A_LOCAL_TIME_VALUE = "\"04:20\"";
    private static final String A_DATE_VALUE = "\"2021-02-24\"";
    private static final String A_LOCAL_DATE_AND_TIME_VALUE = "\"2021-02-24T04:20\"";
    private static final String A_DATE_AND_TIME_VALUE = "\"2021-02-24T04:20+01:00\"";
    private static final String A_DAY_TIME_DURATION_VALUE = "\"PT42H56M33S\"";
    private static final String A_YEAR_MONTH_DURATION_VALUE = "\"P2Y3M\"";
    @Rule
    public final RecordingExporterTestWatcher recordingExporterTestWatcher = new RecordingExporterTestWatcher();
    @Parameterized.Parameter(value=0)
    public String initialVariables;
    @Parameterized.Parameter(value=1)
    public Consumer<SubProcessBuilder> mappings;
    @Parameterized.Parameter(value=2)
    public List<VariableValue> expectedActivityVariables;

    @Parameterized.Parameters(name="from {0} to {2}")
    public static Object[][] parameters() {
        return new Object[][]{{"{'x': 1}", ActivityInputMappingTest.mapping(b -> b.zeebeInputExpression("x", "x")), ActivityInputMappingTest.activityVariables(VariableValue.variable("x", "1"))}, {"{'x': 1}", ActivityInputMappingTest.mapping(b -> b.zeebeInputExpression("x", "y")), ActivityInputMappingTest.activityVariables(VariableValue.variable("y", "1"))}, {"{'x': 1, 'y': 2}", ActivityInputMappingTest.mapping(b -> b.zeebeInputExpression("y", "z")), ActivityInputMappingTest.activityVariables(VariableValue.variable("z", "2"))}, {"{'x': {'y': 2}}", ActivityInputMappingTest.mapping(b -> b.zeebeInputExpression("x", "x")), ActivityInputMappingTest.activityVariables(VariableValue.variable("x", "{\"y\":2}"))}, {"{'x': {'y': 2}}", ActivityInputMappingTest.mapping(b -> b.zeebeInputExpression("x.y", "y")), ActivityInputMappingTest.activityVariables(VariableValue.variable("y", "2"))}, {"{'x': %s}".formatted(A_TIME_VALUE), ActivityInputMappingTest.mapping(b -> b.zeebeInputExpression("time(x)", "y")), ActivityInputMappingTest.activityVariables(VariableValue.variable("y", A_TIME_VALUE))}, {"{'x': %s}".formatted(A_LOCAL_TIME_VALUE), ActivityInputMappingTest.mapping(b -> b.zeebeInputExpression("time(x)", "y")), ActivityInputMappingTest.activityVariables(VariableValue.variable("y", A_LOCAL_TIME_VALUE))}, {"{'x': %s}".formatted(A_DATE_VALUE), ActivityInputMappingTest.mapping(b -> b.zeebeInputExpression("date(x)", "y")), ActivityInputMappingTest.activityVariables(VariableValue.variable("y", A_DATE_VALUE))}, {"{'x': %s}".formatted(A_LOCAL_DATE_AND_TIME_VALUE), ActivityInputMappingTest.mapping(b -> b.zeebeInputExpression("date and time(x)", "y")), ActivityInputMappingTest.activityVariables(VariableValue.variable("y", A_LOCAL_DATE_AND_TIME_VALUE))}, {"{'x': %s}".formatted(A_DATE_AND_TIME_VALUE), ActivityInputMappingTest.mapping(b -> b.zeebeInputExpression("date and time(x)", "y")), ActivityInputMappingTest.activityVariables(VariableValue.variable("y", A_DATE_AND_TIME_VALUE))}, {"{'x': %s}".formatted(A_DAY_TIME_DURATION_VALUE), ActivityInputMappingTest.mapping(b -> b.zeebeInputExpression("duration(x)", "y")), ActivityInputMappingTest.activityVariables(VariableValue.variable("y", A_DAY_TIME_DURATION_VALUE))}, {"{'x': %s}".formatted(A_YEAR_MONTH_DURATION_VALUE), ActivityInputMappingTest.mapping(b -> b.zeebeInputExpression("duration(x)", "y")), ActivityInputMappingTest.activityVariables(VariableValue.variable("y", A_YEAR_MONTH_DURATION_VALUE))}};
    }

    @Test
    public void shouldApplyInputMappings() {
        ((ProcessMetadataValue)((DeploymentRecordValue)ENGINE_RULE.deployment().withXmlResource(Bpmn.createExecutableProcess((String)PROCESS_ID).startEvent().subProcess("sub", b -> {
            b.embeddedSubProcess().startEvent().endEvent();
            this.mappings.accept((SubProcessBuilder)b);
        }).endEvent().done()).deploy().getValue()).getProcessesMetadata().get(0)).getProcessDefinitionKey();
        long processInstanceKey = ENGINE_RULE.processInstance().ofBpmnProcessId(PROCESS_ID).withVariables(this.initialVariables).create();
        long flowScopeKey = ((Record)RecordingExporter.processInstanceRecords((ProcessInstanceIntent)ProcessInstanceIntent.ELEMENT_ACTIVATED).withProcessInstanceKey(processInstanceKey).withElementId("sub").getFirst()).getKey();
        ((AbstractListAssert)Assertions.assertThat((Stream)RecordingExporter.variableRecords().withProcessInstanceKey(processInstanceKey).withScopeKey(flowScopeKey).limit((long)this.expectedActivityVariables.size())).extracting(Record::getValue).extracting(v -> VariableValue.variable(v.getName(), v.getValue())).hasSize(this.expectedActivityVariables.size())).containsAll(this.expectedActivityVariables);
    }

    private static Consumer<ZeebeVariablesMappingBuilder<SubProcessBuilder>> mapping(Consumer<ZeebeVariablesMappingBuilder<SubProcessBuilder>> mappingBuilder) {
        return mappingBuilder;
    }

    private static List<VariableValue> activityVariables(VariableValue ... variables) {
        return Arrays.asList(variables);
    }
}

