/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.distribution;

import io.camunda.zeebe.engine.state.mutable.MutableDistributionState;
import io.camunda.zeebe.engine.state.mutable.MutableProcessingState;
import io.camunda.zeebe.engine.util.ProcessingStateExtension;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DeploymentRecord;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DeploymentResource;
import io.camunda.zeebe.protocol.impl.record.value.deployment.ProcessMetadata;
import io.camunda.zeebe.protocol.impl.record.value.distribution.CommandDistributionRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.DeploymentIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.value.CommandDistributionRecordValue;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.ArrayList;
import java.util.Arrays;
import org.agrona.collections.Long2ObjectHashMap;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ThrowableAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ProcessingStateExtension.class})
public final class DistributionStateTest {
    private final StateHelper stateHelper = new StateHelper();
    private MutableProcessingState processingState;
    private MutableDistributionState distributionState;

    @BeforeEach
    public void setUp() {
        this.distributionState = this.processingState.getDistributionState();
    }

    @Test
    public void shouldReturnFalseOnEmptyStateForHasPendingCheck() {
        boolean hasPending = this.distributionState.hasPendingDistribution(10L);
        Assertions.assertThat((boolean)hasPending).isFalse();
    }

    @Test
    public void shouldReturnFalseOnEmptyStateForHasPendingForPartitionCheck() {
        boolean hasPending = this.distributionState.hasPendingDistribution(10L, 10);
        Assertions.assertThat((boolean)hasPending).isFalse();
    }

    @Test
    public void shouldAddPendingDistribution() {
        long distributionKey = 10L;
        boolean partition = true;
        this.distributionState.addCommandDistribution(10L, this.createCommandDistributionRecord());
        this.distributionState.addPendingDistribution(10L, 1);
        Assertions.assertThat((boolean)this.distributionState.hasPendingDistribution(10L)).isTrue();
        Assertions.assertThat((boolean)this.distributionState.hasPendingDistribution(10L, 1)).isTrue();
    }

    @Test
    public void shouldRemovePendingDistribution() {
        long distributionKey = 10L;
        boolean partition = true;
        this.distributionState.addCommandDistribution(10L, this.createCommandDistributionRecord());
        this.distributionState.addPendingDistribution(10L, 1);
        this.distributionState.removePendingDistribution(10L, 1);
        Assertions.assertThat((boolean)this.distributionState.hasPendingDistribution(10L)).isFalse();
    }

    @Test
    public void shouldReturnNullOnRequestingStoredDistributionWhenNothingStored() {
        CommandDistributionRecord distributionRecord = this.distributionState.getCommandDistributionRecord(1L, 1);
        Assertions.assertThat((Object)distributionRecord).isNull();
    }

    @Test
    public void shouldStoreDistributionInState() {
        CommandDistributionRecord distributionRecord = this.createCommandDistributionRecord();
        this.distributionState.addCommandDistribution(1L, distributionRecord);
        CommandDistributionRecord storedDistribution = this.distributionState.getCommandDistributionRecord(1L, distributionRecord.getPartitionId());
        ((ObjectAssert)Assertions.assertThat((Object)storedDistribution).isNotNull()).isEqualTo((Object)distributionRecord);
    }

    @Test
    public void shouldRemoveDistribution() {
        CommandDistributionRecord distributionRecord = this.createCommandDistributionRecord();
        this.distributionState.addCommandDistribution(1L, distributionRecord);
        this.distributionState.removeCommandDistribution(1L);
        CommandDistributionRecord storedDistribution = this.distributionState.getCommandDistributionRecord(1L, distributionRecord.getPartitionId());
        Assertions.assertThat((Object)storedDistribution).isNull();
    }

    @Test
    public void shouldRemoveDifferentDistributions() {
        CommandDistributionRecord distributionRecord1 = this.createCommandDistributionRecord();
        CommandDistributionRecord distributionRecord2 = this.createCommandDistributionRecord();
        this.distributionState.addCommandDistribution(1L, distributionRecord1);
        this.distributionState.addCommandDistribution(2L, distributionRecord2);
        this.distributionState.removeCommandDistribution(1L);
        CommandDistributionRecord storedDistribution = this.distributionState.getCommandDistributionRecord(1L, distributionRecord1.getPartitionId());
        Assertions.assertThat((Object)storedDistribution).isNull();
        storedDistribution = this.distributionState.getCommandDistributionRecord(2L, distributionRecord2.getPartitionId());
        ((ObjectAssert)Assertions.assertThat((Object)storedDistribution).isNotNull()).isEqualTo((Object)distributionRecord2);
    }

    @Test
    public void shouldRemoveDistributionIdempotent() {
        this.distributionState.removeCommandDistribution(1L);
        CommandDistributionRecord storedDistributionRecord = this.distributionState.getCommandDistributionRecord(1L, 1);
        Assertions.assertThat((Object)storedDistributionRecord).isNull();
    }

    @Test
    public void shouldFailToAddPendingDistributionIfNoCommandDistributionExists() {
        long distributionKey = 1L;
        boolean partition = true;
        ThrowableAssert.ThrowingCallable addPending = () -> this.distributionState.addPendingDistribution(1L, 1);
        Assertions.assertThat((Object)this.distributionState.getCommandDistributionRecord(1L, 1)).isNull();
        Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)addPending).hasStackTraceContaining("Foreign key DbLong{1} does not exist in COMMAND_DISTRIBUTION_RECORD");
    }

    @Test
    public void shouldIterateOverPendingDistributions() {
        PendingDistribution pendingDistribution = new PendingDistribution(1L, this.createCommandDistributionRecord());
        int partitionId3 = 3;
        int partitionId2 = 2;
        this.stateHelper.addPendingDistributionForPartitions(pendingDistribution, 2, 3);
        ArrayList visits = new ArrayList();
        this.distributionState.foreachPendingDistribution((key, commandDistributionRecord) -> visits.add(new PendingDistribution(key, commandDistributionRecord)));
        ((ListAssert)((ListAssert)Assertions.assertThat(visits).allSatisfy(visited -> Assertions.assertThat((long)visited.key()).isEqualTo(pendingDistribution.key))).allSatisfy(visited -> io.camunda.zeebe.protocol.record.Assertions.assertThat((CommandDistributionRecordValue)visited.record()).hasIntent(pendingDistribution.record.getIntent()).hasValueType(pendingDistribution.record.getValueType()).hasCommandValue((RecordValue)pendingDistribution.record.getCommandValue()))).extracting(PendingDistribution::record).extracting(CommandDistributionRecord::getPartitionId).describedAs("Expect that pending distributions are visited for all other partitions", new Object[0]).containsExactly((Object[])new Integer[]{2, 3});
    }

    @Test
    public void shouldIterateOverMultiplePendingDeployments() {
        Long2ObjectHashMap distributions = new Long2ObjectHashMap();
        int partitionId2 = 2;
        int partitionId3 = 3;
        for (int distributionKey = 1; distributionKey <= 5; ++distributionKey) {
            CommandDistributionRecord pendingDistribution = this.createCommandDistributionRecord();
            distributions.put((long)distributionKey, (Object)pendingDistribution);
            this.stateHelper.addPendingDistributionForPartitions(new PendingDistribution(distributionKey, pendingDistribution), 2, 3);
        }
        ArrayList visits = new ArrayList();
        this.distributionState.foreachPendingDistribution((key, commandDistributionRecord) -> visits.add(new PendingDistribution(key, commandDistributionRecord)));
        Assertions.assertThat(visits).extracting(PendingDistribution::key).describedAs("Expect that all pending distribution are visited", new Object[0]).containsOnly((Object[])new Long[]{1L, 2L, 3L, 4L, 5L});
        Assertions.assertThat(visits).allSatisfy(visited -> io.camunda.zeebe.protocol.record.Assertions.assertThat((CommandDistributionRecordValue)visited.record()).hasIntent(((CommandDistributionRecord)distributions.get(visited.key)).getIntent()).hasValueType(((CommandDistributionRecord)distributions.get(visited.key)).getValueType()).hasCommandValue((RecordValue)((CommandDistributionRecord)distributions.get(visited.key)).getCommandValue()));
        Assertions.assertThat(visits).extracting(PendingDistribution::record).extracting(CommandDistributionRecord::getPartitionId).describedAs("Expect that pending distributions are visited for all other partitions", new Object[0]).containsOnly((Object[])new Integer[]{2, 3});
        Assertions.assertThat(visits).hasSize(10);
    }

    @Test
    public void shouldNotFailOnMissingDeploymentInState() {
        PendingDistribution pendingDistribution = new PendingDistribution(1L, this.createCommandDistributionRecord());
        int partitionId2 = 2;
        int partitionId3 = 3;
        this.stateHelper.addPendingDistributionForPartitions(pendingDistribution, 2, 3);
        this.distributionState.removeCommandDistribution(pendingDistribution.key);
        ArrayList visits = new ArrayList();
        this.distributionState.foreachPendingDistribution((key, commandDistributionRecord) -> visits.add(new PendingDistribution(key, commandDistributionRecord)));
        Assertions.assertThat(visits).isEmpty();
    }

    private CommandDistributionRecord createCommandDistributionRecord() {
        return new CommandDistributionRecord().setPartitionId(1).setValueType(ValueType.DEPLOYMENT).setIntent((Intent)DeploymentIntent.CREATE).setCommandValue((UnifiedRecordValue)this.createDeploymentRecord());
    }

    private DeploymentRecord createDeploymentRecord() {
        BpmnModelInstance modelInstance = Bpmn.createExecutableProcess((String)"process").startEvent().endEvent().done();
        DeploymentRecord deploymentRecord = new DeploymentRecord();
        ((DeploymentResource)deploymentRecord.resources().add()).setResourceName(BufferUtil.wrapString((String)"resource")).setResource(BufferUtil.wrapString((String)Bpmn.convertToString((BpmnModelInstance)modelInstance)));
        ((ProcessMetadata)deploymentRecord.processesMetadata().add()).setChecksum(BufferUtil.wrapString((String)"checksum")).setBpmnProcessId("process").setKey(1L).setVersion(1).setResourceName(BufferUtil.wrapString((String)"resource"));
        return deploymentRecord;
    }

    final class StateHelper {
        StateHelper() {
        }

        private void addPendingDistributionForPartitions(PendingDistribution pendingDistribution, int ... partitionIds) {
            DistributionStateTest.this.distributionState.addCommandDistribution(pendingDistribution.key, pendingDistribution.record);
            Arrays.stream(partitionIds).forEach(partitionId -> DistributionStateTest.this.distributionState.addPendingDistribution(pendingDistribution.key, partitionId));
        }
    }

    record PendingDistribution(long key, CommandDistributionRecord record) {
    }
}

