/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.migration;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbCompositeKey;
import io.camunda.zeebe.db.impl.DbForeignKey;
import io.camunda.zeebe.db.impl.DbLong;
import io.camunda.zeebe.db.impl.DbNil;
import io.camunda.zeebe.engine.state.instance.JobRecordValue;
import io.camunda.zeebe.engine.state.migration.JobBackoffCleanupMigration;
import io.camunda.zeebe.engine.state.mutable.MutableJobState;
import io.camunda.zeebe.engine.state.mutable.MutableProcessingState;
import io.camunda.zeebe.engine.util.ProcessingStateExtension;
import io.camunda.zeebe.protocol.ZbColumnFamilies;
import io.camunda.zeebe.protocol.impl.record.value.job.JobRecord;
import java.util.ArrayList;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ProcessingStateExtension.class})
public class JobBackoffCleanupMigrationTest {
    final JobBackoffCleanupMigration jobBackoffCleanupMigration = new JobBackoffCleanupMigration();
    private ZeebeDb<ZbColumnFamilies> zeebeDb;
    private MutableProcessingState processingState;
    private TransactionContext transactionContext;
    private final JobRecordValue jobRecordToRead = new JobRecordValue();
    private DbLong jobKey;
    private ColumnFamily<DbLong, JobRecordValue> jobsColumnFamily;
    private DbLong backoffKey;
    private DbCompositeKey<DbLong, DbForeignKey<DbLong>> backoffJobKey;
    private ColumnFamily<DbCompositeKey<DbLong, DbForeignKey<DbLong>>, DbNil> backoffColumnFamily;

    @BeforeEach
    public void setup() {
        this.jobKey = new DbLong();
        DbForeignKey fkJob = new DbForeignKey((DbKey)this.jobKey, (Enum)ZbColumnFamilies.JOBS);
        this.jobsColumnFamily = this.zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.JOBS, this.transactionContext, (DbKey)this.jobKey, (DbValue)this.jobRecordToRead);
        this.backoffKey = new DbLong();
        this.backoffJobKey = new DbCompositeKey((DbKey)this.backoffKey, (DbKey)fkJob);
        this.backoffColumnFamily = this.zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.JOB_BACKOFF, this.transactionContext, this.backoffJobKey, (DbValue)DbNil.INSTANCE);
        this.jobKey.wrapLong(1L);
    }

    @Test
    public void shouldCleanOrphanBackoffEntries() {
        MutableJobState jobState = this.processingState.getJobState();
        JobRecord record = JobBackoffCleanupMigrationTest.createJobRecord(1000L);
        jobState.create(this.jobKey.getValue(), record);
        jobState.fail(this.jobKey.getValue(), record);
        this.jobsColumnFamily.deleteExisting((DbKey)this.jobKey);
        this.jobBackoffCleanupMigration.runMigration(this.processingState);
        Assertions.assertThat((boolean)this.backoffColumnFamily.isEmpty()).isTrue();
    }

    @Test
    public void shouldNotCleanUpFailedJobs() {
        MutableJobState jobState = this.processingState.getJobState();
        JobRecord record = JobBackoffCleanupMigrationTest.createJobRecord(1000L);
        jobState.create(this.jobKey.getValue(), record);
        jobState.fail(this.jobKey.getValue(), record);
        this.jobBackoffCleanupMigration.runMigration(this.processingState);
        Assertions.assertThat((boolean)this.backoffColumnFamily.isEmpty()).isFalse();
    }

    @Test
    public void shoulCleanDuplicatedBackoffEntries() {
        MutableJobState jobState = this.processingState.getJobState();
        JobRecord record = JobBackoffCleanupMigrationTest.createJobRecord(1000L);
        jobState.create(this.jobKey.getValue(), record);
        jobState.fail(this.jobKey.getValue(), record);
        record.setRecurringTime(System.currentTimeMillis() + 1001L);
        jobState.fail(this.jobKey.getValue(), record);
        this.jobBackoffCleanupMigration.runMigration(this.processingState);
        Assertions.assertThat((boolean)this.backoffColumnFamily.isEmpty()).isFalse();
        ArrayList keys = new ArrayList();
        this.backoffColumnFamily.forEach((k, v) -> keys.add(k));
        Assertions.assertThat(keys).hasSize(1);
        Assertions.assertThat(keys).extracting(DbCompositeKey::second).extracting(DbForeignKey::inner).contains((Object[])new DbLong[]{this.jobKey});
    }

    private static JobRecord createJobRecord(long retryBackoff) {
        return new JobRecord().setType("test").setRetries(3).setRetryBackoff(retryBackoff).setRecurringTime(System.currentTimeMillis() + retryBackoff);
    }
}

