/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.util;

import io.camunda.zeebe.engine.processing.streamprocessor.JobStreamer;
import io.camunda.zeebe.protocol.impl.stream.job.ActivatedJob;
import io.camunda.zeebe.protocol.impl.stream.job.JobActivationProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import org.agrona.DirectBuffer;

public class RecordingJobStreamer
implements JobStreamer {
    private final ConcurrentMap<String, AtomicInteger> jobNotifications = new ConcurrentHashMap<String, AtomicInteger>();
    private final ConcurrentMap<DirectBuffer, List<RecordingJobStream>> jobStreams = new ConcurrentHashMap<DirectBuffer, List<RecordingJobStream>>();

    public void notifyWorkAvailable(String jobType) {
        AtomicInteger counter = this.jobNotifications.getOrDefault(jobType, new AtomicInteger(0));
        counter.getAndIncrement();
    }

    public Optional<JobStreamer.JobStream> streamFor(DirectBuffer jobType, Predicate<JobActivationProperties> predicate) {
        return Optional.ofNullable((JobStreamer.JobStream)((List)this.jobStreams.getOrDefault(jobType, new ArrayList())).stream().filter(jobStream -> predicate.test(jobStream.getProperties())).findAny().get());
    }

    public RecordingJobStream addJobStream(DirectBuffer jobType, JobActivationProperties jobActivationProperties) {
        RecordingJobStream jobStream = new RecordingJobStream(jobActivationProperties);
        List streamsList = this.jobStreams.getOrDefault(jobType, new ArrayList());
        streamsList.add(jobStream);
        this.jobStreams.put(jobType, streamsList);
        return jobStream;
    }

    public static class RecordingJobStream
    implements JobStreamer.JobStream {
        private final JobActivationProperties properties;
        private final List<ActivatedJob> activatedJobs;

        public RecordingJobStream(JobActivationProperties properties) {
            this.properties = properties;
            this.activatedJobs = new ArrayList<ActivatedJob>();
        }

        public JobActivationProperties properties() {
            return this.properties;
        }

        public void push(ActivatedJob payload) {
            this.activatedJobs.add(payload);
        }

        public JobActivationProperties getProperties() {
            return this.properties;
        }

        public List<ActivatedJob> getActivatedJobs() {
            return this.activatedJobs;
        }

        public void clearActivatedJobs() {
            this.activatedJobs.clear();
        }
    }
}

